/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_filedlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:54:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef  _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef  _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_COMMONFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/CommonFilePickerElementIds.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_LISTBOXCONTROLACTIONS_HPP_
#include <com/sun/star/ui/dialogs/ListboxControlActions.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXTENDEDFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/ExtendedFilePickerElementIds.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERLISTENER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerListener.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERNOTIFIER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerNotifier.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFilePicker.hpp>
#endif

#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif

#include <bf_svx/impgrf.hxx>

#include "filedlg.hxx"
#include "sdresid.hxx"
#include "strings.hrc"
namespace binfilter {



//-----------------------------------------------------------------------------

namespace css = ::com::sun::star;


// --------------------------------------------------------------------
// -----------		SdFileDialog_Imp		---------------------------
// --------------------------------------------------------------------
//STRIP001 class SdFileDialog_Imp : public sfx2::FileDialogHelper
//STRIP001 {
//STRIP001 private:
//STRIP001 	friend class SdExportFileDialog;
//STRIP001 	friend class SdOpenSoundFileDialog;
//STRIP001 
//STRIP001 	css::uno::Reference< css::ui::dialogs::XFilePickerControlAccess > 	mxControlAccess;
//STRIP001 
//STRIP001 	Sound						maSound;
//STRIP001     ULONG                       mnPlaySoundEvent;
//STRIP001 	BOOL						mbUsableSelection;
//STRIP001 	BOOL						mbLabelPlaying;
//STRIP001 	BOOL						mbDuringPreparePlaying;
//STRIP001 
//STRIP001 	void						CheckSelectionState();
//STRIP001 	                            
//STRIP001                                 DECL_LINK( PlayMusicHdl, void * );
//STRIP001                                 DECL_LINK( StopMusicHdl, void * );
//STRIP001 	
//STRIP001 public:
//STRIP001 								SdFileDialog_Imp( const short nDialogType, sal_Bool	bUsableSelection );
//STRIP001 						   		~SdFileDialog_Imp();
//STRIP001 
//STRIP001 	ErrCode					 	Execute();
//STRIP001 
//STRIP001 	// overwritten from FileDialogHelper, to receive user feedback
//STRIP001     virtual void SAL_CALL    	ControlStateChanged( const css::ui::dialogs::FilePickerEvent& aEvent );
//STRIP001 
//STRIP001 	sal_Bool					SelectionBoxState() const;
//STRIP001 };
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SAL_CALL SdFileDialog_Imp::ControlStateChanged( const css::ui::dialogs::FilePickerEvent& aEvent )
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 
//STRIP001 	switch( aEvent.ElementId ) 
//STRIP001 	{
//STRIP001 		case css::ui::dialogs::CommonFilePickerElementIds::LISTBOX_FILTER:
//STRIP001 			CheckSelectionState();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case css::ui::dialogs::ExtendedFilePickerElementIds::PUSHBUTTON_PLAY:
//STRIP001 			if( mxControlAccess.is() )
//STRIP001 			{
//STRIP001                 if( mnPlaySoundEvent ) 
//STRIP001                     Application::RemoveUserEvent( mnPlaySoundEvent );
//STRIP001 
//STRIP001                 mnPlaySoundEvent = Application::PostUserEvent( LINK( this, SdFileDialog_Imp, PlayMusicHdl ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 IMPL_LINK( SdFileDialog_Imp, PlayMusicHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001     mnPlaySoundEvent = 0;
//STRIP001 
//STRIP001 	if( mbLabelPlaying )
//STRIP001 	{
//STRIP001         // switch from playing to not playing
//STRIP001 
//STRIP001 		// reset, so that sound file gets unlocked
//STRIP001         maSound.Stop();
//STRIP001 		maSound.SetSoundName( String() );
//STRIP001 		
//STRIP001         try
//STRIP001         {
//STRIP001             mxControlAccess->setLabel( css::ui::dialogs::ExtendedFilePickerElementIds::PUSHBUTTON_PLAY, 
//STRIP001                                        String( SdResId( STR_PLAY ) ) );
//STRIP001                     
//STRIP001             mbLabelPlaying = FALSE;
//STRIP001         }
//STRIP001         catch( css::lang::IllegalArgumentException )
//STRIP001         {
//STRIP001 #ifdef DBG_UTIL
//STRIP001             DBG_ERROR( "Cannot access play button" );
//STRIP001 #endif
//STRIP001         }
//STRIP001     }
//STRIP001 	else
//STRIP001 	{
//STRIP001         // switch from not playing to playing of current file
//STRIP001 		if( maSound.IsPlaying() )
//STRIP001 		{
//STRIP001             // reset, so that sound file gets unlocked
//STRIP001 			maSound.Stop();
//STRIP001             maSound.SetSoundName( String() );
//STRIP001 		}
//STRIP001 
//STRIP001         INetURLObject	aUrl( GetPath() );
//STRIP001         String			aSoundFile( aUrl.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 		
//STRIP001         if( aSoundFile.Len() > 0 && Sound::IsSoundFile(aSoundFile) )
//STRIP001         {
//STRIP001             maSound.SetNotifyHdl( LINK( this, SdFileDialog_Imp, StopMusicHdl ) );
//STRIP001 			mbDuringPreparePlaying=TRUE;
//STRIP001             maSound.SetSoundName( aSoundFile );
//STRIP001             maSound.Play();
//STRIP001 			
//STRIP001 			ULONG nError = maSound.GetLastError();
//STRIP001 			mbDuringPreparePlaying=FALSE;
//STRIP001             // guard against early stopping
//STRIP001             if( maSound.IsPlaying() && !nError)
//STRIP001             {
//STRIP001                 try
//STRIP001                 {
//STRIP001                     mxControlAccess->setLabel( css::ui::dialogs::ExtendedFilePickerElementIds::PUSHBUTTON_PLAY, 
//STRIP001                                                String( SdResId( STR_STOP ) ) );
//STRIP001                     
//STRIP001                     mbLabelPlaying = TRUE;
//STRIP001                 }
//STRIP001                 catch( css::lang::IllegalArgumentException )
//STRIP001                 {
//STRIP001 #ifdef DBG_UTIL
//STRIP001                     DBG_ERROR( "Cannot access play button" );
//STRIP001 #endif
//STRIP001                 }
//STRIP001             }
//STRIP001 			else if(nError)
//STRIP001 			{
//STRIP001 				//reset error state of sound
//STRIP001 				maSound.SetSoundName( String() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 IMPL_LINK( SdFileDialog_Imp, StopMusicHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if(mbDuringPreparePlaying)
//STRIP001 		return( 0L ); //don't reset the error state of maSound during prepare playing
//STRIP001 
//STRIP001 	 ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 
//STRIP001 	// reset, so that sound file gets unlocked
//STRIP001 	maSound.SetSoundName( String() );
//STRIP001 	
//STRIP001 	if( mxControlAccess.is() )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			mxControlAccess->setLabel( css::ui::dialogs::ExtendedFilePickerElementIds::PUSHBUTTON_PLAY, 
//STRIP001 									   String( SdResId( STR_PLAY ) ) );
//STRIP001             mbLabelPlaying = FALSE;
//STRIP001 		}
//STRIP001 		catch( css::lang::IllegalArgumentException )
//STRIP001 		{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 			DBG_ERROR( "Cannot access play button" );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // check whether to disable the "selection" checkbox
//STRIP001 void SdFileDialog_Imp::CheckSelectionState()
//STRIP001 {
//STRIP001 	if( mbUsableSelection && mxControlAccess.is() )
//STRIP001 	{
//STRIP001 		String	aCurrFilter( GetCurrentFilter() );
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if( !aCurrFilter.Len() || ( aCurrFilter == String( SdResId( STR_EXPORT_HTML_NAME ) ) ) )
//STRIP001 				mxControlAccess->enableControl( css::ui::dialogs::ExtendedFilePickerElementIds::CHECKBOX_SELECTION, FALSE );
//STRIP001 			else
//STRIP001 				mxControlAccess->enableControl( css::ui::dialogs::ExtendedFilePickerElementIds::CHECKBOX_SELECTION, TRUE );
//STRIP001 		}
//STRIP001 		catch( css::lang::IllegalArgumentException )
//STRIP001 		{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 			DBG_ERROR( "Cannot access \"selection\" checkbox" );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 SdFileDialog_Imp::SdFileDialog_Imp( const short 	nDialogType,
//STRIP001 									sal_Bool		bUsableSelection	) : 
//STRIP001 	FileDialogHelper( nDialogType, 0 ),
//STRIP001     mnPlaySoundEvent( 0 ),
//STRIP001 	mbUsableSelection( bUsableSelection ),
//STRIP001 	mbLabelPlaying(FALSE),
//STRIP001 	mbDuringPreparePlaying(FALSE)
//STRIP001 {
//STRIP001     css::uno::Reference < ::com::sun::star::ui::dialogs::XFilePicker > xFileDlg = GetFilePicker();
//STRIP001 
//STRIP001 	// get the control access
//STRIP001 	mxControlAccess = css::uno::Reference< css::ui::dialogs::XFilePickerControlAccess > ( xFileDlg, css::uno::UNO_QUERY );
//STRIP001 
//STRIP001 	if( mxControlAccess.is() )
//STRIP001 	{
//STRIP001 		if( nDialogType == ::sfx2::FILEOPEN_PLAY )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				mxControlAccess->setLabel( css::ui::dialogs::ExtendedFilePickerElementIds::PUSHBUTTON_PLAY, 
//STRIP001 										   String( SdResId( STR_PLAY ) ) );
//STRIP001 			}
//STRIP001 			catch( css::lang::IllegalArgumentException )
//STRIP001 			{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 				DBG_ERROR( "Cannot set play button label" );
//STRIP001 #endif
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( mbUsableSelection != sal_True )
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				mxControlAccess->enableControl( css::ui::dialogs::ExtendedFilePickerElementIds::CHECKBOX_SELECTION, FALSE );
//STRIP001 			}
//STRIP001 			catch( css::lang::IllegalArgumentException )
//STRIP001 			{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 				DBG_ERROR( "Cannot disable selection checkbox" );
//STRIP001 #endif
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 SdFileDialog_Imp::~SdFileDialog_Imp()
//STRIP001 {
//STRIP001     if( mnPlaySoundEvent ) 
//STRIP001         Application::RemoveUserEvent( mnPlaySoundEvent );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode SdFileDialog_Imp::Execute()
//STRIP001 {
//STRIP001 	// make sure selection checkbox is disabled if 
//STRIP001 	// HTML is current filter!
//STRIP001 	CheckSelectionState();
//STRIP001 	return FileDialogHelper::Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 sal_Bool SdFileDialog_Imp::SelectionBoxState() const
//STRIP001 {
//STRIP001     if ( !mbUsableSelection || !mxControlAccess.is() )
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	sal_Bool bState(0);
//STRIP001 	try
//STRIP001 	{
//STRIP001 		mxControlAccess->getValue( css::ui::dialogs::ExtendedFilePickerElementIds::CHECKBOX_SELECTION, 0 ) >>= bState;
//STRIP001 	}
//STRIP001 	catch( css::lang::IllegalArgumentException )
//STRIP001 	{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		DBG_ERROR( "Cannot access \"selection\" checkbox" );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	return bState;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // --------------------------------------------------------------------
//STRIP001 // -----------		SdExportFileDialog		---------------------------
//STRIP001 // --------------------------------------------------------------------
//STRIP001 
//STRIP001 // these are simple forwarders
//STRIP001 SdExportFileDialog::SdExportFileDialog(BOOL bHaveCheckbox) : 
//STRIP001 	mpImpl( new SdFileDialog_Imp( ::sfx2::FILESAVE_AUTOEXTENSION_SELECTION, 
//STRIP001 								  bHaveCheckbox ) )
//STRIP001 {
//STRIP001 	// setup filter
//STRIP001 	const String    aHTMLFilter( SdResId( STR_EXPORT_HTML_NAME ) );
//STRIP001 	GraphicFilter*	pFilter = GetGrfFilter();
//STRIP001 	const USHORT	nFilterCount = pFilter->GetExportFormatCount();
//STRIP001 
//STRIP001 	// add HTML filter
//STRIP001 	mpImpl->AddFilter( aHTMLFilter, String( SdResId( STR_EXPORT_HTML_FILTER ) ) );
//STRIP001 
//STRIP001 	// add other graphic filters
//STRIP001 	for ( USHORT i = 0; i < nFilterCount; i++ )
//STRIP001 	{
//STRIP001 		mpImpl->AddFilter( pFilter->GetExportFormatName( i ),
//STRIP001 						   pFilter->GetExportWildcard( i ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// set dialog title
//STRIP001 	mpImpl->SetTitle( String( SdResId( STR_EXPORT_DIALOG_TITLE ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 SdExportFileDialog::~SdExportFileDialog()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode SdExportFileDialog::Execute()
//STRIP001 {
//STRIP001 	return mpImpl->Execute();
//STRIP001 }
//STRIP001 
//STRIP001 String SdExportFileDialog::GetPath() const
//STRIP001 {
//STRIP001 	return mpImpl->GetPath();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SdExportFileDialog::SetPath( const String& rPath )
//STRIP001 {
//STRIP001 	mpImpl->SetDisplayDirectory( rPath );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String SdExportFileDialog::ReqCurrentFilter() const
//STRIP001 {
//STRIP001 	return mpImpl->GetCurrentFilter();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 BOOL SdExportFileDialog::IsExportSelection() const
//STRIP001 {
//STRIP001 	return mpImpl->SelectionBoxState();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // --------------------------------------------------------------------
//STRIP001 // -----------		SdOpenSoundFileDialog		-----------------------
//STRIP001 // --------------------------------------------------------------------
//STRIP001 
//STRIP001 // these are simple forwarders
//STRIP001 SdOpenSoundFileDialog::SdOpenSoundFileDialog() :
//STRIP001 	mpImpl( new SdFileDialog_Imp( ::sfx2::FILEOPEN_PLAY, sal_False ) )
//STRIP001 {
//STRIP001 	// setup filter
//STRIP001 #if defined UNX
//STRIP001 	String aDescr;
//STRIP001 	aDescr = String(SdResId(STR_AU_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.au;*.snd" ) ) );
//STRIP001 	aDescr = String(SdResId(STR_VOC_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.voc" ) ) );
//STRIP001 	aDescr = String(SdResId(STR_WAV_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.wav" ) ) );
//STRIP001 	aDescr = String(SdResId(STR_AIFF_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.aiff" ) ) );
//STRIP001 	aDescr = String(SdResId(STR_SVX_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.svx" ) ) );
//STRIP001 #else
//STRIP001 	String aDescr;
//STRIP001 	aDescr = String(SdResId(STR_WAV_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.wav" ) ) );
//STRIP001 	aDescr = String(SdResId(STR_MIDI_FILE));
//STRIP001 	mpImpl->AddFilter( aDescr, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "*.mid" ) ) );
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 SdOpenSoundFileDialog::~SdOpenSoundFileDialog()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 ErrCode SdOpenSoundFileDialog::Execute()
//STRIP001 {
//STRIP001 	return mpImpl->Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 String SdOpenSoundFileDialog::GetPath() const
//STRIP001 {
//STRIP001 	return mpImpl->GetPath();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 void SdOpenSoundFileDialog::SetPath( const String& rPath )
//STRIP001 {
//STRIP001 	mpImpl->SetDisplayDirectory( rPath );
//STRIP001 }
}
