/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_slidview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:46:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <math.h>

// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW3D_HXX
// auto strip #include <bf_svx/view3d.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _GRFMGR_HXX
// auto strip #include <goodies/grfmgr.hxx>
// auto strip #endif
// auto strip #include <bf_svx/svdoutl.hxx>

// auto strip #include "docshell.hxx"
// auto strip #include "slidview.hxx"
// auto strip #include "slidvish.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "pres.hxx"
#include "drawdoc.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "bmcache.hxx"
// auto strip #include "showview.hxx"
#include "glob.hrc"
// auto strip #include "fuslsel.hxx"
// auto strip #include "sdxfer.hxx"
// auto strip #include "sdmod.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "ins_paste.hxx"
#include "strings.hrc"
#include "app.hrc"
// auto strip #include "AccessibleSlideView.hxx"

// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventId.hpp>
// auto strip #endif

#include <algorithm>
namespace binfilter {

using namespace ::com::sun::star;

#define NAME_HEIGHT_FRACTION  (ULONG)	   25
#define NAME_OFFSET_FRACTION  (ULONG)		4
#define SELRECT_OFFSET		  (ULONG)		2
#define SELRECT_THICKNESS	  (ULONG)		2
#define BITMAPCACHE_SIZE	  (ULONG) 4000000
#define ZOOM_TOLERANCE		  (long)	  -10
#define DELAYED_PAINT_TIMEOUT (ULONG)	   50

// ---------------------
// - DelayedPaintEvent -
// ---------------------

//STRIP001 struct DelayedPaintEvent
//STRIP001 {
//STRIP001 	OutputDevice* pOut;
//STRIP001 	Rectangle	  aRect;
//STRIP001 };

// ---------------
// - SdSlideView -
// ---------------

//STRIP001 TYPEINIT1( SdSlideView, SdView );

// -----------------------------------------------------------------------------

//STRIP001 SdSlideView::SdSlideView(SdDrawDocument* pDoc, Window* pWindow, SdSlideViewShell* pSlideVShell) :
//STRIP001     SdView(pDoc, pWindow, pSlideVShell),
//STRIP001 	nAllowInvalidateSmph(0),
//STRIP001 	nPagesPerRow(4),
//STRIP001 	pCache(NULL),
//STRIP001 	pShowView(NULL),
//STRIP001 	pVDev(NULL),
//STRIP001     bInPaint(FALSE),
//STRIP001 	bInDelayedPaint(FALSE),
//STRIP001 	pSlideViewShell(pSlideVShell),
//STRIP001     nFocusPage( SDRPAGE_NOTFOUND )
//STRIP001 {
//STRIP001 	SetAnimationEnabled( FALSE );
//STRIP001 	ArrangePages();
//STRIP001 
//STRIP001 	aDelayedPaintTimer.SetTimeout( DELAYED_PAINT_TIMEOUT );
//STRIP001 	aDelayedPaintTimer.SetTimeoutHdl( LINK( this,SdSlideView,PaintDelayed ) );
//STRIP001 	aDelayedPaintTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdSlideView::~SdSlideView()
//STRIP001 {
//STRIP001     aDelayedPaintTimer.Stop();
//STRIP001 
//STRIP001 	delete pCache;
//STRIP001 	delete pShowView;
//STRIP001 	delete pVDev;
//STRIP001 
//STRIP001     for( void* pEvt = aDelayedPaints.First(); pEvt; pEvt = aDelayedPaints.Next() )
//STRIP001         delete static_cast< DelayedPaintEvent* >( pEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdSlideView::ChangePagesPerRow(USHORT nNum)
//STRIP001 {
//STRIP001 	USHORT nResult = nPagesPerRow;
//STRIP001 	
//STRIP001     nPagesPerRow = nNum;
//STRIP001     ArrangePages();
//STRIP001 	
//STRIP001     return nResult;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::InvalidateOneWin( Window& rWin )
//STRIP001 {
//STRIP001 	if( IsInvalidateAllowed() )
//STRIP001 		SdrPaintView::InvalidateOneWin(rWin);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::InvalidateOneWin( Window& rWin, const Rectangle& rRect )
//STRIP001 {
//STRIP001 	if( IsInvalidateAllowed() )
//STRIP001 		SdrPaintView::InvalidateOneWin(rWin, rRect);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::Paint( const Rectangle& rRect, OutputDevice* pOut )
//STRIP001 {
//STRIP001     if( !bInPaint )
//STRIP001     {
//STRIP001         // set this flag to avoid 'paint in paint' calls, caused by a call to Application::Reschedule
//STRIP001         bInPaint = TRUE;
//STRIP001 
//STRIP001 	    const Rectangle aOutputRect( pOut->PixelToLogic( Point() ), pOut->GetOutputSize() );
//STRIP001         const Color     aOldLineColor( pOut->GetLineColor() );
//STRIP001 	    const Color     aOldFillColor( pOut->GetFillColor() );
//STRIP001 	    SdPage*         pPage = 0;
//STRIP001 	    USHORT	        nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	    USHORT	        nPage;
//STRIP001 	    Point	        aPos;					// Position fuer Name
//STRIP001 	    Font	        aOldFont( pOut->GetFont() );
//STRIP001 	    Font	        aNewFont( OutputDevice::GetDefaultFont( DEFAULTFONT_SANS_UNICODE,
//STRIP001 	                              pOut->GetSettings().GetInternational().GetLanguage(), FALSE, pOut ) );
//STRIP001 
//STRIP001 	    if( nNoOfPages > 0 )
//STRIP001 	    {
//STRIP001 		    pPage = pDoc->GetSdPage( 0, PK_STANDARD );
//STRIP001 		    
//STRIP001             Size    aPageSize( pPage->GetSize() );
//STRIP001 		    Size    aPixelSize( pOut->PixelToLogic(Size( 1, 1 ) ) );
//STRIP001 		    Size    aCPageSize( aPageSize.Width() + aPixelSize.Width(), aPageSize.Height() + aPixelSize.Height() );
//STRIP001 		    Size    aFontSize ( 0, pPage->GetSize().Height() / NAME_HEIGHT_FRACTION );
//STRIP001             Point   aNullPt;
//STRIP001 
//STRIP001 		    aNewFont.SetSize( aFontSize );
//STRIP001 		    aNewFont.SetTransparent( TRUE );
//STRIP001 		    pOut->SetFont( aNewFont );
//STRIP001 
//STRIP001 		    if( pShowView )
//STRIP001 		    {
//STRIP001 			    // ShowView und VDev existieren schon
//STRIP001 			    MapMode aMapMode( pOut->GetMapMode() );
//STRIP001 			    aMapMode.SetOrigin( aNullPt);
//STRIP001 			    pVDev->SetMapMode( aMapMode );
//STRIP001 			    pVDev->SetOutputSize( aCPageSize );
//STRIP001                 pVDev->SetDigitLanguage (pOut->GetDigitLanguage());
//STRIP001 			    pShowView->HideAllPages();
//STRIP001 		    }
//STRIP001 
//STRIP001 			for( nPage = 0; nPage < nNoOfPages; nPage++ )
//STRIP001 		    {
//STRIP001                 const Rectangle aPageArea( GetPageArea( nPage ) );
//STRIP001 
//STRIP001                 pSlideViewShell->PageVisibilityHasChanged( nPage, aOutputRect.IsOver( aPageArea ) );
//STRIP001 
//STRIP001 			    // Seitenbereich getroffen?
//STRIP001 			    if( rRect.IsOver( aPageArea ) )
//STRIP001 			    {
//STRIP001 				    pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 				    
//STRIP001 					SdrOutliner& rOutl=pDoc->GetDrawOutliner(NULL);
//STRIP001 					rOutl.SetBackgroundColor( pPage->GetBackgroundColor() );
//STRIP001 	
//STRIP001                     Rectangle aPageRect( CalcPagePos( nPage ), aPageSize );
//STRIP001 
//STRIP001 				    // die Seite selbst getroffen
//STRIP001 				    if( rRect.IsOver( aPageRect ) )
//STRIP001 				    {
//STRIP001 					    Fraction                aScale( pOut->GetMapMode().GetScaleX() );
//STRIP001 					    long	                nZoom = aScale.GetNumerator() * 100L / aScale.GetDenominator();
//STRIP001 					    long                    nZoomOfBitmap = nZoom;
//STRIP001 					    const GraphicObject*    pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );
//STRIP001 
//STRIP001 					    // die Seite selbst zeichnen?
//STRIP001 					    if( bInDelayedPaint || pGraphicObject )
//STRIP001 					    {
//STRIP001 						    // nicht im Cache, erzeugen und in Cache stellen
//STRIP001 						    if( !pGraphicObject )
//STRIP001 						    {
//STRIP001                         	    // wenn noetig, virtuelles Device und View erzeugen
//STRIP001 							    if( !pShowView )
//STRIP001 							    {
//STRIP001 								    pVDev = new VirtualDevice;
//STRIP001 								    MapMode aMapMode( pOut->GetMapMode() );
//STRIP001 								    aMapMode.SetOrigin( aNullPt );
//STRIP001 								    pVDev->SetMapMode( aMapMode );
//STRIP001 								    pVDev->SetOutputSize( aCPageSize );
//STRIP001                                     pVDev->SetDigitLanguage (pOut->GetDigitLanguage());
//STRIP001 
//STRIP001 									// adjust contrast mode initially
//STRIP001 									bool bUseContrast = Application::GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001 									pVDev->SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 
//STRIP001     							    pShowView = new ShowView( pDoc, pVDev, pSlideViewShell );
//STRIP001 								    pShowView->SetLineDraft( IsLineDraft() );
//STRIP001 								    pShowView->SetFillDraft( IsFillDraft() );
//STRIP001 								    pShowView->SetTextDraft( IsTextDraft() );
//STRIP001 								    pShowView->SetGrafDraft( IsGrafDraft() );
//STRIP001 							    }
//STRIP001 
//STRIP001 							    pShowView->ShowPage( pPage, aNullPt ); 
//STRIP001 
//STRIP001 							    SdrPageView*    pPageView = pShowView->GetPageView( pPage );
//STRIP001 							    FrameView*      pFrameView = pSlideViewShell->GetFrameView();
//STRIP001 							    Region          aRegion( Rectangle( aNullPt, aCPageSize ) );
//STRIP001 
//STRIP001                                 pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 
//STRIP001                                 // set draw-mode for rendering the cache bitmap
//STRIP001                                 pVDev->SetDrawMode( pFrameView->GetDrawMode() );
//STRIP001 
//STRIP001                                 // redraw
//STRIP001                                 pShowView->InitRedraw( pVDev,aRegion );
//STRIP001                                 while(!pShowView->IsRedrawReady()) {}
//STRIP001 
//STRIP001 							    AddToCache( pPage, pVDev->GetBitmap( aNullPt, aCPageSize ), nZoom );
//STRIP001                            
//STRIP001                                 pShowView->HidePage( pPageView );
//STRIP001                                 pPage->ForceSwapOutObjects();
//STRIP001                                 pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );
//STRIP001 						    }
//STRIP001 
//STRIP001                             ULONG nPreviousDrawMode( pOut->GetDrawMode());
//STRIP001                             // the bitmap was rendered in the correct draw-mode
//STRIP001                             // so use default mode to display it 'as is'
//STRIP001                             pOut->SetDrawMode( DRAWMODE_DEFAULT );
//STRIP001 
//STRIP001                             if( pGraphicObject )
//STRIP001                                 const_cast< GraphicObject* >( pGraphicObject )->Draw( pOut, aPageRect.TopLeft(), aCPageSize );
//STRIP001 
//STRIP001                             pOut->SetDrawMode( nPreviousDrawMode );
//STRIP001 					    }
//STRIP001 					    else
//STRIP001 					    {
//STRIP001     					    // spaeter zeichnen (kommt Zeit, kommt Paint)
//STRIP001 						    DelayedPaintEvent* pEvent = new DelayedPaintEvent;
//STRIP001 
//STRIP001 						    pEvent->aRect = aPageRect.GetIntersection(rRect);
//STRIP001 						    pEvent->aRect.Right() += aPixelSize.Width();
//STRIP001 						    pEvent->aRect.Bottom() += aPixelSize.Height();
//STRIP001 						    pEvent->pOut  = pOut;
//STRIP001 						    
//STRIP001                             aDelayedPaints.Insert(pEvent, LIST_APPEND);
//STRIP001 					    }
//STRIP001 
//STRIP001 					    // draw border around page (in every case)
//STRIP001 					    pOut->SetLineColor( Color( COL_BLACK ) );
//STRIP001 					    pOut->SetFillColor();
//STRIP001 					    pOut->DrawRect( aPageRect );
//STRIP001 				    }
//STRIP001 
//STRIP001 				    if( !bInDelayedPaint )
//STRIP001 				    {
//STRIP001 					    // Symbol fuer Ueberblendeffekt
//STRIP001 					    Rectangle aRect( GetFadeIconArea(nPage) );
//STRIP001 					    
//STRIP001                         if (pPage->GetFadeEffect() != presentation::FadeEffect_NONE )
//STRIP001 					    {
//STRIP001 						    pOut->SetLineColor( Color( COL_BLACK ) );
//STRIP001 						    pOut->SetFillColor();
//STRIP001 						    pOut->DrawRect(aRect);
//STRIP001 
//STRIP001 						    pOut->SetLineColor();
//STRIP001 						    pOut->SetFillColor( Color( COL_BLACK ) );
//STRIP001 
//STRIP001 						    Point aTriangle[3];
//STRIP001 						    aTriangle[0] = aRect.TopLeft();
//STRIP001 						    aTriangle[1] = aRect.Center();
//STRIP001 						    aTriangle[2] = aRect.BottomLeft();
//STRIP001 						    pOut->DrawPolygon(Polygon(3, aTriangle));
//STRIP001 					    }
//STRIP001 
//STRIP001 					    // Name der Seite
//STRIP001 					    aPos = CalcPagePos(nPage);
//STRIP001 					    
//STRIP001                         Size    aPageSize( pPage->GetSize() );
//STRIP001 					    Size    aSize( pOut->PixelToLogic( Size( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 ) ) );
//STRIP001 					    String  aName (pPage->GetName());
//STRIP001 
//STRIP001 					    aPos.Y() += aPageSize.Height() + aSize.Height();
//STRIP001 
//STRIP001 
//STRIP001 				        if( !aName.Len() )
//STRIP001 					    {
//STRIP001 						    String aStandardName( SdResId(STR_PAGE) );
//STRIP001 						    aName = aStandardName;
//STRIP001 						    aName += String::CreateFromInt32( nPage + 1 );
//STRIP001 					    }
//STRIP001 
//STRIP001 					    if( pOut->GetTextWidth(aName) > aPageSize.Width() - 2 * aRect.GetWidth() )
//STRIP001 					    {
//STRIP001 						    aName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 						    
//STRIP001                             while( pOut->GetTextWidth( aName ) > aPageSize.Width() - 2 * aRect.GetWidth() )
//STRIP001 							    aName.Erase(aName.Len() - 4, 1);
//STRIP001 					    }
//STRIP001 
//STRIP001 					    // rechtsbuendig unter der Seite
//STRIP001 					    aPos.X() += aPageSize.Width() - pOut->GetTextWidth( aName );
//STRIP001 
//STRIP001 					    // grau hinterlegen, wenn Seite ausgeschlossen
//STRIP001 					    if( pPage->IsExcluded() )
//STRIP001 					    {
//STRIP001 						    Size aTextSize( Size( pOut->GetTextWidth( aName ), pOut->GetTextHeight() ) );
//STRIP001 
//STRIP001 						    pOut->SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 						    pOut->SetLineColor();
//STRIP001 						    pOut->DrawRect( Rectangle( aPos, aTextSize ) );
//STRIP001 					    }
//STRIP001 
//STRIP001 					    pOut->DrawText( aPos, aName );
//STRIP001                         pSlideViewShell->DrawSelectionRect( nPage );
//STRIP001                     }
//STRIP001 			    }
//STRIP001 		    }
//STRIP001 	    }
//STRIP001 
//STRIP001 	    pOut->SetFont( aOldFont );
//STRIP001 	    pOut->SetFillColor( aOldLineColor );
//STRIP001 	    pOut->SetFillColor( aOldFillColor );
//STRIP001         
//STRIP001         bInPaint = FALSE;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::Select( USHORT nSdPageNum, BOOL bSelect )
//STRIP001 {
//STRIP001 	SdPage* pPage = pDoc->GetSdPage( nSdPageNum, PK_STANDARD );
//STRIP001 
//STRIP001 	if( pPage->IsSelected() != bSelect )
//STRIP001 	{
//STRIP001         const uno::Any  aOldAny, aNewAny;
//STRIP001         const USHORT    nOldFocusPage = nFocusPage;
//STRIP001 
//STRIP001         pDoc->SetSelected( pDoc->GetSdPage( nSdPageNum, PK_STANDARD ), bSelect );
//STRIP001         pSlideViewShell->DrawSelectionRect( nSdPageNum );
//STRIP001         pSlideViewShell->SelectionHasChanged();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::SelectAll( BOOL bSelect )
//STRIP001 {
//STRIP001     BOOL bChanged = FALSE;
//STRIP001 
//STRIP001     for( USHORT i = 0, nCount = pDoc->GetSdPageCount( PK_STANDARD ); i < nCount; ++i )
//STRIP001     {
//STRIP001     	SdPage* pPage = pDoc->GetSdPage( i, PK_STANDARD );
//STRIP001 
//STRIP001         if( pPage->IsSelected() != bSelect )
//STRIP001         { 
//STRIP001             pDoc->SetSelected( pDoc->GetSdPage( i, PK_STANDARD ), bSelect );
//STRIP001             pSlideViewShell->DrawSelectionRect( i );
//STRIP001             bChanged = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if( bChanged )
//STRIP001         pSlideViewShell->SelectionHasChanged();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::MoveFocus( SlideViewFocusMove eMove )
//STRIP001 {
//STRIP001     const USHORT nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 
//STRIP001     if( nPageCount )
//STRIP001     {
//STRIP001         const USHORT nOldFocusPage = nFocusPage;
//STRIP001 
//STRIP001         if( SLIDEVIEWFOCUSMOVE_TOGGLE == eMove )
//STRIP001             pSlideViewShell->DrawFocusRect( nFocusPage = ( SDRPAGE_NOTFOUND == nFocusPage ) ? 0 : SDRPAGE_NOTFOUND );
//STRIP001         else if( SDRPAGE_NOTFOUND != nFocusPage )
//STRIP001         {
//STRIP001             if( SLIDEVIEWFOCUSMOVE_SELECT == eMove )
//STRIP001             {
//STRIP001             	SdPage* pPage = pDoc->GetSdPage( nFocusPage, PK_STANDARD );
//STRIP001 
//STRIP001                 if( pPage )
//STRIP001                     Select( nFocusPage, !pPage->IsSelected() );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 switch( eMove )
//STRIP001                 {
//STRIP001                     case( SLIDEVIEWFOCUSMOVE_LEFT ):
//STRIP001                         nFocusPage = ( nFocusPage ? --nFocusPage : ( nPageCount - 1 ) );
//STRIP001                     break;
//STRIP001 
//STRIP001                     case( SLIDEVIEWFOCUSMOVE_TOP ):
//STRIP001                     {
//STRIP001                         const sal_Int32 nNewFocusPage = nFocusPage - nPagesPerRow;
//STRIP001 
//STRIP001                         if( nNewFocusPage < 0 )
//STRIP001                         {
//STRIP001                             const USHORT    nColumn = nFocusPage % nPagesPerRow;
//STRIP001                             USHORT          nRow = nPageCount / nPagesPerRow;
//STRIP001 
//STRIP001                             if( ( nRow * nPagesPerRow + nColumn ) >= nPageCount )
//STRIP001                                 --nRow;
//STRIP001 
//STRIP001                             nFocusPage = nRow * nPagesPerRow + nColumn;
//STRIP001                         }
//STRIP001                         else
//STRIP001                             nFocusPage = (USHORT) nNewFocusPage;
//STRIP001                     }
//STRIP001                     break;
//STRIP001 
//STRIP001                     case( SLIDEVIEWFOCUSMOVE_RIGHT ):
//STRIP001                         nFocusPage = ( nFocusPage < ( nPageCount - 1 ) ? ++nFocusPage : 0 );
//STRIP001                     break;
//STRIP001 
//STRIP001                     case( SLIDEVIEWFOCUSMOVE_BOTTOM ):
//STRIP001                     {
//STRIP001                         const sal_Int32 nNewFocusPage = nFocusPage + nPagesPerRow;
//STRIP001 
//STRIP001                         if( nNewFocusPage >= nPageCount )
//STRIP001                             nFocusPage %= nPagesPerRow;
//STRIP001                         else
//STRIP001                             nFocusPage = (USHORT) nNewFocusPage;
//STRIP001                     }
//STRIP001                     break;
//STRIP001                 }
//STRIP001 
//STRIP001                 pSlideViewShell->DrawFocusRect( nFocusPage );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         pSlideViewShell->FocusHasChanged( nOldFocusPage, nFocusPage );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdSlideView::HasFocus() const
//STRIP001 {
//STRIP001     return( SDRPAGE_NOTFOUND != nFocusPage );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdSlideView::GetFocusPage() const
//STRIP001 {
//STRIP001     return( nFocusPage );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Point SdSlideView::CalcPagePos( USHORT nPageNo ) const
//STRIP001 {
//STRIP001     OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
//STRIP001 	Point           aResult;
//STRIP001 
//STRIP001 	if( pDoc->GetSdPageCount( PK_STANDARD ) > 0 )
//STRIP001 	{
//STRIP001 		Size            aPageSize( pDoc->GetSdPage( 0, PK_STANDARD )->GetSize() );
//STRIP001 		ULONG           nGapX = GetPageGap();
//STRIP001 		ULONG           nGapY = nGapX;
//STRIP001 		Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );
//STRIP001 		
//STRIP001         aSize = pOut->PixelToLogic( aSize );
//STRIP001 		aSize.Height() += aPageSize.Height() / NAME_HEIGHT_FRACTION;
//STRIP001 		
//STRIP001         if( (long) nGapY < aSize.Height() )
//STRIP001 			nGapY = aSize.Height() * 2;
//STRIP001 
//STRIP001 		aResult.X() = nPageNo % nPagesPerRow * ( nGapX + aPageSize.Width() ) + nGapX;
//STRIP001 		aResult.Y() = nPageNo / nPagesPerRow * ( nGapY + aPageSize.Height() ) + nGapY;
//STRIP001 	}
//STRIP001 
//STRIP001     return( aResult );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::ArrangePages()
//STRIP001 {
//STRIP001     const uno::Any  aOldAny, aNewAny;
//STRIP001 	USHORT          nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	USHORT          nPage;
//STRIP001 	Point           aOffset;
//STRIP001 
//STRIP001 	if( nNoOfPages > 0 )
//STRIP001 	{
//STRIP001 		for( nPage = 0; nPage < nNoOfPages; nPage++ )
//STRIP001 		{
//STRIP001 			SetAllowInvalidate( FALSE );
//STRIP001 			aOffset = CalcPagePos( nPage );
//STRIP001 			SdrPage* pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 			SetAllowInvalidate( TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     pSlideViewShell->PageLayoutHasChanged();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Rectangle SdSlideView::GetPageArea( USHORT nPageNo ) const
//STRIP001 {
//STRIP001 	Size    aSize( pDoc->GetSdPage( nPageNo, PK_STANDARD )->GetSize() );
//STRIP001 	Point   aPos( CalcPagePos( nPageNo ) );
//STRIP001 
//STRIP001 	aSize.Height() += aSize.Height() / NAME_HEIGHT_FRACTION + aSize.Height() / NAME_HEIGHT_FRACTION / NAME_OFFSET_FRACTION;
//STRIP001 	Rectangle aResult( aPos, aSize );
//STRIP001 
//STRIP001 	// dazu auf jeder Seite SELRECT_OFFSET Pixel Abstand + SELRECT_THICKNESS Pixel Selektionsrahmen + 2 Pixel Toleranz
//STRIP001 	OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
//STRIP001 	Size            aPixelSize( pOut->PixelToLogic( Size( 1, 1 ) ) );
//STRIP001 	USHORT          nFactor = SELRECT_OFFSET + SELRECT_THICKNESS + 2;
//STRIP001 	
//STRIP001     aResult.Left() -= nFactor * aPixelSize.Width();
//STRIP001 	aResult.Right() += nFactor * aPixelSize.Width();
//STRIP001 	aResult.Top() -= nFactor * aPixelSize.Height();
//STRIP001 	aResult.Bottom() += nFactor * aPixelSize.Height();
//STRIP001 
//STRIP001 	return( aResult );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 ULONG SdSlideView::GetPageGap() const
//STRIP001 {
//STRIP001 	ULONG nResult;
//STRIP001 	
//STRIP001     if( pDoc->GetSdPageCount( PK_STANDARD ) > 0 )
//STRIP001 		nResult = pDoc->GetSdPage( 0, PK_STANDARD )->GetSize().Width() / 8;
//STRIP001     else
//STRIP001         nResult = 0;
//STRIP001 
//STRIP001 	return nResult;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Rectangle SdSlideView::GetFadeIconArea( USHORT nPageNo ) const
//STRIP001 {
//STRIP001 	SdPage*         pPage = pDoc->GetSdPage( nPageNo, PK_STANDARD );
//STRIP001 	Size	        aPageSize( pPage->GetSize() );
//STRIP001 	Point	        aPos( CalcPagePos( nPageNo ) );
//STRIP001 	OutputDevice*   pOut = reinterpret_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
//STRIP001 	Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );
//STRIP001 	
//STRIP001     aSize = pOut->PixelToLogic( aSize );
//STRIP001 	aPos.Y() += aPageSize.Height() + aSize.Height();
//STRIP001 
//STRIP001     Rectangle aResult( aPos, Size( aPageSize.Height() / NAME_HEIGHT_FRACTION, aPageSize.Height() / NAME_HEIGHT_FRACTION ) );
//STRIP001 
//STRIP001     return( aResult );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdPage* SdSlideView::GetHitPage( const Point& rPos ) const
//STRIP001 {
//STRIP001     SdPage* pRet = NULL;
//STRIP001     
//STRIP001     for( USHORT nPage = 0, nCount = pDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
//STRIP001         if( GetPageArea( nPage ).IsInside( rPos ) )
//STRIP001             pRet = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001     return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdPage* SdSlideView::GetNearestPage( const Point& rPos ) const
//STRIP001 {
//STRIP001     SdPage* pRet = NULL;
//STRIP001     USHORT  nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 
//STRIP001     if( nPageCount )
//STRIP001     {
//STRIP001         Point       aCenter( GetPageArea( 0 ).Center() );
//STRIP001         USHORT      nBestPage = 0;
//STRIP001         double      fBestDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );
//STRIP001 
//STRIP001         for( USHORT nPage = 1; nPage < nPageCount; nPage++ )
//STRIP001         {
//STRIP001             aCenter = GetPageArea( nPage ).Center();
//STRIP001             const double fDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );
//STRIP001 
//STRIP001             if( fDist < fBestDist )
//STRIP001             {
//STRIP001                 nBestPage = nPage;
//STRIP001                 fBestDist = fDist;
//STRIP001                 
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         pRet = pDoc->GetSdPage( nBestPage, PK_STANDARD );
//STRIP001     }
//STRIP001 
//STRIP001     return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdPage* SdSlideView::GetFadePage( const Point& rPos ) const
//STRIP001 {
//STRIP001     SdPage* pRet = NULL;
//STRIP001     
//STRIP001     for( USHORT nPage = 0, nCount = pDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
//STRIP001         if( GetFadeIconArea( nPage ).IsInside( rPos ) )
//STRIP001             pRet = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001     return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::AddToCache( SdPage* pPage, const Bitmap& rBitmap, long nZoom )
//STRIP001 {
//STRIP001 	if( !pCache )
//STRIP001         pCache = new BitmapCache( BITMAPCACHE_SIZE );
//STRIP001 	
//STRIP001     pCache->Add(pPage, rBitmap, nZoom);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 const GraphicObject* SdSlideView::GetFromCache( SdPage* pPage, long& rZoom, long nZoomTolerance) const
//STRIP001 {
//STRIP001 	const GraphicObject* pGraphicObject = NULL;
//STRIP001 	
//STRIP001     if( pCache )
//STRIP001 		pGraphicObject = pCache->Get( pPage, rZoom, nZoomTolerance );
//STRIP001 
//STRIP001 	return pGraphicObject;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdSlideView, PaintDelayed, Timer *, pTimer )
//STRIP001 {
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if( aDelayedPaints.Count() > 0 )
//STRIP001 		{
//STRIP001 			FuPoor* pFu = pSlideViewShell->GetActualFunction();
//STRIP001 			
//STRIP001             if (!pFu									||
//STRIP001 				(pFu && !pFu->ISA(FuSlideSelection))	||
//STRIP001 				(pFu && pFu->ISA(FuSlideSelection) &&
//STRIP001 				!((FuSlideSelection*)pFu)->IsShowingEffect()))
//STRIP001 			{
//STRIP001 				DelayedPaintEvent* pEvent = static_cast< DelayedPaintEvent* >( aDelayedPaints.Remove( (ULONG) 0 ) );
//STRIP001 				
//STRIP001                 bInDelayedPaint = TRUE;
//STRIP001 
//STRIP001 				if( OUTDEV_WINDOW == pEvent->pOut->GetOutDevType() )
//STRIP001 				{
//STRIP001 					static_cast< Window* >( pEvent->pOut )->Invalidate( pEvent->aRect );
//STRIP001 					static_cast< Window* >( pEvent->pOut )->Update();
//STRIP001 				}
//STRIP001 				else
//STRIP001 					Paint( pEvent->aRect, pEvent->pOut );
//STRIP001 
//STRIP001 				bInDelayedPaint = FALSE;
//STRIP001 				delete pEvent;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	while (!GetpApp()->AnyInput() && aDelayedPaints.Count() > 0 );
//STRIP001 
//STRIP001 	pTimer->Start();
//STRIP001 	
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 							           const SfxHint& rHint, const TypeId& rHintType)
//STRIP001 {
//STRIP001 	SdrHint* pSdrHint = PTR_CAST( SdrHint, &rHint );
//STRIP001 
//STRIP001 	if( pSdrHint )
//STRIP001 	{
//STRIP001 		SdrHintKind eHint = pSdrHint->GetKind();
//STRIP001 
//STRIP001 		if( eHint == HINT_PAGEORDERCHG )
//STRIP001 		{
//STRIP001 			ArrangePages();
//STRIP001 			InvalidateAllWin();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SdrPage* pChangedPage = pSdrHint->GetPage();
//STRIP001 
//STRIP001 			if( pChangedPage )
//STRIP001 			{
//STRIP001 				if( pChangedPage->IsMasterPage() )
//STRIP001 				{
//STRIP001 					if( pCache )
//STRIP001 						delete pCache, pCache = NULL;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SdrPageView* pPageView = GetPageView( pChangedPage );
//STRIP001 
//STRIP001 					if( pPageView && pCache )
//STRIP001 					    pCache->Remove( (SdPage*) pChangedPage );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SdView::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::SetAllowInvalidate(BOOL bFlag)
//STRIP001 {
//STRIP001 	if( !bFlag )
//STRIP001 		nAllowInvalidateSmph++;
//STRIP001 	else if( nAllowInvalidateSmph > 0 )
//STRIP001 		nAllowInvalidateSmph--;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdSlideView::IsInvalidateAllowed() const
//STRIP001 {
//STRIP001 	return( nAllowInvalidateSmph == 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::DeleteMarked()
//STRIP001 {
//STRIP001 	String  aStr( SdResId( STR_UNDO_DELETEPAGES ) );
//STRIP001 	USHORT  nPage = 0, nOldFocusPage = nFocusPage;
//STRIP001 	SdPage* pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001     // hide focus if necessary
//STRIP001     if( SDRPAGE_NOTFOUND != nOldFocusPage )
//STRIP001         pSlideViewShell->DrawFocusRect( nFocusPage = SDRPAGE_NOTFOUND );
//STRIP001 	
//STRIP001     BegUndo( aStr );
//STRIP001 
//STRIP001 	while( pPage )
//STRIP001 	{
//STRIP001 		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001 		if( pPage->IsSelected() && pDoc->GetSdPageCount( PK_STANDARD ) > 1 )
//STRIP001 		{
//STRIP001 			AddUndo( new SdrUndoDelPage( *pPage ) );
//STRIP001 			pDoc->RemovePage( pPage->GetPageNum() );
//STRIP001 			pPage = pDoc->GetSdPage( nPage, PK_NOTES );
//STRIP001 			AddUndo( new SdrUndoDelPage( *pPage ) );
//STRIP001 			pDoc->RemovePage( pPage->GetPageNum() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nPage++;
//STRIP001 
//STRIP001 		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 
//STRIP001     // show focus if necessary
//STRIP001     const USHORT nNewPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001     if( ( SDRPAGE_NOTFOUND != nOldFocusPage ) && nNewPageCount )
//STRIP001         pSlideViewShell->DrawFocusRect( nFocusPage = (USHORT) Min( (ULONG) nOldFocusPage, (ULONG) nNewPageCount - 1 ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::MoveMarked( USHORT nTargetPage )
//STRIP001 {
//STRIP001 	String                      aComment ( SdResId( STR_UNDO_SLIDE_MOVE ) );
//STRIP001 	USHORT	                    nPage, nNoOfPages = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001     ::std::vector< SdPage* >    aOldPageVect( nNoOfPages );
//STRIP001 
//STRIP001 	for( nPage = 0; nPage < nNoOfPages; nPage++ )
//STRIP001 		aOldPageVect[ nPage ] = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001 	SetAllowInvalidate( FALSE );
//STRIP001 	BOOL bMoved = pDoc->MovePages( nTargetPage );
//STRIP001 	SetAllowInvalidate( TRUE );
//STRIP001 
//STRIP001 	if( bMoved )
//STRIP001 	{
//STRIP001         ::std::vector< SdPage* > aNewPageVect( nNoOfPages );
//STRIP001 
//STRIP001 		for( nPage = 0; nPage < nNoOfPages; nPage++ )
//STRIP001 		    aNewPageVect[ nPage ] = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001 		ArrangePages();
//STRIP001 
//STRIP001 		for( nPage = 0; nPage < nNoOfPages; nPage++ )
//STRIP001 		{
//STRIP001 			if( aNewPageVect[ nPage ] != aOldPageVect[ nPage ] )
//STRIP001 			{
//STRIP001 				InvalidateAllWin( GetPageArea( nPage ) );
//STRIP001 				pViewSh->UpdateWindows();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::CreateSlideTransferable( Window* pWindow, BOOL bDrag )
//STRIP001 {
//STRIP001 	List	aBookmarkList;
//STRIP001 	SdPage* pPage = NULL;
//STRIP001 
//STRIP001 	for( USHORT nPage = 0, nPgCnt = pDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
//STRIP001 	{
//STRIP001 		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 
//STRIP001 		if( pPage->IsSelected() )
//STRIP001 			aBookmarkList.Insert( new String( pPage->GetName() ), LIST_APPEND );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aBookmarkList.Count() )
//STRIP001 	{
//STRIP001 		BrkAction();
//STRIP001 
//STRIP001     	SdTransferable* pTransferable = new SdTransferable( pDoc, NULL, FALSE );
//STRIP001 	    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
//STRIP001     	TransferableObjectDescriptor aObjDesc;
//STRIP001 
//STRIP001         if( bDrag )
//STRIP001     	    SD_MOD()->pTransferDrag = pTransferable;
//STRIP001         else
//STRIP001     	    SD_MOD()->pTransferClip = pTransferable;
//STRIP001 
//STRIP001 	    pDoc->CreatingDataObj( pTransferable );
//STRIP001 	    pTransferable->SetWorkDocument( (SdDrawDocument*) GetAllMarkedModel() );
//STRIP001 	    pDoc->CreatingDataObj( NULL );
//STRIP001         pTransferable->GetWorkDocument()->GetDocSh()->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 
//STRIP001 	    if( pDocSh )
//STRIP001 		    aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 
//STRIP001         Window* pActionWindow = ( pWindow ? pWindow : pViewSh->GetActiveWindow() );
//STRIP001    
//STRIP001     	pTransferable->SetStartPos( pActionWindow->PixelToLogic( pActionWindow->GetPointerPosPixel() ) );
//STRIP001     	pTransferable->SetObjectDescriptor( aObjDesc );
//STRIP001 		pTransferable->SetPageBookmarks( aBookmarkList, !bDrag );
//STRIP001 
//STRIP001 		for( void* p = aBookmarkList.First(); p; p = aBookmarkList.Next() )
//STRIP001 			delete static_cast< String* >( p );
//STRIP001 
//STRIP001         if( bDrag )
//STRIP001         {
//STRIP001             pTransferable->SetView( this );
//STRIP001     	    pTransferable->StartDrag( pActionWindow, DND_ACTION_COPY | DND_ACTION_MOVE );
//STRIP001         }
//STRIP001         else
//STRIP001     	    pTransferable->CopyToClipboard( pActionWindow );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::DoCut( Window* pWindow )
//STRIP001 {
//STRIP001 	String aString( SdResId( STR_WARN_DEL_SEL_PAGES ) );
//STRIP001 
//STRIP001 	if( pDoc->GetSdPageCount( PK_STANDARD ) > 1 && QueryBox( pWindow, WB_YES_NO, aString ).Execute() == RET_YES )
//STRIP001 	{
//STRIP001 		DoCopy( pWindow );
//STRIP001 		DeleteMarked();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::DoCopy( Window* pWindow )
//STRIP001 {
//STRIP001     CreateSlideTransferable( pWindow, FALSE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::DoPaste( Window* pWindow )
//STRIP001 {
//STRIP001     SdTransferable* pClipTransferable = SD_MOD()->pTransferClip;
//STRIP001 
//STRIP001     if( pClipTransferable && pClipTransferable->IsPageTransferable() )
//STRIP001     {
//STRIP001 		USHORT	nInsertPgCnt, nInsertPos = 0; // pDoc->GetSdPageCount( PK_STANDARD ) * 2 + 1;
//STRIP001 		USHORT	nPgCnt = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 		BOOL	bMergeMasterPages = !pClipTransferable->HasSourceDoc( pDoc );
//STRIP001 
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 		while( (nInsertPos < nCount) && !pDoc->GetSdPage( nInsertPos, PK_STANDARD )->IsSelected() )
//STRIP001 			nInsertPos++;
//STRIP001 
//STRIP001 		if( nInsertPos < nCount )
//STRIP001 			nInsertPos++;
//STRIP001 
//STRIP001 		nInsertPos = nInsertPos * 2 + 1;
//STRIP001 
//STRIP001         if( HasFocus() )
//STRIP001         {
//STRIP001             SdInsertPasteDlg aDlg( pWindow );
//STRIP001 
//STRIP001             if( aDlg.Execute() != RET_OK )
//STRIP001                 return;
//STRIP001 
//STRIP001             nInsertPos = GetFocusPage() * 2 + ( aDlg.IsInsertBefore() ? 1 : 3 );
//STRIP001         }
//STRIP001 
//STRIP001         if( pClipTransferable->HasPageBookmarks() )
//STRIP001         {
//STRIP001             const List&         rBookmarkList = pClipTransferable->GetPageBookmarks();
//STRIP001             const ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 		    
//STRIP001             nInsertPgCnt = (USHORT) rBookmarkList.Count();
//STRIP001 		    pDoc->InsertBookmarkAsPage( const_cast< List* >( &rBookmarkList ), NULL, FALSE, FALSE, nInsertPos, 
//STRIP001                                         FALSE, pClipTransferable->GetPageDocShell(), TRUE, bMergeMasterPages, FALSE );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001 			SvEmbeddedObject*	pObj = pClipTransferable->GetDocShell();
//STRIP001 			SdDrawDocShell*		pDataDocSh = (SdDrawDocShell*) pObj;
//STRIP001 			SdDrawDocument*		pDataDoc = pDataDocSh->GetDoc();
//STRIP001 
//STRIP001 			if( pDataDoc && pDataDoc->GetSdPageCount( PK_STANDARD ) )
//STRIP001 			{
//STRIP001                 const ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 				
//STRIP001                 nInsertPgCnt = pDataDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 				pDoc->InsertBookmarkAsPage( NULL, NULL, FALSE, FALSE, nInsertPos, 
//STRIP001                                             FALSE, pDataDocSh, TRUE, bMergeMasterPages, FALSE );
//STRIP001 			}
//STRIP001         }
//STRIP001        
//STRIP001 	    SfxUInt16Item aItem( SID_PAGES_PER_ROW, nPagesPerRow);
//STRIP001 
//STRIP001 	    ( pDocSh->GetViewShell() ? pDocSh->GetViewShell()->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->Execute(
//STRIP001 		    SID_PAGES_PER_ROW, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L, 0L );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::StartDrag( const Point& rDragPt, Window* pWindow )
//STRIP001 {
//STRIP001     CreateSlideTransferable( pWindow, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
//STRIP001 
//STRIP001 	if( pDragTransferable )
//STRIP001 		pDragTransferable->SetView( NULL );
//STRIP001 
//STRIP001 	if( nDropAction & DND_ACTION_MOVE )
//STRIP001         DeleteMarked();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 SdSlideView::AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
//STRIP001                                   SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001     SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
//STRIP001     sal_Int8        nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     if( pDragTransferable && pDragTransferable->IsPageTransferable() )
//STRIP001         nRet = rEvt.mnAction;
//STRIP001 
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 SdSlideView::ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                    SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001     SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
//STRIP001     sal_Int8        nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     if( pDragTransferable && pDragTransferable->IsPageTransferable() )
//STRIP001     {
//STRIP001         const Point aEvtPos( pTargetWindow->PixelToLogic( rEvt.maPosPixel ) );
//STRIP001         const BOOL  bCont = ( pDragTransferable->GetView() != this ) ||
//STRIP001                             ( ( labs( pDragTransferable->GetStartPos().X() - aEvtPos.X() ) >= 2 ) &&
//STRIP001                               ( labs( pDragTransferable->GetStartPos().Y() - aEvtPos.Y() ) >= 2 ) );
//STRIP001 
//STRIP001         if( bCont )
//STRIP001         {
//STRIP001             SdPage* pNearestSdPage = GetNearestPage( aEvtPos );
//STRIP001             USHORT  nNearestSdPagePos = pNearestSdPage ? ( ( pNearestSdPage->GetPageNum() - 1 ) / 2 ) : ( pDoc->GetSdPageCount( PK_STANDARD ) - 1 );
//STRIP001 
//STRIP001             if( ( pDragTransferable->GetView() == this ) && ( DND_ACTION_MOVE == rEvt.mnAction ) )
//STRIP001             {
//STRIP001                 MoveMarked( nNearestSdPagePos );
//STRIP001                 nRet = DND_ACTION_NONE;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001 		        USHORT	nInsertPgCnt, nInsertPos = ( nNearestSdPagePos + 1 ) * 2 + 1;
//STRIP001                 BOOL    bMergeMasterPages = !pDragTransferable->HasSourceDoc( pDoc );
//STRIP001 
//STRIP001                 if( pDragTransferable->HasPageBookmarks() )
//STRIP001                 {
//STRIP001                     const List& rBookmarkList = pDragTransferable->GetPageBookmarks();
//STRIP001 		            
//STRIP001                     nInsertPgCnt = (USHORT) rBookmarkList.Count();
//STRIP001 		            pDoc->InsertBookmarkAsPage( const_cast< List* >( &rBookmarkList ), NULL, FALSE, FALSE, nInsertPos, TRUE, pDragTransferable->GetPageDocShell(), TRUE, bMergeMasterPages, FALSE );
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001 		            SvEmbeddedObject*	pObj = pDragTransferable->GetDocShell();
//STRIP001 		            SdDrawDocShell*		pDataDocSh = pDragTransferable->HasPageBookmarks() ? pDragTransferable->GetPageDocShell() : ( (SdDrawDocShell*) pObj );
//STRIP001 		            SdDrawDocument*		pDataDoc = pDataDocSh->GetDoc();
//STRIP001 		            
//STRIP001                     nInsertPgCnt = pDataDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 		            pDoc->InsertBookmarkAsPage( NULL, NULL, FALSE, FALSE, nInsertPos, TRUE, pDataDocSh, TRUE, bMergeMasterPages, FALSE );
//STRIP001                 }
//STRIP001 
//STRIP001 		        // deselect all pages
//STRIP001 		        for( USHORT nPage = 0, nPgCnt = pDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
//STRIP001 			        pDoc->GetSdPage( nPage, PK_STANDARD )->SetSelected( FALSE );
//STRIP001 
//STRIP001 		        // select inserted pages
//STRIP001                 for( USHORT i = 1; i <= nInsertPgCnt; i++ )
//STRIP001                 {
//STRIP001     		        SdPage*	pPage = pDoc->GetSdPage( nNearestSdPagePos + i, PK_STANDARD );
//STRIP001 
//STRIP001 	    	        if( pPage )
//STRIP001 		    	        pPage->SetSelected( TRUE );
//STRIP001                 }
//STRIP001 
//STRIP001                 // Update
//STRIP001                 ( (SdSlideViewShell*) pViewSh )->SetPagesPerRow( nPagesPerRow );
//STRIP001                 nRet = rEvt.mnAction;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdSlideView::UpdateAllPages()
//STRIP001 {
//STRIP001 	delete pCache, pCache = NULL;
//STRIP001 	InvalidateAllWin();
//STRIP001 }
}
