/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accelcfg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:54:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef INCLUDED_SFX_ACCELCFG_HXX
#define INCLUDED_SFX_ACCELCFG_HXX

#ifndef _COM_SUN_STAR_AWT_KEYEVENT_HPP_
#include <com/sun/star/awt/KeyEvent.hpp>
#endif

#include <rtl/ustring.hxx>
#include <tools/stream.hxx>

#include "accmgr.hxx"
class SvStream;
class KeyEvent;
class String;
class Accelerator;
namespace binfilter {


class SfxAcceleratorConfig_Impl;

class SfxAcceleratorConfiguration
{
    SfxAcceleratorConfig_Impl*    pImp;

private:

public:
                    // get the global accelerators
                    SfxAcceleratorConfiguration();

                    ~SfxAcceleratorConfiguration();

	bool			Load( SvStream& rStream );

					// save the configuration to a stream, f.e. into a document
    bool            Commit( SvStream& rStream );

                    // returns the whole configuration
    const SfxAcceleratorItemList& GetItems();

                    // sets a single configuration item
    void            SetCommand( const SfxAcceleratorConfigItem& rItem );

                    // sets several or all configuration items
                    // if bClear=FALSE, all items not in the sequence remain unchanged
    void            SetItems( const SfxAcceleratorItemList& rItems, bool bClear );
};

}//end of namespace binfilter
#endif
