/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpOutputStream.java,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:37:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

 /**
  * Buffers the output written by XSLProcessor
  */

package com.sun.star.help;

import java.io.*;
import com.sun.star.uno.*;
import com.sun.star.io.*;


public final class HelpOutputStream extends OutputStream {

  	int pos;
  	private byte[] smallbuffer;
  	private byte[] bigbuffer;


  	public HelpOutputStream( )
  	{
    	pos = 0;
    	smallbuffer = new byte[1024];
    	bigbuffer = null;
  	}


  	public void write(int b) throws java.io.IOException
  	{
    	if( pos == 1024)
    	{
      		write( null );
      		pos = 0;
    	}
    	smallbuffer[pos++] = ( byte ) b;
  	}


  	public void write(byte b[]) throws java.io.IOException
  	{
    	try
    	{
      		if( b != null )
      		{
        		pos = b.length;
        		smallbuffer = b;
      		}

      		int i;
      		int old = ( bigbuffer == null ) ? 0 : bigbuffer.length;
      		byte[] temp = new byte[ old + pos ];

      		for( i = 0; i < old; ++i )
        		temp[i] = bigbuffer[i];

      		for( i = 0; i < pos; ++i )
      			temp[i + old ] = smallbuffer[i];

      		bigbuffer = temp;
    	}
    	catch( com.sun.star.uno.RuntimeException e )
    	{
      		throw new java.io.IOException( e.getMessage() );
    	}
  	}


  	public void flush() throws java.io.IOException
  	{
  		// String html = "<HTML>  bluber </HTML>";
   		// bigbuffer = html.getBytes();
    	// return;

    	write( null );
		pos = 0;
  	}


  	public void close() throws java.io.IOException
  	{
		// Must not close anything
  	}


	public byte[] getBigBuffer()
 	{
  		return bigbuffer;
  	}


   	public void setBigBuffer( byte[] buffer )
   	{
   		bigbuffer = buffer;
    }


  	public void writeToXOutputStream( XOutputStream stream )
     	throws 	com.sun.star.uno.Exception,
  				com.sun.star.uno.RuntimeException,
                com.sun.star.ucb.CommandAbortedException
  	{
  		try
   		{
  			if( bigbuffer != null )
     			stream.writeBytes( bigbuffer );
			stream.closeOutput();
    	}
    	catch( NotConnectedException e )
    	{
      		throw new com.sun.star.ucb.CommandAbortedException( e.getMessage() );
    	}
    	catch( BufferSizeExceededException e )
    	{
      		throw new com.sun.star.ucb.CommandAbortedException( e.getMessage() );
    	}
    	catch( com.sun.star.io.IOException e )
    	{
      		throw new com.sun.star.ucb.CommandAbortedException( e.getMessage() );
    	}
  	}



   	final class XInputStreamImpl implements XSeekable,XInputStream
    {
    	private int offset = 0;
		private int read = offset;

  		XInputStreamImpl()
    	{
     	}

 		// XSeekable

  		public synchronized long getLength() throws com.sun.star.io.IOException,com.sun.star.uno.RuntimeException
   		{
     		if( bigbuffer != null )
    			return bigbuffer.length - offset;
       		else
         		return 0;
    	}

  		public synchronized long getPosition() throws com.sun.star.io.IOException,com.sun.star.uno.RuntimeException
   		{
    		return read - offset ;
    	}

   		public synchronized void seek(long p0) throws IllegalArgumentException,com.sun.star.io.IOException,com.sun.star.uno.RuntimeException
    	{
     		if( bigbuffer != null )
       		{
				p0 +=offset;
    			int curr = ( int ) p0;
     			if( curr < offset )
      			{
      				throw new IllegalArgumentException();
        		}
        		else if( curr > bigbuffer.length )
        			curr = bigbuffer.length;

        		read = curr;
          	}
           	else
            	read = 0;
    	}


  		// XInputStream

  		public synchronized int available() throws NotConnectedException,com.sun.star.io.IOException, com.sun.star.uno.RuntimeException
  		{
    		if( bigbuffer != null )
    			return ( bigbuffer.length - read );
       		else
         		return 0;
  		}

  		public void closeInput()
    		throws NotConnectedException,com.sun.star.io.IOException, com.sun.star.uno.RuntimeException
  		{
    		read = -1;
			// bigbuffer = null;
  		}


  		public synchronized int readBytes(byte[][] p0, int p1)
    		throws NotConnectedException, BufferSizeExceededException,com.sun.star.io.IOException, com.sun.star.uno.RuntimeException
  		{
    		if( bigbuffer != null )
      		{
    			if( read == -1 )
      			return 0;

    			int i = 0;
    			int available = ( p1 > bigbuffer.length - read ) ? bigbuffer.length - read : p1;

   				p0[0] = new byte[p1];
   				while( available != 0 )
   				{
   					p0[0][i++] = bigbuffer[read++];
 					--available;
   				}

    			return i;
       		}
         	else
          	{
           		p0[0] = new byte[0];
          		return 0;
            }
  		}


  		public synchronized int readSomeBytes(byte[][] p0, int p1)
    		throws 	NotConnectedException,
      			   	BufferSizeExceededException,
            		com.sun.star.io.IOException,
              		com.sun.star.uno.RuntimeException
  		{
    		return readBytes( p0,p1 );
  		}


  		public synchronized void skipBytes(int p0)
    		throws 	NotConnectedException, BufferSizeExceededException,
      				com.sun.star.io.IOException,
          			com.sun.star.uno.RuntimeException
  		{
    		read += p0;

     		if( read > bigbuffer.length )
      			read = bigbuffer.length;

         	if( read < offset )
          		read = offset;
  		}
	}


   	public XInputStream getNewInputStream()
    {
    	return new XInputStreamImpl();
    }

}
