/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* NDC.cpp - wraps log4cpp NDC with a simple class object

   Scott Cantor
   9/8/02

   $History:$
*/

#include "internal.h"

#include <openssl/rand.h>

#if defined(HAVE_LOG4SHIB)
# include <log4shib/NDC.hh>
#elif defined(HAVE_LOG4CPP)
# include <log4cpp/NDC.hh>
#else
# error "Supported logging library not available."
#endif

using namespace saml;
using namespace std;

saml::NDC::NDC()
{
    unsigned char key[17];
    int ret=RAND_pseudo_bytes(key,16);
    if (ret<0)
        throw SAMLException("SAMLIdentifier() unable to generate a random identifier; was OpenSSL seeded?");
    
    char hexform[33];
    sprintf(hexform,"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
            key[0],key[1],key[2],key[3],key[4],key[5],key[6],key[7],
            key[8],key[9],key[10],key[11],key[12],key[13],key[14],key[15]);
    hexform[32]=0;

    logging::NDC::push(hexform);
}

saml::NDC::NDC(const char* context)
{
    logging::NDC::push(context);
}

saml::NDC::NDC(string& context)
{
    logging::NDC::push(context);
}

saml::NDC::~NDC()
{
    logging::NDC::pop();
}
