<?php
/*
 * $Id: class.htmlDepartments.inc.php,v 1.3 2001/05/30 05:00:37 themaniac Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */



class htmlDepartments
{
	function createCombo($default = 0, $cbName = 'department', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'department', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		$objDBDept = CreateObject('ccs.dbDepartments');

		$query = "SELECT id,$longShort FROM osims_departments ";

		if ($activeOnly)
			$query .= 'WHERE active=\'Y\' ';

		$query .= "ORDER BY $longShort";
		$objDBDept->db->query($query);
		//	$objDBDept->db->next_record;
		$str = "<select name=\"$cbName";
		if ($size > 0)
			$str .= '[]" multiple size=' . $size;
		else
			$str .= '"';
		$str .= '>';
		if ($size == 0)
			$str .= sprintf('<option value="0">%s</option>', 'Select Department');

		while ($objDBDept->db->next_record())
		{
			$id = $objDBDept->db->f('id');
			$name = $objDBDept->db->f('name');
			$str .= '<option value="'. $id . '"';
			if ($id == $default)
				$str .= ' selected';
			$str .= '>' . $name . '</option>';

			//if ($objDBDept->db->next_record() == -1)
			//break;
		}

		$str .= '</select>';

		return $str;
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		$objDBDepts = CreateObject('ccs.dbDepartments');


		$objDBDepts->db->query("SELECT id,active,short,name FROM osims_departments ORDER BY $orderBy");
		$allRecs = $objDBDepts->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="alight" href="index.php?menuAction=ccs.boDepartments.add">[ New ]</a>';
		else
			$titleLink = '';

		if (is_array($allRecs))
		{
			$allName = array(
					0 => 'Department ID', 
					1 => 'Active', 
					2 => 'Short', 
					3 => 'Department Name');

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = 'Options';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="index.php?menuAction=ccs.boDepartments.modify&id=' . $allRecs[$i][0] . '">' . Edit . '</a>';
					$options .= "&nbsp;";
					$options .= '<a class="adark" href="index.php?menuAction=ccs.boDepartments.delete&id=' . $allRecs[$i][0] . '">' . Delete . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf('Departments', $orderBy), '', $titleLink);
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont(STR_DEPT_NODEPTS . '&nbsp;&nbsp;' . $titleLink);
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info,$phpgw;

		$isEdit = is_object($obj);
		$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
		$Template->set_file(array('hForm' => 'htmlDepartmentsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_DEPT_EDIT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="ccs.boDepartments.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_DEPT_ADD);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="ccs.boDepartments.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

			// Labels
		$Template->set_var('TXT_ACTIVE', STR_DEPT_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_DEPT_SHORT);
		$Template->set_var('TXT_NAME', STR_DEPT_NAME);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_DEPT_HIGHLIGHTEDNOTE);

			// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}

?>
