<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.uinscontact.inc.php,v 1.22 2001/09/06 22:56:15 bettina Exp $ */

	class uinscontact
	{
		var $action;
		var $grants;
		var $cat_id;
		var $start;
		var $order;
		var $sort;
		var $filter;

		var $public_functions = array
		(
			'prefs_contact'		=> True,
			'add_contact'		=> True,
			'edit_contact'		=> True,
			'delete_contact'	=> True,
			'view_contact'		=> True,
			'prefs_cg'			=> True,
			'add_cg'			=> True,
			'edit_cg'			=> True,
			'view_cg'			=> True,
			'abook'				=> True
		);

		function uinscontact()
		{
			global $phpgw, $phpgw_info, $action;

			$this->account					= $phpgw_info['user']['account_id'];
			$this->t						= $phpgw->template;
			$this->cats						= CreateObject('phpgwapi.categories');
			$this->nextmatchs				= CreateObject('phpgwapi.nextmatchs');
			$this->grants					= $phpgw->acl->get_grants('netsaint');
			$this->grants[$this->account]	= PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;
			$this->bonscontact				= CreateObject('netsaint.bonscontact', True, $action);
			$this->botimeperiod				= CreateObject('netsaint.botimeperiod');
			$this->bonetsaint				= CreateObject('netsaint.bonetsaint');

			$this->start					= $this->bonscontact->start;
			$this->query					= $this->bonscontact->query;
			$this->filter					= $this->bonscontact->filter;
			$this->sort						= $this->bonscontact->sort;
			$this->order					= $this->bonscontact->order;
			$this->cat_id					= $this->bonscontact->cat_id;
		}

		function save_sessiondata($action)
		{
			$data = array
			(
				'start'		=> $this->start,
				'query'		=> $this->query,
				'filter'	=> $this->filter,
				'sort'		=> $this->sort,
				'order'		=> $this->order,
				'cat_id'	=> $this->cat_id
			);
			$this->bonscontact->save_sessiondata($data, $action);
		}

		function set_app_langs()
		{
			global $phpgw, $phpgw_info;

			$this->t->set_var('bg_color',$phpgw_info['theme']['th_bg']);
			$this->t->set_var('row_on',$phpgw_info['theme']['row_on']);
			$this->t->set_var('row_off',$phpgw_info['theme']['row_off']);
			$this->t->set_var('lang_netsaint',lang('Netsaint'));
			$this->t->set_var('lang_prefs',lang('Preferences'));
			$this->t->set_var('lang_timeperiods',lang('Time Periods'));
			$this->t->set_var('lang_hosts',lang('Hosts'));
			$this->t->set_var('lang_host_groups',lang('Host groups'));
			$this->t->set_var('lang_contacts',lang('Contacts'));
			$this->t->set_var('lang_contact_groups',lang('Contact groups'));
			$this->t->set_var('lang_services',lang('Services'));
			$this->t->set_var('lang_notifications',lang('Notifications'));
			$this->t->set_var('lang_s_escalation',lang('Service escalation'));
			$this->t->set_var('lang_hg_escalation',lang('Host group escalation'));
			$this->t->set_var('lang_escalations',lang('Escalations'));

			$this->t->set_var('lang_done',lang('Done'));
			$this->t->set_var('lang_view',lang('View'));
			$this->t->set_var('lang_edit',lang('Edit'));
			$this->t->set_var('lang_save',lang('Save'));
			$this->t->set_var('lang_delete',lang('Delete'));

			$this->t->set_var('lang_csv_period',lang('Time period to notify of service states'));
			$this->t->set_var('lang_h_period',lang('Time period to notify of host states'));
			$this->t->set_var('lang_s_rec',lang('Notify on service recoveries ?'));
			$this->t->set_var('lang_s_crit',lang('Notify on critical service states ?'));
			$this->t->set_var('lang_s_warn',lang('Notify on warning service states ?'));

			$this->t->set_var('lang_alias',lang('Description'));
			$this->t->set_var('lang_cat',lang('Category'));
			$this->t->set_var('lang_private',lang('Private'));
			$this->t->set_var('lang_access',lang('Access'));
			$this->t->set_var('lang_contact',lang('Contact'));
			$this->t->set_var('lang_name',lang('Short name'));

			$this->t->set_var('lang_h_rec',lang('Notify on host recoveries ?'));
			$this->t->set_var('lang_h_down',lang('Notify when hosts are down ?'));
			$this->t->set_var('lang_h_unreach',lang('Notify when hosts are unreachable ?'));

			$this->t->set_var('lang_s_comand',lang('Command to notify of service states'));
			$this->t->set_var('lang_h_comand',lang('Command to notify of host states'));

			$this->t->set_var('lang_bselect',lang('Select per button !'));
			$this->t->set_var('lang_select',lang('Select'));

			$this->t->set_var('lang_created',lang('Created by'));
			$this->t->set_var('lang_modified',lang('last modified'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_all',lang('All'));
		}

		function display_prefs_header()
		{
			global $phpgw, $phpgw_info, $Update;

			$this->t->set_file(array('prefs' => 'prefs_header.tpl'));
            $this->t->set_block('prefs','header');

			if ($Update)
			{
				$msg = $this->bonetsaint->check_config();

				if (is_array($msg))
				{
					$this->t->set_var('message',$phpgw->common->error_list($msg));
				}
				else
				{
					$this->bonetsaint->create_config();
					$this->t->set_var('message',lang('Netsaint configuration files have been created successfully !'));
					$this->bonetsaint->set_config_status('off');
				}
			}

			$this->set_app_langs();

			$this->t->set_var('link_time',$phpgw->link('/index.php','menuaction=netsaint.uitimeperiod.prefs_time'));
			$this->t->set_var('link_host',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_host&action=host'));
			$this->t->set_var('link_host_group',$phpgw->link('/index.php','menuaction=netsaint.uinshost.prefs_hg&action=hg'));
			$this->t->set_var('link_contact',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_contact&action=contact'));
			$this->t->set_var('link_contact_group',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.prefs_cg&action=cg'));
			$this->t->set_var('link_service',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_service&action=service'));
			$this->t->set_var('link_escalation',$phpgw->link('/index.php','menuaction=netsaint.uinetsaint.prefs_escal&action=host'));

			$update_config = $this->bonetsaint->check_config_status();

			if ($update_config == True)
			{
				$this->t->set_var('update','<form method="POST"><input type="submit" name="Update" value="' . lang('Update') . '"></form>');
			}
			else
			{
				$this->t->set_var('update','');
			}

			$this->t->fp('prefs','header');

			$phpgw->common->phpgw_header();
			echo parse_navbar();
		}

		function abook()
		{
			global $phpgw, $phpgw_info, $start, $cat_id, $sort, $order, $filter, $qfilter;

			$this->t->set_file(array('abook_list_t' => 'abook.tpl'));
			$this->t->set_block('abook_list_t','abook_list','list');

			$c = CreateObject('phpgwapi.categories');
			$c->app_name = 'addressbook';

			$this->set_app_langs();

			$this->t->set_var('title',$phpgw_info['site_title']);
			$this->t->set_var('lang_action',lang('Address book'));
			$this->t->set_var('charset',$phpgw->translation->translate('charset'));
			$this->t->set_var('font',$phpgw_info['theme']['font']);

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.abook',
				'start'			=> $start,
				'sort'			=> $sort,
				'order'			=> $order,	
				'cat_id'		=> $cat_id,
				'filter'		=> $filter
			);

			if (! $start) { $start = 0; }

			if (!$filter) { $filter = 'none'; }

			$qfilter = 'tid=n';

			switch ($filter)
			{
				case 'none': break;				
				case 'private': $qfilter .= ',access=private'; break;
				case 'yours': $qfilter .= ',owner=' . $this->account; break;
			}

			if ($cat_id)
			{
				$qfilter .= ',cat_id=' . $cat_id;
			}
 
			$entries = $this->bonscontact->read_abook($start, $query, $qfilter, $sort, $order);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$start,$this->bonscontact->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$start,$this->bonscontact->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonscontact->total_records,$start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$c->formated_list('select','all',$cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

// ---------------- list header variable template-declarations --------------------------

// -------------- list header variable template-declaration ------------------------

			$this->t->set_var('sort_email',$this->nextmatchs->show_sort_order($sort,'email',$order,'/index.php',lang('Business E-mail'),$link_data));
			$this->t->set_var('sort_hemail',$this->nextmatchs->show_sort_order($sort,'home_email',$order,'/index.php',lang('Home E-mail'),$link_data));
			$this->t->set_var('sort_pager',$this->nextmatchs->show_sort_order($sort,'tel_pager',$order,'/index.php',lang('Pager'),$link_data));
			$this->t->set_var('sort_firstname',$this->nextmatchs->show_sort_order($sort,'n_given',$order,'/index.php',lang('Firstname'),$link_data));
			$this->t->set_var('sort_lastname',$this->nextmatchs->show_sort_order($sort,'n_family',$order,'/index.php',lang('Lastname'),$link_data));
			$this->t->set_var('lang_select',lang('Select'));

// ------------------------- end header declaration --------------------------------

			for ($i=0;$i<count($entries);$i++)
			{
				$this->t->set_var('tr_color',$this->nextmatchs->alternate_row_color($tr_color));
				$firstname = $entries[$i]['n_given'];
				if (!$firstname) { $firstname = '&nbsp;'; }
				$lastname = $entries[$i]['n_family'];
				if (!$lastname) { $lastname = '&nbsp;'; }
				$email = $entries[$i]['email'];
				if (!$email) { $email = '&nbsp;'; }
				$hemail = $entries[$i]['email_home'];
				if (!$hemail) { $hemail = '&nbsp;'; }
				$pager = $entries[$i]['tel_pager'];
				if (!$pager) { $pager = '&nbsp;'; }

// ---------------- template declaration for list records -------------------------- 

				$this->t->set_var(array('email' 	=> $email,
									'firstname' 	=> $firstname,
									'lastname'		=> $lastname,
									'pager'			=> $pager,
									'hemail'		=> $hemail));

				$this->t->parse('list','abook_list',True);
			}

			$this->t->set_var('lang_done',lang('Done'));
			$this->t->parse('out','abook_list_t',True);
			$this->t->p('out');

			$phpgw->common->phpgw_exit();
		}

		function prefs_contact()
		{
			global $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'contact_list_t' => 'prefs_contact.tpl'));
			$this->t->set_block('contact_list_t','contact_list','list');

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.prefs_contact',
				'action'		=> 'contact'
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$contact_list = $this->bonscontact->read_contacts('contact',$this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonscontact->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonscontact->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonscontact->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Contacts'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'c_name',$this->order,'/index.php',lang('Short name'),$link_data));
			$this->t->set_var(sort_email,$this->nextmatchs->show_sort_order($this->sort,'c_email',$this->order,'/index.php',lang('E-Mail'),$link_data));
			$this->t->set_var(sort_pager,$this->nextmatchs->show_sort_order($this->sort,'c_pager',$this->order,'/index.php',lang('Pager'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'c_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($contact_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);

				$email = $phpgw->strip_html($contact_list[$i]['email']);
				if (!$email)
				{
					$email = '&nbsp;';
				}

				$pager = $phpgw->strip_html($contact_list[$i]['pager']);
				if (!$pager)
				{
					$pager = '&nbsp;';
				}

				$new_date = $contact_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$this->t->set_var(array
				(
					'c_name'	=> $phpgw->strip_html($contact_list[$i]['name']),
					'email'		=> $email,
					'pager'		=> $pager,
					'modified'	=> $new_dateout
				));

				$link_data['c_id'] = $contact_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinscontact.view_contact';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$contact_list[$i]['owner']],PHPGW_ACL_EDIT) || $contact_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinscontact.edit_contact';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$contact_list[$i]['owner']],PHPGW_ACL_DELETE) || $contact_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinscontact.delete_contact';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','contact_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'netsaint.uinscontact.add_contact';
			$link_data['cat_id']		= $cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add contact') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add contact') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','contact_list_t',True);
			$this->save_sessiondata('contact');
//			$phpgw->common->phpgw_footer();
		}

		function add_contact()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $email, $hemail, $pager, $snot, $hnot, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.add_contact',
				'action'		=> 'contact'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				if ($values['check_pager'])
				{
					$values['pager'] = $pager;
				}

				if ($values['check_wemail'])
				{
					$values['email'] = $email;
				}
				elseif ($values['check_hemail'])
				{
					$values['email'] = $hemail;
				}

				if (is_array($hnot))
				{
					$values['h_comand'] = implode(',',$hnot);
				}

				if (is_array($snot))
				{
					$values['s_comand'] = implode(',',$snot);
				}

				$error = $this->bonscontact->check_values('contact', $values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonscontact->save_contact('contact', $values);

					$link_data['menuaction'] = 'netsaint.uinscontact.prefs_contact';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('contact_add' => 'contact_form.tpl'));
			$this->t->set_block('contact_add','add','addhandle');
			$this->t->set_block('contact_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('addressbook_link',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.abook&query='));
			$this->t->set_var('lang_action',lang('Add contact'));

			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));

			$this->t->set_var('service_comand_list',$this->bonetsaint->select_comand_list('snot_enabled',$snot));
			$this->t->set_var('host_comand_list',$this->bonetsaint->select_comand_list('hnot_enabled',$hnot));

			$this->t->set_var('csv_tp_list',$this->botimeperiod->select_tp_list('tp',$values['csv_period']));
			$this->t->set_var('h_tp_list',$this->botimeperiod->select_tp_list('tp',$values['h_period']));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('h_rec','<input type="checkbox" name="values[h_rec]" value="True"' . ($values['h_rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('h_down','<input type="checkbox" name="values[h_down]" value="True"' . ($values['h_down'] == '1'?' checked':'') . '>');
			$this->t->set_var('h_unreach','<input type="checkbox" name="values[h_unreach]" value="True"' . ($values['h_unreach'] == '1'?' checked':'') . '>');

			$this->t->set_var('s_rec','<input type="checkbox" name="values[s_rec]" value="True"' . ($values['s_rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('s_crit','<input type="checkbox" name="values[s_crit]" value="True"' . ($values['s_crit'] == '1'?' checked':'') . '>');
			$this->t->set_var('s_warn','<input type="checkbox" name="values[s_warn]" value="True"' . ($values['s_down'] == '1'?' checked':'') . '>');

			$this->t->set_var('email_check','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');	
			$this->t->set_var('hemail_check','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');
			$this->t->set_var('pager_check','<input type="checkbox" name="pager_" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$email = $values['email'];

			if ($email)
			{
				$this->t->set_var('check_wemail','<input type="checkbox" name="values[check_wemail]" value="True" checked>');
			}
			else
			{
				$this->t->set_var('check_wemail','<input type="checkbox" name="values[check_wemail]" value="True">');	
			}

			$pager = $values['pager'];

			if ($pager)
			{
				$this->t->set_var('check_pager','<input type="checkbox" name="values[check_pager]" value="True" checked>');
			}
			else
			{
				$this->t->set_var('check_pager','<input type="checkbox" name="values[check_pager]" value="True">');	
			}

			$this->t->set_var('email',$email);
			$this->t->set_var('hemail',$hemail);
			$this->t->set_var('pager',$pager);

			$this->t->set_var('c_name',$values['name']);
			$this->t->set_var('alias',$values['alias']);

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','contact_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function edit_contact()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $c_id, $email, $pager, $hnot, $snot, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.edit_contact',
				'c_id'			=> $c_id,
				'action'		=> 'contact'
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $c_id;

				if ($values['check_pager'])
				{
					$values['pager'] = $pager;
				}

				if ($values['check_wemail'])
				{
					$values['email'] = $email;
				}
				elseif ($values['check_hemail'])
				{
					$values['email'] = $hemail;
				}
				else
				{
					$values['pager']	= $pager;
					$values['email']	= $email;
				}

				if (is_array($hnot))
				{
					$values['h_comand'] = implode(',',$hnot);
				}

				if (is_array($snot))
				{
					$values['s_comand'] = implode(',',$snot);
				}

				$error = $this->bonscontact->check_values('contact',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonscontact->save_contact('contact', $values);
					$this->bonetsaint->set_config_status('on');
					$link_data['menuaction'] = 'netsaint.uinscontact.prefs_contact';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('contact_edit' => 'contact_form.tpl'));
			$this->t->set_block('contact_edit','add','addhandle');
			$this->t->set_block('contact_edit','edit','edithandle');

			$values = $this->bonscontact->read_single_contact('contact',$c_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit contact'));
			$this->t->set_var('addressbook_link',$phpgw->link('/index.php','menuaction=netsaint.uinscontact.abook'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$saved_snot = explode(',',$phpgw->strip_html($values['s_comand']));
			$saved_hnot = explode(',',$phpgw->strip_html($values['h_comand']));

			$this->t->set_var('service_comand_list',$this->bonetsaint->select_comand_list('snot_enabled',$saved_snot));
			$this->t->set_var('host_comand_list',$this->bonetsaint->select_comand_list('hnot_enabled',$saved_hnot));

			$this->t->set_var('csv_tp_list',$this->botimeperiod->select_tp_list('tp',$values['csv_period']));
			$this->t->set_var('h_tp_list',$this->botimeperiod->select_tp_list('tp',$values['h_period']));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('h_rec','<input type="checkbox" name="values[h_rec]" value="True"' . ($values['h_rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('h_down','<input type="checkbox" name="values[h_down]" value="True"' . ($values['h_down'] == '1'?' checked':'') . '>');
			$this->t->set_var('h_unreach','<input type="checkbox" name="values[h_unreach]" value="True"' . ($values['h_unreach'] == '1'?' checked':'') . '>');

			$this->t->set_var('s_rec','<input type="checkbox" name="values[s_rec]" value="True"' . ($values['s_rec'] == '1'?' checked':'') . '>');
			$this->t->set_var('s_crit','<input type="checkbox" name="values[s_crit]" value="True"' . ($values['s_crit'] == '1'?' checked':'') . '>');
			$this->t->set_var('s_warn','<input type="checkbox" name="values[s_warn]" value="True"' . ($values['s_warn'] == '1'?' checked':'') . '>');

			$email = $values['email'];

			if ($email)
			{
				$this->t->set_var('check_wemail','<input type="checkbox" name="values[check_wemail]" value="True" checked>');
			}
			else
			{
				$this->t->set_var('check_wemail','<input type="checkbox" name="values[check_wemail]" value="True">');
			}

			$pager = $values['pager'];

			if ($pager)
			{
				$this->t->set_var('check_pager','<input type="checkbox" name="values[check_pager]" value="True" checked>');
			}
			else
			{
				$this->t->set_var('check_pager','<input type="checkbox" name="values[check_pager]" value="True">');
			}

			$this->t->set_var('email',$email);
			$this->t->set_var('hemail',$hemail);
			$this->t->set_var('pager',$pager);

			$this->t->set_var('c_name',$values['name']);
			$this->t->set_var('alias',$values['alias']);

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinscontact.delete_contact';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','contact_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function delete_contact()
		{
			global $phpgw, $confirm, $c_id, $action;

			switch($action)
			{
				case 'contact'	: $menu = 'netsaint.uinscontact.prefs_contact'; break;
				case 'cg'		: $menu = 'netsaint.uinscontact.prefs_cg'; break;
			}

			$link_data = array
			(
				'menuaction'	=> $menu,
				'c_id'			=> $c_id,
				'action'		=> $action
			);

			if ($confirm)
			{
				$this->bonscontact->delete_contact($action, $c_id);
				Header('Location: ' . $phpgw->link('/index.php',$link_data));				
			}
			else
			{
				$this->display_prefs_header();

				$this->t->set_file(array('delete' => 'delete.tpl'));

				$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('deleteheader',lang('Are you sure you want to delete this entry ?'));
				$this->t->set_var('lang_no',lang('No'));
				$this->t->set_var('lang_yes',lang('Yes'));
				$link_data['menuaction'] = 'netsaint.uinscontact.delete_contact';
				$this->t->set_var('action_url',$phpgw->link('/index.php',$link_data));

				$this->t->pfp('out','delete');
//				$phpgw->common->phpgw_footer();
			}
		}

		function view_contact()
		{
			global $c_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.prefs_contact',
				'action'		=> 'contact'
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$c = $this->bonscontact->read_single_contact('contact',$c_id);

			$this->t->set_var('lang_action',lang('View contact'));

			$this->t->set_var('cat',$this->cats->id2name($c['cat']));

			$new_date = $c['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$alias = nl2br($phpgw->strip_html($c['alias']));

			$this->t->set_var('alias',$alias);
			$this->t->set_var('h_name',$phpgw->strip_html($c['name']));
			$this->t->set_var('access',lang($c['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($c['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$c['owner']]['account_lid'] . ' [' . $cached_data[$c['owner']]['firstname'] . ' '
										. $cached_data[$c['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);

			$this->t->set_var('service_comand',$phpgw->strip_html($c['s_comand']));
			$this->t->set_var('host_comand',$phpgw->strip_html($c['h_comand']));

			$this->t->set_var('csv_tp',$phpgw->strip_html($c['csv_period']));
			$this->t->set_var('h_tp',$phpgw->strip_html($c['h_period']));

			$email = $phpgw->strip_html($c['email']);
			if (!$email)
			{
				$email = '&nbsp;';
			}

			$pager = $phpgw->strip_html($c['pager']);
			if (!$pager)
			{
				$pager = '&nbsp;';
			}

			$this->t->set_var('email',$email);
			$this->t->set_var('pager',$pager);

			switch($c['h_rec'])
			{
				case '1':	$h_rec = 'Yes'; break;
				case '0':	$h_rec = 'No'; break;
			}
			
			switch($c['h_down'])
			{
				case '1':	$h_down = 'Yes'; break;
				case '0':	$h_down = 'No'; break;
			}

			switch($c['h_unreach'])
			{
				case '1':	$h_unreach = 'Yes'; break;
				case '0':	$h_unreach = 'No'; break;
			}

			$this->t->set_var('h_rec',lang($h_rec));
			$this->t->set_var('h_down',lang($h_down));
			$this->t->set_var('h_unreach',lang($h_unreach));

			switch($c['s_rec'])
			{
				case '1':	$s_rec = 'Yes'; break;
				case '0':	$s_rec = 'No'; break;
			}
			
			switch($c['s_crit'])
			{
				case '1':	$s_crit = 'Yes'; break;
				case '0':	$s_crit = 'No'; break;
			}

			switch($c['s_warn'])
			{
				case '1':	$s_warn = 'Yes'; break;
				case '0':	$s_warn = 'No'; break;
			}

			$this->t->set_var('s_rec',lang($s_rec));
			$this->t->set_var('s_crit',lang($s_crit));
			$this->t->set_var('s_warn',lang($s_warn));

			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('contacthandle','contact');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}

		function prefs_cg()
		{
			global $phpgw, $phpgw_info, $start, $query, $filter, $sort, $order, $cat_id, $action;

			$this->display_prefs_header();

			$this->t->set_file(array('filter' => 'filter.tpl',
									'item_list_t' => 'prefs_default.tpl'));
			$this->t->set_block('item_list_t','item_list','list');

			$link_data = array
			(
				'menuaction' 	=> 'netsaint.uinscontact.prefs_cg',
				'action'		=> 'cg'
			);

			if (!$this->start)
			{
				$this->start = 0;
			}

			$cg_list = $this->bonscontact->read_contacts('cg',$this->start,True,$this->query,$this->filter,$this->sort,$this->order,$this->cat_id);

// --------------------------------- nextmatch ---------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bonscontact->total_records,$link_data);
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bonscontact->total_records,$link_data);
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('lang_showing',$this->nextmatchs->show_hits($this->bonscontact->total_records,$this->start));

// -------------------------- end nextmatch ------------------------------------

			$this->t->set_var('lang_action',lang('Contact groups'));
			$this->t->set_var('cat_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
			$this->t->set_var('filter_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
			$this->t->set_var('search_action',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('search_list',$this->nextmatchs->search(1));

			$this->t->pfp('out','filter',True);

// ---------------- list header variable template-declarations --------------------------

			$this->t->set_var(sort_name,$this->nextmatchs->show_sort_order($this->sort,'cg_name',$this->order,'/index.php',lang('Short name'),$link_data));
			$this->t->set_var(sort_alias,$this->nextmatchs->show_sort_order($this->sort,'cg_alias',$this->order,'/index.php',lang('Description'),$link_data));
			$this->t->set_var(sort_owner,$this->nextmatchs->show_sort_order($this->sort,'cg_owner',$this->order,'/index.php',lang('created by'),$link_data));
			$this->t->set_var(sort_modified,$this->nextmatchs->show_sort_order($this->sort,'cg_date',$this->order,'/index.php',lang('last modified'),$link_data));

// -------------- end header declaration ---------------------------------------

			for ($i=0;$i<count($cg_list);$i++)
			{
				$tr_color = $this->nextmatchs->alternate_row_color($tr_color);
				$this->t->set_var('tr_color',$tr_color);
				$new_date = $cg_list[$i]['date'];
				$month = $phpgw->common->show_date(time(),'n');
				$day = $phpgw->common->show_date(time(),'d');
				$year = $phpgw->common->show_date(time(),'Y');
				$new_date = $new_date + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
				$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);

				$alias = split(' ',$phpgw->strip_html($cg_list[$i]['alias']));
				$first = "$alias[0] $alias[1] $alias[2] $alias[3] .....";

				$cached_data = $this->bonetsaint->cached_accounts(intval($cg_list[$i]['owner']));
				$ownerout = $phpgw->strip_html($cached_data[$cg_list[$i]['owner']]['account_lid']
										. ' [' . $cached_data[$cg_list[$i]['owner']]['firstname'] . ' '
										. $cached_data[$cg_list[$i]['owner']]['lastname'] . ' ]');

				$this->t->set_var(array
				(
					'i_name'	=> $phpgw->strip_html($cg_list[$i]['name']),
					'alias'		=> $first,
					'owner'		=> $ownerout,
					'modified'	=> $new_dateout
				));

				$link_data['c_id'] = $cg_list[$i]['id'];
				$link_data['menuaction'] = 'netsaint.uinscontact.view_cg';

				$this->t->set_var('view',$phpgw->link('/index.php',$link_data));
				$this->t->set_var('lang_view_entry',lang('View'));

				if ($this->bonetsaint->check_perms($this->grants[$cg_list[$i]['owner']],PHPGW_ACL_EDIT) || $cg_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinscontact.edit_cg';

					$this->t->set_var('edit',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_edit_entry',lang('Edit'));
				}
				else
				{
					$this->t->set_var('edit','');
					$this->t->set_var('lang_edit_entry','');
				}

				if ($this->bonetsaint->check_perms($this->grants[$cg_list[$i]['owner']],PHPGW_ACL_DELETE) || $cg_list[$i]['owner'] == $this->account)
				{
					$link_data['menuaction'] = 'netsaint.uinscontact.delete_contact';
					$this->t->set_var('delete',$phpgw->link('/index.php',$link_data));
					$this->t->set_var('lang_delete_entry',lang('Delete'));
				}
				else
				{
					$this->t->set_var('delete','');
					$this->t->set_var('lang_delete_entry','');
				}

				$this->t->fp('list','item_list',True);
			}

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			$link_data['menuaction']	= 'netsaint.uinscontact.add_cg';
			$link_data['cat_id']		= $this->cat_id;

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add contactgroup') .'"></form>');
			}
			else
			{
				if ($this->bonetsaint->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
										. '"><input type="submit" name="Add" value="' . lang('Add contactgroup') .'"></font></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

			$this->t->pfp('out','item_list_t',True);
//			$this->save_sessiondata('cg');
//			$phpgw->common->phpgw_footer();
		}

		function add_cg()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $contacts, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.add_cg',
				'action'		=> 'cg'
			);

			if ($submit)
			{
				$values['cat'] = $cat_id;

				if (is_array($contacts))
				{
					$values['contacts'] = implode(',',$contacts);
				}

				$error = $this->bonscontact->check_values('cg',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonscontact->save_contact('cg', $values);

					$link_data['menuaction'] = 'netsaint.uinscontact.prefs_cg';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('cg_add' => 'cg_form.tpl'));
			$this->t->set_block('cg_add','add','addhandle');
			$this->t->set_block('cg_add','edit','edithandle');

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Add contactgroup'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$cat_id,True));

			$this->t->set_var('contact_list',$this->bonscontact->select_contact_list('contact',$contacts));

			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('cg_name',$values['name']);
			$this->t->set_var('alias',$values['alias']);

			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','cg_add');
			$this->t->pfp('addhandle','add');

//			$phpgw->common->phpgw_footer();
		}

		function edit_cg()
		{
			global $phpgw, $phpgw_info, $cat_id, $new_cat, $submit, $values, $c_id, $contacts, $action;

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.edit_cg',
				'c_id'			=> $c_id,
				'action'		=> 'cg'
			);

			if ($submit)
			{
				$values['cat']	= $cat_id;
				$values['id']	= $c_id;

				if (is_array($contacts))
				{
					$values['contacts'] = implode(',',$contacts);
				}

				$error = $this->bonscontact->check_values('cg',$values);
				if (is_array($error))
				{
					$this->t->set_var('message',$phpgw->common->error_list($error));
				}
				else
				{
					$this->bonscontact->save_contact('cg', $values);
					$this->bonetsaint->set_config_status('on');
					$link_data['menuaction'] = 'netsaint.uinscontact.prefs_cg';
					$link_data['cat_id'] = $cat_id;

					Header('Location: ' . $phpgw->link('/index.php',$link_data));
				}
			}

			$this->display_prefs_header();

			$this->t->set_file(array('cg_edit' => 'cg_form.tpl'));
			$this->t->set_block('cg_edit','add','addhandle');
			$this->t->set_block('cg_edit','edit','edithandle');

			$values = $this->bonscontact->read_single_contact('cg',$c_id);

			$this->t->set_var('actionurl',$phpgw->link('/index.php',$link_data));
			$this->t->set_var('lang_action',lang('Edit contactgroup'));
			$this->t->set_var('cats_list',$this->cats->formated_list('select','all',$values['cat'],True));

			$saved_contacts = explode(',',$phpgw->strip_html($values['contacts']));

			$this->t->set_var('contact_list',$this->bonscontact->select_contact_list('contact',$saved_contacts));
			$this->t->set_var('access','<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('cg_name',$phpgw->strip_html($values['name']));
			$this->t->set_var('alias',$phpgw->strip_html($values['alias']));

			if ($this->bonetsaint->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$link_data['menuaction'] = 'netsaint.uinscontact.delete_contact';
				$this->t->set_var('delete','<form method="POST" action="' . $phpgw->link('/index.php',$link_data)
									. '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','cg_edit');
			$this->t->pfp('edithandle','edit');
//			$phpgw->common->phpgw_footer();
		}

		function view_cg()
		{
			global $c_id, $phpgw, $phpgw_info, $action;

			$this->display_prefs_header();

			$link_data = array
			(
				'menuaction'	=> 'netsaint.uinscontact.prefs_cg',
				'action'		=> 'cg'
			);

			$this->t->set_file(array('view' => 'default_view.tpl'));
			$this->t->set_block('view','escal','escalhandle');
			$this->t->set_block('view','service','servicehandle');
			$this->t->set_block('view','cg','cghandle');
			$this->t->set_block('view','contact','contacthandle');
			$this->t->set_block('view','tp','tphandle');
			$this->t->set_block('view','host','hosthandle');
			$this->t->set_block('view','group','grouphandle');
			$this->t->set_block('view','done','donehandle');

			$cg = $this->bonscontact->read_single_contact('cg',$c_id);

			$this->t->set_var('lang_action',lang('View contactgroup'));

			$this->t->set_var('cat',$this->cats->id2name($cg['cat']));

			$new_date = $cg['date'] + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
			$new_dateout = $phpgw->common->show_date($new_date,$phpgw_info['user']['preferences']['common']['dateformat']);
			$this->t->set_var('new_date',$new_dateout);

			$alias = nl2br($phpgw->strip_html($cg['alias']));

			$this->t->set_var('alias',$alias);
			$this->t->set_var('h_name',$phpgw->strip_html($cg['name']));
			$this->t->set_var('access',lang($cg['access']));

			$cached_data = $this->bonetsaint->cached_accounts(intval($cg['owner']));
			$ownerout = $phpgw->strip_html($cached_data[$cg['owner']]['account_lid'] . ' [' . $cached_data[$cg['owner']]['firstname'] . ' '
										. $cached_data[$cg['owner']]['lastname'] . ' ]');

			$this->t->set_var('owner',$ownerout);
			$this->t->set_var('contacts',$phpgw->strip_html($cg['contacts']));
			$this->t->set_var('done_action',$phpgw->link('/index.php',$link_data));

			$this->t->set_var('servicehandle','');
			$this->t->set_var('escalhandle','');
			$this->t->set_var('cghandle','');
			$this->t->set_var('contacthandle','');
			$this->t->set_var('grouphandle','');
			$this->t->set_var('hosthandle','');
			$this->t->set_var('tphandle','');
			$this->t->pfp('out','view');
			$this->t->pfp('cghandle','cg');
			$this->t->pfp('donehandle','done');
//			$phpgw->common->phpgw_footer();
		}
	}
?>
