<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* This product includes software developed by The SyncML Initiative. */

	$phpgw_baseline = array(
		'phpgw_syncml_device' => array(
			'fd' => array(
				'device_id' => array('type' => 'auto','nullable' => false),
				'name' => array('type' => 'varchar','precision' => 15),
				'owner' => array('type' => 'varchar','precision' => 25),
				'server_last_sync' => array('type' => 'varchar','precision' => 15),
				'client_last_sync' => array('type' => 'varchar','precision' => 15),
				'capabilities' => array('type' => 'varchar','precision' => 255)
			),
			'pk' => array('device_id'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		),

		'phpgw_syncml_guidmap' => array(
			'fd' => array(
				'guid'          => array('type' => 'varchar', 'precision' => 16, 'nullable' => false),
				'appname'       => array('type' => 'varchar', 'precision' => 1, 'nullable' => false),
				'record_id'     => array('type' => 'int', 'precision' => '4',  'nullable' => false),
				'record_status' => array('type' => 'varchar', 'precision' => 1)
			),
			'pk' => array('guid'),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		),

		'phpgw_syncml_luidmap' => array(
			'fd' => array( 
				'device_id' => array('type' => 'int', 'precision' => 4, 'nullable' => false),
				'guid'      => array('type' => 'varchar', 'precision' => 16, 'nullable' => false),
				'luid'      => array('type' => 'varchar', 'precision' => 4, 'nullable' => false)
			),
			'pk' => array(),
			'fk' => array(),
			'ix' => array(),
			'uc' => array()
		)
	);
?>
