<?php
  /**************************************************************************\
  * phpgwtimetrack - phpGroupWare addon application                          *
  * http://phpgwtimetrack.sourceforge.net                                    *
  * Written by Robert Schader <bobs@product-des.com>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: customers.php,v 1.7 2001/07/11 20:21:42 rschader Exp $ */

  $phpgw_info["flags"]["enable_nextmatchs_class"] = "True";
  $phpgw_info["flags"]["currentapp"] = "timetrack";
  include("../header.inc.php");

  $t = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('timetrack'));
  
  $t->set_file("body", "customers.tpl" );
  
  $t->set_block("body", "header", "header");
  $t->set_block("body", "row", "rows");
  $t->set_block("body", "footer", "footer");

  $t->set_var("rows", ""); // Default rows value in case there are no customers.
  
  if (! $start)
     $start = 0;

  if ($order)
      $ordermethod = "order by $order $sort";
   else
      $ordermethod = "order by company_name,industry_type,status asc";

  if (! $sort)
     $sort = "desc";

  if ($query) {
     $querymethod = " where company_name like '%$query%' OR industry_type like '%$query%' OR status "
		        . "like '%$query%' ";
  }

  $phpgw->db->query("select count(*) from phpgw_ttrack_customers $querymethod");
  $phpgw->db->next_record();

  $total = $phpgw->db->f(0);
  //$limit = $phpgw->db->limit($start);

  $t->set_var("bg_color",$phpgw_info["theme"]["bg_color"]);
  $t->set_var("th_bg",$phpgw_info["theme"]["th_bg"]);

  $t->set_var("left_next_matchs",$phpgw->nextmatchs->left("/timetrack/customers.php",$start,$total));
  $t->set_var("lang_customer_list",lang("customer list"));
  $t->set_var("right_next_matchs",$phpgw->nextmatchs->right("/timetrack/customers.php",$start,$total));

  $t->set_var("lang_company_name",$phpgw->nextmatchs->show_sort_order($sort,"company_name",$order,"/timetrack/customers.php",lang("company name")));
  $t->set_var("lang_industry_type",$phpgw->nextmatchs->show_sort_order($sort,"industry_type",$order,"/timetrack/customers.php",lang("industry type")));
  $t->set_var("lang_status",$phpgw->nextmatchs->show_sort_order($sort,"status",$order,"/timetrack/customers.php",lang("status")));

  $t->set_var("lang_edit",lang("Edit"));
  $t->set_var("lang_delete",lang("Delete"));
  $t->set_var("lang_view",lang("View"));

  $t->parse("header","header");

  $phpgw->db->limit_query("select company_id,company_name,industry_type,status "
	. "from phpgw_ttrack_customers $querymethod "
	. "$ordermethod",$start,__LINE__,__FILE__);
				 
				 
  while ($phpgw->db->next_record()) {
    $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
    $t->set_var("tr_color",$tr_color);

    $company_name  = $phpgw->db->f("company_name");
    $industry_type = $phpgw->db->f("industry_type");
    $status = $phpgw->db->f("status");

    if (! $company_name)  $company_name  = '&nbsp;';
    if (! $industry_type) $industry_type = '&nbsp;';
    if (! $status) $status = '&nbsp;';

    $t->set_var("row_company_name",$company_name);
    $t->set_var("row_industry_type",$industry_type);
    $t->set_var("row_status",$status);
    $t->set_var("row_edit",'<a href="'.$phpgw->link("/timetrack/editcustomer.php","cid="
				  . $phpgw->db->f("company_id")) . '"> ' . lang("Edit") . ' </a>');

    if($phpgw_info["apps"]["timetrack"]["ismanager"] || $phpgw_info["apps"]["timetrack"]["ispayroll"])
    {
      $t->set_var("row_delete",'<a href="' . $phpgw->link("/timetrack/deletecustomer.php",'cid='
			 	  . $phpgw->db->f("company_id")) . '"> '.lang("Delete").' </a>');
    } else {
      $t->set_var("row_delete",lang("N/A"));
    }

    $t->set_var("row_view",'<a href="' . $phpgw->link("/timetrack/viewcustomer.php", "cid="
				 . $phpgw->db->f("company_id")) . '"> ' . lang("View") . ' </a>');

	// Build the rows variable
	$t->parse("rows","row",True);

  }

  $t->set_var("actionurl",$phpgw->link("/timetrack/newcustomer.php"));
  $t->set_var("lang_add",lang("add"));
  $t->set_var("lang_search",lang("search"));
  $t->set_var("queryurl",$phpgw->link("/timetrack/customers.php"));

  $t->parse("footer","footer");

  // Display completed body.  
  $t->pparse("res", "body");

  $phpgw->common->phpgw_footer();
