/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import java.awt.Dimension;
import java.io.IOException;

public abstract class TelnetProtocolHandler {
    public static final String ID = "$Id: TelnetProtocolHandler.java,v 2.18 2003/11/16 12:37:29 marcus Exp $";
    private static final int debug = 0;
    private byte[] tempbuf = new byte[0];
    private byte[] crlf = new byte[2];
    private byte[] cr = new byte[2];
    private static byte[] one = new byte[1];
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte TELOPT_BINARY = 0;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_SGA = 3;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;

    public TelnetProtocolHandler() {
        this.reset();
        this.crlf[0] = 13;
        this.crlf[1] = 10;
        this.cr[0] = 13;
        this.cr[1] = 0;
    }

    protected abstract String getTerminalType();

    protected abstract Dimension getWindowSize();

    protected abstract void setLocalEcho(boolean var1);

    protected abstract void notifyEndOfRecord();

    protected abstract void write(byte[] var1) throws IOException;

    private void write(byte b) throws IOException {
        TelnetProtocolHandler.one[0] = b;
        this.write(one);
    }

    public void reset() {
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
    }

    public void sendTelnetControl(byte code) throws IOException {
        byte[] b = new byte[]{-1, code};
        this.write(b);
    }

    private void handle_sb(byte type, byte[] sbdata, int sbcount) throws IOException {
        switch (type) {
            case 24: {
                if (sbcount <= 0 || sbdata[0] != 1) break;
                this.write(IACSB);
                this.write((byte)24);
                this.write((byte)0);
                String ttype = this.getTerminalType();
                if (ttype == null) {
                    ttype = "dumb";
                }
                this.write(ttype.getBytes());
                this.write(IACSE);
            }
        }
    }

    public void startup() throws IOException {
    }

    public void transpose(byte[] buf) throws IOException {
        byte[] xbuf;
        int nbufptr = 0;
        byte[] nbuf = new byte[buf.length * 2];
        int i = 0;
        while (i < buf.length) {
            switch (buf[i]) {
                case -1: {
                    nbuf[nbufptr++] = -1;
                    nbuf[nbufptr++] = -1;
                    break;
                }
                case 10: {
                    int j;
                    if (this.receivedDX[128] != -3) {
                        while (nbuf.length - nbufptr < this.crlf.length) {
                            xbuf = new byte[nbuf.length * 2];
                            System.arraycopy(nbuf, 0, xbuf, 0, nbufptr);
                            nbuf = xbuf;
                        }
                        j = 0;
                        while (j < this.crlf.length) {
                            nbuf[nbufptr++] = this.crlf[j];
                            ++j;
                        }
                        break;
                    }
                    nbuf[nbufptr++] = buf[i];
                    break;
                }
                case 13: {
                    int j;
                    if (this.receivedDX[128] != -3) {
                        while (nbuf.length - nbufptr < this.cr.length) {
                            xbuf = new byte[nbuf.length * 2];
                            System.arraycopy(nbuf, 0, xbuf, 0, nbufptr);
                            nbuf = xbuf;
                        }
                        j = 0;
                        while (j < this.cr.length) {
                            nbuf[nbufptr++] = this.cr[j];
                            ++j;
                        }
                        break;
                    }
                    nbuf[nbufptr++] = buf[i];
                    break;
                }
                default: {
                    nbuf[nbufptr++] = buf[i];
                }
            }
            ++i;
        }
        xbuf = new byte[nbufptr];
        System.arraycopy(nbuf, 0, xbuf, 0, nbufptr);
        this.write(xbuf);
    }

    public void setCRLF(String xcrlf) {
        this.crlf = xcrlf.getBytes();
    }

    public void setCR(String xcr) {
        this.cr = xcr.getBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int negotiate(byte[] nbuf) throws IOException {
        sbbuf = new byte[this.tempbuf.length];
        count = this.tempbuf.length;
        buf = this.tempbuf;
        sendbuf = new byte[3];
        sbcount = 0;
        boffset = 0;
        noffset = 0;
        dobreak = false;
        if (count != 0) ** GOTO lbl223
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((b = buf[boffset++]) >= 128) {
                b = (byte)(b - 256);
            }
            block0 : switch (this.neg_state) {
                case 0: {
                    if (b == -1) {
                        this.neg_state = 1;
                        dobreak = true;
                        break;
                    }
                    nbuf[noffset++] = b;
                    break;
                }
                case 1: {
                    switch (b) {
                        case -1: {
                            this.neg_state = 0;
                            nbuf[noffset++] = -1;
                            break block0;
                        }
                        case -5: {
                            this.neg_state = (byte)3;
                            break block0;
                        }
                        case -4: {
                            this.neg_state = (byte)5;
                            break block0;
                        }
                        case -2: {
                            this.neg_state = (byte)6;
                            break block0;
                        }
                        case -3: {
                            this.neg_state = (byte)4;
                            break block0;
                        }
                        case -17: {
                            this.notifyEndOfRecord();
                            dobreak = true;
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.neg_state = (byte)2;
                            sbcount = 0;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                case 3: {
                    switch (b) {
                        case 1: {
                            reply = -3;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            reply = -3;
                            break;
                        }
                        case 25: {
                            reply = -3;
                            break;
                        }
                        case 0: {
                            reply = -3;
                            break;
                        }
                        default: {
                            reply = -2;
                        }
                    }
                    if (reply != this.sentDX[b + 128] || -5 != this.receivedWX[b + 128]) {
                        sendbuf[0] = -1;
                        sendbuf[1] = reply;
                        sendbuf[2] = b;
                        this.write(sendbuf);
                        this.sentDX[b + 128] = reply;
                        this.receivedWX[b + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 5: {
                    switch (b) {
                        case 1: {
                            this.setLocalEcho(true);
                            reply = -2;
                            break;
                        }
                        case 3: {
                            reply = -2;
                            break;
                        }
                        case 25: {
                            reply = -2;
                            break;
                        }
                        case 0: {
                            reply = -2;
                            break;
                        }
                        default: {
                            reply = -2;
                        }
                    }
                    if (reply != this.sentDX[b + 128] || -4 != this.receivedWX[b + 128]) {
                        sendbuf[0] = -1;
                        sendbuf[1] = reply;
                        sendbuf[2] = b;
                        this.write(sendbuf);
                        this.sentDX[b + 128] = reply;
                        this.receivedWX[b + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 4: {
                    switch (b) {
                        case 1: {
                            reply = -5;
                            this.setLocalEcho(true);
                            break;
                        }
                        case 3: {
                            reply = -5;
                            break;
                        }
                        case 24: {
                            reply = -5;
                            break;
                        }
                        case 0: {
                            reply = -5;
                            break;
                        }
                        case 31: {
                            size = this.getWindowSize();
                            this.receivedDX[b] = -3;
                            if (size == null) {
                                this.write((byte)-1);
                                this.write((byte)-4);
                                this.write((byte)31);
                                reply = -4;
                                this.sentWX[b] = -4;
                                break;
                            }
                            reply = -5;
                            this.sentWX[b] = -5;
                            sendbuf[0] = -1;
                            sendbuf[1] = -5;
                            sendbuf[2] = 31;
                            this.write(sendbuf);
                            this.write((byte)-1);
                            this.write((byte)-6);
                            this.write((byte)31);
                            this.write((byte)(size.width >> 8));
                            this.write((byte)(size.width & 255));
                            this.write((byte)(size.height >> 8));
                            this.write((byte)(size.height & 255));
                            this.write((byte)-1);
                            this.write((byte)-16);
                            break;
                        }
                        default: {
                            reply = -4;
                        }
                    }
                    if (reply != this.sentWX[128 + b] || -3 != this.receivedDX[128 + b]) {
                        sendbuf[0] = -1;
                        sendbuf[1] = reply;
                        sendbuf[2] = b;
                        this.write(sendbuf);
                        this.sentWX[b + 128] = reply;
                        this.receivedDX[b + 128] = -3;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 6: {
                    switch (b) {
                        case 1: {
                            reply = -4;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            reply = -4;
                            break;
                        }
                        case 31: {
                            reply = -4;
                            break;
                        }
                        case 0: {
                            reply = -4;
                            break;
                        }
                        default: {
                            reply = -4;
                        }
                    }
                    if (reply != this.sentWX[b + 128] || -2 != this.receivedDX[b + 128]) {
                        this.write((byte)-1);
                        this.write(reply);
                        this.write(b);
                        this.sentWX[b + 128] = reply;
                        this.receivedDX[b + 128] = -2;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 7: {
                    if (b == -1) {
                        sbcount = 0;
                        this.current_sb = b;
                        this.neg_state = (byte)8;
                        break;
                    }
                    System.err.println("(bad) " + b + " ");
                    this.neg_state = 0;
                    break;
                }
                case 2: {
                    switch (b) {
                        case -1: {
                            this.neg_state = (byte)7;
                            break block0;
                        }
                    }
                    this.current_sb = b;
                    sbcount = 0;
                    this.neg_state = (byte)8;
                    break;
                }
                case 8: {
                    switch (b) {
                        case -1: {
                            this.neg_state = (byte)9;
                            break block0;
                        }
                    }
                    sbbuf[sbcount++] = b;
                    break;
                }
                case 9: {
                    switch (b) {
                        case -1: {
                            this.neg_state = (byte)8;
                            sbbuf[sbcount++] = -1;
                            break block0;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, sbbuf, sbcount);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, sbbuf, sbcount);
                            this.neg_state = (byte)2;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                default: {
                    this.neg_state = 0;
                }
            }
lbl223:
            // 26 sources

            ** while (!dobreak && boffset < count && noffset < nbuf.length)
        }
lbl224:
        // 1 sources

        xb = new byte[count - boffset];
        System.arraycopy(this.tempbuf, boffset, xb, 0, count - boffset);
        this.tempbuf = xb;
        return noffset;
    }

    public void inputfeed(byte[] b, int len) {
        byte[] xb = new byte[this.tempbuf.length + len];
        System.arraycopy(this.tempbuf, 0, xb, 0, this.tempbuf.length);
        System.arraycopy(b, 0, xb, this.tempbuf.length, len);
        this.tempbuf = xb;
    }
}

