#include <stdio.h>
#include <math.h>
#include <termios.h>

#include "fppxp.h"

#define	NAME_HEIGHT	23
#define	KEY_HEIGHT	23
#define	APPLY_HEIGHT	20
#define	APPLY_WIDTH	50

#define	RESET_HEIGHT	20
#define	RESET_WIDTH	50

#define	LEFT_WIDTH	45

#define	nameObj		(userObjs[0])
#define	keyObj		(userObjs[1])
#define	entryObj	(userObjs[2])
#define	applyObj	(userObjs[3])
#define	resetObj	(userObjs[4])
static FL_OBJECT *userObjs[5];

void
ActivateUserPanel(int sw)
{
    int i;

    for (i = 0; userObjs[i] ; i ++) {
	if (sw) {
	    fl_activate_object(userObjs[i]);
	    fl_show_object(userObjs[i]);
	} else {
	    fl_deactivate_object(userObjs[i]);
	    fl_hide_object(userObjs[i]);
	}
    }
}

static void
BtnsCallBack(FL_OBJECT *obj, long arg)
{
    if (arg) {
/*	XcEnvCommand("ip", IpRefresh);*/
    } else {
    }
}

FL_OBJECT **
CreateUserPanel(int x, int y, int w, int h)
{
    FL_OBJECT *obj;
    unsigned int i, n=0, width, dy, dx;

    width = (w - (FRAME_GAP << 1) - LEFT_WIDTH);

    dy = y + FRAME_GAP;
    obj = fl_add_input(FL_NORMAL_INPUT, x + FRAME_GAP + LEFT_WIDTH,
		       dy, width, NAME_HEIGHT, "Name:");
    userObjs[n ++] = obj;
    dy += FRAME_GAP + NAME_HEIGHT;

    obj = fl_add_input(FL_SECRET_INPUT, x + FRAME_GAP + LEFT_WIDTH,
		       dy, width, NAME_HEIGHT, "Passwd:");
    userObjs[n ++] = obj;

    dx = x + w - APPLY_WIDTH - RESET_WIDTH - (FRAME_GAP << 1);
    dy = y + h - APPLY_HEIGHT - FRAME_GAP;

    obj = fl_add_button(FL_NORMAL_BUTTON, dx, dy,
			APPLY_WIDTH, APPLY_HEIGHT, "Apply");
    fl_set_object_callback(obj, BtnsCallBack, 0);
    userObjs[n ++] = obj;

    dx += APPLY_WIDTH + FRAME_GAP;
    obj = fl_add_button(FL_NORMAL_BUTTON, dx, dy,
			RESET_WIDTH, RESET_HEIGHT, "Reset");
    fl_set_object_callback(obj, BtnsCallBack, 1);
    userObjs[n ++] = obj;

    return(userObjs);
}
