<?xml version="1.0" encoding="UTF-8"?>
<!--
	v12_to_v11.xsl
	
	XSL stylesheet converting a Shibboleth 1.2 sites metadata file into the equivalent for
	Shibboleth 1.1.

	Author: Ian A. Young <ian@iay.org.uk>

	$Id: metadata_v12_to_v11.xsl 1595 2005-05-17 02:14:30Z cantor $
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:shibb10="urn:mace:shibboleth:1.0"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	exclude-result-prefixes="shibb10">
	
	<!--
		Version information for this file.  Remember to peel off the dollar signs
		before dropping the text into another versioned file.
	-->
	<xsl:param name="cvsId">$Id: metadata_v12_to_v11.xsl 1595 2005-05-17 02:14:30Z cantor $</xsl:param>

	<!--
		Add a comment to the start of the output file.
	-->
	<xsl:template match="/">
		<xsl:comment>
			<xsl:text>&#10;&#9;***DO NOT EDIT THIS FILE***&#10;&#10;</xsl:text>
			<xsl:text>&#9;Converted by:&#10;&#10;&#9;</xsl:text>
			<xsl:value-of select="substring-before(substring-after($cvsId, ': '), '$')"/>
			<xsl:text>&#10;</xsl:text>
		</xsl:comment>
		<xsl:apply-templates/>
	</xsl:template>

	<!--Force UTF-8 encoding for the output.-->
	<xsl:output omit-xml-declaration="no" method="xml" encoding="UTF-8" indent="yes"/>

	<!--
		shibb10:SiteGroup is the root element for the sites file.  Process it by copying across everything except DestinationSite elements.
	-->
	<xsl:template match="shibb10:SiteGroup">
		<xsl:copy>
			<xsl:attribute name="xsi:schemaLocation">
				<xsl:text>urn:mace:shibboleth:1.0 shibboleth.xsd</xsl:text>
			</xsl:attribute>
			<xsl:apply-templates select="@Name|text()|comment()|shibb10:OriginSite"/>
		</xsl:copy>
	</xsl:template>

	<!--By default, copy text blocks, comments and attributes unchanged.-->
	<xsl:template match="text()|comment()|@*">
		<xsl:copy/>
	</xsl:template>

	<!--By default, copy all elements from the input to the output, along with their attributes and contents.-->
	<xsl:template match="*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
