#include "qaudio.h"
#include "qaudio-p.h"

QAuServer& QAudio::server()
{
	static QAuServer* server=0;
	if (!server)
		server=new QAuServer;
	return *server;
}

int QAudio::play(const char* filename, double volume_percent)
{
	server().play(filename,volume_percent);
}

QAudio::QAudio(const char* fname, double volume) :
	filename(new char[strlen(fname)+1]),
	volume_percent(volume)
{
	strcpy(filename,fname);
}

QAudio::~QAudio()
{
	delete filename;
}

void QAudio::setVolume(double volume)
{
	volume_percent=volume;
}

void QAudio::play()
{
	play(filename,volume_percent);
}

bool QAudio::soundAvailable()
{
	return server().okay();
}
