/*********************************************************************
store.c, distributed as part of Spade v092200.1
Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
Released under GNU General Public License, see the COPYING file included
with the distribution or http://www.silicondefense.com/spice/ for details.

store.c contains all the checkpoint and recovery functionality in Spade.

Please send complaints, kudos, and especially improvements and bugfixes to
hoagland@SiliconDefense.com.  As described in GNU General Public License, no
warranty is expressed for this program.
*********************************************************************/

#include <errno.h>
#include "anomsensor.h"
#include "store.h"
#include "tree.h"
#include "anommem.h"

int checkpoint(char *filename) {
	unsigned char uc;
	char v='v';
	unsigned char fvers= CUR_FVERS;
	u16 v16;
	u32 v32;
	unsigned int i,rb_used,ib_used,lb_used;
	
	FILE *f;
	errno=0;
	f= fopen(filename,"wb");
	if (errno) {
		perror(filename);
		return 0;
	}
	
	fwrite(&v,sizeof(v),1,f);
	fwrite(&fvers,sizeof(fvers),1,f);
	uc= sizeof(u16);
	fwrite(&uc,sizeof(uc),1,f);
	uc= sizeof(u32);
	fwrite(&uc,sizeof(uc),1,f);
	v16= MAX_U16;
	fwrite(&v16,sizeof(v16),1,f);
	v32= MAX_U32;
	fwrite(&v32,sizeof(v32),1,f);
	
	fwrite(&ROOT_BLOCK_BITS,sizeof(ROOT_BLOCK_BITS),1,f);
	fwrite(&INT_BLOCK_BITS,sizeof(INT_BLOCK_BITS),1,f);
	fwrite(&LEAF_BLOCK_BITS,sizeof(LEAF_BLOCK_BITS),1,f);
	fwrite(&MAX_ROOT_BLOCKS,sizeof(MAX_ROOT_BLOCKS),1,f);
	fwrite(&MAX_INT_BLOCKS,sizeof(MAX_INT_BLOCKS),1,f);
	fwrite(&MAX_LEAF_BLOCKS,sizeof(MAX_LEAF_BLOCKS),1,f);

	fwrite(&TNULL,sizeof(TNULL),1,f);
	fwrite(&DMINDEXMASK,sizeof(DMINDEXMASK),1,f);
	
	fwrite(T,sizeof(mindex),NUM_FEATURES,f);
	
	fwrite(&root_freelist,sizeof(root_freelist),1,f);
	fwrite(&int_freelist,sizeof(int_freelist),1,f);
	fwrite(&leaf_freelist,sizeof(leaf_freelist),1,f);
	
	for (rb_used= 0; ROOT_M[rb_used] != NULL; rb_used++) {}
	fwrite(&rb_used,sizeof(rb_used),1,f);
	for (ib_used= 0; INT_M[ib_used] != NULL; ib_used++) {}
	fwrite(&ib_used,sizeof(ib_used),1,f);
	for (lb_used= 0; LEAF_M[lb_used] != NULL; lb_used++) {}
	fwrite(&lb_used,sizeof(lb_used),1,f);
	
	for (i= 0; i < rb_used; i++) {
		fwrite(ROOT_M[i],sizeof(treeroot),ROOT_BLOCK_SIZE,f);
	}
	for (i= 0; i < ib_used; i++) {
		fwrite(INT_M[i],sizeof(intnode),INT_BLOCK_SIZE,f);
	}
	for (i= 0; i < lb_used; i++) {
		fwrite(LEAF_M[i],sizeof(leafnode),LEAF_BLOCK_SIZE,f);
	}

	fclose(f);
	return 1;
}

int recover(char *filename) {
	unsigned char uc,fvers;
	char v;
	u16 v16;
	u32 v32;
	unsigned int i,rb_used,ib_used,lb_used,FILE_MAX_ROOT_BLOCKS,FILE_MAX_INT_BLOCKS,FILE_MAX_LEAF_BLOCKS;
	FILE *f;
	errno=0;
	f= fopen(filename,"rb");
	if (errno) { /* file prob does not exist */
		return 0;
	}
	
	fread(&v,sizeof(v),1,f);
	if (v == 'v') { /* format version # encoded */
		fread(&fvers,sizeof(fvers),1,f);
		fread(&uc,sizeof(uc),1,f);
	} else { /* format version #0; only diff from version 1 is that the version # is listed */
		fvers= 0;
		uc= (unsigned char)v;
	}
	if (fvers > CUR_FVERS) {
		fprintf(stderr,"This version of the state recover procedure cannot read file %s since has format version %d; this routine can only handle up to version %d\n",filename,fvers,CUR_FVERS);
		fclose(f);
		return 0;
	}
	
	if (sizeof(u16) != uc) {
		fprintf(stderr,"u16 type size from recovery file (%s) (%d bytes) does not match current size (%d bytes)\n",filename,sizeof(u16),uc);
		fclose(f);
		return 0;
	}
	fread(&uc,sizeof(uc),1,f);
	if (sizeof(u32) != uc) {
		fprintf(stderr,"u32 type size from recovery file (%s) (%d bytes) does not match current size (%d bytes)\n",filename,sizeof(u32),uc);
		fclose(f);
		return 0;
	}
	fread(&v16,sizeof(v16),1,f);
	if (v16 != MAX_U16) {
		fprintf(stderr,"strange: MAX_U16 from recovery file (%s) (%d) does not match current value (%d)\n",filename,MAX_U16,v16);
		fclose(f);
		return 0;
	}
	fread(&v32,sizeof(v32),1,f);
	if (v32 != MAX_U32) {
		fprintf(stderr,"strange: MAX_U32 from recovery file (%s) (%d) does not match current value (%d)\n",filename,MAX_U32,v32);
		fclose(f);
		return 0;
	}
	
	fread(&ROOT_BLOCK_BITS,sizeof(ROOT_BLOCK_BITS),1,f);
	fread(&INT_BLOCK_BITS,sizeof(INT_BLOCK_BITS),1,f);
	fread(&LEAF_BLOCK_BITS,sizeof(LEAF_BLOCK_BITS),1,f);
	fread(&FILE_MAX_ROOT_BLOCKS,sizeof(MAX_ROOT_BLOCKS),1,f);
	fread(&FILE_MAX_INT_BLOCKS,sizeof(MAX_INT_BLOCKS),1,f);
	fread(&FILE_MAX_LEAF_BLOCKS,sizeof(MAX_LEAF_BLOCKS),1,f);

	fread(&TNULL,sizeof(TNULL),1,f);
	fread(&DMINDEXMASK,sizeof(DMINDEXMASK),1,f);

	fread(T,sizeof(mindex),NUM_FEATURES,f);
	
	fread(&root_freelist,sizeof(root_freelist),1,f);
	fread(&int_freelist,sizeof(int_freelist),1,f);
	fread(&leaf_freelist,sizeof(leaf_freelist),1,f);

	fread(&rb_used,sizeof(rb_used),1,f);
	/* use the size for this run unless there is more stored in the file */
	MAX_ROOT_BLOCKS= rb_used > DEFAULT_MAX_ROOT_BLOCKS ? rb_used : DEFAULT_MAX_ROOT_BLOCKS;
	fread(&ib_used,sizeof(ib_used),1,f);
	MAX_INT_BLOCKS= ib_used > DEFAULT_MAX_INT_BLOCKS ? ib_used : DEFAULT_MAX_INT_BLOCKS;
	fread(&lb_used,sizeof(lb_used),1,f);
	MAX_LEAF_BLOCKS= rb_used > DEFAULT_MAX_LEAF_BLOCKS ? lb_used : DEFAULT_MAX_LEAF_BLOCKS;

	allocate_mem_blocks();
	
	for (i= 0; i < rb_used; i++) {
		ROOT_M[i]= (treeroot *)malloc(sizeof(treeroot)*ROOT_BLOCK_SIZE);
		fread(ROOT_M[i],sizeof(treeroot),ROOT_BLOCK_SIZE,f);
	}
	for (i= 0; i < ib_used; i++) {
		INT_M[i]= (intnode *)malloc(sizeof(intnode)*INT_BLOCK_SIZE);
		fread(INT_M[i],sizeof(intnode),INT_BLOCK_SIZE,f);
	}
	for (i= 0; i < lb_used; i++) {
		LEAF_M[i]= (leafnode *)malloc(sizeof(leafnode)*LEAF_BLOCK_SIZE);
		fread(LEAF_M[i],sizeof(leafnode),LEAF_BLOCK_SIZE,f);
	}
	fclose(f);
	return 1;
}

/* $Id: store.c,v 1.3 2000/09/22 17:43:54 jim Exp $ */
