<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - submit:
 *   - time:
 *   - time_sep:
 */
?>

<?php
  include ("acid_db.inc");
  include ("acid_db_common.php");
  include ("acid_common.php");
  include ("acid_stat_common.php");
  include("acid_conf.php");
?>

<?php
function StoreAlertNum($sql, $label, $time_sep, $i_year, $i_month, $i_day, $i_hour)
{  
  GLOBAL $db, $cnt, $label_lst, $value_lst, $value_POST_lst, $debug_mode;

  $label_lst [ $cnt ] = $label;

  if ( $debug_mode > 0 )
     echo $sql."<BR>";

  $result = $db->acidExecute($sql);
  if ( $myrow = $result->acidFetchRow() )
  {
     $value_lst [ $cnt ] = $myrow[0];
     $result->acidFreeRows();

     $value_POST_lst[$cnt] = "acid_pkt_main.php?new=1&submit=Query+DB&num_result_rows=-1&time_cnt=1".
                             "&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3D";

     if ( $time_sep[0] == "hour" )
        $value_POST_lst[$cnt] = $value_POST_lst[$cnt].'&time%5B0%5D%5B2%5D='.$i_month.
                                '&time%5B0%5D%5B3%5D='.$i_day.
                                '&time%5B0%5D%5B4%5D='.$i_year.
                                '&time%5B0%5D%5B5%5D='.$i_hour;

     else if ( $time_sep[0] == "day" )
        $value_POST_lst[$cnt] = $value_POST_lst[$cnt].'&time%5B0%5D%5B2%5D='.$i_month.
                                '&time%5B0%5D%5B3%5D='.$i_day.
                                '&time%5B0%5D%5B4%5D='.$i_year;

     else if ( $time_sep[0] == "month" )
        $value_POST_lst[$cnt] = $value_POST_lst[$cnt].'&time%5B0%5D%5B2%5D='.$i_month.
                                '&time%5B0%5D%5B4%5D='.$i_year;

     /* add no parentheses and no operator */
     $value_POST_lst[$cnt] = $value_POST_lst[$cnt].'&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+';
 
     $cnt++;
  }
  else
     $value_lst [ $cnt++ ] = 0;
}

function PrintTimeProfile()
{
   GLOBAL $cnt, $label_lst, $value_lst, $value_POST_lst;

   /* find max value */
   $max_cnt = $value_lst[0];
   for ( $i = 0; $i < $cnt; $i++ )
       if ( $value_lst[$i] > $max_cnt )  $max_cnt = $value_lst[$i];

   echo '<TABLE BORDER=1 WIDTH="100%">
           <TR><TD CLASS="plfieldhdr">Time</TD>
               <TD CLASS="plfieldhdr"># of Alerts</TD>
               <TD CLASS="plfieldhdr">Alerts</TD></TR>';


   for ($i = 0; $i < $cnt; $i++ )
   {
       if ($value_lst[$i] == 0)
          $entry_width = 0;
       else
          $entry_width = round($value_lst[$i]/$max_cnt*100);

       if ($entry_width > 0 )
          $entry_color = "#FF0000";
       else
          $entry_color = "#FFFFFF";

       echo '<TR>
                 <TD>';

       if ( $value_lst[$i] == 0 ) 
          echo $label_lst[$i];
       else
          echo '<A HREF="'.$value_POST_lst[$i].'">'.$label_lst[$i].'</A>';

       echo     '</TD>
                 <TD ALIGN=CENTER>'.$value_lst[$i].'</TD>
                 <TD><TABLE WIDTH="100%">
                      <TR>
                       <TD BGCOLOR="'.$entry_color.'" WIDTH="'.$entry_width.'%">&nbsp;</TD>
                       <TD></TD>
                      </TR>
                     </TABLE>
                 </TD>
             </TR>';
    }
    echo '</TABLE>';
}

?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Time Profile of Alerts</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Time Profile of Alerts</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<FORM ACTION="acid_stat_time.php" METHOD="post">

<TABLE WIDTH="100%" BORDER=0>
  <TR>
      <TD WIDTH="40%" CLASS="metatitle"><B><FONT COLOR="#FFFFFF">Time Criteria</FONT></B></TD>
      <TD></TD></TR>
</TABLE>

<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
  <TR>
     <TD>

<?php

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  echo '<B>Profile by :</B> &nbsp;
        <INPUT NAME="time_sep[0]" TYPE="radio" VALUE="hour" '.chk_check($time_sep[0],"hour").'> Hour
        <INPUT NAME="time_sep[0]" TYPE="radio" VALUE="day" '.chk_check($time_sep[0], "day").'> Day
        <INPUT NAME="time_sep[0]" TYPE="radio" VALUE="month" '.chk_check($time_sep[0], "month").'> Month
        <BR>';

  echo '<SELECT NAME="time_sep[1]"><OPTION VALUE=" "  '.chk_select($time_sep[1], " ").'>{ time }
                                   <OPTION VALUE="on" '.chk_select($time_sep[1], "on").'>on
                                   <OPTION VALUE="between"'.chk_select($time_sep[1], "between").'>between
        </SELECT>';

  for ( $i = 0; $i < 2; $i++ )
  {
      echo '<SELECT NAME="time['.$i.'][0]"><OPTION VALUE=" "  '.chk_select($time[$i][0]," " ).'>{ month }';
      echo '                               <OPTION VALUE="01" '.chk_select($time[$i][0],"01").'>Jan';
      echo '                               <OPTION VALUE="02" '.chk_select($time[$i][0],"02").'>Feb';
      echo '                               <OPTION VALUE="03" '.chk_select($time[$i][0],"03").'>Mar';
      echo '                               <OPTION VALUE="04" '.chk_select($time[$i][0],"04").'>Apr';
      echo '                               <OPTION VALUE="05" '.chk_select($time[$i][0],"05").'>May';
      echo '                               <OPTION VALUE="06" '.chk_select($time[$i][0],"06").'>Jun';
      echo '                               <OPTION VALUE="07" '.chk_select($time[$i][0],"07").'>Jly';
      echo '                               <OPTION VALUE="08" '.chk_select($time[$i][0],"08").'>Aug';
      echo '                               <OPTION VALUE="09" '.chk_select($time[$i][0],"09").'>Sep';
      echo '                               <OPTION VALUE="10" '.chk_select($time[$i][0],"10").'>Oct';
      echo '                               <OPTION VALUE="11" '.chk_select($time[$i][0],"11").'>Nov';
      echo '                               <OPTION VALUE="12" '.chk_select($time[$i][0],"12").'>Dec</SELECT>';
      echo '<INPUT TYPE="text" NAME="time['.$i.'][1]" SIZE=2 VALUE="'.$time[$i][1].'"> &nbsp';
      echo '<SELECT NAME="time['.$i.'][2]"><OPTION VALUE=" "    '.chk_select($time[$i][2]," ").'>{ year }';
      echo '                               <OPTION VALUE="1999" '.chk_select($time[$i][2],"1999").'>1999';
      echo '                               <OPTION VALUE="2000" '.chk_select($time[$i][2],"2000").'>2000';
      echo '                               <OPTION VALUE="2001" '.chk_select($time[$i][2],"2001").'>2001</SELECT>';

      if ( $i == 0 ) echo '&nbsp; -- &nbsp;&nbsp';
  }

  echo '<INPUT TYPE="submit" NAME="submit" VALUE="Profile Alert">
        </TD></TR></TABLE>
        </FORM>

        <P><HR>';

  if ( $submit != "" && $time_sep[0] == "" )
     echo '<FONT><B>No profiling criteria was specified!</B>  Click on "hour", "day", or "month"
           to choose the granularity of the aggregate statistics.</FONT>';     
  else if ( $submit != "" && $time_sep[1] == " " )
     echo '<FONT><B>The type of time parameter which will be passed was not specified!</B>  Choose either
           "on", to specify a single date, or "between" to specify an interval.</FONT>';

  else if ( $submit != "" && $time_sep[0] != "" && $time_sep[1] == "on" &&
            $time[0][2] == " " )
     echo '<FONT><B>No Year parameter was specified!</B></FONT>';

  else if ( $submit != "" && $time_sep[0] != "" && $time_sep[1] == "between" &&
            ($time[1][2] == " " || $time[0][2] == " ") )
     echo '<FONT><B>No Year parameter was specified!</B></FONT>';

  else if ( $submit != "" && $time_sep[0] != "" && $time_sep[1] == "between" &&
            ($time[1][0] == " " || $time[0][0] == " ") )
     echo '<FONT><B>No Month parameter was specified!</B></FONT>'; 
 
  else if ( $submit != "" && ($time_sep[0] != "") 
            && $time_sep[1] == "between" && ($time[1][1] == "" || $time[0][1] == "") )
     echo '<FONT><B>No Day parameter was specified!</B></FONT>';

  else if ($submit != "")
  {

  /* Dump the results of the above specified query */
           
  if ( $time_sep[1] == "between" )
  {
     if ($time_sep[0] == "hour")       
     { 
        $year_start = $time[0][2];  $year_end = $time[1][2];
        $month_start = $time[0][0]; $month_end = $time[1][0];
        $day_start = $time[0][1]; $day_end = $time[1][1];
        $hour_start = 0; $hour_end = 23; 
     }
     else if ($time_sep[0] == "day")          
     { 
        $year_start = $time[0][2];  $year_end = $time[1][2];
        $month_start = $time[0][0]; $month_end = $time[1][0];
        $day_start = $time[0][1]; $day_end = $time[1][1];
        $hour_start = -1; 
     }
     else if ($time_sep[0] == "month")           
     { 
        $year_start = $time[0][2];  $year_end = $time[1][2];
        $month_start = $time[0][0]; $month_end = $time[1][0];
        $day_start = -1;
        $hour_start = -1; 
     }
  }
  else if ( $time_sep[1] == "on" )
  {
     if ($time_sep[0] == "hour")       
     { 
        $year_start = $time[0][2];  $year_end = $time[0][2];
        if ( $time[0][0] != " " )
        {   $month_start = $time[0][0]; $month_end = $time[0][0];  }
        else
        {   $month_start = 1; $month_end = 12;  }

        if ( $time[0][1] != "" )
        {  $day_start = $time[0][1]; $day_end = $time[0][1];  }
        else
        {  $day_start = 1; $day_end = 31;  }
        $hour_start = 0; $hour_end = 23; 
     }
     else if ($time_sep[0] == "day")          
     { 
        $year_start = $time[0][2];  $year_end = $time[0][2];
        if ( $time[0][0] != " " )
        {   $month_start = $time[0][0]; $month_end = $time[0][0];  }
        else
        {   $month_start = 1; $month_end = 12;  }

        if ( $time[0][1] != "" )
        {  $day_start = $time[0][1]; $day_end = $time[0][1];  }
        else
        {  $day_start = 1; $day_end = 31;  }

        $hour_start = -1; 
     }
     else if ($time_sep[0] == "month")           
     { 
        $year_start = $time[0][2];  $year_end = $time[0][2];
        if ( $time[0][0] != " " )
        {   $month_start = $time[0][0]; $month_end = $time[0][0];  }
        else
        {   $month_start = 1; $month_end = 12;  }  
        $day_start = -1;
        $hour_start = -1; 
     }
  }

  if ( $debug_mode == 1 )
  {
     echo '<TABLE BORDER=1>
            <TR>
              <TD>year_start<TD>year_end<TD>month_start<TD>month_end
              <TD>day_start<TD>day_end<TD>hour_start<TD>hour_end
            <TR>
              <TD>'.$year_start.'<TD>'.$year_end.'<TD>'.$month_start.'<TD>'.$month_end.
              '<TD>'.$day_start.'<TD>'.$day_end.'<TD>'.$hour_start.'<TD>'.$hour_end.
           '</TABLE>';
  }

  $cnt = 0;

  for ( $i_year = $year_start; $i_year <= $year_end; $i_year++ )
  {
      $sql = "SELECT count(*) FROM event WHERE ".
             $db->acidSQL_YEAR("timestamp", "=", $i_year);

      if ( $month_start != -1 )
      {
         if ($i_year == $year_start)  $month_start2 = $month_start;  else  $month_start2 = 1;
         if ($i_year == $year_end)    $month_end2 = $month_end;      else  $month_end2 = 12;

         for ( $i_month = $month_start2; $i_month <= $month_end2; $i_month++ )
         {
             $sql = "SELECT count(*) FROM event WHERE ".
                    $db->acidSQL_YEAR("timestamp", "=", $i_year)." AND ".
                    $db->acidSQL_MONTH("timestamp", "=", $i_month);

             if ( $day_start != -1 )
             {
                if ($i_month == $month_start)  $day_start2 = $day_start;  else  $day_start2 = 1;
                if ($i_month == $month_end)    $day_end2 = $day_end;      else  $day_end2 = 31;

                for ( $i_day = $day_start2; $i_day <= $day_end2; $i_day++ )
                {
                  if ( checkdate($i_month, $i_day, $i_year) )
                  {
                    $sql = "SELECT count(*) FROM event WHERE ".
                           $db->acidSQL_YEAR("timestamp", "=", $i_year)." AND ".
                           $db->acidSQL_MONTH("timestamp", "=",$i_month)." AND ".
                           $db->acidSQL_DAY("timestamp", "=", $i_day);

                    if ( $hour_start != -1 )
                    {
                       for ( $i_hour = $hour_start; $i_hour <= $hour_end; $i_hour++ )
                       {
                           $sql = "SELECT count(*) FROM event WHERE ".
                                  $db->acidSQL_YEAR("timestamp", "=", $i_year)." AND ".
                                  $db->acidSQL_MONTH("timestamp", "=", $i_month)." AND ".
                                  $db->acidSQL_DAY("timestamp", "=", $i_day)." AND ".
                                  $db->acidSQL_HOUR("timestamp", "=", $i_hour);

                           StoreAlertNum($sql, $i_month."/".$i_day."/".$i_year." ".
                                               $i_hour.":00:00 - ".$i_hour.":59:59", 
                                         $time_sep, $i_year, $i_month, $i_day, $i_hour);
                       }  // end hour
                    }
                    else
                        StoreAlertNum($sql, $i_month."/".$i_day."/".$i_year,
                                      $time_sep, $i_year, $i_month, $i_day, $i_hour);
                  }
                }   // end day
             }
             else
               StoreAlertNum($sql, $i_month."/".$i_year, $time_sep, $i_year, $i_month, $i_day, $i_hour);
         }   // end month
      }
      else
        StoreAlertNum($sql, $i_year, $time_sep, $i_year, $i_month, $i_day, $i_hour);
  }   // end year

  echo '</TABLE>';
  PrintTimeProfile();
  }

//  $db->acidClose();
?>


<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

