/*
** Copyright (C) 1998,1999,2000,2001 Martin Roesch <roesch@clark.net>
** Copyright (C) 2001 Brian Caswell <bmc@mitre.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: spo_csv.h,v 1.2 2001/06/11 05:49:28 roesch Exp $ */

/* This file gets included in plugbase.h when it is integrated into the rest 
 * of the program.  Sometime in The Future, I'll whip up a bad ass Perl script
 * to handle automatically loading all the required info into the plugbase.*
 * files.
 */
#include "snort.h"

#ifndef __SPO_CSV_H__
#define __SPO_CSV_H__

#define DEFAULT_CSV "timestamp,msg,proto,src,srcport,dst,dsport,ethsrc,ethdst,ethlen,tcpflags,tcpseq,tcpack,tcpln,tcpwindow,ttl,tos,id,dgmlen,iplen,icmptype,icmpcode,icmpid,icmpseq"

typedef struct _SpoCSVConfig
{
    char *type;
    struct _SpoCSVConfig *next;
} SpoCSVConfig;

typedef struct _SpoCSVData
{
    FILE *file;
    char * csvargs;
    char ** args;
    int numargs;
    SpoCSVConfig *config;
} SpoCSVData;


/* list of function prototypes for this preprocessor */
void SetupCSV();
void CSVInit(u_char *);
SpoCSVData *ParseCSVArgs(char *);
void SpoCSV(Packet *, char *, void *, Event *);
void CSVCleanExitFunc(int, void *);
void CSVRestartFunc(int, void *);

void AlertCSV(Packet *, char *, FILE *, char **, const int);
void CSVAlert(Packet *, char *, void *, char **, const int);

#endif  /* __SPO_CSV_H__ */
