unit LogoMain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, Grids, DBGrids;

type
    paramt = record
           path, name, disc: pchar;
    end;
    pparamt = ^paramt;

    TSwordAppForm = class(TForm)
        MainMenu: TMainMenu;
        FileMenu: TMenuItem;
        FileExitItem: TMenuItem;
        Help1: TMenuItem;
        AboutItem: TMenuItem;
        SpeedPanel: TPanel;
        ExitBtn: TSpeedButton;
        StatusBar: TStatusBar;
        TextBox: TRichEdit;
        CommentBox: TRichEdit;
        BookCB: TComboBox;
        CHBox: TEdit;
        VSBox: TEdit;
        Label1: TLabel;
        LookupBtn: TSpeedButton;
        TextKeyText: TLabel;
        LDBox: TRichEdit;
        LDTitle: TLabel;
        Label2: TLabel;
        LDKeyText: TLabel;
        TextTitle: TLabel;
        CommentTitle: TLabel;
    PopupMenu1: TPopupMenu;
    EastonsBibleDictionary1: TMenuItem;
    VinesBibleDictionary1: TMenuItem;
        procedure FormCreate(Sender: TObject);
        procedure FileExit(Sender: TObject);
        procedure Lookup(Sender: TObject);
        procedure About(Sender: TObject);
        procedure ShowHint(Sender: TObject);
    procedure EastonsBibleDictionary1Click(Sender: TObject);
    procedure TextBoxEnter(Sender: TObject);
    procedure VinesBibleDictionary1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    private
        curedit: TRichEdit;
        commonkey: integer;
        webster: integer;
        mhc: longint;
        eastons: longint;
        vines: longint;
        FFileName: String;
  public
    { Public declarations }
  end;

var
  SwordAppForm: TSwordAppForm;

implementation

uses SwordAPI, SysUtils, Mapi, About;

{$R *.DFM}

procedure TSwordAppForm.FormCreate(Sender: TObject);
var
   params: paramt;
   s1, s2, s3, s4: AnsiString;
   buf:PChar;
   book: integer;
begin
  Application.OnHint := ShowHint;

  commonkey := NewKey('VerseKey');
  GetMem(buf, 255);
  KeySetText(commonkey, 'Genesis 1:1');
  while (KeyError(commonkey) = 0) do
  begin
    KeyGetText(commonkey, buf, 254);
    s4 := strpas(buf);
    SetLength(s4, Length(s4) - 4);
    BookCB.Items.Add(s4);
    book := VerseKeyGetBook(commonkey);
    book := book + 1;
    VerseKeySetBook(commonkey, book);
  end;
  FreeMem(buf, 255);

  s1 := 'Webster';
  s2 := '../../../../modules/texts/rawtext/webster/';
  s3 :=  'Webster Text';
  params.name := PChar(s1);
  params.path := PChar(s2);
  params.disc := PChar(s3);
  webster := NewModule('RawText', @params);


  params.name := 'MHC';
  params.path := '../../../../modules/comments/rawcom/mhc/';
  params.disc := 'Matthew Henry''''s Commentary';
  mhc     := NewModule('RawCom', @params);

  KeySetPersist(commonkey, 1);
  ModSetKeyKey(mhc, commonkey);
  ModSetKeyKey(webster, commonkey);

  params.name := 'Eastons';
  params.path := '../../../../modules/lexdict/rawld/eastons/eastons';
  params.disc := 'Easton''''s Bible Dictionary';
  eastons     := NewModule('RawLD', @params);

  params.path := '../../../../modules/lexdict/rawld/vines/vines';
  params.name := 'Vines';
  params.disc := 'Vine''''s Bible Dictionary';
  vines       := NewModule('RawLD', @params);
end;


procedure TSwordAppForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	DeleteModule(webster);
     DeleteModule(mhc);
     DeleteModule(eastons);
     DeleteModule(vines);
     DeleteKey(commonkey);
end;


procedure TSwordAppForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TSwordAppForm.Lookup(Sender: TObject);
var
  Buffer: PChar;
  s1: AnsiString;
  hkey: integer;
begin
  s1 := BookCB.Text + ' ' + CHBox.Text + ':' + VSBox.Text;
  if ((StrToInt(CHBox.Text) = 0) or (StrToInt(VSBox.Text) = 0)) then
     VerseKeySetAutoNormalize(commonkey, 0);

  KeySetText(commonkey, PChar(s1));

  GetMem(Buffer, 4096);           {Creates Buffer dynamic variable}
  KeyGetText(commonkey, Buffer, 4095);
  TextKeyText.Caption := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
  ModGetText(webster, Buffer, 4095);
  TextBox.Text := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
  ModGetText(mhc, Buffer, 4095);
  CommentBox.Text := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
  FreeMem(Buffer, 4096);          {Frees memory allocated to Buffer}

  VerseKeySetAutoNormalize(commonkey, 1);
end;

procedure TSwordAppForm.About(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSwordAppForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TSwordAppForm.EastonsBibleDictionary1Click(Sender: TObject);
var
   s1 : AnsiString;
   Buffer: PChar;
begin
     s1 := Trim(curedit.SelText);
     ModSetKeyText(eastons, PChar(s1));
     GetMem(Buffer, 4096);           {Creates Buffer dynamic variable}
     ModGetText(eastons, Buffer, 4095);
     LDBox.Text := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
     ModGetKeyText(eastons, Buffer, 4095);
     LDKeyText.Caption := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
     LDTitle.Caption := 'Easton''s Bible Dictionary';
     FreeMem(Buffer, 4096);
end;

procedure TSwordAppForm.TextBoxEnter(Sender: TObject);
begin
     curedit := TRichEdit(Sender);
end;

procedure TSwordAppForm.VinesBibleDictionary1Click(Sender: TObject);
var
   s1 : AnsiString;
   Buffer: PChar;
begin
     s1 := Trim(curedit.SelText);
     ModSetKeyText(vines, PChar(s1));
     GetMem(Buffer, 4096);           {Creates Buffer dynamic variable}
     ModGetText(vines, Buffer, 4095);
     LDBox.Text := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
     ModGetKeyText(vines, Buffer, 4095);
     LDKeyText.Caption := StrPas(Buffer);   {Converts Buffer to a Pascal-style string}
     LDTitle.Caption := 'Vines''s Bible Dictionary';
     FreeMem(Buffer, 4096);

end;

end.

