<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * delte a product from the database
 *
 * @modulegroup product
 * @module product_new
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'appointment.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','del');

 $msg = "";
 $gotourl = "product_overview.php";
 $p = new product($dbconn);

 if ( empty($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$p->getType()]) ."<br>";
 } else {
   $p->read($_GET['id']);
   if ( $p->id < 1 ) {
     $msg .= sprintf($lang['Err0040'],$lang[$p->getType()]) . "<br>";
   } else {
     $gotourl = $p->getUrl();
   }
 }
 if ( ! $p->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$p->getType()]) ."<br>";
 }

 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $p->delete();
   $dbconn->Commit("WORK");

   $gotourl = "product_overview.php";
 }

 $_SESSION['MSGID'.$p->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $p->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl(). $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: product_del.php,v 1.24.2.1 2003/07/24 09:05:08 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
