<?php
/**
 * Copyright 1999 - 2001 by Gero Kohnert
 *
 * @modulegroup timetrack
 * @module timetrack_select
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","select");
 loadlayout();

 /**
  * display a timetrack selection form
  */
 class timetrack_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang , $tutos;

     echo "<br><br><center>\n";
     echo "<form name=\"ttsearch\" action=\"timetrack_overview.php\" method=\"get\">\n";
     DoubleTableStart();

     echo "<tr>\n";
     if ( $this->ext == 0 ) {
       echo "<th colspan=\"3\">". $lang['SearchForTT'] ."</th>\n";
       echo "</tr><tr>\n";

       echo $this->showfieldc($lang['AdrName']);
       echo " <td align=\"center\">&nbsp;<input type=\"text\" value=\"\" name=\"name\"></td>\n";
       echo " <td align=\"center\">\n";
       echo " <input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForTT'] ."\"></td>\n";
       echo "</tr><tr>\n";
       echo " <td colspan=\"2\" align=\"center\"><font size=\"-1\">&nbsp;</font></td>\n";
       echo " <td align=\"center\">". makelink("timetrack_select.php?ext=1",$lang['extended']) ."</td>\n";
     } else {
       echo "<th colspan=\"3\">". $lang['SearchForTTExt'] ."</th>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['AdrName']);
       echo " <td>&nbsp;<input type=\"text\" value=\"\" name=\"name\">";
       echo " </td>\n";
       echo " <td align=\"center\"><input type=\"submit\" value=\"". $lang['Search'] ."\" title=\"". $lang['SearchForTTExt'] ."\"></td>\n";

       echo "</tr><tr>\n";
       echo " <td rowspan=\"2\" class=\"desc\">". $lang['TimetrackBetween'] ."</td>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->fd->EnterDate("f",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo " <td colspan=\"2\">&nbsp;";
       $this->td->EnterDate("t",1);
       echo "&nbsp;</td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['TTState']);
       echo " <td colspan=\"2\"><select name=\"state\">";
       echo "   <option value=\"-2\">". $lang['any'] ."</option>\n";
       foreach ($lang['TTStates'] as $s => $x) {
         echo "   <option value=\"". $s ."\"". ($this->state == $s ? " selected" : "") .">". $lang['TTStates'][$s] ."</option>\n";
       }
       echo "</select></td>\n";

       echo "</tr><tr>\n";
       echo $this->showfieldc($lang['TimetrackWorker']);
       echo " <td colspan=\"2\">\n";
       echo $this->user->askPeople("worker",$this->user->id,0);
       echo " </td>\n";
     }
     echo "</tr>\n";
     DoubleTableEnd();
     hiddenFormElements();
     echo "</form>\n";
     echo "</center>\n";
     echo $this->setfocus("ttsearch.name");
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['TimetrackSearch'];

     # Defaults for search
     $this->fd = new DateTime(0);
     $this->td = new DateTime(0);
     if ( isset($_SESSION['ttsearchfrom']) ) {
       $this->fd->setDateTime($_SESSION['ttsearchfrom']);
     }
     if ( isset($_SESSION['ttsearchto']) ) {
       $this->td->setDateTime($_SESSION['ttsearchto']);
     }
     if ( isset($_SESSION['ttsearchstate']) ) {
       $this->state = $_SESSION['ttsearchstate'];
     } else {
       $this->state = -2;
     }
     if ( isset($_GET['ext']) ) {
       $this->ext = $_GET['ext'];
     } else {
       $this->ext = 0;
     }
     if ( ! $this->user->feature_ok(usetimetrack,PERM_SEL) ) {
       $this->stop = true;
     }
   }
 }

 $l = new timetrack_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: timetrack_select.php,v 1.19 2002/12/31 14:33:41 gokohnert Exp $
    $Author: gokohnert $
-->
