/* 
 * w3m func.h
 */

#ifndef FUNC_H
#define FUNC_H

#include <btri.h>
#include "textlist.h"

#define K_ESC_POS (7)
#define K_ESC_LEN (2)
#define K_ESC_MASK (((1U << K_ESC_LEN) - 1U) << K_ESC_POS)
#define K_ESC_NONE (0U << K_ESC_POS)
#define K_ESC (1U << K_ESC_POS)
#define K_ESCB (2U << K_ESC_POS)
#define K_ESCD (3U << K_ESC_POS)

#define K_UP (K_ESCB | 0x41)
#define K_DOWN (K_ESCB | 0x42)
#define K_RIGHT (K_ESCB | 0x43)
#define K_LEFT (K_ESCB | 0x44)
#define K_PocketBSD_INS (K_ESCB | 0x45)
#define K_END (K_ESCB | 0x46)
#define K_PGDN (K_ESCB | 0x47)
#define K_HOME (K_ESCB | 0x48)
#define K_PGUP (K_ESCB | 0x49)
#define K_FreeBSD_CONSOLE_INS (K_ESCB | 0x4C)

#define K_XTERM_MOUSE (K_ESCB | 0x4D)

#define K_PAD_HOME (K_ESCD | 0x01) /* fixme */
#define K_PAD_INS (K_ESCD | 0x02)
#define K_PAD_END (K_ESCD | 0x04) /* fixme */
#define K_PAD_PGUP (K_ESCD | 0x05)
#define K_PAD_PGDN (K_ESCD | 0x06)
#define K_PAD_F1 (K_ESCD | 0x0B)
#define K_PAD_F2 (K_ESCD | 0x0C)
#define K_PAD_F3 (K_ESCD | 0x0D)
#define K_PAD_F4 (K_ESCD | 0x0E)
#define K_PAD_F5 (K_ESCD | 0x0F)
#define K_PAD_F6 (K_ESCD | 0x11)
#define K_PAD_F7 (K_ESCD | 0x12)
#define K_PAD_F8 (K_ESCD | 0x13)
#define K_PAD_F9 (K_ESCD | 0x14)
#define K_PAD_F10 (K_ESCD | 0x15)
#define K_PAD_HELP (K_ESCD | 0x1C)

#ifdef USE_MOUSE
#define K_MOUSE_CLICK (0)
#define K_MOUSE_DCLICK (1)
#define K_MOUSE_DRAG (2)
#define K_MOUSE_MOVE (3)
#define K_MOUSE_NBTNS (5)
#define K_MOUSE(op) (K_ESCD | (100 + K_MOUSE_ ## op * K_MOUSE_NBTNS))
#endif

#define K_ONE_LEN (K_ESC_POS + K_ESC_LEN)

#define K_LEN_LEN (2)
#define K_LEN_MASK ((1U << K_LEN_LEN) - 1U)
#define K_LEN(k) ((k) & K_LEN_MASK)

#define K_LEN_MAX (2)

#define K_CMP_LEN ((K_ONE_LEN) * K_LEN_MAX + K_LEN_LEN)
#define K_CMP_MASK (~(~0U << K_CMP_LEN))
#define K_CMP(x, op, y) ((x) & K_CMP_MASK) op ((y) & K_CMP_MASK)

#define K_SET_FUNC(k, f) (((f) << K_CMP_LEN) | (k))
#define K_GET_FUNC(k) ((k) >> K_CMP_LEN)
#define K_FUNC_MAX (~(~0 << (sizeof(int) * CHAR_BIT - 1 - K_CMP_LEN)))

#define K_GEN(old, cur) \
((((old) << K_ONE_LEN) & (~0U << (K_ONE_LEN + K_LEN_LEN))) | \
 (((cur) & ~(~0U << K_ONE_LEN)) << K_LEN_LEN) | \
 (((old) & K_LEN_MASK) + 1U))

#define K_OVER(old, cur) (((old) & ~(~(~0U << K_ONE_LEN) << K_LEN_LEN)) | (((cur) & ~(~0U << K_ONE_LEN)) << K_LEN_LEN))

struct _InputLineEnv;

typedef struct _FuncList {
  char *id;
  union {
    void (*main_func)(void);
    void (*edit_func)(int, struct _InputLineEnv *);
    int (*menu_func)(int);
  } func;
} FuncList;

typedef int KeyTabItem;

typedef struct _KeyTabList {
  struct _KeyTabList *next;
  KeyTabItem *key_table;
  int nitem, size;
} KeyTabList;

extern btri_string_tab_t w3mFuncTab[];

#endif				/* not FUNC_H */
