#!/usr/local/bin/perl
# edit_vserv.cgi
# Edit the fundamental parameters of some virtual server

require './apache-lib.pl';
&ReadParse();
$access{'vaddr'} || &error($text{'vserv_ecannot'});
$vconf = &get_config()->[$in{'virt'}];
&header($text{'vserv_title'}, "",
	undef, undef, undef, undef, &restart_button());
print "<hr>\n";

$val = $vconf->{'value'};
if ($val =~ /\s/) {
	$addrs = $val;
	}
if ($val =~ /^(\S+):(\S+)$/) {
	$addr = $1; $port = $2;
	}
else { $addr = $val; }
if ($addr eq "_default_" || $addr eq "*") { undef($addr); }
$root = &find_directive_struct("DocumentRoot", $vconf->{'members'});
$name = &find_directive("ServerName", $vconf->{'members'});

print "<form action=save_vserv.cgi>\n";
print "<input type=hidden name=virt value=$in{'virt'}>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'vserv_title'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

if ($addrs) {
	print "<tr> <td valign=top><b>$text{'vserv_addrs'}</b></td>\n";
	print "<td><textarea name=addrs rows=4 cols=30>",
	      join("\n", split(/\s+/, $addrs)),"</textarea></td> </tr>\n";
	}
else {
	print "<tr> <td><b>$text{'vserv_addr'}</b></td>\n";
	print "<td>",&opt_input($addr, "addr", $text{'vserv_any'}, 30),
	      "</td> </tr>\n";

	print "<tr> <td><b>$text{'vserv_port'}</b></td>\n";
	print "<td>",&choice_input($port eq "*" ? 1 : $port > 0 ? 2 : 0,
				   "port_mode", "0", "$text{'vserv_default'},0",
				   "$text{'vserv_any'},1", ",2");
	printf "<input name=port size=5 value=\"%s\"></td> </tr>\n",
		$port > 0 ? $port : "";
	}

print "<tr> <td><b>$text{'vserv_root'}</b></td>\n";
print "<td>",&opt_input($root->{'words'}->[0], "root", $text{'vserv_default'},
	50), &file_chooser_button("root", 1),"</td> </tr>\n";

print "<tr> <td><b>$text{'vserv_name'}</b></td>\n";
print "<td>",&opt_input($name, "name", $text{'vserv_default'}, 30),
      "</td> </tr>\n";

print "<tr> <td colspan=2 align=right>\n";
print "<input type=submit value=\"$text{'save'}\">\n";
print "<input type=submit value=\"$text{'vserv_delete'}\" name=delete>\n";
print "</td> </tr>\n";

print "</table> </td></tr></table><p>\n";
print "</form>\n";

print "<hr>\n";
&footer("virt_index.cgi?virt=$in{'virt'}", $text{'virt_return'});

