#!/usr/local/bin/perl
# list_features.cgi
# Display a list of all sendmail features from the M4 file

require './sendmail-lib.pl';
require './features-lib.pl';

$features_access || &error($text{'features_ecannot'});
&header($text{'features_title'}, "");
print "<hr>\n";

@features = &list_features() if (-r $config{'sendmail_mc'} &&
				 -r "$config{'sendmail_features'}/feature");
if (@features) {
	# Show table of features
	print &text('features_desc', "<tt>$config{'sendmail_mc'}</tt>",
		    "<tt>$config{'sendmail_cf'}</tt>"),"<p>\n";
	print "<form action=edit_feature.cgi>\n";
	print "<input type=hidden name=new value=1>\n";
	print "<table cellpadding=0 cellspacing=0 width=100%>\n";
	print "<tr $tb> <td><b>$text{'features_type'}</b></td>\n";
	print "<td><b>$text{'features_value'}</b></td> </tr>\n";
	foreach $f (@features) {
		print "<tr $cb>\n";
		print "<td><a href='edit_feature.cgi?idx=$f->{'index'}'>";
		print "<b>" if ($f->{'type'});
		print $text{"features_type".$f->{'type'}};
		print "</b>" if ($f->{'type'});
		print "</a></td>\n";
		print "<td><tt>",$f->{'text'} ? &html_escape($f->{'text'})
					      : "<br>","</tt></td>\n";
		print "</tt></td> </tr>\n";
		}
	print "</table>\n";
	print "<input type=submit value='$text{'features_add'}'>\n";
	print "<select name=type>\n";
	foreach $i (0, 1, 2, 4, 5) {
		print "<option value=$i>",$text{'features_type'.$i},"\n";
		}
	print "</select></form>\n";

	# Show button to rebuild sendmail.cf
	print "<hr>\n";
	print "<form action=build.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'features_build'}'></td>\n";
	print "<td>",&text('features_buildmsg', "<tt>$config{'sendmail_cf'}</tt>"),
	      "</td>\n";
	print "</tr></table>\n";
	}
else {
	# Features file is not setup yet ..
	if (!$config{'sendmail_mc'} || !$config{'sendmail_features'}) {
		print "<p>",&text('features_econfig',
				  "/config.cgi?$module_name"),"<p>\n";
		}
	elsif (!-r $config{'sendmail_mc'}) {
		print "<p>",&text('features_emc', "/config.cgi?$module_name",
				  "<tt>$config{'sendmail_mc'}</tt>"),"<p>\n";
		}
	elsif (!-r "$config{'sendmail_features'}/feature") {
		print "<p>",&text('features_efeatures', "/config.cgi?$module_name",
				  "<tt>$config{'sendmail_features'}</tt>"),"<p>\n";
		}
	}

print "<hr>\n";
&footer("", $text{'index_return'});

