/* DO NOT EDIT
 * This dissector is autogenerated
 */

/* packet-dcerpc-drsuapi.c
 * Routines for DRSUAPI packet disassembly
 *   ronnie sahlberg 2005
 *
 * $Id: packet-dcerpc-drsuapi.c 24397 2008-02-19 22:13:53Z jmayer $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <string.h>

#include <epan/packet.h>
#include "packet-dcerpc.h"
#include "packet-dcerpc-nt.h"
#include "packet-windows-common.h"
#include "packet-dcerpc-drsuapi.h"

static int proto_drsuapi = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_nc_dn = -1;


/* INCLUDED FILE : ETH_HF */
static int hf_drsuapi_opnum = -1;
static int hf_drsuapi_rc = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_BASE = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00000080 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00100000 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_20000000 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_40000000 = -1;
static int hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_80000000 = -1;
static int hf_drsuapi_DsBindInfo24_supported_extensions = -1;
static int hf_drsuapi_DsBindInfo24_site_guid = -1;
static int hf_drsuapi_DsBindInfo24_u1 = -1;
static int hf_drsuapi_DsBindInfo28_supported_extensions = -1;
static int hf_drsuapi_DsBindInfo28_site_guid = -1;
static int hf_drsuapi_DsBindInfo28_u1 = -1;
static int hf_drsuapi_DsBindInfo28_repl_epoch = -1;
static int hf_drsuapi_DsBindInfo_24_info24 = -1;
static int hf_drsuapi_DsBindInfo_28_info28 = -1;
static int hf_drsuapi_DsBindInfoCtr_length = -1;
static int hf_drsuapi_DsBindInfoCtr_info = -1;
static int hf_drsuapi_DsBind_bind_guid = -1;
static int hf_drsuapi_DsBind_bind_info = -1;
static int hf_drsuapi_DsBind_bind_handle = -1;
static int hf_drsuapi_DsUnbind_bind_handle = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_unknown1 = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_unknown2 = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_guid1 = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_byte_array = -1;
static int hf_drsuapi_DsReplicaSyncRequest1Info_str_len = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_WRITEABLE = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PERIODIC = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_URGENT = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FORCE = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_TWO_WAY = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ABANDONED = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_REQUEUE = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_CRITICAL = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS = -1;
static int hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PREEMPTED = -1;
static int hf_drsuapi_DsReplicaSyncRequest1_info = -1;
static int hf_drsuapi_DsReplicaSyncRequest1_guid1 = -1;
static int hf_drsuapi_DsReplicaSyncRequest1_string1 = -1;
static int hf_drsuapi_DsReplicaSyncRequest1_options = -1;
static int hf_drsuapi_DsReplicaSyncRequest_1_req1 = -1;
static int hf_drsuapi_DsReplicaSync_bind_handle = -1;
static int hf_drsuapi_DsReplicaSync_level = -1;
static int hf_drsuapi_DsReplicaSync_req = -1;
static int hf_drsuapi_DsGetNCChangesUsnTriple_usn1 = -1;
static int hf_drsuapi_DsGetNCChangesUsnTriple_usn2 = -1;
static int hf_drsuapi_DsGetNCChangesUsnTriple_usn3 = -1;
static int hf_drsuapi_DsReplicaCoursor_source_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaCoursor_highest_usn = -1;
static int hf_drsuapi_DsReplicaCoursor05Ctr_u1 = -1;
static int hf_drsuapi_DsReplicaCoursor05Ctr_u2 = -1;
static int hf_drsuapi_DsReplicaCoursor05Ctr_count = -1;
static int hf_drsuapi_DsReplicaCoursor05Ctr_u3 = -1;
static int hf_drsuapi_DsReplicaCoursor05Ctr_array = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_guid1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_guid2 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_sync_req_info1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_usn1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_coursor = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_unknown1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_unknown2 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_unknown3 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_unknown4 = -1;
static int hf_drsuapi_DsGetNCChangesRequest5_h1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr14_length = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr14_byte_array = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr13_unknown1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr13_data = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr12_count = -1;
static int hf_drsuapi_DsGetNCChangesRequest_Ctr12_array = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_guid1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_guid2 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_sync_req_info1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_usn1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_coursor = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unknown1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unknown2 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unknown3 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unknown4 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_h1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unique_ptr1 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_unique_ptr2 = -1;
static int hf_drsuapi_DsGetNCChangesRequest8_ctr12 = -1;
static int hf_drsuapi_DsGetNCChangesRequest_5_req5 = -1;
static int hf_drsuapi_DsGetNCChangesRequest_8_req8 = -1;
static int hf_drsuapi_DsReplicaCoursorEx_coursor = -1;
static int hf_drsuapi_DsReplicaCoursorEx_time1 = -1;
static int hf_drsuapi_DsReplicaCoursorEx05Ctr_u1 = -1;
static int hf_drsuapi_DsReplicaCoursorEx05Ctr_u2 = -1;
static int hf_drsuapi_DsReplicaCoursorEx05Ctr_count = -1;
static int hf_drsuapi_DsReplicaCoursorEx05Ctr_u3 = -1;
static int hf_drsuapi_DsReplicaCoursorEx05Ctr_array = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_guid1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_guid2 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_sync_req_info1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_usn1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_usn2 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_coursor_ex = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_ctr12 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_u1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_ptr1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_u2 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_len1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_array_ptr1 = -1;
static int hf_drsuapi_DsGetNCChangesCtr6_u3 = -1;
static int hf_drsuapi_DsGetNCChangesCtr_6_ctr6 = -1;
static int hf_drsuapi_DsGetNCChangesCtr_7_ctr7 = -1;
static int hf_drsuapi_DsGetNCChanges_bind_handle = -1;
static int hf_drsuapi_DsGetNCChanges_level = -1;
static int hf_drsuapi_DsGetNCChanges_req = -1;
static int hf_drsuapi_DsGetNCChanges_ctr = -1;
static int hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION = -1;
static int hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE = -1;
static int hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE = -1;
static int hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE = -1;
static int hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_0x00000010 = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown1 = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown2 = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_guid = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_options = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_sync_req_info1 = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_dns_name = -1;
static int hf_drsuapi_DsReplicaUpdateRefsRequest_1_req1 = -1;
static int hf_drsuapi_DsReplicaUpdateRefs_bind_handle = -1;
static int hf_drsuapi_DsReplicaUpdateRefs_level = -1;
static int hf_drsuapi_DsReplicaUpdateRefs_req = -1;
static int hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION = -1;
static int hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_WRITEABLE = -1;
static int hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION = -1;
static int hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_WRITEABLE = -1;
static int hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION = -1;
static int hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE = -1;
static int hf_drsuapi_DsNameString_str = -1;
static int hf_drsuapi_DsNameRequest1_unknown1 = -1;
static int hf_drsuapi_DsNameRequest1_unknown2 = -1;
static int hf_drsuapi_DsNameRequest1_format_flags = -1;
static int hf_drsuapi_DsNameRequest1_format_offered = -1;
static int hf_drsuapi_DsNameRequest1_format_desired = -1;
static int hf_drsuapi_DsNameRequest1_count = -1;
static int hf_drsuapi_DsNameRequest1_names = -1;
static int hf_drsuapi_DsNameRequest_1_req1 = -1;
static int hf_drsuapi_DsNameInfo1_status = -1;
static int hf_drsuapi_DsNameInfo1_dns_domain_name = -1;
static int hf_drsuapi_DsNameInfo1_result_name = -1;
static int hf_drsuapi_DsNameCtr1_count = -1;
static int hf_drsuapi_DsNameCtr1_array = -1;
static int hf_drsuapi_DsNameCtr_1_ctr1 = -1;
static int hf_drsuapi_DsCrackNames_bind_handle = -1;
static int hf_drsuapi_DsCrackNames_level = -1;
static int hf_drsuapi_DsCrackNames_req = -1;
static int hf_drsuapi_DsCrackNames_ctr = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest1_operation = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest1_unknown1 = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest1_object_dn = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest1_count = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest1_spn_names = -1;
static int hf_drsuapi_DsWriteAccountSpnRequest_1_req1 = -1;
static int hf_drsuapi_DsWriteAccountSpnResult1_status = -1;
static int hf_drsuapi_DsWriteAccountSpnResult_1_res1 = -1;
static int hf_drsuapi_DsWriteAccountSpn_bind_handle = -1;
static int hf_drsuapi_DsWriteAccountSpn_level = -1;
static int hf_drsuapi_DsWriteAccountSpn_req = -1;
static int hf_drsuapi_DsWriteAccountSpn_res = -1;
static int hf_drsuapi_DsGetDCInfoRequest1_domain_name = -1;
static int hf_drsuapi_DsGetDCInfoRequest1_level = -1;
static int hf_drsuapi_DsGetDCInfoRequest_1_req1 = -1;
static int hf_drsuapi_DsGetDCInfo1_netbios_name = -1;
static int hf_drsuapi_DsGetDCInfo1_dns_name = -1;
static int hf_drsuapi_DsGetDCInfo1_site_name = -1;
static int hf_drsuapi_DsGetDCInfo1_computer_dn = -1;
static int hf_drsuapi_DsGetDCInfo1_server_dn = -1;
static int hf_drsuapi_DsGetDCInfo1_is_pdc = -1;
static int hf_drsuapi_DsGetDCInfo1_is_enabled = -1;
static int hf_drsuapi_DsGetDCInfoCtr1_count = -1;
static int hf_drsuapi_DsGetDCInfoCtr1_array = -1;
static int hf_drsuapi_DsGetDCInfo2_netbios_name = -1;
static int hf_drsuapi_DsGetDCInfo2_dns_name = -1;
static int hf_drsuapi_DsGetDCInfo2_site_name = -1;
static int hf_drsuapi_DsGetDCInfo2_site_dn = -1;
static int hf_drsuapi_DsGetDCInfo2_computer_dn = -1;
static int hf_drsuapi_DsGetDCInfo2_server_dn = -1;
static int hf_drsuapi_DsGetDCInfo2_ntds_dn = -1;
static int hf_drsuapi_DsGetDCInfo2_is_pdc = -1;
static int hf_drsuapi_DsGetDCInfo2_is_enabled = -1;
static int hf_drsuapi_DsGetDCInfo2_is_gc = -1;
static int hf_drsuapi_DsGetDCInfo2_site_guid = -1;
static int hf_drsuapi_DsGetDCInfo2_computer_guid = -1;
static int hf_drsuapi_DsGetDCInfo2_server_guid = -1;
static int hf_drsuapi_DsGetDCInfo2_ntds_guid = -1;
static int hf_drsuapi_DsGetDCInfoCtr2_count = -1;
static int hf_drsuapi_DsGetDCInfoCtr2_array = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown1 = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown2 = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown3 = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown4 = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown5 = -1;
static int hf_drsuapi_DsGetDCInfo01_unknown6 = -1;
static int hf_drsuapi_DsGetDCInfo01_server_nt4_account = -1;
static int hf_drsuapi_DsGetDCInfoCtr01_count = -1;
static int hf_drsuapi_DsGetDCInfoCtr01_array = -1;
static int hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_1_ctr1 = -1;
static int hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_2_ctr2 = -1;
static int hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_01_ctr01 = -1;
static int hf_drsuapi_DsGetDomainControllerInfo_bind_handle = -1;
static int hf_drsuapi_DsGetDomainControllerInfo_level = -1;
static int hf_drsuapi_DsGetDomainControllerInfo_req = -1;
static int hf_drsuapi_DsGetDomainControllerInfo_ctr = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest1_info_type = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest1_object_dn = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest1_guid1 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_info_type = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_object_dn = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_guid1 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_unknown1 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_string1 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_string2 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest2_unknown2 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO_req1 = -1;
static int hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO2_req2 = -1;
static int hf_drsuapi_DsReplicaNeighbour_naming_context_dn = -1;
static int hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaNeighbour_source_dsa_address = -1;
static int hf_drsuapi_DsReplicaNeighbour_transport_obj_dn = -1;
static int hf_drsuapi_DsReplicaNeighbour_replica_flags = -1;
static int hf_drsuapi_DsReplicaNeighbour_reserved = -1;
static int hf_drsuapi_DsReplicaNeighbour_naming_context_obj_guid = -1;
static int hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_guid = -1;
static int hf_drsuapi_DsReplicaNeighbour_source_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaNeighbour_transport_obj_guid = -1;
static int hf_drsuapi_DsReplicaNeighbour_tmp_highest_usn = -1;
static int hf_drsuapi_DsReplicaNeighbour_highest_usn = -1;
static int hf_drsuapi_DsReplicaNeighbour_last_success = -1;
static int hf_drsuapi_DsReplicaNeighbour_last_attempt = -1;
static int hf_drsuapi_DsReplicaNeighbour_result_last_attempt = -1;
static int hf_drsuapi_DsReplicaNeighbour_consecutive_sync_failures = -1;
static int hf_drsuapi_DsReplicaNeighbourCtr_count = -1;
static int hf_drsuapi_DsReplicaNeighbourCtr_reserved = -1;
static int hf_drsuapi_DsReplicaNeighbourCtr_array = -1;
static int hf_drsuapi_DsReplicaCoursorCtr_count = -1;
static int hf_drsuapi_DsReplicaCoursorCtr_reserved = -1;
static int hf_drsuapi_DsReplicaCoursorCtr_array = -1;
static int hf_drsuapi_DsReplicaObjMetaData_attribute_name = -1;
static int hf_drsuapi_DsReplicaObjMetaData_version = -1;
static int hf_drsuapi_DsReplicaObjMetaData_originating_last_changed = -1;
static int hf_drsuapi_DsReplicaObjMetaData_originating_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaObjMetaData_originating_usn = -1;
static int hf_drsuapi_DsReplicaObjMetaData_local_usn = -1;
static int hf_drsuapi_DsReplicaObjMetaDataCtr_count = -1;
static int hf_drsuapi_DsReplicaObjMetaDataCtr_reserved = -1;
static int hf_drsuapi_DsReplicaObjMetaDataCtr_array = -1;
static int hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_guid = -1;
static int hf_drsuapi_DsReplicaKccDsaFailure_first_failure = -1;
static int hf_drsuapi_DsReplicaKccDsaFailure_num_failures = -1;
static int hf_drsuapi_DsReplicaKccDsaFailure_last_result = -1;
static int hf_drsuapi_DsReplicaKccDsaFailuresCtr_count = -1;
static int hf_drsuapi_DsReplicaKccDsaFailuresCtr_reserved = -1;
static int hf_drsuapi_DsReplicaKccDsaFailuresCtr_array = -1;
static int hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_SYNC_sync = -1;
static int hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_ADD_add = -1;
static int hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_DELETE_delete = -1;
static int hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY_modify = -1;
static int hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS_update_refs = -1;
static int hf_drsuapi_DsRplicaOpOptions_default_unknown = -1;
static int hf_drsuapi_DsReplicaOp_operation_start = -1;
static int hf_drsuapi_DsReplicaOp_serial_num = -1;
static int hf_drsuapi_DsReplicaOp_priority = -1;
static int hf_drsuapi_DsReplicaOp_operation_type = -1;
static int hf_drsuapi_DsReplicaOp_options = -1;
static int hf_drsuapi_DsReplicaOp_nc_dn = -1;
static int hf_drsuapi_DsReplicaOp_remote_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaOp_remote_dsa_address = -1;
static int hf_drsuapi_DsReplicaOp_nc_obj_guid = -1;
static int hf_drsuapi_DsReplicaOp_remote_dsa_obj_guid = -1;
static int hf_drsuapi_DsReplicaOpCtr_time = -1;
static int hf_drsuapi_DsReplicaOpCtr_count = -1;
static int hf_drsuapi_DsReplicaOpCtr_array = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_attribute_name = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_object_dn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_value_length = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_value = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_deleted = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_created = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_version = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_originating_last_changed = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_originating_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_originating_usn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData_local_usn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaDataCtr_count = -1;
static int hf_drsuapi_DsReplicaAttrValMetaDataCtr_enumeration_context = -1;
static int hf_drsuapi_DsReplicaAttrValMetaDataCtr_array = -1;
static int hf_drsuapi_DsReplicaCoursor2_source_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaCoursor2_highest_usn = -1;
static int hf_drsuapi_DsReplicaCoursor2_last_sync_success = -1;
static int hf_drsuapi_DsReplicaCoursor2Ctr_count = -1;
static int hf_drsuapi_DsReplicaCoursor2Ctr_enumeration_context = -1;
static int hf_drsuapi_DsReplicaCoursor2Ctr_array = -1;
static int hf_drsuapi_DsReplicaCoursor3_source_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaCoursor3_highest_usn = -1;
static int hf_drsuapi_DsReplicaCoursor3_last_sync_success = -1;
static int hf_drsuapi_DsReplicaCoursor3_source_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaCoursor3Ctr_count = -1;
static int hf_drsuapi_DsReplicaCoursor3Ctr_enumeration_context = -1;
static int hf_drsuapi_DsReplicaCoursor3Ctr_array = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_attribute_name = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_version = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_originating_last_changed = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_originating_usn = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_local_usn = -1;
static int hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaObjMetaData2Ctr_count = -1;
static int hf_drsuapi_DsReplicaObjMetaData2Ctr_enumeration_context = -1;
static int hf_drsuapi_DsReplicaObjMetaData2Ctr_array = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_attribute_name = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_object_dn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_value_length = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_value = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_deleted = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_created = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_version = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_originating_last_changed = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_invocation_id = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_originating_usn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_local_usn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_obj_dn = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2Ctr_count = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2Ctr_enumeration_context = -1;
static int hf_drsuapi_DsReplicaAttrValMetaData2Ctr_array = -1;
static int hf_drsuapi_DsReplicaConnection04_u1 = -1;
static int hf_drsuapi_DsReplicaConnection04_u2 = -1;
static int hf_drsuapi_DsReplicaConnection04_u3 = -1;
static int hf_drsuapi_DsReplicaConnection04_bind_guid = -1;
static int hf_drsuapi_DsReplicaConnection04_bind_time = -1;
static int hf_drsuapi_DsReplicaConnection04_u4 = -1;
static int hf_drsuapi_DsReplicaConnection04_u5 = -1;
static int hf_drsuapi_DsReplicaConnection04Ctr_count = -1;
static int hf_drsuapi_DsReplicaConnection04Ctr_reserved = -1;
static int hf_drsuapi_DsReplicaConnection04Ctr_array = -1;
static int hf_drsuapi_DsReplica06_str1 = -1;
static int hf_drsuapi_DsReplica06_u1 = -1;
static int hf_drsuapi_DsReplica06_u2 = -1;
static int hf_drsuapi_DsReplica06_u3 = -1;
static int hf_drsuapi_DsReplica06_u4 = -1;
static int hf_drsuapi_DsReplica06_u5 = -1;
static int hf_drsuapi_DsReplica06_u6 = -1;
static int hf_drsuapi_DsReplica06_u7 = -1;
static int hf_drsuapi_DsReplica06Ctr_count = -1;
static int hf_drsuapi_DsReplica06Ctr_reserved = -1;
static int hf_drsuapi_DsReplica06Ctr_array = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05 = -1;
static int hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06 = -1;
static int hf_drsuapi_DsReplicaGetInfo_bind_handle = -1;
static int hf_drsuapi_DsReplicaGetInfo_level = -1;
static int hf_drsuapi_DsReplicaGetInfo_req = -1;
static int hf_drsuapi_DsReplicaGetInfo_info_type = -1;
static int hf_drsuapi_DsReplicaGetInfo_info = -1;
/* END OF INCLUDED FILE : ETH_HF */





/* INCLUDED FILE : ETH_ETT */
static gint ett_drsuapi = -1;
static gint ett_drsuapi_SupportedExtensions = -1;
static gint ett_drsuapi_DsBindInfo24 = -1;
static gint ett_drsuapi_DsBindInfo28 = -1;
static gint ett_drsuapi_DsBindInfo = -1;
static gint ett_drsuapi_DsBindInfoCtr = -1;
static gint ett_drsuapi_DsReplicaSyncRequest1Info = -1;
static gint ett_drsuapi_DsReplicaSyncOptions = -1;
static gint ett_drsuapi_DsReplicaSyncRequest1 = -1;
static gint ett_drsuapi_DsReplicaSyncRequest = -1;
static gint ett_drsuapi_DsGetNCChangesUsnTriple = -1;
static gint ett_drsuapi_DsReplicaCoursor = -1;
static gint ett_drsuapi_DsReplicaCoursor05Ctr = -1;
static gint ett_drsuapi_DsGetNCChangesRequest5 = -1;
static gint ett_drsuapi_DsGetNCChangesRequest_Ctr14 = -1;
static gint ett_drsuapi_DsGetNCChangesRequest_Ctr13 = -1;
static gint ett_drsuapi_DsGetNCChangesRequest_Ctr12 = -1;
static gint ett_drsuapi_DsGetNCChangesRequest8 = -1;
static gint ett_drsuapi_DsGetNCChangesRequest = -1;
static gint ett_drsuapi_DsReplicaCoursorEx = -1;
static gint ett_drsuapi_DsReplicaCoursorEx05Ctr = -1;
static gint ett_drsuapi_DsGetNCChangesCtr6 = -1;
static gint ett_drsuapi_DsGetNCChangesCtr7 = -1;
static gint ett_drsuapi_DsGetNCChangesCtr = -1;
static gint ett_drsuapi_DsReplicaUpdateRefsOptions = -1;
static gint ett_drsuapi_DsReplicaUpdateRefsRequest1 = -1;
static gint ett_drsuapi_DsReplicaUpdateRefsRequest = -1;
static gint ett_drsuapi_DsReplicaAddOptions = -1;
static gint ett_drsuapi_DsReplicaDeleteOptions = -1;
static gint ett_drsuapi_DsReplicaModifyOptions = -1;
static gint ett_drsuapi_DsNameString = -1;
static gint ett_drsuapi_DsNameRequest1 = -1;
static gint ett_drsuapi_DsNameRequest = -1;
static gint ett_drsuapi_DsNameInfo1 = -1;
static gint ett_drsuapi_DsNameCtr1 = -1;
static gint ett_drsuapi_DsNameCtr = -1;
static gint ett_drsuapi_DsWriteAccountSpnRequest1 = -1;
static gint ett_drsuapi_DsWriteAccountSpnRequest = -1;
static gint ett_drsuapi_DsWriteAccountSpnResult1 = -1;
static gint ett_drsuapi_DsWriteAccountSpnResult = -1;
static gint ett_drsuapi_DsGetDCInfoRequest1 = -1;
static gint ett_drsuapi_DsGetDCInfoRequest = -1;
static gint ett_drsuapi_DsGetDCInfo1 = -1;
static gint ett_drsuapi_DsGetDCInfoCtr1 = -1;
static gint ett_drsuapi_DsGetDCInfo2 = -1;
static gint ett_drsuapi_DsGetDCInfoCtr2 = -1;
static gint ett_drsuapi_DsGetDCInfo01 = -1;
static gint ett_drsuapi_DsGetDCInfoCtr01 = -1;
static gint ett_drsuapi_DsGetDCInfoCtr = -1;
static gint ett_drsuapi_DsReplicaGetInfoRequest1 = -1;
static gint ett_drsuapi_DsReplicaGetInfoRequest2 = -1;
static gint ett_drsuapi_DsReplicaGetInfoRequest = -1;
static gint ett_drsuapi_DsReplicaNeighbour = -1;
static gint ett_drsuapi_DsReplicaNeighbourCtr = -1;
static gint ett_drsuapi_DsReplicaCoursorCtr = -1;
static gint ett_drsuapi_DsReplicaObjMetaData = -1;
static gint ett_drsuapi_DsReplicaObjMetaDataCtr = -1;
static gint ett_drsuapi_DsReplicaKccDsaFailure = -1;
static gint ett_drsuapi_DsReplicaKccDsaFailuresCtr = -1;
static gint ett_drsuapi_DsRplicaOpOptions = -1;
static gint ett_drsuapi_DsReplicaOp = -1;
static gint ett_drsuapi_DsReplicaOpCtr = -1;
static gint ett_drsuapi_DsReplicaAttrValMetaData = -1;
static gint ett_drsuapi_DsReplicaAttrValMetaDataCtr = -1;
static gint ett_drsuapi_DsReplicaCoursor2 = -1;
static gint ett_drsuapi_DsReplicaCoursor2Ctr = -1;
static gint ett_drsuapi_DsReplicaCoursor3 = -1;
static gint ett_drsuapi_DsReplicaCoursor3Ctr = -1;
static gint ett_drsuapi_DsReplicaObjMetaData2 = -1;
static gint ett_drsuapi_DsReplicaObjMetaData2Ctr = -1;
static gint ett_drsuapi_DsReplicaAttrValMetaData2 = -1;
static gint ett_drsuapi_DsReplicaAttrValMetaData2Ctr = -1;
static gint ett_drsuapi_DsReplicaConnection04 = -1;
static gint ett_drsuapi_DsReplicaConnection04Ctr = -1;
static gint ett_drsuapi_DsReplica06 = -1;
static gint ett_drsuapi_DsReplica06Ctr = -1;
static gint ett_drsuapi_DsReplicaInfo = -1;
/* END OF INCLUDED FILE : ETH_ETT */



static int
ucarray_drsuapi_dissect_DsReplicaSyncRequest1Info_nc_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
	header_field_info *hfinfo;
	static guint32 len;
	dcerpc_info *di;
	char *s;
	int old_offset;

	di=pinfo->private_data;
	if(di->conformant_run){
		/*just a run to handle conformant arrays, nothing to dissect 
		  but we need to remember how long this array was.
		  see packet-dcerpc.c for examples of conformant_run
		  and what it is.
		*/
		old_offset=offset;
		offset=dissect_dcerpc_uint32(tvb, offset, pinfo, NULL, drep, -1, &len);
		di->array_max_count_offset=offset-4;
		di->conformant_run=1;
		di->conformant_eaten=offset-old_offset;
		return offset;
	}

	ALIGN_TO_2_BYTES;

	s = tvb_fake_unicode(tvb, offset, len, TRUE);
        if (tree && len) {
            hfinfo = proto_registrar_get_nth(hf_drsuapi_DsReplicaSyncRequest1Info_nc_dn);
            if (hfinfo->type == FT_STRING) {
                proto_tree_add_string(tree, hf_drsuapi_DsReplicaSyncRequest1Info_nc_dn, tvb, offset,
                                      len, s);
            } else {
                proto_tree_add_item(tree, hf_drsuapi_DsReplicaSyncRequest1Info_nc_dn, tvb, offset,
                                    len, drep[0] & 0x10);
            }
        }

	offset+=2*len;
	return offset;
}

static int
drsuapi_dissect_a_string(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_vstring(tvb, offset, pinfo, tree, drep, 1, hf_index, FALSE, NULL);
    return offset;
}



/* INCLUDED FILE : ETH_CODE */
static e_uuid_t uuid_dcerpc_drsuapi = {
    0xe3514235, 0x4b06, 0x11d1,
    { 0xab, 0x04, 0x00, 0xc0, 0x4f, 0xc2, 0xdc, 0xd2}
};

static guint16 ver_drsuapi = 4;

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_BASE_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_BASE is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_BASE is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_00000080_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_00000080 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_00000080 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_00100000_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_00100000 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_00100000 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_20000000_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_20000000 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_20000000 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_40000000_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_40000000 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_40000000 is NOT set"
};

static const true_false_string DRSUAPI_SUPPORTED_EXTENSION_80000000_tfs = {
    "DRSUAPI_SUPPORTED_EXTENSION_80000000 is SET",
    "DRSUAPI_SUPPORTED_EXTENSION_80000000 is NOT set"
};


int
drsuapi_dissect_SupportedExtensions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_SupportedExtensions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_BASE, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_BASE");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION");
    }
    flags&=(~0x00000002);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI, tvb, offset-4, 4, flags);
    if(flags&0x00000004){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI");
    }
    flags&=(~0x00000004);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2, tvb, offset-4, 4, flags);
    if(flags&0x00000008){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2");
    }
    flags&=(~0x00000008);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS, tvb, offset-4, 4, flags);
    if(flags&0x00000010){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS");
    }
    flags&=(~0x00000010);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1, tvb, offset-4, 4, flags);
    if(flags&0x00000020){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1");
    }
    flags&=(~0x00000020);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION, tvb, offset-4, 4, flags);
    if(flags&0x00000040){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION");
    }
    flags&=(~0x00000040);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00000080, tvb, offset-4, 4, flags);
    if(flags&0x00000080){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_00000080");
    }
    flags&=(~0x00000080);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE, tvb, offset-4, 4, flags);
    if(flags&0x00000100){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE");
    }
    flags&=(~0x00000100);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2, tvb, offset-4, 4, flags);
    if(flags&0x00000200){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2");
    }
    flags&=(~0x00000200);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION, tvb, offset-4, 4, flags);
    if(flags&0x00000400){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION");
    }
    flags&=(~0x00000400);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2, tvb, offset-4, 4, flags);
    if(flags&0x00000800){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2");
    }
    flags&=(~0x00000800);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD, tvb, offset-4, 4, flags);
    if(flags&0x00001000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD");
    }
    flags&=(~0x00001000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND, tvb, offset-4, 4, flags);
    if(flags&0x00002000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND");
    }
    flags&=(~0x00002000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO, tvb, offset-4, 4, flags);
    if(flags&0x00004000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO");
    }
    flags&=(~0x00004000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION, tvb, offset-4, 4, flags);
    if(flags&0x00008000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION");
    }
    flags&=(~0x00008000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01, tvb, offset-4, 4, flags);
    if(flags&0x00010000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01");
    }
    flags&=(~0x00010000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP, tvb, offset-4, 4, flags);
    if(flags&0x00020000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP");
    }
    flags&=(~0x00020000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY, tvb, offset-4, 4, flags);
    if(flags&0x00040000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY");
    }
    flags&=(~0x00040000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3, tvb, offset-4, 4, flags);
    if(flags&0x00080000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3");
    }
    flags&=(~0x00080000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00100000, tvb, offset-4, 4, flags);
    if(flags&0x00100000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_00100000");
    }
    flags&=(~0x00100000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2, tvb, offset-4, 4, flags);
    if(flags&0x00200000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2");
    }
    flags&=(~0x00200000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6, tvb, offset-4, 4, flags);
    if(flags&0x00400000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6");
    }
    flags&=(~0x00400000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS, tvb, offset-4, 4, flags);
    if(flags&0x00800000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS");
    }
    flags&=(~0x00800000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8, tvb, offset-4, 4, flags);
    if(flags&0x01000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8");
    }
    flags&=(~0x01000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5, tvb, offset-4, 4, flags);
    if(flags&0x02000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5");
    }
    flags&=(~0x02000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6, tvb, offset-4, 4, flags);
    if(flags&0x04000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6");
    }
    flags&=(~0x04000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3, tvb, offset-4, 4, flags);
    if(flags&0x08000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3");
    }
    flags&=(~0x08000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7, tvb, offset-4, 4, flags);
    if(flags&0x08000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7");
    }
    flags&=(~0x08000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT, tvb, offset-4, 4, flags);
    if(flags&0x08000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT");
    }
    flags&=(~0x08000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS, tvb, offset-4, 4, flags);
    if(flags&0x10000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS");
    }
    flags&=(~0x10000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_20000000, tvb, offset-4, 4, flags);
    if(flags&0x20000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_20000000");
    }
    flags&=(~0x20000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_40000000, tvb, offset-4, 4, flags);
    if(flags&0x40000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_40000000");
    }
    flags&=(~0x40000000);

    proto_tree_add_boolean(tree, hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_80000000, tvb, offset-4, 4, flags);
    if(flags&0x80000000){
        proto_item_append_text(item, " DRSUAPI_SUPPORTED_EXTENSION_80000000");
    }
    flags&=(~0x80000000);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static int
drsuapi_dissect_DsBindInfo24_supported_extensions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_SupportedExtensions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo24_supported_extensions, param);
    return offset;
}


static int
drsuapi_dissect_GUID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uuid_t(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_DsBindInfo24_site_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo24_site_guid, param);
    return offset;
}


static int
drsuapi_dissect_uint32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_DsBindInfo24_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo24_u1, param);
    return offset;
}


int
drsuapi_dissect_DsBindInfo24(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsBindInfo24);
    }

    offset=drsuapi_dissect_DsBindInfo24_supported_extensions(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfo24_site_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfo24_u1(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsBindInfo28_supported_extensions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_SupportedExtensions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo28_supported_extensions, param);
    return offset;
}

static int
drsuapi_dissect_DsBindInfo28_site_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo28_site_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsBindInfo28_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo28_u1, param);
    return offset;
}

static int
drsuapi_dissect_DsBindInfo28_repl_epoch(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo28_repl_epoch, param);
    return offset;
}


int
drsuapi_dissect_DsBindInfo28(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsBindInfo28);
    }

    offset=drsuapi_dissect_DsBindInfo28_supported_extensions(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfo28_site_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfo28_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfo28_repl_epoch(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsBindInfo_24_info24(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsBindInfo24(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo_24_info24, param);
    return offset;
}

static int
drsuapi_dissect_union_DsBindInfo_28_info28(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsBindInfo28(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfo_28_info28, param);
    return offset;
}


static int
drsuapi_dissect_union_DsBindInfo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsBindInfo");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsBindInfo);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 24:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsBindInfo_24_info24(tvb, offset, pinfo, tree, drep);
        break;

    case 28:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsBindInfo_28_info28(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsBindInfoCtr_length(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfoCtr_length, param);
    return offset;
}

static int
drsuapi_dissect_DsBindInfoCtr_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsBindInfo(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBindInfoCtr_info, param);
    return offset;
}


int
drsuapi_dissect_DsBindInfoCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsBindInfoCtr);
    }

    offset=drsuapi_dissect_DsBindInfoCtr_length(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsBindInfoCtr_info(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsBind_bind_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBind_bind_guid, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsBind_bind_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsBind_bind_guid, NDR_POINTER_UNIQUE, "bind_guid", -1);
    return offset;
}

static int
drsuapi_dissect_DsBind_bind_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsBindInfoCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBind_bind_info, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsBind_bind_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsBind_bind_info, NDR_POINTER_UNIQUE, "bind_info", -1);
    return offset;
}


static e_ctx_hnd policy_hnd;
static proto_item *hnd_item;

static int
drsuapi_dissect_policy_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param)
{
    offset = dissect_nt_policy_hnd(tvb, offset, pinfo, tree, drep,
                   hf_index, &policy_hnd, &hnd_item,
                   param&0x01, param&0x02);
    return offset;
}

static int
drsuapi_dissect_DsBind_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsBind_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsBind_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsBind_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}


static int
drsuapi_dissect_DsBind_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_drsuapi_dissect_DsBind_bind_guid(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=unique_drsuapi_dissect_DsBind_bind_info(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsBind_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=unique_drsuapi_dissect_DsBind_bind_info(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=ref_drsuapi_dissect_DsBind_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static int
drsuapi_dissect_DsUnbind_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsUnbind_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsUnbind_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsUnbind_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}


static int
drsuapi_dissect_DsUnbind_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsUnbind_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsUnbind_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsUnbind_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static int
drsuapi_dissect_DsReplicaSyncRequest1Info_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1Info_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1Info_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1Info_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1Info_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1Info_guid1, param);
    return offset;
}


static int
drsuapi_dissect_uint8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint8(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1Info_byte_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1Info_byte_array, param);
    return offset;
}

static int
fixedarray_drsuapi_dissect_DsReplicaSyncRequest1Info_byte_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    int count=28;
    while(count--){
        offset=drsuapi_dissect_DsReplicaSyncRequest1Info_byte_array(tvb, offset, pinfo, tree, drep);
    }

    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1Info_str_len(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1Info_str_len, param);
    return offset;
}


#if 0
static int
drsuapi_dissect_uint16(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint16(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}
#endif


int
drsuapi_dissect_DsReplicaSyncRequest1Info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaSyncRequest1Info);
    }

    offset=drsuapi_dissect_DsReplicaSyncRequest1Info_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaSyncRequest1Info_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaSyncRequest1Info_guid1(tvb, offset, pinfo, tree, drep);

    offset=fixedarray_drsuapi_dissect_DsReplicaSyncRequest1Info_byte_array(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaSyncRequest1Info_str_len(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaSyncRequest1Info_nc_dn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static const true_false_string DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION is SET",
    "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_WRITEABLE_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_WRITEABLE is SET",
    "DRSUAPI_DS_REPLICA_SYNC_WRITEABLE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_PERIODIC_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_PERIODIC is SET",
    "DRSUAPI_DS_REPLICA_SYNC_PERIODIC is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING is SET",
    "DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES is SET",
    "DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_FULL_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_FULL is SET",
    "DRSUAPI_DS_REPLICA_SYNC_FULL is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_URGENT_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_URGENT is SET",
    "DRSUAPI_DS_REPLICA_SYNC_URGENT is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD is SET",
    "DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_FORCE_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_FORCE is SET",
    "DRSUAPI_DS_REPLICA_SYNC_FORCE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE is SET",
    "DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED is SET",
    "DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_TWO_WAY_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_TWO_WAY is SET",
    "DRSUAPI_DS_REPLICA_SYNC_TWO_WAY is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY is SET",
    "DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_INITIAL_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_INITIAL is SET",
    "DRSUAPI_DS_REPLICA_SYNC_INITIAL is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION is SET",
    "DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_ABANDONED_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_ABANDONED is SET",
    "DRSUAPI_DS_REPLICA_SYNC_ABANDONED is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS is SET",
    "DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET is SET",
    "DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_REQUEUE_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_REQUEUE is SET",
    "DRSUAPI_DS_REPLICA_SYNC_REQUEUE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION is SET",
    "DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA is SET",
    "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_CRITICAL_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_CRITICAL is SET",
    "DRSUAPI_DS_REPLICA_SYNC_CRITICAL is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS is SET",
    "DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_SYNC_PREEMPTED_tfs = {
    "DRSUAPI_DS_REPLICA_SYNC_PREEMPTED is SET",
    "DRSUAPI_DS_REPLICA_SYNC_PREEMPTED is NOT set"
};


int
drsuapi_dissect_DsReplicaSyncOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaSyncOptions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_WRITEABLE, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_WRITEABLE");
    }
    flags&=(~0x00000002);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PERIODIC, tvb, offset-4, 4, flags);
    if(flags&0x00000004){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_PERIODIC");
    }
    flags&=(~0x00000004);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING, tvb, offset-4, 4, flags);
    if(flags&0x00000008){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING");
    }
    flags&=(~0x00000008);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES, tvb, offset-4, 4, flags);
    if(flags&0x00000010){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES");
    }
    flags&=(~0x00000010);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL, tvb, offset-4, 4, flags);
    if(flags&0x00000020){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_FULL");
    }
    flags&=(~0x00000020);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_URGENT, tvb, offset-4, 4, flags);
    if(flags&0x00000040){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_URGENT");
    }
    flags&=(~0x00000040);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD, tvb, offset-4, 4, flags);
    if(flags&0x00000080){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD");
    }
    flags&=(~0x00000080);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FORCE, tvb, offset-4, 4, flags);
    if(flags&0x00000100){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_FORCE");
    }
    flags&=(~0x00000100);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE, tvb, offset-4, 4, flags);
    if(flags&0x00000200){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE");
    }
    flags&=(~0x00000200);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED, tvb, offset-4, 4, flags);
    if(flags&0x00000400){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED");
    }
    flags&=(~0x00000400);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_TWO_WAY, tvb, offset-4, 4, flags);
    if(flags&0x00000800){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_TWO_WAY");
    }
    flags&=(~0x00000800);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY, tvb, offset-4, 4, flags);
    if(flags&0x00001000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY");
    }
    flags&=(~0x00001000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL, tvb, offset-4, 4, flags);
    if(flags&0x00002000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_INITIAL");
    }
    flags&=(~0x00002000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION, tvb, offset-4, 4, flags);
    if(flags&0x00004000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION");
    }
    flags&=(~0x00004000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ABANDONED, tvb, offset-4, 4, flags);
    if(flags&0x00008000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_ABANDONED");
    }
    flags&=(~0x00008000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS, tvb, offset-4, 4, flags);
    if(flags&0x00010000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS");
    }
    flags&=(~0x00010000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET, tvb, offset-4, 4, flags);
    if(flags&0x00020000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET");
    }
    flags&=(~0x00020000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_REQUEUE, tvb, offset-4, 4, flags);
    if(flags&0x00040000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_REQUEUE");
    }
    flags&=(~0x00040000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION, tvb, offset-4, 4, flags);
    if(flags&0x00080000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION");
    }
    flags&=(~0x00080000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA, tvb, offset-4, 4, flags);
    if(flags&0x00100000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA");
    }
    flags&=(~0x00100000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_CRITICAL, tvb, offset-4, 4, flags);
    if(flags&0x00200000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_CRITICAL");
    }
    flags&=(~0x00200000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS, tvb, offset-4, 4, flags);
    if(flags&0x00400000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS");
    }
    flags&=(~0x00400000);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PREEMPTED, tvb, offset-4, 4, flags);
    if(flags&0x00800000){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_SYNC_PREEMPTED");
    }
    flags&=(~0x00800000);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static int
drsuapi_dissect_DsReplicaSyncRequest1_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1Info(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1_info, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsReplicaSyncRequest1_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaSyncRequest1_info, NDR_POINTER_REF, "info", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1_guid1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1_string1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_a_string(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1_string1, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaSyncRequest1_string1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaSyncRequest1_string1, NDR_POINTER_UNIQUE, "string1", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSyncRequest1_options(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest1_options, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaSyncRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaSyncRequest1);
    }

    offset=ref_drsuapi_dissect_DsReplicaSyncRequest1_info(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaSyncRequest1_guid1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaSyncRequest1_string1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaSyncRequest1_options(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}

static int
drsuapi_dissect_int32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaSyncRequest_1_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSyncRequest_1_req1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsReplicaSyncRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsReplicaSyncRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaSyncRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaSyncRequest_1_req1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaSync_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSync_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsReplicaSync_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaSync_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSync_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSync_level, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaSync_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsReplicaSyncRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaSync_req, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsReplicaSync_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaSync_req, NDR_POINTER_REF, "req", -1);
    return offset;
}


static int
drsuapi_dissect_DsReplicaSync_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsReplicaSync_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaSync_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=ref_drsuapi_dissect_DsReplicaSync_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsReplicaSync_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_uint64(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    
    ALIGN_TO_8_BYTES;
    offset=dissect_ndr_uint64(tvb, offset, pinfo, tree, drep, hf_index, NULL);

    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesUsnTriple_usn1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesUsnTriple_usn1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesUsnTriple_usn2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesUsnTriple_usn2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesUsnTriple_usn3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesUsnTriple_usn3, param);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesUsnTriple(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesUsnTriple);
    }

    offset=drsuapi_dissect_DsGetNCChangesUsnTriple_usn1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesUsnTriple_usn2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesUsnTriple_usn3(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor_source_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor_source_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor_highest_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor_highest_usn, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor);
    }

    offset=drsuapi_dissect_DsReplicaCoursor_source_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor_highest_usn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor05Ctr_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor05Ctr_u1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor05Ctr_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor05Ctr_u2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor05Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor05Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor05Ctr_u3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor05Ctr_u3, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor05Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor05Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaCoursor05Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursor05Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor05Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor05Ctr);
    }

    offset=drsuapi_dissect_DsReplicaCoursor05Ctr_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor05Ctr_u2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor05Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor05Ctr_u3(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaCoursor05Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesRequest5_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_guid1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_guid2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_guid2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1Info(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_sync_req_info1, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsGetNCChangesRequest5_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest5_sync_req_info1, NDR_POINTER_REF, "sync_req_info1", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_usn1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesUsnTriple(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_usn1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_coursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor05Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_coursor, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetNCChangesRequest5_coursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest5_coursor, NDR_POINTER_UNIQUE, "coursor", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_unknown3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_unknown3, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_unknown4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_unknown4, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest5_h1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest5_h1, param);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesRequest5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest5);
    }

    offset=drsuapi_dissect_DsGetNCChangesRequest5_guid1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_guid2(tvb, offset, pinfo, tree, drep);

    offset=ref_drsuapi_dissect_DsGetNCChangesRequest5_sync_req_info1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_usn1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetNCChangesRequest5_coursor(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_unknown3(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_unknown4(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest5_h1(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr14_length(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr14_length, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr14_byte_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array, NDR_POINTER_UNIQUE, "byte_array", -1);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesRequest_Ctr14(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest_Ctr14);
    }

    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr14_length(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr14_byte_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr13_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr13_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr13_data(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr14(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr13_data, param);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesRequest_Ctr13(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest_Ctr13);
    }

    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr13_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr13_data(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr12_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr12_count, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr13(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_Ctr12_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array, NDR_POINTER_UNIQUE, "array", -1);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesRequest_Ctr12(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest_Ctr12);
    }

    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr12_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsGetNCChangesRequest_Ctr12_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesRequest8_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_guid1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_guid2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_guid2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1Info(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_sync_req_info1, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsGetNCChangesRequest8_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest8_sync_req_info1, NDR_POINTER_REF, "sync_req_info1", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_usn1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesUsnTriple(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_usn1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_coursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor05Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_coursor, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetNCChangesRequest8_coursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesRequest8_coursor, NDR_POINTER_UNIQUE, "coursor", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unknown3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unknown3, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unknown4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unknown4, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_h1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_h1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unique_ptr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unique_ptr1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_unique_ptr2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_unique_ptr2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesRequest8_ctr12(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr12(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest8_ctr12, param);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesRequest8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest8);
    }

    offset=drsuapi_dissect_DsGetNCChangesRequest8_guid1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_guid2(tvb, offset, pinfo, tree, drep);

    offset=ref_drsuapi_dissect_DsGetNCChangesRequest8_sync_req_info1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_usn1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetNCChangesRequest8_coursor(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unknown3(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unknown4(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_h1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unique_ptr1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_unique_ptr2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesRequest8_ctr12(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsGetNCChangesRequest_5_req5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest5(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_5_req5, param);
    return offset;
}

static int
drsuapi_dissect_union_DsGetNCChangesRequest_8_req8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest8(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesRequest_8_req8, param);
    return offset;
}


static int
drsuapi_dissect_union_DsGetNCChangesRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsGetNCChangesRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 5:
        ALIGN_TO_8_BYTES;
        offset=drsuapi_dissect_union_DsGetNCChangesRequest_5_req5(tvb, offset, pinfo, tree, drep);
        break;

    case 8:
        ALIGN_TO_8_BYTES;
        offset=drsuapi_dissect_union_DsGetNCChangesRequest_8_req8(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaCoursorEx_coursor(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx_coursor, param);
    return offset;
}


static int
drsuapi_dissect_NTTIME_1sec(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    ALIGN_TO_8_BYTES;
    offset = dissect_ndr_nt_NTTIME(tvb, offset, pinfo, tree, drep, hf_index);

    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorEx_time1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME_1sec(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx_time1, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursorEx(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursorEx);
    }

    offset=drsuapi_dissect_DsReplicaCoursorEx_coursor(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursorEx_time1(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursorEx05Ctr_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx05Ctr_u1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorEx05Ctr_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx05Ctr_u2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorEx05Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx05Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorEx05Ctr_u3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx05Ctr_u3, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorEx05Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursorEx(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorEx05Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaCoursorEx05Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursorEx05Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursorEx05Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursorEx05Ctr);
    }

    offset=drsuapi_dissect_DsReplicaCoursorEx05Ctr_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursorEx05Ctr_u2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursorEx05Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursorEx05Ctr_u3(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaCoursorEx05Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetNCChangesCtr6_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_guid1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_guid2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_guid2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1Info(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_sync_req_info1, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetNCChangesCtr6_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesCtr6_sync_req_info1, NDR_POINTER_UNIQUE, "sync_req_info1", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_usn1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesUsnTriple(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_usn1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_usn2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesUsnTriple(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_usn2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_coursor_ex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursorEx05Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_coursor_ex, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetNCChangesCtr6_coursor_ex(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChangesCtr6_coursor_ex, NDR_POINTER_UNIQUE, "coursor_ex", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_ctr12(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesRequest_Ctr12(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_ctr12, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_u1, param);
    return offset;
}

static int
fixedarray_drsuapi_dissect_DsGetNCChangesCtr6_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    int count=3;
    while(count--){
        offset=drsuapi_dissect_DsGetNCChangesCtr6_u1(tvb, offset, pinfo, tree, drep);
    }

    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_ptr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_ptr1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_u2, param);
    return offset;
}

static int
fixedarray_drsuapi_dissect_DsGetNCChangesCtr6_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    int count=3;
    while(count--){
        offset=drsuapi_dissect_DsGetNCChangesCtr6_u2(tvb, offset, pinfo, tree, drep);
    }

    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_len1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_len1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_array_ptr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_array_ptr1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChangesCtr6_u3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr6_u3, param);
    return offset;
}


int
drsuapi_dissect_DsGetNCChangesCtr6(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesCtr6);
    }

    offset=drsuapi_dissect_DsGetNCChangesCtr6_guid1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_guid2(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetNCChangesCtr6_sync_req_info1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_usn1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_usn2(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetNCChangesCtr6_coursor_ex(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_ctr12(tvb, offset, pinfo, tree, drep);

    offset=fixedarray_drsuapi_dissect_DsGetNCChangesCtr6_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_ptr1(tvb, offset, pinfo, tree, drep);

    offset=fixedarray_drsuapi_dissect_DsGetNCChangesCtr6_u2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_len1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_array_ptr1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetNCChangesCtr6_u3(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}

int
drsuapi_dissect_DsGetNCChangesCtr7(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, guint8 *drep _U_, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesCtr7);
    }

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsGetNCChangesCtr_6_ctr6(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesCtr6(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr_6_ctr6, param);
    return offset;
}

static int
drsuapi_dissect_union_DsGetNCChangesCtr_7_ctr7(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetNCChangesCtr7(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChangesCtr_7_ctr7, param);
    return offset;
}


static int
drsuapi_dissect_union_DsGetNCChangesCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsGetNCChangesCtr");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetNCChangesCtr);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 6:
        ALIGN_TO_8_BYTES;
        offset=drsuapi_dissect_union_DsGetNCChangesCtr_6_ctr6(tvb, offset, pinfo, tree, drep);
        break;

    case 7:
        offset=drsuapi_dissect_union_DsGetNCChangesCtr_7_ctr7(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsGetNCChanges_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChanges_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsGetNCChanges_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetNCChanges_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChanges_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChanges_level, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChanges_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsGetNCChangesRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChanges_req, param);
    return offset;
}

static int
drsuapi_dissect_DsGetNCChanges_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsGetNCChangesCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetNCChanges_ctr, param);
    return offset;
}


static int
drsuapi_dissect_DsGetNCChanges_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsGetNCChanges_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetNCChanges_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetNCChanges_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsGetNCChanges_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=drsuapi_dissect_DsGetNCChanges_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetNCChanges_ctr(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static const true_false_string DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION_tfs = {
    "DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION is SET",
    "DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE_tfs = {
    "DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE is SET",
    "DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE_tfs = {
    "DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE is SET",
    "DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE_tfs = {
    "DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE is SET",
    "DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_UPDATE_0x00000010_tfs = {
    "DRSUAPI_DS_REPLICA_UPDATE_0x00000010 is SET",
    "DRSUAPI_DS_REPLICA_UPDATE_0x00000010 is NOT set"
};


int
drsuapi_dissect_DsReplicaUpdateRefsOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaUpdateRefsOptions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE");
    }
    flags&=(~0x00000002);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE, tvb, offset-4, 4, flags);
    if(flags&0x00000004){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE");
    }
    flags&=(~0x00000004);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE, tvb, offset-4, 4, flags);
    if(flags&0x00000008){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE");
    }
    flags&=(~0x00000008);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_0x00000010, tvb, offset-4, 4, flags);
    if(flags&0x00000010){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_UPDATE_0x00000010");
    }
    flags&=(~0x00000010);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}
static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_dest_dsa_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_options(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaUpdateRefsOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_options, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_sync_req_info1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncRequest1Info(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_sync_req_info1, param);
    return offset;
}


static int
drsuapi_dissect_ascstr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_cvstring(tvb, offset, pinfo, tree, drep, 1, hf_index, FALSE, NULL);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefsRequest1_dest_dsa_dns_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_ascstr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_dns_name, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaUpdateRefsRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaUpdateRefsRequest1);
    }

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_dest_dsa_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_options(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_sync_req_info1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1_dest_dsa_dns_name(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsReplicaUpdateRefsRequest_1_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaUpdateRefsRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefsRequest_1_req1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsReplicaUpdateRefsRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsReplicaUpdateRefsRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaUpdateRefsRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaUpdateRefsRequest_1_req1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaUpdateRefs_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefs_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsReplicaUpdateRefs_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaUpdateRefs_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefs_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefs_level, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefs_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsReplicaUpdateRefsRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaUpdateRefs_req, param);
    return offset;
}


static int
drsuapi_dissect_DsReplicaUpdateRefs_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsReplicaUpdateRefs_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaUpdateRefs_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaUpdateRefs_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsReplicaUpdateRefs_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static const true_false_string DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION_tfs = {
    "DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION is SET",
    "DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_ADD_WRITEABLE_tfs = {
    "DRSUAPI_DS_REPLICA_ADD_WRITEABLE is SET",
    "DRSUAPI_DS_REPLICA_ADD_WRITEABLE is NOT set"
};


int
drsuapi_dissect_DsReplicaAddOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaAddOptions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_WRITEABLE, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_ADD_WRITEABLE");
    }
    flags&=(~0x00000002);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_ADD_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_ADD_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static const true_false_string DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION_tfs = {
    "DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION is SET",
    "DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_DELETE_WRITEABLE_tfs = {
    "DRSUAPI_DS_REPLICA_DELETE_WRITEABLE is SET",
    "DRSUAPI_DS_REPLICA_DELETE_WRITEABLE is NOT set"
};


int
drsuapi_dissect_DsReplicaDeleteOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaDeleteOptions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_WRITEABLE, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_DELETE_WRITEABLE");
    }
    flags&=(~0x00000002);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_DEL_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_DEL_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static const true_false_string DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION_tfs = {
    "DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION is SET",
    "DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION is NOT set"
};

static const true_false_string DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE_tfs = {
    "DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE is SET",
    "DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE is NOT set"
};


int
drsuapi_dissect_DsReplicaModifyOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    guint32 flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaModifyOptions);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
        proto_item_append_text(item, " DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE");
    }
    flags&=(~0x00000002);

    if(flags){
        proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_MODIFY_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_MODIFY_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_VERIFY_NAMES_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_VERIFY_NAMES_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_INTER_DOMAIN_MOVE_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_INTER_DOMAIN_MOVE_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_NT4_CHANGELOG_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_NT4_CHANGELOG_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

const value_string drsuapi_DsNameStatus_vals[] = {
    { 0	, "DRSUAPI_DS_NAME_STATUS_OK" },
    { 1	, "DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR" },
    { 2	, "DRSUAPI_DS_NAME_STATUS_NOT_FOUND" },
    { 3	, "DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE" },
    { 4	, "DRSUAPI_DS_NAME_STATUS_NO_MAPPING" },
    { 5	, "DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY" },
    { 6	, "DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING" },
    { 7	, "DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsNameStatus(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}


const value_string drsuapi_DsNameFlags_vals[] = {
    { 0	, "DRSUAPI_DS_NAME_FLAG_NO_FLAGS" },
    { 0	, "DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY" },
    { 0	, "DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC" },
    { 0	, "DRSUAPI_DS_NAME_FLAG_GCVERIFY" },
    { 0	, "DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsNameFlags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}


const value_string drsuapi_DsNameFormat_vals[] = {
    { 0	, "DRSUAPI_DS_NAME_FORMAT_UKNOWN" },
    { 1	, "DRSUAPI_DS_NAME_FORMAT_FQDN_1779" },
    { 2	, "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT" },
    { 3	, "DRSUAPI_DS_NAME_FORMAT_DISPLAY" },
    { 6	, "DRSUAPI_DS_NAME_FORMAT_GUID" },
    { 7	, "DRSUAPI_DS_NAME_FORMAT_CANONICAL" },
    { 8	, "DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL" },
    { 9	, "DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX" },
    { 10	, "DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL" },
    { 11	, "DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY" },
    { 12	, "DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsNameFormat(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}


static int
drsuapi_dissect_unistr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_cvstring(tvb, offset, pinfo, tree, drep, 2, hf_index, FALSE, NULL);
    return offset;
}

static int
drsuapi_dissect_DsNameString_str(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameString_str, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsNameString_str(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsNameString_str, NDR_POINTER_UNIQUE, "str", -1);
    return offset;
}


int
drsuapi_dissect_DsNameString(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameString);
    }

    offset=unique_drsuapi_dissect_DsNameString_str(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsNameRequest1_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_format_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameFlags(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_format_flags, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_format_offered(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameFormat(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_format_offered, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_format_desired(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameFormat(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_format_desired, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_count, param);
    return offset;
}

static int
drsuapi_dissect_DsNameRequest1_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameString(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest1_names, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsNameRequest1_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsNameRequest1_names);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsNameRequest1_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsNameRequest1_names, NDR_POINTER_UNIQUE, "names", -1);
    return offset;
}


int
drsuapi_dissect_DsNameRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameRequest1);
    }

    offset=drsuapi_dissect_DsNameRequest1_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsNameRequest1_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsNameRequest1_format_flags(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsNameRequest1_format_offered(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsNameRequest1_format_desired(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsNameRequest1_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsNameRequest1_names(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsNameRequest_1_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameRequest_1_req1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsNameRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsNameRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsNameRequest_1_req1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsNameInfo1_status(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameStatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameInfo1_status, param);
    return offset;
}

static int
drsuapi_dissect_DsNameInfo1_dns_domain_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameInfo1_dns_domain_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsNameInfo1_dns_domain_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsNameInfo1_dns_domain_name, NDR_POINTER_UNIQUE, "dns_domain_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsNameInfo1_result_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameInfo1_result_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsNameInfo1_result_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsNameInfo1_result_name, NDR_POINTER_UNIQUE, "result_name", -1);
    return offset;
}


int
drsuapi_dissect_DsNameInfo1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameInfo1);
    }

    offset=drsuapi_dissect_DsNameInfo1_status(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsNameInfo1_dns_domain_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsNameInfo1_result_name(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsNameCtr1_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameCtr1_count, param);
    return offset;
}

static int
drsuapi_dissect_DsNameCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameInfo1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameCtr1_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsNameCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsNameCtr1_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsNameCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsNameCtr1_array, NDR_POINTER_UNIQUE, "array", -1);
    return offset;
}


int
drsuapi_dissect_DsNameCtr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameCtr1);
    }

    offset=drsuapi_dissect_DsNameCtr1_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsNameCtr1_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsNameCtr_1_ctr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameCtr1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsNameCtr_1_ctr1, param);
    return offset;
}

static int
drsuapi_dissect_union_DsNameCtr_1_ctr1_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsNameCtr_1_ctr1, NDR_POINTER_UNIQUE, "ctr1", -1);
    return offset;
}


static int
drsuapi_dissect_union_DsNameCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsNameCtr");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsNameCtr);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsNameCtr_1_ctr1_unique(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsCrackNames_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsCrackNames_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsCrackNames_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsCrackNames_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsCrackNames_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsCrackNames_level, param);
    return offset;
}

static int
drsuapi_dissect_DsCrackNames_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsNameRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsCrackNames_req, param);
    return offset;
}

static int
drsuapi_dissect_DsCrackNames_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsNameCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsCrackNames_ctr, param);
    return offset;
}


static int
drsuapi_dissect_DsCrackNames_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsCrackNames_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsCrackNames_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsCrackNames_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsCrackNames_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=drsuapi_dissect_DsCrackNames_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsCrackNames_ctr(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

const value_string drsuapi_DsSpnOperation_vals[] = {
    { 0	, "DRSUAPI_DS_SPN_OPERATION_ADD" },
    { 1	, "DRSUAPI_DS_SPN_OPERATION_REPLACE" },
    { 2	, "DRSUAPI_DS_SPN_OPERATION_DELETE" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsSpnOperation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnRequest1_operation(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsSpnOperation(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest1_operation, param);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnRequest1_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest1_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnRequest1_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest1_object_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsWriteAccountSpnRequest1_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsWriteAccountSpnRequest1_object_dn, NDR_POINTER_UNIQUE, "object_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnRequest1_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest1_count, param);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsNameString(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest1_spn_names, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names, NDR_POINTER_UNIQUE, "spn_names", -1);
    return offset;
}


int
drsuapi_dissect_DsWriteAccountSpnRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsWriteAccountSpnRequest1);
    }

    offset=drsuapi_dissect_DsWriteAccountSpnRequest1_operation(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsWriteAccountSpnRequest1_unknown1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsWriteAccountSpnRequest1_object_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsWriteAccountSpnRequest1_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsWriteAccountSpnRequest1_spn_names(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsWriteAccountSpnRequest_1_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsWriteAccountSpnRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnRequest_1_req1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsWriteAccountSpnRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsWriteAccountSpnRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsWriteAccountSpnRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsWriteAccountSpnRequest_1_req1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}

static int
drsuapi_dissect_WERROR(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);

    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpnResult1_status(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_WERROR(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnResult1_status, param);
    return offset;
}


int
drsuapi_dissect_DsWriteAccountSpnResult1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsWriteAccountSpnResult1);
    }

    offset=drsuapi_dissect_DsWriteAccountSpnResult1_status(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsWriteAccountSpnResult_1_res1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsWriteAccountSpnResult1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpnResult_1_res1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsWriteAccountSpnResult(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsWriteAccountSpnResult");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsWriteAccountSpnResult);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsWriteAccountSpnResult_1_res1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsWriteAccountSpn_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpn_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsWriteAccountSpn_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsWriteAccountSpn_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpn_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpn_level, param);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpn_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsWriteAccountSpnRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpn_req, param);
    return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpn_res(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsWriteAccountSpnResult(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsWriteAccountSpn_res, param);
    return offset;
}


static int
drsuapi_dissect_DsWriteAccountSpn_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsWriteAccountSpn_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsWriteAccountSpn_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsWriteAccountSpn_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsWriteAccountSpn_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=drsuapi_dissect_DsWriteAccountSpn_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsWriteAccountSpn_res(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REMOVE_DS_SERVER_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REMOVE_DS_SERVER_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REMOVE_DS_DOMAIN_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REMOVE_DS_DOMAIN_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
static int
drsuapi_dissect_DsGetDCInfoRequest1_domain_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoRequest1_domain_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfoRequest1_domain_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfoRequest1_domain_name, NDR_POINTER_UNIQUE, "domain_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfoRequest1_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoRequest1_level, param);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfoRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoRequest1);
    }

    offset=unique_drsuapi_dissect_DsGetDCInfoRequest1_domain_name(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfoRequest1_level(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsGetDCInfoRequest_1_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfoRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoRequest_1_req1, param);
    return offset;
}


static int
drsuapi_dissect_union_DsGetDCInfoRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsGetDCInfoRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case 1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsGetDCInfoRequest_1_req1(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsGetDCInfo1_netbios_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_netbios_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo1_netbios_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo1_netbios_name, NDR_POINTER_UNIQUE, "netbios_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_dns_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_dns_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo1_dns_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo1_dns_name, NDR_POINTER_UNIQUE, "dns_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_site_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_site_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo1_site_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo1_site_name, NDR_POINTER_UNIQUE, "site_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_computer_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_computer_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo1_computer_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo1_computer_dn, NDR_POINTER_UNIQUE, "computer_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_server_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_server_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo1_server_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo1_server_dn, NDR_POINTER_UNIQUE, "server_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_is_pdc(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_is_pdc, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo1_is_enabled(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo1_is_enabled, param);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfo1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfo1);
    }

    offset=unique_drsuapi_dissect_DsGetDCInfo1_netbios_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo1_dns_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo1_site_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo1_computer_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo1_server_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo1_is_pdc(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo1_is_enabled(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetDCInfoCtr1_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr1_count, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfoCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfo1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr1_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsGetDCInfoCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfoCtr1_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr1_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsGetDCInfoCtr1_array, NDR_POINTER_UNIQUE, "array", -1);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfoCtr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoCtr1);
    }

    offset=drsuapi_dissect_DsGetDCInfoCtr1_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr1_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetDCInfo2_netbios_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_netbios_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_netbios_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_netbios_name, NDR_POINTER_UNIQUE, "netbios_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_dns_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_dns_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_dns_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_dns_name, NDR_POINTER_UNIQUE, "dns_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_site_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_site_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_site_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_site_name, NDR_POINTER_UNIQUE, "site_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_site_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_site_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_site_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_site_dn, NDR_POINTER_UNIQUE, "site_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_computer_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_computer_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_computer_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_computer_dn, NDR_POINTER_UNIQUE, "computer_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_server_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_server_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_server_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_server_dn, NDR_POINTER_UNIQUE, "server_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_ntds_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_ntds_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo2_ntds_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo2_ntds_dn, NDR_POINTER_UNIQUE, "ntds_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_is_pdc(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_is_pdc, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_is_enabled(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_is_enabled, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_is_gc(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_is_gc, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_site_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_site_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_computer_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_computer_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_server_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_server_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo2_ntds_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo2_ntds_guid, param);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfo2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfo2);
    }

    offset=unique_drsuapi_dissect_DsGetDCInfo2_netbios_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_dns_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_site_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_site_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_computer_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_server_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo2_ntds_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_is_pdc(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_is_enabled(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_is_gc(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_site_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_computer_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_server_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo2_ntds_guid(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetDCInfoCtr2_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr2_count, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfoCtr2_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfo2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr2_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsGetDCInfoCtr2_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfoCtr2_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr2_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsGetDCInfoCtr2_array, NDR_POINTER_UNIQUE, "array", -1);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfoCtr2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoCtr2);
    }

    offset=drsuapi_dissect_DsGetDCInfoCtr2_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr2_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetDCInfo01_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown2, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_unknown3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown3, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_unknown4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown4, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_unknown5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown5, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_unknown6(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_unknown6, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfo01_server_nt4_account(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfo01_server_nt4_account, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsGetDCInfo01_server_nt4_account(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfo01_server_nt4_account, NDR_POINTER_UNIQUE, "server_nt4_account", -1);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfo01(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfo01);
    }

    offset=drsuapi_dissect_DsGetDCInfo01_unknown1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo01_unknown2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo01_unknown3(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo01_unknown4(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo01_unknown5(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsGetDCInfo01_unknown6(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsGetDCInfo01_server_nt4_account(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsGetDCInfoCtr01_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr01_count, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDCInfoCtr01_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfo01(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr01_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsGetDCInfoCtr01_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDCInfoCtr01_array);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr01_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsGetDCInfoCtr01_array, NDR_POINTER_UNIQUE, "array", -1);
    return offset;
}


int
drsuapi_dissect_DsGetDCInfoCtr01(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoCtr01);
    }

    offset=drsuapi_dissect_DsGetDCInfoCtr01_count(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsGetDCInfoCtr01_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}

const value_string drsuapi_DsGetDCInfoCtrLevels_vals[] = {
    { 1	, "DRSUAPI_DC_INFO_CTR_1" },
    { 2	, "DRSUAPI_DC_INFO_CTR_2" },
    { -1	, "DRSUAPI_DC_INFO_CTR_01" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsGetDCInfoCtrLevels(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_1_ctr1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfoCtr1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_1_ctr1, param);
    return offset;
}

static int
drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_2_ctr2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfoCtr2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_2_ctr2, param);
    return offset;
}

static int
drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_01_ctr01(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsGetDCInfoCtr01(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_01_ctr01, param);
    return offset;
}


static int
drsuapi_dissect_union_DsGetDCInfoCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsGetDCInfoCtr");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsGetDCInfoCtr);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case DRSUAPI_DC_INFO_CTR_1:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_1_ctr1(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DC_INFO_CTR_2:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_2_ctr2(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DC_INFO_CTR_01:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_01_ctr01(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsGetDomainControllerInfo_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDomainControllerInfo_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsGetDomainControllerInfo_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsGetDomainControllerInfo_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsGetDomainControllerInfo_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDomainControllerInfo_level, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDomainControllerInfo_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsGetDCInfoRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDomainControllerInfo_req, param);
    return offset;
}

static int
drsuapi_dissect_DsGetDomainControllerInfo_ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsGetDCInfoCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsGetDomainControllerInfo_ctr, param);
    return offset;
}


static int
drsuapi_dissect_DsGetDomainControllerInfo_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsGetDomainControllerInfo_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetDomainControllerInfo_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetDomainControllerInfo_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsGetDomainControllerInfo_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=drsuapi_dissect_DsGetDomainControllerInfo_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsGetDomainControllerInfo_ctr(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DsAddEntry_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DsAddEntry_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_EXECUTE_KCC_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_EXECUTE_KCC_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

const value_string drsuapi_DsReplicaGetInfoLevel_vals[] = {
    { 1	, "DRSUAPI_DS_REPLICA_GET_INFO" },
    { 2	, "DRSUAPI_DS_REPLICA_GET_INFO2" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsReplicaGetInfoLevel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}


const value_string drsuapi_DsReplicaInfoType_vals[] = {
    { 0	, "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS" },
    { 1	, "DRSUAPI_DS_REPLICA_INFO_CURSORS" },
    { 2	, "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA" },
    { 3	, "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES" },
    { 4	, "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES" },
    { 5	, "DRSUAPI_DS_REPLICA_INFO_PENDING_OPS" },
    { 6	, "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA" },
    { 7	, "DRSUAPI_DS_REPLICA_INFO_CURSORS2" },
    { 8	, "DRSUAPI_DS_REPLICA_INFO_CURSORS3" },
    { 9	, "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2" },
    { 10	, "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2" },
    { -2	, "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02" },
    { -4	, "DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04" },
    { -5	, "DRSUAPI_DS_REPLICA_INFO_CURSURS05" },
    { -6	, "DRSUAPI_DS_REPLICA_INFO_06" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsReplicaInfoType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest1_info_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaInfoType(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest1_info_type, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest1_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest1_object_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaGetInfoRequest1_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaGetInfoRequest1_object_dn, NDR_POINTER_UNIQUE, "object_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest1_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest1_guid1, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaGetInfoRequest1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaGetInfoRequest1);
    }

    offset=drsuapi_dissect_DsReplicaGetInfoRequest1_info_type(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaGetInfoRequest1_object_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaGetInfoRequest1_guid1(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaGetInfoRequest2_info_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaInfoType(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_info_type, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_object_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaGetInfoRequest2_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaGetInfoRequest2_object_dn, NDR_POINTER_UNIQUE, "object_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_guid1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_guid1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_unknown1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_unknown1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_string1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_string1, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaGetInfoRequest2_string1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaGetInfoRequest2_string1, NDR_POINTER_UNIQUE, "string1", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_string2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_string2, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaGetInfoRequest2_string2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaGetInfoRequest2_string2, NDR_POINTER_UNIQUE, "string2", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfoRequest2_unknown2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest2_unknown2, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaGetInfoRequest2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaGetInfoRequest2);
    }

    offset=drsuapi_dissect_DsReplicaGetInfoRequest2_info_type(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaGetInfoRequest2_object_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaGetInfoRequest2_guid1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaGetInfoRequest2_unknown1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaGetInfoRequest2_string1(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaGetInfoRequest2_string2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaGetInfoRequest2_unknown2(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO_req1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaGetInfoRequest1(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO_req1, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO2_req2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaGetInfoRequest2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO2_req2, param);
    return offset;
}


static int
drsuapi_dissect_union_DsReplicaGetInfoRequest(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsReplicaGetInfoRequest");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaGetInfoRequest);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case DRSUAPI_DS_REPLICA_GET_INFO:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO_req1(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_GET_INFO2:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO2_req2(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaNeighbour_naming_context_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_naming_context_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaNeighbour_naming_context_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaNeighbour_naming_context_dn, NDR_POINTER_UNIQUE, "naming_context_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_dn, NDR_POINTER_UNIQUE, "source_dsa_obj_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_source_dsa_address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_source_dsa_address, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaNeighbour_source_dsa_address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaNeighbour_source_dsa_address, NDR_POINTER_UNIQUE, "source_dsa_address", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_transport_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_transport_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaNeighbour_transport_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaNeighbour_transport_obj_dn, NDR_POINTER_UNIQUE, "transport_obj_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_replica_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_replica_flags, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_naming_context_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_naming_context_obj_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_source_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_source_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_transport_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_transport_obj_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_tmp_highest_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_tmp_highest_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_highest_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_highest_usn, param);
    return offset;
}


static int
drsuapi_dissect_NTTIME(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset = dissect_ndr_nt_NTTIME(tvb, offset, pinfo, tree, drep, hf_index);

    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_last_success(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_last_success, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_last_attempt(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_last_attempt, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_result_last_attempt(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_WERROR(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_result_last_attempt, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbour_consecutive_sync_failures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbour_consecutive_sync_failures, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaNeighbour(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaNeighbour);
    }

    offset=unique_drsuapi_dissect_DsReplicaNeighbour_naming_context_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaNeighbour_source_dsa_address(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaNeighbour_transport_obj_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_replica_flags(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_reserved(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_naming_context_obj_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_source_dsa_obj_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_source_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_transport_obj_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_tmp_highest_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_highest_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_last_success(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_last_attempt(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_result_last_attempt(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbour_consecutive_sync_failures(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaNeighbourCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbourCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbourCtr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbourCtr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaNeighbourCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaNeighbour(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaNeighbourCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaNeighbourCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaNeighbourCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaNeighbourCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaNeighbourCtr);
    }

    offset=drsuapi_dissect_DsReplicaNeighbourCtr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaNeighbourCtr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaNeighbourCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursorCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorCtr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorCtr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursorCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursorCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaCoursorCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursorCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursorCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursorCtr);
    }

    offset=drsuapi_dissect_DsReplicaCoursorCtr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursorCtr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaCoursorCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaObjMetaData_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_attribute_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaObjMetaData_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaObjMetaData_attribute_name, NDR_POINTER_UNIQUE, "attribute_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData_version(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_version, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData_originating_last_changed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_originating_last_changed, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData_originating_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_originating_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData_originating_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_originating_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData_local_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData_local_usn, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaObjMetaData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaObjMetaData);
    }

    offset=unique_drsuapi_dissect_DsReplicaObjMetaData_attribute_name(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData_version(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData_originating_last_changed(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData_originating_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData_originating_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData_local_usn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaObjMetaDataCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaDataCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaDataCtr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaDataCtr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaDataCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaObjMetaData(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaDataCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaObjMetaDataCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaObjMetaDataCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaObjMetaDataCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaObjMetaDataCtr);
    }

    offset=drsuapi_dissect_DsReplicaObjMetaDataCtr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaDataCtr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaObjMetaDataCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_dn, NDR_POINTER_UNIQUE, "dsa_obj_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailure_first_failure(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailure_first_failure, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailure_num_failures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailure_num_failures, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailure_last_result(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_WERROR(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailure_last_result, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaKccDsaFailure(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaKccDsaFailure);
    }

    offset=unique_drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaKccDsaFailure_dsa_obj_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaKccDsaFailure_first_failure(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaKccDsaFailure_num_failures(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaKccDsaFailure_last_result(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaKccDsaFailuresCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailuresCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailuresCtr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailuresCtr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaKccDsaFailuresCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaKccDsaFailure(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaKccDsaFailuresCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaKccDsaFailuresCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaKccDsaFailuresCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaKccDsaFailuresCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaKccDsaFailuresCtr);
    }

    offset=drsuapi_dissect_DsReplicaKccDsaFailuresCtr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaKccDsaFailuresCtr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaKccDsaFailuresCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}

const value_string drsuapi_DsReplicaOpType_vals[] = {
    { 0	, "DRSUAPI_DS_REPLICA_OP_TYPE_SYNC" },
    { 1	, "DRSUAPI_DS_REPLICA_OP_TYPE_ADD" },
    { 2	, "DRSUAPI_DS_REPLICA_OP_TYPE_DELETE" },
    { 3	, "DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY" },
    { 4	, "DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS" },
    { 0	, NULL }
};

int
drsuapi_dissect_DsReplicaOpType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    offset=dissect_ndr_uint16(tvb, offset, pinfo, tree, drep, hf_index, NULL);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_SYNC_sync(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaSyncOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_SYNC_sync, param);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_ADD_add(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaAddOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_ADD_add, param);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_DELETE_delete(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaDeleteOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_DELETE_delete, param);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY_modify(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaModifyOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY_modify, param);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS_update_refs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaUpdateRefsOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS_update_refs, param);
    return offset;
}

static int
drsuapi_dissect_union_DsRplicaOpOptions_default_unknown(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsRplicaOpOptions_default_unknown, param);
    return offset;
}


static int
drsuapi_dissect_union_DsRplicaOpOptions(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint16 level;

    ALIGN_TO_2_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsRplicaOpOptions");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsRplicaOpOptions);
    }

    offset=dissect_ndr_uint16(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_SYNC_sync(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_OP_TYPE_ADD:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_ADD_add(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_DELETE_delete(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY_modify(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS_update_refs(tvb, offset, pinfo, tree, drep);
        break;

    default:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsRplicaOpOptions_default_unknown(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaOp_operation_start(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_operation_start, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_serial_num(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_serial_num, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_priority(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_priority, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_operation_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaOpType(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_operation_type, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_options(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsRplicaOpOptions(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_options, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_nc_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_nc_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaOp_nc_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaOp_nc_dn, NDR_POINTER_UNIQUE, "nc_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_remote_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_remote_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaOp_remote_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaOp_remote_dsa_obj_dn, NDR_POINTER_UNIQUE, "remote_dsa_obj_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_remote_dsa_address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_remote_dsa_address, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaOp_remote_dsa_address(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaOp_remote_dsa_address, NDR_POINTER_UNIQUE, "remote_dsa_address", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_nc_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_nc_obj_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOp_remote_dsa_obj_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOp_remote_dsa_obj_guid, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaOp(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaOp);
    }

    offset=drsuapi_dissect_DsReplicaOp_operation_start(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_serial_num(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_priority(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_operation_type(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_options(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaOp_nc_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaOp_remote_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaOp_remote_dsa_address(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_nc_obj_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOp_remote_dsa_obj_guid(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaOpCtr_time(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOpCtr_time, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOpCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOpCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaOpCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaOp(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaOpCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaOpCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaOpCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaOpCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaOpCtr);
    }

    offset=drsuapi_dissect_DsReplicaOpCtr_time(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaOpCtr_count(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaOpCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaAttrValMetaData_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_attribute_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaAttrValMetaData_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData_attribute_name, NDR_POINTER_UNIQUE, "attribute_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_object_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaAttrValMetaData_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData_object_dn, NDR_POINTER_UNIQUE, "object_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_value_length(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_value_length, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_value, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaAttrValMetaData_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData_value);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsReplicaAttrValMetaData_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsReplicaAttrValMetaData_value, NDR_POINTER_UNIQUE, "value", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_deleted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_deleted, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_created(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_created, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_version(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_version, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_originating_last_changed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_originating_last_changed, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_originating_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_originating_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_originating_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_originating_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData_local_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData_local_usn, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaAttrValMetaData(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaAttrValMetaData);
    }

    offset=unique_drsuapi_dissect_DsReplicaAttrValMetaData_attribute_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaAttrValMetaData_object_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_value_length(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsReplicaAttrValMetaData_value(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_deleted(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_created(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_version(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_originating_last_changed(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_originating_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_originating_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData_local_usn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaAttrValMetaDataCtr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaDataCtr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaDataCtr_enumeration_context(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaDataCtr_enumeration_context, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaDataCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaAttrValMetaData(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaDataCtr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaAttrValMetaDataCtr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaDataCtr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaAttrValMetaDataCtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaAttrValMetaDataCtr);
    }

    offset=drsuapi_dissect_DsReplicaAttrValMetaDataCtr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaDataCtr_enumeration_context(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaAttrValMetaDataCtr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor2_source_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2_source_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor2_highest_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2_highest_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor2_last_sync_success(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2_last_sync_success, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor2);
    }

    offset=drsuapi_dissect_DsReplicaCoursor2_source_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor2_highest_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor2_last_sync_success(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor2Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor2Ctr_enumeration_context(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2Ctr_enumeration_context, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor2Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaCoursor2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursor2Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor2Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor2Ctr);
    }

    offset=drsuapi_dissect_DsReplicaCoursor2Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor2Ctr_enumeration_context(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaCoursor2Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor3_source_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3_source_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor3_highest_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3_highest_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor3_last_sync_success(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3_last_sync_success, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor3_source_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3_source_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaCoursor3_source_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursor3_source_dsa_obj_dn, NDR_POINTER_UNIQUE, "source_dsa_obj_dn", -1);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor3);
    }

    offset=drsuapi_dissect_DsReplicaCoursor3_source_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor3_highest_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor3_last_sync_success(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaCoursor3_source_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaCoursor3Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor3Ctr_enumeration_context(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3Ctr_enumeration_context, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaCoursor3Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor3(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaCoursor3Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaCoursor3Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaCoursor3Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaCoursor3Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaCoursor3Ctr);
    }

    offset=drsuapi_dissect_DsReplicaCoursor3Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaCoursor3Ctr_enumeration_context(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaCoursor3Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaObjMetaData2_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_attribute_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaObjMetaData2_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaObjMetaData2_attribute_name, NDR_POINTER_UNIQUE, "attribute_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_version(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_version, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_originating_last_changed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_originating_last_changed, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_originating_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_originating_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_local_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_local_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_obj_dn, NDR_POINTER_UNIQUE, "originating_dsa_obj_dn", -1);
    return offset;
}


int
drsuapi_dissect_DsReplicaObjMetaData2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaObjMetaData2);
    }

    offset=unique_drsuapi_dissect_DsReplicaObjMetaData2_attribute_name(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2_version(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2_originating_last_changed(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2_originating_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2_local_usn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaObjMetaData2_originating_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaObjMetaData2Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2Ctr_enumeration_context(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2Ctr_enumeration_context, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaObjMetaData2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaObjMetaData2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaObjMetaData2Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaObjMetaData2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaObjMetaData2Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaObjMetaData2Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaObjMetaData2Ctr);
    }

    offset=drsuapi_dissect_DsReplicaObjMetaData2Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaObjMetaData2Ctr_enumeration_context(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaObjMetaData2Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaAttrValMetaData2_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_attribute_name, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaAttrValMetaData2_attribute_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData2_attribute_name, NDR_POINTER_UNIQUE, "attribute_name", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_object_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaAttrValMetaData2_object_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData2_object_dn, NDR_POINTER_UNIQUE, "object_dn", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_value_length(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_value_length, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint8(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_value, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData2_value);
    return offset;
}

static int
unique_ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2_value(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2_value, NDR_POINTER_UNIQUE, "value", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_deleted(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_deleted, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_created(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_created, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_version(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_version, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_originating_last_changed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_originating_last_changed, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_invocation_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_invocation_id, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_originating_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_originating_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_local_usn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_local_usn, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_obj_dn, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_obj_dn(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_obj_dn, NDR_POINTER_UNIQUE, "originating_dsa_obj_dn", -1);
    return offset;
}


int
drsuapi_dissect_DsReplicaAttrValMetaData2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaAttrValMetaData2);
    }

    offset=unique_drsuapi_dissect_DsReplicaAttrValMetaData2_attribute_name(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaAttrValMetaData2_object_dn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_value_length(tvb, offset, pinfo, tree, drep);

    offset=unique_ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2_value(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_deleted(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_created(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_version(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_originating_last_changed(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_invocation_id(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_originating_usn(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2_local_usn(tvb, offset, pinfo, tree, drep);

    offset=unique_drsuapi_dissect_DsReplicaAttrValMetaData2_originating_dsa_obj_dn(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_enumeration_context(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_int32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2Ctr_enumeration_context, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaAttrValMetaData2(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaAttrValMetaData2Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaAttrValMetaData2Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaAttrValMetaData2Ctr);
    }

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_enumeration_context(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaAttrValMetaData2Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaConnection04_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_u1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_u2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_u3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_u3, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_bind_guid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_GUID(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_bind_guid, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_bind_time(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_NTTIME_1sec(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_bind_time, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_u4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_u4, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04_u5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04_u5, param);
    return offset;
}


int
drsuapi_dissect_DsReplicaConnection04(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaConnection04);
    }

    offset=drsuapi_dissect_DsReplicaConnection04_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_u2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_u3(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_bind_guid(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_bind_time(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_u4(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04_u5(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplicaConnection04Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04Ctr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04Ctr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaConnection04Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaConnection04(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaConnection04Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplicaConnection04Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaConnection04Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplicaConnection04Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaConnection04Ctr);
    }

    offset=drsuapi_dissect_DsReplicaConnection04Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplicaConnection04Ctr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplicaConnection04Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplica06_str1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_unistr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_str1, param);
    return offset;
}

static int
unique_drsuapi_dissect_DsReplica06_str1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplica06_str1, NDR_POINTER_UNIQUE, "str1", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u1, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u2, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u3, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u4, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u5, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u6(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint64(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u6, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06_u7(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06_u7, param);
    return offset;
}


int
drsuapi_dissect_DsReplica06(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplica06);
    }

    offset=unique_drsuapi_dissect_DsReplica06_str1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u1(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u2(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u3(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u4(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u5(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u6(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06_u7(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_DsReplica06Ctr_count(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06Ctr_count, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06Ctr_reserved(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_uint32(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06Ctr_reserved, param);
    return offset;
}

static int
drsuapi_dissect_DsReplica06Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplica06(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplica06Ctr_array, param);
    return offset;
}

static int
ucarray_drsuapi_dissect_DsReplica06Ctr_array(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplica06Ctr_array);
    return offset;
}


int
drsuapi_dissect_DsReplica06Ctr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_8_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, TRUE);
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplica06Ctr);
    }

    offset=drsuapi_dissect_DsReplica06Ctr_count(tvb, offset, pinfo, tree, drep);

    offset=drsuapi_dissect_DsReplica06Ctr_reserved(tvb, offset, pinfo, tree, drep);

    offset=ucarray_drsuapi_dissect_DsReplica06Ctr_array(tvb, offset, pinfo, tree, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaNeighbourCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours, NDR_POINTER_UNIQUE, "neighbours", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursorCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors, NDR_POINTER_UNIQUE, "coursors", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaObjMetaDataCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata, NDR_POINTER_UNIQUE, "objmetadata", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaKccDsaFailuresCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures, NDR_POINTER_UNIQUE, "connectfailures", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaKccDsaFailuresCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures, NDR_POINTER_UNIQUE, "linkfailures", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaOpCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops, NDR_POINTER_UNIQUE, "pendingops", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaAttrValMetaDataCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata, NDR_POINTER_UNIQUE, "attrvalmetadata", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor2Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2, NDR_POINTER_UNIQUE, "coursors2", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor3Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3, NDR_POINTER_UNIQUE, "coursors3", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaObjMetaData2Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2, NDR_POINTER_UNIQUE, "objmetadata2", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaAttrValMetaData2Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2, NDR_POINTER_UNIQUE, "attrvalmetadata2", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaNeighbourCtr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02, NDR_POINTER_UNIQUE, "neighbours02", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaConnection04Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04, NDR_POINTER_UNIQUE, "connections04", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaCoursor05Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05, NDR_POINTER_UNIQUE, "coursors05", -1);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplica06Ctr(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06, param);
    return offset;
}

static int
drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06_unique(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06, NDR_POINTER_UNIQUE, "i06", -1);
    return offset;
}


static int
drsuapi_dissect_union_DsReplicaInfo(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, guint8 *drep, int hf_index, guint32 param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    guint32 level;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
        item=proto_tree_add_text(parent_tree, tvb, offset, -1, "DsReplicaInfo");
        tree=proto_item_add_subtree(item, ett_drsuapi_DsReplicaInfo);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
                              drep, hf_index, &level);

    switch(level){
    case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_CURSORS:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_CURSURS05:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05_unique(tvb, offset, pinfo, tree, drep);
        break;

    case DRSUAPI_DS_REPLICA_INFO_06:
        ALIGN_TO_4_BYTES;
        offset=drsuapi_dissect_union_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06_unique(tvb, offset, pinfo, tree, drep);
        break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
drsuapi_dissect_DsReplicaGetInfo_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_policy_handle(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfo_bind_handle, param);
    return offset;
}

static int
ref_drsuapi_dissect_DsReplicaGetInfo_bind_handle(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, drep, drsuapi_dissect_DsReplicaGetInfo_bind_handle, NDR_POINTER_REF, "bind_handle", -1);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfo_level(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaGetInfoLevel(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfo_level, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfo_req(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsReplicaGetInfoRequest(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfo_req, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfo_info_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_DsReplicaInfoType(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfo_info_type, param);
    return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfo_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, guint8 *drep)
{
    guint32 param=0;
    offset=drsuapi_dissect_union_DsReplicaInfo(tvb, offset, pinfo, tree, drep, hf_drsuapi_DsReplicaGetInfo_info, param);
    return offset;
}


static int
drsuapi_dissect_DsReplicaGetInfo_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=ref_drsuapi_dissect_DsReplicaGetInfo_bind_handle(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaGetInfo_level(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaGetInfo_req(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);


   return offset;
}

static int
drsuapi_dissect_DsReplicaGetInfo_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
        offset=drsuapi_dissect_DsReplicaGetInfo_info_type(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

        offset=drsuapi_dissect_DsReplicaGetInfo_info(tvb, offset, pinfo, tree, drep);
        offset=dissect_deferred_pointers(pinfo, tvb, offset, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_ADD_SID_HISTORY_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_ADD_SID_HISTORY_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS2_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS2_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_VERIFY_OBJECTS_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_REPLICA_VERIFY_OBJECTS_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_OBJECT_EXISTENCE_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_GET_OBJECT_EXISTENCE_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}

static int
drsuapi_dissect_DRSUAPI_QUERY_SITES_BY_COST_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{

   return offset;
}

static int
drsuapi_dissect_DRSUAPI_QUERY_SITES_BY_COST_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, guint8 *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, drep, hf_drsuapi_rc, NULL);


   return offset;
}
/* END OF INCLUDED FILE : ETH_CODE */



void
proto_register_drsuapi(void)
{
        static hf_register_info hf[] = {
        { &hf_drsuapi_DsReplicaSyncRequest1Info_nc_dn,
          { "nc_dn", "drsuapi.DsReplicaSyncRequest1Info.nc_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},



/* INCLUDED FILE : ETH_HFARR */
        { &hf_drsuapi_opnum,
          { "Operation", "drsuapi.opnum", FT_UINT16, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_rc,
          { "Return code", "drsuapi.rc", FT_UINT32, BASE_HEX,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_BASE,
          { "DRSUAPI_SUPPORTED_EXTENSION_BASE", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_BASE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_BASE_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION,
          { "DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI,
          { "DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI_tfs), 0x00000004,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2,
          { "DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2_tfs), 0x00000008,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS_tfs), 0x00000010,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1,
          { "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1_tfs), 0x00000020,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION,
          { "DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION_tfs), 0x00000040,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00000080,
          { "DRSUAPI_SUPPORTED_EXTENSION_00000080", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_00000080", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_00000080_tfs), 0x00000080,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE,
          { "DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE_tfs), 0x00000100,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2,
          { "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2_tfs), 0x00000200,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION,
          { "DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION_tfs), 0x00000400,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2,
          { "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2_tfs), 0x00000800,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD,
          { "DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD_tfs), 0x00001000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND,
          { "DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND_tfs), 0x00002000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO,
          { "DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO_tfs), 0x00004000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION,
          { "DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION_tfs), 0x00008000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01,
          { "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01_tfs), 0x00010000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP,
          { "DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP_tfs), 0x00020000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY,
          { "DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY_tfs), 0x00040000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3,
          { "DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3_tfs), 0x00080000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_00100000,
          { "DRSUAPI_SUPPORTED_EXTENSION_00100000", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_00100000", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_00100000_tfs), 0x00100000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2,
          { "DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2_tfs), 0x00200000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6_tfs), 0x00400000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS,
          { "DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS_tfs), 0x00800000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8_tfs), 0x01000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5_tfs), 0x02000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6_tfs), 0x04000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3,
          { "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3_tfs), 0x08000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7,
          { "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7_tfs), 0x08000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT,
          { "DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT_tfs), 0x08000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS,
          { "DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS_tfs), 0x10000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_20000000,
          { "DRSUAPI_SUPPORTED_EXTENSION_20000000", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_20000000", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_20000000_tfs), 0x20000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_40000000,
          { "DRSUAPI_SUPPORTED_EXTENSION_40000000", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_40000000", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_40000000_tfs), 0x40000000,
         "", HFILL }},

        { &hf_drsuapi_SupportedExtensions_DRSUAPI_SUPPORTED_EXTENSION_80000000,
          { "DRSUAPI_SUPPORTED_EXTENSION_80000000", "drsuapi.SupportedExtensions.DRSUAPI_SUPPORTED_EXTENSION_80000000", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_SUPPORTED_EXTENSION_80000000_tfs), 0x80000000,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo24_supported_extensions,
          { "supported_extensions", "drsuapi.DsBindInfo24.supported_extensions", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo24_site_guid,
          { "site_guid", "drsuapi.DsBindInfo24.site_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo24_u1,
          { "u1", "drsuapi.DsBindInfo24.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo28_supported_extensions,
          { "supported_extensions", "drsuapi.DsBindInfo28.supported_extensions", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo28_site_guid,
          { "site_guid", "drsuapi.DsBindInfo28.site_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo28_u1,
          { "u1", "drsuapi.DsBindInfo28.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo28_repl_epoch,
          { "repl_epoch", "drsuapi.DsBindInfo28.repl_epoch", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo_24_info24,
          { "info24", "drsuapi.DsBindInfo.info24", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfo_28_info28,
          { "info28", "drsuapi.DsBindInfo.info28", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfoCtr_length,
          { "length", "drsuapi.DsBindInfoCtr.length", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBindInfoCtr_info,
          { "info", "drsuapi.DsBindInfoCtr.info", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBind_bind_guid,
          { "bind_guid", "drsuapi.DsBind.bind_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBind_bind_info,
          { "bind_info", "drsuapi.DsBind.bind_info", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsBind_bind_handle,
          { "bind_handle", "drsuapi.DsBind.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsUnbind_bind_handle,
          { "bind_handle", "drsuapi.DsUnbind.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1Info_unknown1,
          { "unknown1", "drsuapi.DsReplicaSyncRequest1Info.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1Info_unknown2,
          { "unknown2", "drsuapi.DsReplicaSyncRequest1Info.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1Info_guid1,
          { "guid1", "drsuapi.DsReplicaSyncRequest1Info.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1Info_byte_array,
          { "byte_array", "drsuapi.DsReplicaSyncRequest1Info.byte_array", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1Info_str_len,
          { "str_len", "drsuapi.DsReplicaSyncRequest1Info.str_len", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION,
          { "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_OPERATION_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_WRITEABLE,
          { "DRSUAPI_DS_REPLICA_SYNC_WRITEABLE", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_WRITEABLE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_WRITEABLE_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PERIODIC,
          { "DRSUAPI_DS_REPLICA_SYNC_PERIODIC", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_PERIODIC", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_PERIODIC_tfs), 0x00000004,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING,
          { "DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_INTERSITE_MESSAGING_tfs), 0x00000008,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES,
          { "DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_ALL_SOURCES_tfs), 0x00000010,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL,
          { "DRSUAPI_DS_REPLICA_SYNC_FULL", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_FULL", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_FULL_tfs), 0x00000020,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_URGENT,
          { "DRSUAPI_DS_REPLICA_SYNC_URGENT", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_URGENT", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_URGENT_tfs), 0x00000040,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD,
          { "DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_NO_DISCARD_tfs), 0x00000080,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FORCE,
          { "DRSUAPI_DS_REPLICA_SYNC_FORCE", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_FORCE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_FORCE_tfs), 0x00000100,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE,
          { "DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_ADD_REFERENCE_tfs), 0x00000200,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED,
          { "DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_NEVER_COMPLETED_tfs), 0x00000400,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_TWO_WAY,
          { "DRSUAPI_DS_REPLICA_SYNC_TWO_WAY", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_TWO_WAY", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_TWO_WAY_tfs), 0x00000800,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY,
          { "DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_NEVER_NOTIFY_tfs), 0x00001000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL,
          { "DRSUAPI_DS_REPLICA_SYNC_INITIAL", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_INITIAL", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_INITIAL_tfs), 0x00002000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION,
          { "DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_USE_COMPRESSION_tfs), 0x00004000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ABANDONED,
          { "DRSUAPI_DS_REPLICA_SYNC_ABANDONED", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_ABANDONED", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_ABANDONED_tfs), 0x00008000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS,
          { "DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_INITIAL_IN_PROGRESS_tfs), 0x00010000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET,
          { "DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_PARTIAL_ATTRIBUTE_SET_tfs), 0x00020000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_REQUEUE,
          { "DRSUAPI_DS_REPLICA_SYNC_REQUEUE", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_REQUEUE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_REQUEUE_tfs), 0x00040000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION,
          { "DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_NOTIFICATION_tfs), 0x00080000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA,
          { "DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_ASYNCHRONOUS_REPLICA_tfs), 0x00100000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_CRITICAL,
          { "DRSUAPI_DS_REPLICA_SYNC_CRITICAL", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_CRITICAL", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_CRITICAL_tfs), 0x00200000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS,
          { "DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_FULL_IN_PROGRESS_tfs), 0x00400000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncOptions_DRSUAPI_DS_REPLICA_SYNC_PREEMPTED,
          { "DRSUAPI_DS_REPLICA_SYNC_PREEMPTED", "drsuapi.DsReplicaSyncOptions.DRSUAPI_DS_REPLICA_SYNC_PREEMPTED", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_SYNC_PREEMPTED_tfs), 0x00800000,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1_info,
          { "info", "drsuapi.DsReplicaSyncRequest1.info", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1_guid1,
          { "guid1", "drsuapi.DsReplicaSyncRequest1.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1_string1,
          { "string1", "drsuapi.DsReplicaSyncRequest1.string1", FT_STRING, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest1_options,
          { "options", "drsuapi.DsReplicaSyncRequest1.options", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSyncRequest_1_req1,
          { "req1", "drsuapi.DsReplicaSyncRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSync_bind_handle,
          { "bind_handle", "drsuapi.DsReplicaSync.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSync_level,
          { "level", "drsuapi.DsReplicaSync.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaSync_req,
          { "req", "drsuapi.DsReplicaSync.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesUsnTriple_usn1,
          { "usn1", "drsuapi.DsGetNCChangesUsnTriple.usn1", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesUsnTriple_usn2,
          { "usn2", "drsuapi.DsGetNCChangesUsnTriple.usn2", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesUsnTriple_usn3,
          { "usn3", "drsuapi.DsGetNCChangesUsnTriple.usn3", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor_source_dsa_invocation_id,
          { "source_dsa_invocation_id", "drsuapi.DsReplicaCoursor.source_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor_highest_usn,
          { "highest_usn", "drsuapi.DsReplicaCoursor.highest_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor05Ctr_u1,
          { "u1", "drsuapi.DsReplicaCoursor05Ctr.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor05Ctr_u2,
          { "u2", "drsuapi.DsReplicaCoursor05Ctr.u2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor05Ctr_count,
          { "count", "drsuapi.DsReplicaCoursor05Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor05Ctr_u3,
          { "u3", "drsuapi.DsReplicaCoursor05Ctr.u3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor05Ctr_array,
          { "array", "drsuapi.DsReplicaCoursor05Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_guid1,
          { "guid1", "drsuapi.DsGetNCChangesRequest5.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_guid2,
          { "guid2", "drsuapi.DsGetNCChangesRequest5.guid2", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_sync_req_info1,
          { "sync_req_info1", "drsuapi.DsGetNCChangesRequest5.sync_req_info1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_usn1,
          { "usn1", "drsuapi.DsGetNCChangesRequest5.usn1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_coursor,
          { "coursor", "drsuapi.DsGetNCChangesRequest5.coursor", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_unknown1,
          { "unknown1", "drsuapi.DsGetNCChangesRequest5.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_unknown2,
          { "unknown2", "drsuapi.DsGetNCChangesRequest5.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_unknown3,
          { "unknown3", "drsuapi.DsGetNCChangesRequest5.unknown3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_unknown4,
          { "unknown4", "drsuapi.DsGetNCChangesRequest5.unknown4", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest5_h1,
          { "h1", "drsuapi.DsGetNCChangesRequest5.h1", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr14_length,
          { "length", "drsuapi.DsGetNCChangesRequest_Ctr14.length", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr14_byte_array,
          { "byte_array", "drsuapi.DsGetNCChangesRequest_Ctr14.byte_array", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr13_unknown1,
          { "unknown1", "drsuapi.DsGetNCChangesRequest_Ctr13.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr13_data,
          { "data", "drsuapi.DsGetNCChangesRequest_Ctr13.data", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr12_count,
          { "count", "drsuapi.DsGetNCChangesRequest_Ctr12.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_Ctr12_array,
          { "array", "drsuapi.DsGetNCChangesRequest_Ctr12.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_guid1,
          { "guid1", "drsuapi.DsGetNCChangesRequest8.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_guid2,
          { "guid2", "drsuapi.DsGetNCChangesRequest8.guid2", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_sync_req_info1,
          { "sync_req_info1", "drsuapi.DsGetNCChangesRequest8.sync_req_info1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_usn1,
          { "usn1", "drsuapi.DsGetNCChangesRequest8.usn1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_coursor,
          { "coursor", "drsuapi.DsGetNCChangesRequest8.coursor", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unknown1,
          { "unknown1", "drsuapi.DsGetNCChangesRequest8.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unknown2,
          { "unknown2", "drsuapi.DsGetNCChangesRequest8.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unknown3,
          { "unknown3", "drsuapi.DsGetNCChangesRequest8.unknown3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unknown4,
          { "unknown4", "drsuapi.DsGetNCChangesRequest8.unknown4", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_h1,
          { "h1", "drsuapi.DsGetNCChangesRequest8.h1", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unique_ptr1,
          { "unique_ptr1", "drsuapi.DsGetNCChangesRequest8.unique_ptr1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_unique_ptr2,
          { "unique_ptr2", "drsuapi.DsGetNCChangesRequest8.unique_ptr2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest8_ctr12,
          { "ctr12", "drsuapi.DsGetNCChangesRequest8.ctr12", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_5_req5,
          { "req5", "drsuapi.DsGetNCChangesRequest.req5", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesRequest_8_req8,
          { "req8", "drsuapi.DsGetNCChangesRequest.req8", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx_coursor,
          { "coursor", "drsuapi.DsReplicaCoursorEx.coursor", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx_time1,
          { "time1", "drsuapi.DsReplicaCoursorEx.time1", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx05Ctr_u1,
          { "u1", "drsuapi.DsReplicaCoursorEx05Ctr.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx05Ctr_u2,
          { "u2", "drsuapi.DsReplicaCoursorEx05Ctr.u2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx05Ctr_count,
          { "count", "drsuapi.DsReplicaCoursorEx05Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx05Ctr_u3,
          { "u3", "drsuapi.DsReplicaCoursorEx05Ctr.u3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorEx05Ctr_array,
          { "array", "drsuapi.DsReplicaCoursorEx05Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_guid1,
          { "guid1", "drsuapi.DsGetNCChangesCtr6.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_guid2,
          { "guid2", "drsuapi.DsGetNCChangesCtr6.guid2", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_sync_req_info1,
          { "sync_req_info1", "drsuapi.DsGetNCChangesCtr6.sync_req_info1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_usn1,
          { "usn1", "drsuapi.DsGetNCChangesCtr6.usn1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_usn2,
          { "usn2", "drsuapi.DsGetNCChangesCtr6.usn2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_coursor_ex,
          { "coursor_ex", "drsuapi.DsGetNCChangesCtr6.coursor_ex", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_ctr12,
          { "ctr12", "drsuapi.DsGetNCChangesCtr6.ctr12", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_u1,
          { "u1", "drsuapi.DsGetNCChangesCtr6.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_ptr1,
          { "ptr1", "drsuapi.DsGetNCChangesCtr6.ptr1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_u2,
          { "u2", "drsuapi.DsGetNCChangesCtr6.u2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_len1,
          { "len1", "drsuapi.DsGetNCChangesCtr6.len1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_array_ptr1,
          { "array_ptr1", "drsuapi.DsGetNCChangesCtr6.array_ptr1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr6_u3,
          { "u3", "drsuapi.DsGetNCChangesCtr6.u3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr_6_ctr6,
          { "ctr6", "drsuapi.DsGetNCChangesCtr.ctr6", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChangesCtr_7_ctr7,
          { "ctr7", "drsuapi.DsGetNCChangesCtr.ctr7", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChanges_bind_handle,
          { "bind_handle", "drsuapi.DsGetNCChanges.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChanges_level,
          { "level", "drsuapi.DsGetNCChanges.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChanges_req,
          { "req", "drsuapi.DsGetNCChanges.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetNCChanges_ctr,
          { "ctr", "drsuapi.DsGetNCChanges.ctr", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION,
          { "DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION", "drsuapi.DsReplicaUpdateRefsOptions.DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_UPDATE_ASYNCHRONOUS_OPERATION_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE,
          { "DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE", "drsuapi.DsReplicaUpdateRefsOptions.DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_UPDATE_WRITEABLE_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE,
          { "DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE", "drsuapi.DsReplicaUpdateRefsOptions.DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_UPDATE_ADD_REFERENCE_tfs), 0x00000004,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE,
          { "DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE", "drsuapi.DsReplicaUpdateRefsOptions.DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_UPDATE_DELETE_REFERENCE_tfs), 0x00000008,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsOptions_DRSUAPI_DS_REPLICA_UPDATE_0x00000010,
          { "DRSUAPI_DS_REPLICA_UPDATE_0x00000010", "drsuapi.DsReplicaUpdateRefsOptions.DRSUAPI_DS_REPLICA_UPDATE_0x00000010", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_UPDATE_0x00000010_tfs), 0x00000010,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown1,
          { "unknown1", "drsuapi.DsReplicaUpdateRefsRequest1.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_unknown2,
          { "unknown2", "drsuapi.DsReplicaUpdateRefsRequest1.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_guid,
          { "dest_dsa_guid", "drsuapi.DsReplicaUpdateRefsRequest1.dest_dsa_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_options,
          { "options", "drsuapi.DsReplicaUpdateRefsRequest1.options", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_sync_req_info1,
          { "sync_req_info1", "drsuapi.DsReplicaUpdateRefsRequest1.sync_req_info1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest1_dest_dsa_dns_name,
          { "dest_dsa_dns_name", "drsuapi.DsReplicaUpdateRefsRequest1.dest_dsa_dns_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefsRequest_1_req1,
          { "req1", "drsuapi.DsReplicaUpdateRefsRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefs_bind_handle,
          { "bind_handle", "drsuapi.DsReplicaUpdateRefs.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefs_level,
          { "level", "drsuapi.DsReplicaUpdateRefs.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaUpdateRefs_req,
          { "req", "drsuapi.DsReplicaUpdateRefs.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION,
          { "DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION", "drsuapi.DsReplicaAddOptions.DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_ADD_ASYNCHRONOUS_OPERATION_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAddOptions_DRSUAPI_DS_REPLICA_ADD_WRITEABLE,
          { "DRSUAPI_DS_REPLICA_ADD_WRITEABLE", "drsuapi.DsReplicaAddOptions.DRSUAPI_DS_REPLICA_ADD_WRITEABLE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_ADD_WRITEABLE_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION,
          { "DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION", "drsuapi.DsReplicaDeleteOptions.DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_DELETE_ASYNCHRONOUS_OPERATION_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaDeleteOptions_DRSUAPI_DS_REPLICA_DELETE_WRITEABLE,
          { "DRSUAPI_DS_REPLICA_DELETE_WRITEABLE", "drsuapi.DsReplicaDeleteOptions.DRSUAPI_DS_REPLICA_DELETE_WRITEABLE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_DELETE_WRITEABLE_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION,
          { "DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION", "drsuapi.DsReplicaModifyOptions.DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_MODIFY_ASYNCHRONOUS_OPERATION_tfs), 0x00000001,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaModifyOptions_DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE,
          { "DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE", "drsuapi.DsReplicaModifyOptions.DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE", FT_BOOLEAN, 32,
          TFS(&DRSUAPI_DS_REPLICA_MODIFY_WRITEABLE_tfs), 0x00000002,
         "", HFILL }},

        { &hf_drsuapi_DsNameString_str,
          { "str", "drsuapi.DsNameString.str", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_unknown1,
          { "unknown1", "drsuapi.DsNameRequest1.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_unknown2,
          { "unknown2", "drsuapi.DsNameRequest1.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_format_flags,
          { "format_flags", "drsuapi.DsNameRequest1.format_flags", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsNameFlags_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_format_offered,
          { "format_offered", "drsuapi.DsNameRequest1.format_offered", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsNameFormat_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_format_desired,
          { "format_desired", "drsuapi.DsNameRequest1.format_desired", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsNameFormat_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_count,
          { "count", "drsuapi.DsNameRequest1.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest1_names,
          { "names", "drsuapi.DsNameRequest1.names", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameRequest_1_req1,
          { "req1", "drsuapi.DsNameRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameInfo1_status,
          { "status", "drsuapi.DsNameInfo1.status", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsNameStatus_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameInfo1_dns_domain_name,
          { "dns_domain_name", "drsuapi.DsNameInfo1.dns_domain_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameInfo1_result_name,
          { "result_name", "drsuapi.DsNameInfo1.result_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameCtr1_count,
          { "count", "drsuapi.DsNameCtr1.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameCtr1_array,
          { "array", "drsuapi.DsNameCtr1.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsNameCtr_1_ctr1,
          { "ctr1", "drsuapi.DsNameCtr.ctr1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsCrackNames_bind_handle,
          { "bind_handle", "drsuapi.DsCrackNames.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsCrackNames_level,
          { "level", "drsuapi.DsCrackNames.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsCrackNames_req,
          { "req", "drsuapi.DsCrackNames.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsCrackNames_ctr,
          { "ctr", "drsuapi.DsCrackNames.ctr", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest1_operation,
          { "operation", "drsuapi.DsWriteAccountSpnRequest1.operation", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsSpnOperation_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest1_unknown1,
          { "unknown1", "drsuapi.DsWriteAccountSpnRequest1.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest1_object_dn,
          { "object_dn", "drsuapi.DsWriteAccountSpnRequest1.object_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest1_count,
          { "count", "drsuapi.DsWriteAccountSpnRequest1.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest1_spn_names,
          { "spn_names", "drsuapi.DsWriteAccountSpnRequest1.spn_names", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnRequest_1_req1,
          { "req1", "drsuapi.DsWriteAccountSpnRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnResult1_status,
          { "status", "drsuapi.DsWriteAccountSpnResult1.status", FT_UINT32, BASE_DEC,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpnResult_1_res1,
          { "res1", "drsuapi.DsWriteAccountSpnResult.res1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpn_bind_handle,
          { "bind_handle", "drsuapi.DsWriteAccountSpn.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpn_level,
          { "level", "drsuapi.DsWriteAccountSpn.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpn_req,
          { "req", "drsuapi.DsWriteAccountSpn.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsWriteAccountSpn_res,
          { "res", "drsuapi.DsWriteAccountSpn.res", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoRequest1_domain_name,
          { "domain_name", "drsuapi.DsGetDCInfoRequest1.domain_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoRequest1_level,
          { "level", "drsuapi.DsGetDCInfoRequest1.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoRequest_1_req1,
          { "req1", "drsuapi.DsGetDCInfoRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_netbios_name,
          { "netbios_name", "drsuapi.DsGetDCInfo1.netbios_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_dns_name,
          { "dns_name", "drsuapi.DsGetDCInfo1.dns_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_site_name,
          { "site_name", "drsuapi.DsGetDCInfo1.site_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_computer_dn,
          { "computer_dn", "drsuapi.DsGetDCInfo1.computer_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_server_dn,
          { "server_dn", "drsuapi.DsGetDCInfo1.server_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_is_pdc,
          { "is_pdc", "drsuapi.DsGetDCInfo1.is_pdc", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo1_is_enabled,
          { "is_enabled", "drsuapi.DsGetDCInfo1.is_enabled", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr1_count,
          { "count", "drsuapi.DsGetDCInfoCtr1.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr1_array,
          { "array", "drsuapi.DsGetDCInfoCtr1.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_netbios_name,
          { "netbios_name", "drsuapi.DsGetDCInfo2.netbios_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_dns_name,
          { "dns_name", "drsuapi.DsGetDCInfo2.dns_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_site_name,
          { "site_name", "drsuapi.DsGetDCInfo2.site_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_site_dn,
          { "site_dn", "drsuapi.DsGetDCInfo2.site_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_computer_dn,
          { "computer_dn", "drsuapi.DsGetDCInfo2.computer_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_server_dn,
          { "server_dn", "drsuapi.DsGetDCInfo2.server_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_ntds_dn,
          { "ntds_dn", "drsuapi.DsGetDCInfo2.ntds_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_is_pdc,
          { "is_pdc", "drsuapi.DsGetDCInfo2.is_pdc", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_is_enabled,
          { "is_enabled", "drsuapi.DsGetDCInfo2.is_enabled", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_is_gc,
          { "is_gc", "drsuapi.DsGetDCInfo2.is_gc", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_site_guid,
          { "site_guid", "drsuapi.DsGetDCInfo2.site_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_computer_guid,
          { "computer_guid", "drsuapi.DsGetDCInfo2.computer_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_server_guid,
          { "server_guid", "drsuapi.DsGetDCInfo2.server_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo2_ntds_guid,
          { "ntds_guid", "drsuapi.DsGetDCInfo2.ntds_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr2_count,
          { "count", "drsuapi.DsGetDCInfoCtr2.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr2_array,
          { "array", "drsuapi.DsGetDCInfoCtr2.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown1,
          { "unknown1", "drsuapi.DsGetDCInfo01.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown2,
          { "unknown2", "drsuapi.DsGetDCInfo01.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown3,
          { "unknown3", "drsuapi.DsGetDCInfo01.unknown3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown4,
          { "unknown4", "drsuapi.DsGetDCInfo01.unknown4", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown5,
          { "unknown5", "drsuapi.DsGetDCInfo01.unknown5", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_unknown6,
          { "unknown6", "drsuapi.DsGetDCInfo01.unknown6", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfo01_server_nt4_account,
          { "server_nt4_account", "drsuapi.DsGetDCInfo01.server_nt4_account", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr01_count,
          { "count", "drsuapi.DsGetDCInfoCtr01.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr01_array,
          { "array", "drsuapi.DsGetDCInfoCtr01.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_1_ctr1,
          { "ctr1", "drsuapi.DsGetDCInfoCtr.ctr1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_2_ctr2,
          { "ctr2", "drsuapi.DsGetDCInfoCtr.ctr2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDCInfoCtr_DRSUAPI_DC_INFO_CTR_01_ctr01,
          { "ctr01", "drsuapi.DsGetDCInfoCtr.ctr01", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDomainControllerInfo_bind_handle,
          { "bind_handle", "drsuapi.DsGetDomainControllerInfo.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDomainControllerInfo_level,
          { "level", "drsuapi.DsGetDomainControllerInfo.level", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDomainControllerInfo_req,
          { "req", "drsuapi.DsGetDomainControllerInfo.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsGetDomainControllerInfo_ctr,
          { "ctr", "drsuapi.DsGetDomainControllerInfo.ctr", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest1_info_type,
          { "info_type", "drsuapi.DsReplicaGetInfoRequest1.info_type", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsReplicaInfoType_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest1_object_dn,
          { "object_dn", "drsuapi.DsReplicaGetInfoRequest1.object_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest1_guid1,
          { "guid1", "drsuapi.DsReplicaGetInfoRequest1.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_info_type,
          { "info_type", "drsuapi.DsReplicaGetInfoRequest2.info_type", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsReplicaInfoType_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_object_dn,
          { "object_dn", "drsuapi.DsReplicaGetInfoRequest2.object_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_guid1,
          { "guid1", "drsuapi.DsReplicaGetInfoRequest2.guid1", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_unknown1,
          { "unknown1", "drsuapi.DsReplicaGetInfoRequest2.unknown1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_string1,
          { "string1", "drsuapi.DsReplicaGetInfoRequest2.string1", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_string2,
          { "string2", "drsuapi.DsReplicaGetInfoRequest2.string2", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest2_unknown2,
          { "unknown2", "drsuapi.DsReplicaGetInfoRequest2.unknown2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO_req1,
          { "req1", "drsuapi.DsReplicaGetInfoRequest.req1", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfoRequest_DRSUAPI_DS_REPLICA_GET_INFO2_req2,
          { "req2", "drsuapi.DsReplicaGetInfoRequest.req2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_naming_context_dn,
          { "naming_context_dn", "drsuapi.DsReplicaNeighbour.naming_context_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_dn,
          { "source_dsa_obj_dn", "drsuapi.DsReplicaNeighbour.source_dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_source_dsa_address,
          { "source_dsa_address", "drsuapi.DsReplicaNeighbour.source_dsa_address", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_transport_obj_dn,
          { "transport_obj_dn", "drsuapi.DsReplicaNeighbour.transport_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_replica_flags,
          { "replica_flags", "drsuapi.DsReplicaNeighbour.replica_flags", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_reserved,
          { "reserved", "drsuapi.DsReplicaNeighbour.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_naming_context_obj_guid,
          { "naming_context_obj_guid", "drsuapi.DsReplicaNeighbour.naming_context_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_source_dsa_obj_guid,
          { "source_dsa_obj_guid", "drsuapi.DsReplicaNeighbour.source_dsa_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_source_dsa_invocation_id,
          { "source_dsa_invocation_id", "drsuapi.DsReplicaNeighbour.source_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_transport_obj_guid,
          { "transport_obj_guid", "drsuapi.DsReplicaNeighbour.transport_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_tmp_highest_usn,
          { "tmp_highest_usn", "drsuapi.DsReplicaNeighbour.tmp_highest_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_highest_usn,
          { "highest_usn", "drsuapi.DsReplicaNeighbour.highest_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_last_success,
          { "last_success", "drsuapi.DsReplicaNeighbour.last_success", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_last_attempt,
          { "last_attempt", "drsuapi.DsReplicaNeighbour.last_attempt", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_result_last_attempt,
          { "result_last_attempt", "drsuapi.DsReplicaNeighbour.result_last_attempt", FT_UINT32, BASE_DEC,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbour_consecutive_sync_failures,
          { "consecutive_sync_failures", "drsuapi.DsReplicaNeighbour.consecutive_sync_failures", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbourCtr_count,
          { "count", "drsuapi.DsReplicaNeighbourCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbourCtr_reserved,
          { "reserved", "drsuapi.DsReplicaNeighbourCtr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaNeighbourCtr_array,
          { "array", "drsuapi.DsReplicaNeighbourCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorCtr_count,
          { "count", "drsuapi.DsReplicaCoursorCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorCtr_reserved,
          { "reserved", "drsuapi.DsReplicaCoursorCtr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursorCtr_array,
          { "array", "drsuapi.DsReplicaCoursorCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_attribute_name,
          { "attribute_name", "drsuapi.DsReplicaObjMetaData.attribute_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_version,
          { "version", "drsuapi.DsReplicaObjMetaData.version", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_originating_last_changed,
          { "originating_last_changed", "drsuapi.DsReplicaObjMetaData.originating_last_changed", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_originating_dsa_invocation_id,
          { "originating_dsa_invocation_id", "drsuapi.DsReplicaObjMetaData.originating_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_originating_usn,
          { "originating_usn", "drsuapi.DsReplicaObjMetaData.originating_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData_local_usn,
          { "local_usn", "drsuapi.DsReplicaObjMetaData.local_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaDataCtr_count,
          { "count", "drsuapi.DsReplicaObjMetaDataCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaDataCtr_reserved,
          { "reserved", "drsuapi.DsReplicaObjMetaDataCtr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaDataCtr_array,
          { "array", "drsuapi.DsReplicaObjMetaDataCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_dn,
          { "dsa_obj_dn", "drsuapi.DsReplicaKccDsaFailure.dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailure_dsa_obj_guid,
          { "dsa_obj_guid", "drsuapi.DsReplicaKccDsaFailure.dsa_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailure_first_failure,
          { "first_failure", "drsuapi.DsReplicaKccDsaFailure.first_failure", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailure_num_failures,
          { "num_failures", "drsuapi.DsReplicaKccDsaFailure.num_failures", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailure_last_result,
          { "last_result", "drsuapi.DsReplicaKccDsaFailure.last_result", FT_UINT32, BASE_DEC,
          VALS(NT_errors), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailuresCtr_count,
          { "count", "drsuapi.DsReplicaKccDsaFailuresCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailuresCtr_reserved,
          { "reserved", "drsuapi.DsReplicaKccDsaFailuresCtr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaKccDsaFailuresCtr_array,
          { "array", "drsuapi.DsReplicaKccDsaFailuresCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_SYNC_sync,
          { "sync", "drsuapi.DsRplicaOpOptions.sync", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_ADD_add,
          { "add", "drsuapi.DsRplicaOpOptions.add", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_DELETE_delete,
          { "delete", "drsuapi.DsRplicaOpOptions.delete", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY_modify,
          { "modify", "drsuapi.DsRplicaOpOptions.modify", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS_update_refs,
          { "update_refs", "drsuapi.DsRplicaOpOptions.update_refs", FT_UINT32, BASE_HEX,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsRplicaOpOptions_default_unknown,
          { "unknown", "drsuapi.DsRplicaOpOptions.unknown", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_operation_start,
          { "operation_start", "drsuapi.DsReplicaOp.operation_start", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_serial_num,
          { "serial_num", "drsuapi.DsReplicaOp.serial_num", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_priority,
          { "priority", "drsuapi.DsReplicaOp.priority", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_operation_type,
          { "operation_type", "drsuapi.DsReplicaOp.operation_type", FT_INT16, BASE_DEC,
          VALS(drsuapi_DsReplicaOpType_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_options,
          { "options", "drsuapi.DsReplicaOp.options", FT_UINT16, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_nc_dn,
          { "nc_dn", "drsuapi.DsReplicaOp.nc_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_remote_dsa_obj_dn,
          { "remote_dsa_obj_dn", "drsuapi.DsReplicaOp.remote_dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_remote_dsa_address,
          { "remote_dsa_address", "drsuapi.DsReplicaOp.remote_dsa_address", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_nc_obj_guid,
          { "nc_obj_guid", "drsuapi.DsReplicaOp.nc_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOp_remote_dsa_obj_guid,
          { "remote_dsa_obj_guid", "drsuapi.DsReplicaOp.remote_dsa_obj_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOpCtr_time,
          { "time", "drsuapi.DsReplicaOpCtr.time", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOpCtr_count,
          { "count", "drsuapi.DsReplicaOpCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaOpCtr_array,
          { "array", "drsuapi.DsReplicaOpCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_attribute_name,
          { "attribute_name", "drsuapi.DsReplicaAttrValMetaData.attribute_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_object_dn,
          { "object_dn", "drsuapi.DsReplicaAttrValMetaData.object_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_value_length,
          { "value_length", "drsuapi.DsReplicaAttrValMetaData.value_length", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_value,
          { "value", "drsuapi.DsReplicaAttrValMetaData.value", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_deleted,
          { "deleted", "drsuapi.DsReplicaAttrValMetaData.deleted", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_created,
          { "created", "drsuapi.DsReplicaAttrValMetaData.created", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_version,
          { "version", "drsuapi.DsReplicaAttrValMetaData.version", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_originating_last_changed,
          { "originating_last_changed", "drsuapi.DsReplicaAttrValMetaData.originating_last_changed", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_originating_dsa_invocation_id,
          { "originating_dsa_invocation_id", "drsuapi.DsReplicaAttrValMetaData.originating_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_originating_usn,
          { "originating_usn", "drsuapi.DsReplicaAttrValMetaData.originating_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData_local_usn,
          { "local_usn", "drsuapi.DsReplicaAttrValMetaData.local_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaDataCtr_count,
          { "count", "drsuapi.DsReplicaAttrValMetaDataCtr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaDataCtr_enumeration_context,
          { "enumeration_context", "drsuapi.DsReplicaAttrValMetaDataCtr.enumeration_context", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaDataCtr_array,
          { "array", "drsuapi.DsReplicaAttrValMetaDataCtr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2_source_dsa_invocation_id,
          { "source_dsa_invocation_id", "drsuapi.DsReplicaCoursor2.source_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2_highest_usn,
          { "highest_usn", "drsuapi.DsReplicaCoursor2.highest_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2_last_sync_success,
          { "last_sync_success", "drsuapi.DsReplicaCoursor2.last_sync_success", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2Ctr_count,
          { "count", "drsuapi.DsReplicaCoursor2Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2Ctr_enumeration_context,
          { "enumeration_context", "drsuapi.DsReplicaCoursor2Ctr.enumeration_context", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor2Ctr_array,
          { "array", "drsuapi.DsReplicaCoursor2Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3_source_dsa_invocation_id,
          { "source_dsa_invocation_id", "drsuapi.DsReplicaCoursor3.source_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3_highest_usn,
          { "highest_usn", "drsuapi.DsReplicaCoursor3.highest_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3_last_sync_success,
          { "last_sync_success", "drsuapi.DsReplicaCoursor3.last_sync_success", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3_source_dsa_obj_dn,
          { "source_dsa_obj_dn", "drsuapi.DsReplicaCoursor3.source_dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3Ctr_count,
          { "count", "drsuapi.DsReplicaCoursor3Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3Ctr_enumeration_context,
          { "enumeration_context", "drsuapi.DsReplicaCoursor3Ctr.enumeration_context", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaCoursor3Ctr_array,
          { "array", "drsuapi.DsReplicaCoursor3Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_attribute_name,
          { "attribute_name", "drsuapi.DsReplicaObjMetaData2.attribute_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_version,
          { "version", "drsuapi.DsReplicaObjMetaData2.version", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_originating_last_changed,
          { "originating_last_changed", "drsuapi.DsReplicaObjMetaData2.originating_last_changed", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_invocation_id,
          { "originating_dsa_invocation_id", "drsuapi.DsReplicaObjMetaData2.originating_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_originating_usn,
          { "originating_usn", "drsuapi.DsReplicaObjMetaData2.originating_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_local_usn,
          { "local_usn", "drsuapi.DsReplicaObjMetaData2.local_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2_originating_dsa_obj_dn,
          { "originating_dsa_obj_dn", "drsuapi.DsReplicaObjMetaData2.originating_dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2Ctr_count,
          { "count", "drsuapi.DsReplicaObjMetaData2Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2Ctr_enumeration_context,
          { "enumeration_context", "drsuapi.DsReplicaObjMetaData2Ctr.enumeration_context", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaObjMetaData2Ctr_array,
          { "array", "drsuapi.DsReplicaObjMetaData2Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_attribute_name,
          { "attribute_name", "drsuapi.DsReplicaAttrValMetaData2.attribute_name", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_object_dn,
          { "object_dn", "drsuapi.DsReplicaAttrValMetaData2.object_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_value_length,
          { "value_length", "drsuapi.DsReplicaAttrValMetaData2.value_length", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_value,
          { "value", "drsuapi.DsReplicaAttrValMetaData2.value", FT_UINT8, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_deleted,
          { "deleted", "drsuapi.DsReplicaAttrValMetaData2.deleted", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_created,
          { "created", "drsuapi.DsReplicaAttrValMetaData2.created", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_version,
          { "version", "drsuapi.DsReplicaAttrValMetaData2.version", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_originating_last_changed,
          { "originating_last_changed", "drsuapi.DsReplicaAttrValMetaData2.originating_last_changed", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_invocation_id,
          { "originating_dsa_invocation_id", "drsuapi.DsReplicaAttrValMetaData2.originating_dsa_invocation_id", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_originating_usn,
          { "originating_usn", "drsuapi.DsReplicaAttrValMetaData2.originating_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_local_usn,
          { "local_usn", "drsuapi.DsReplicaAttrValMetaData2.local_usn", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2_originating_dsa_obj_dn,
          { "originating_dsa_obj_dn", "drsuapi.DsReplicaAttrValMetaData2.originating_dsa_obj_dn", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2Ctr_count,
          { "count", "drsuapi.DsReplicaAttrValMetaData2Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2Ctr_enumeration_context,
          { "enumeration_context", "drsuapi.DsReplicaAttrValMetaData2Ctr.enumeration_context", FT_INT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaAttrValMetaData2Ctr_array,
          { "array", "drsuapi.DsReplicaAttrValMetaData2Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_u1,
          { "u1", "drsuapi.DsReplicaConnection04.u1", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_u2,
          { "u2", "drsuapi.DsReplicaConnection04.u2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_u3,
          { "u3", "drsuapi.DsReplicaConnection04.u3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_bind_guid,
          { "bind_guid", "drsuapi.DsReplicaConnection04.bind_guid", FT_GUID, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_bind_time,
          { "bind_time", "drsuapi.DsReplicaConnection04.bind_time", FT_ABSOLUTE_TIME, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_u4,
          { "u4", "drsuapi.DsReplicaConnection04.u4", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04_u5,
          { "u5", "drsuapi.DsReplicaConnection04.u5", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04Ctr_count,
          { "count", "drsuapi.DsReplicaConnection04Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04Ctr_reserved,
          { "reserved", "drsuapi.DsReplicaConnection04Ctr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaConnection04Ctr_array,
          { "array", "drsuapi.DsReplicaConnection04Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_str1,
          { "str1", "drsuapi.DsReplica06.str1", FT_STRING, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u1,
          { "u1", "drsuapi.DsReplica06.u1", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u2,
          { "u2", "drsuapi.DsReplica06.u2", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u3,
          { "u3", "drsuapi.DsReplica06.u3", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u4,
          { "u4", "drsuapi.DsReplica06.u4", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u5,
          { "u5", "drsuapi.DsReplica06.u5", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u6,
          { "u6", "drsuapi.DsReplica06.u6", FT_UINT64, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06_u7,
          { "u7", "drsuapi.DsReplica06.u7", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06Ctr_count,
          { "count", "drsuapi.DsReplica06Ctr.count", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06Ctr_reserved,
          { "reserved", "drsuapi.DsReplica06Ctr.reserved", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplica06Ctr_array,
          { "array", "drsuapi.DsReplica06Ctr.array", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS_neighbours,
          { "neighbours", "drsuapi.DsReplicaInfo.neighbours", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS_coursors,
          { "coursors", "drsuapi.DsReplicaInfo.coursors", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA_objmetadata,
          { "objmetadata", "drsuapi.DsReplicaInfo.objmetadata", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES_connectfailures,
          { "connectfailures", "drsuapi.DsReplicaInfo.connectfailures", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES_linkfailures,
          { "linkfailures", "drsuapi.DsReplicaInfo.linkfailures", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_PENDING_OPS_pendingops,
          { "pendingops", "drsuapi.DsReplicaInfo.pendingops", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA_attrvalmetadata,
          { "attrvalmetadata", "drsuapi.DsReplicaInfo.attrvalmetadata", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS2_coursors2,
          { "coursors2", "drsuapi.DsReplicaInfo.coursors2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSORS3_coursors3,
          { "coursors3", "drsuapi.DsReplicaInfo.coursors3", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2_objmetadata2,
          { "objmetadata2", "drsuapi.DsReplicaInfo.objmetadata2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2_attrvalmetadata2,
          { "attrvalmetadata2", "drsuapi.DsReplicaInfo.attrvalmetadata2", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_NEIGHBORS02_neighbours02,
          { "neighbours02", "drsuapi.DsReplicaInfo.neighbours02", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CONNECTIONS04_connections04,
          { "connections04", "drsuapi.DsReplicaInfo.connections04", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_CURSURS05_coursors05,
          { "coursors05", "drsuapi.DsReplicaInfo.coursors05", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaInfo_DRSUAPI_DS_REPLICA_INFO_06_i06,
          { "i06", "drsuapi.DsReplicaInfo.i06", FT_NONE, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfo_bind_handle,
          { "bind_handle", "drsuapi.DsReplicaGetInfo.bind_handle", FT_BYTES, BASE_NONE,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfo_level,
          { "level", "drsuapi.DsReplicaGetInfo.level", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsReplicaGetInfoLevel_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfo_req,
          { "req", "drsuapi.DsReplicaGetInfo.req", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfo_info_type,
          { "info_type", "drsuapi.DsReplicaGetInfo.info_type", FT_INT32, BASE_DEC,
          VALS(drsuapi_DsReplicaInfoType_vals), 0,
         "", HFILL }},

        { &hf_drsuapi_DsReplicaGetInfo_info,
          { "info", "drsuapi.DsReplicaGetInfo.info", FT_UINT32, BASE_DEC,
          NULL, 0,
         "", HFILL }},

/* END OF INCLUDED FILE : ETH_HFARR */


	};

        static gint *ett[] = {


/* INCLUDED FILE : ETH_ETTARR */
        &ett_drsuapi,
        &ett_drsuapi_SupportedExtensions,
        &ett_drsuapi_DsBindInfo24,
        &ett_drsuapi_DsBindInfo28,
        &ett_drsuapi_DsBindInfo,
        &ett_drsuapi_DsBindInfoCtr,
        &ett_drsuapi_DsReplicaSyncRequest1Info,
        &ett_drsuapi_DsReplicaSyncOptions,
        &ett_drsuapi_DsReplicaSyncRequest1,
        &ett_drsuapi_DsReplicaSyncRequest,
        &ett_drsuapi_DsGetNCChangesUsnTriple,
        &ett_drsuapi_DsReplicaCoursor,
        &ett_drsuapi_DsReplicaCoursor05Ctr,
        &ett_drsuapi_DsGetNCChangesRequest5,
        &ett_drsuapi_DsGetNCChangesRequest_Ctr14,
        &ett_drsuapi_DsGetNCChangesRequest_Ctr13,
        &ett_drsuapi_DsGetNCChangesRequest_Ctr12,
        &ett_drsuapi_DsGetNCChangesRequest8,
        &ett_drsuapi_DsGetNCChangesRequest,
        &ett_drsuapi_DsReplicaCoursorEx,
        &ett_drsuapi_DsReplicaCoursorEx05Ctr,
        &ett_drsuapi_DsGetNCChangesCtr6,
        &ett_drsuapi_DsGetNCChangesCtr7,
        &ett_drsuapi_DsGetNCChangesCtr,
        &ett_drsuapi_DsReplicaUpdateRefsOptions,
        &ett_drsuapi_DsReplicaUpdateRefsRequest1,
        &ett_drsuapi_DsReplicaUpdateRefsRequest,
        &ett_drsuapi_DsReplicaAddOptions,
        &ett_drsuapi_DsReplicaDeleteOptions,
        &ett_drsuapi_DsReplicaModifyOptions,
        &ett_drsuapi_DsNameString,
        &ett_drsuapi_DsNameRequest1,
        &ett_drsuapi_DsNameRequest,
        &ett_drsuapi_DsNameInfo1,
        &ett_drsuapi_DsNameCtr1,
        &ett_drsuapi_DsNameCtr,
        &ett_drsuapi_DsWriteAccountSpnRequest1,
        &ett_drsuapi_DsWriteAccountSpnRequest,
        &ett_drsuapi_DsWriteAccountSpnResult1,
        &ett_drsuapi_DsWriteAccountSpnResult,
        &ett_drsuapi_DsGetDCInfoRequest1,
        &ett_drsuapi_DsGetDCInfoRequest,
        &ett_drsuapi_DsGetDCInfo1,
        &ett_drsuapi_DsGetDCInfoCtr1,
        &ett_drsuapi_DsGetDCInfo2,
        &ett_drsuapi_DsGetDCInfoCtr2,
        &ett_drsuapi_DsGetDCInfo01,
        &ett_drsuapi_DsGetDCInfoCtr01,
        &ett_drsuapi_DsGetDCInfoCtr,
        &ett_drsuapi_DsReplicaGetInfoRequest1,
        &ett_drsuapi_DsReplicaGetInfoRequest2,
        &ett_drsuapi_DsReplicaGetInfoRequest,
        &ett_drsuapi_DsReplicaNeighbour,
        &ett_drsuapi_DsReplicaNeighbourCtr,
        &ett_drsuapi_DsReplicaCoursorCtr,
        &ett_drsuapi_DsReplicaObjMetaData,
        &ett_drsuapi_DsReplicaObjMetaDataCtr,
        &ett_drsuapi_DsReplicaKccDsaFailure,
        &ett_drsuapi_DsReplicaKccDsaFailuresCtr,
        &ett_drsuapi_DsRplicaOpOptions,
        &ett_drsuapi_DsReplicaOp,
        &ett_drsuapi_DsReplicaOpCtr,
        &ett_drsuapi_DsReplicaAttrValMetaData,
        &ett_drsuapi_DsReplicaAttrValMetaDataCtr,
        &ett_drsuapi_DsReplicaCoursor2,
        &ett_drsuapi_DsReplicaCoursor2Ctr,
        &ett_drsuapi_DsReplicaCoursor3,
        &ett_drsuapi_DsReplicaCoursor3Ctr,
        &ett_drsuapi_DsReplicaObjMetaData2,
        &ett_drsuapi_DsReplicaObjMetaData2Ctr,
        &ett_drsuapi_DsReplicaAttrValMetaData2,
        &ett_drsuapi_DsReplicaAttrValMetaData2Ctr,
        &ett_drsuapi_DsReplicaConnection04,
        &ett_drsuapi_DsReplicaConnection04Ctr,
        &ett_drsuapi_DsReplica06,
        &ett_drsuapi_DsReplica06Ctr,
        &ett_drsuapi_DsReplicaInfo,
/* END OF INCLUDED FILE : ETH_ETTARR */


        };

        proto_drsuapi = proto_register_protocol(
                "DRSUAPI", 
		"DRSUAPI", "drsuapi");
	proto_register_field_array(proto_drsuapi, hf, array_length(hf));
        proto_register_subtree_array(ett, array_length(ett));
}

static dcerpc_sub_dissector function_dissectors[] = {


/* INCLUDED FILE : ETH_FT */
    { 0, "DsBind",
        drsuapi_dissect_DsBind_request,
        drsuapi_dissect_DsBind_response },
    { 1, "DsUnbind",
        drsuapi_dissect_DsUnbind_request,
        drsuapi_dissect_DsUnbind_response },
    { 2, "DsReplicaSync",
        drsuapi_dissect_DsReplicaSync_request,
        drsuapi_dissect_DsReplicaSync_response },
    { 3, "DsGetNCChanges",
        drsuapi_dissect_DsGetNCChanges_request,
        drsuapi_dissect_DsGetNCChanges_response },
    { 4, "DsReplicaUpdateRefs",
        drsuapi_dissect_DsReplicaUpdateRefs_request,
        drsuapi_dissect_DsReplicaUpdateRefs_response },
    { 5, "DRSUAPI_REPLICA_ADD",
        drsuapi_dissect_DRSUAPI_REPLICA_ADD_request,
        drsuapi_dissect_DRSUAPI_REPLICA_ADD_response },
    { 6, "DRSUAPI_REPLICA_DEL",
        drsuapi_dissect_DRSUAPI_REPLICA_DEL_request,
        drsuapi_dissect_DRSUAPI_REPLICA_DEL_response },
    { 7, "DRSUAPI_REPLICA_MODIFY",
        drsuapi_dissect_DRSUAPI_REPLICA_MODIFY_request,
        drsuapi_dissect_DRSUAPI_REPLICA_MODIFY_response },
    { 8, "DRSUAPI_VERIFY_NAMES",
        drsuapi_dissect_DRSUAPI_VERIFY_NAMES_request,
        drsuapi_dissect_DRSUAPI_VERIFY_NAMES_response },
    { 9, "DRSUAPI_GET_MEMBERSHIPS",
        drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS_request,
        drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS_response },
    { 10, "DRSUAPI_INTER_DOMAIN_MOVE",
        drsuapi_dissect_DRSUAPI_INTER_DOMAIN_MOVE_request,
        drsuapi_dissect_DRSUAPI_INTER_DOMAIN_MOVE_response },
    { 11, "DRSUAPI_GET_NT4_CHANGELOG",
        drsuapi_dissect_DRSUAPI_GET_NT4_CHANGELOG_request,
        drsuapi_dissect_DRSUAPI_GET_NT4_CHANGELOG_response },
    { 12, "DsCrackNames",
        drsuapi_dissect_DsCrackNames_request,
        drsuapi_dissect_DsCrackNames_response },
    { 13, "DsWriteAccountSpn",
        drsuapi_dissect_DsWriteAccountSpn_request,
        drsuapi_dissect_DsWriteAccountSpn_response },
    { 14, "DRSUAPI_REMOVE_DS_SERVER",
        drsuapi_dissect_DRSUAPI_REMOVE_DS_SERVER_request,
        drsuapi_dissect_DRSUAPI_REMOVE_DS_SERVER_response },
    { 15, "DRSUAPI_REMOVE_DS_DOMAIN",
        drsuapi_dissect_DRSUAPI_REMOVE_DS_DOMAIN_request,
        drsuapi_dissect_DRSUAPI_REMOVE_DS_DOMAIN_response },
    { 16, "DsGetDomainControllerInfo",
        drsuapi_dissect_DsGetDomainControllerInfo_request,
        drsuapi_dissect_DsGetDomainControllerInfo_response },
    { 17, "DsAddEntry",
        drsuapi_dissect_DsAddEntry_request,
        drsuapi_dissect_DsAddEntry_response },
    { 18, "DRSUAPI_EXECUTE_KCC",
        drsuapi_dissect_DRSUAPI_EXECUTE_KCC_request,
        drsuapi_dissect_DRSUAPI_EXECUTE_KCC_response },
    { 19, "DsReplicaGetInfo",
        drsuapi_dissect_DsReplicaGetInfo_request,
        drsuapi_dissect_DsReplicaGetInfo_response },
    { 20, "DRSUAPI_ADD_SID_HISTORY",
        drsuapi_dissect_DRSUAPI_ADD_SID_HISTORY_request,
        drsuapi_dissect_DRSUAPI_ADD_SID_HISTORY_response },
    { 21, "DRSUAPI_GET_MEMBERSHIPS2",
        drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS2_request,
        drsuapi_dissect_DRSUAPI_GET_MEMBERSHIPS2_response },
    { 22, "DRSUAPI_REPLICA_VERIFY_OBJECTS",
        drsuapi_dissect_DRSUAPI_REPLICA_VERIFY_OBJECTS_request,
        drsuapi_dissect_DRSUAPI_REPLICA_VERIFY_OBJECTS_response },
    { 23, "DRSUAPI_GET_OBJECT_EXISTENCE",
        drsuapi_dissect_DRSUAPI_GET_OBJECT_EXISTENCE_request,
        drsuapi_dissect_DRSUAPI_GET_OBJECT_EXISTENCE_response },
    { 24, "DRSUAPI_QUERY_SITES_BY_COST",
        drsuapi_dissect_DRSUAPI_QUERY_SITES_BY_COST_request,
        drsuapi_dissect_DRSUAPI_QUERY_SITES_BY_COST_response },
/* END OF INCLUDED FILE : ETH_FT */


	{ 0, NULL, NULL, NULL },
};

void
proto_reg_handoff_drsuapi(void)
{


/* INCLUDED FILE : ETH_HANDOFF */
    dcerpc_init_uuid(proto_drsuapi, ett_drsuapi,
        &uuid_dcerpc_drsuapi, ver_drsuapi,
        function_dissectors, hf_drsuapi_opnum);
/* END OF INCLUDED FILE : ETH_HANDOFF */


}

