.\" $Xorg: xstdcmap.man,v 1.3 2000/08/17 19:55:06 cpqbld Exp $
.\" Copyright 1989, 1994, 1998  The Open Group
.\" 
.\" All Rights Reserved.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86$
.\"
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XSTDCMAP 1 __xorgversion__
.SH NAME
xstdcmap - X standard colormap utility
.SH SYNOPSIS
.B xstdcmap
[-all] [-best] [-blue] [-default] [-delete \fImap\fP] [-display \fIdisplay\fP]
[-gray] [-green] [-help] [-red] [-verbose]
.SH DESCRIPTION
.PP
The \fIxstdcmap\fP utility can be used to selectively define standard colormap
properties.  It is intended to be run from a user's X startup script to
create standard colormap definitions in order to facilitate sharing of
scarce colormap resources among clients.  Where at all possible, colormaps
are created with read-only allocations.
.SH OPTIONS
.PP
The following options may be used with \fIxstdcmap\fP:
.TP 8
.B \-all
This option indicates that all six standard colormap properties should be
defined on each screen of the display.  Not all screens will support 
visuals under which all six standard colormap properties are meaningful.
\fIxstdcmap\fP will determine the best 
allocations and visuals for the colormap properties of a screen. Any
previously existing standard colormap properties will be replaced.
.TP 8
.B \-best
This option indicates that the RGB_BEST_MAP should be defined.
.TP 8
.B \-blue 
This option indicates that the RGB_BLUE_MAP should be defined.
.TP 8
.B \-default
This option indicates that the RGB_DEFAULT_MAP should be defined.
.TP 8
.B \-delete \fImap\fP
This option specifies that a specific standard colormap property, or
all such properties, should be removed.
\fImap\fP may be one of: default, best, red, green, blue, gray, or all.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the host and display to use; see \fIX(__miscmansuffix__)\fP.
.TP 8
.B \-gray
This option indicates that the RGB_GRAY_MAP should be defined.
.TP 8
.B \-green
This option indicates that the RGB_GREEN_MAP should be defined.
.TP 8
.B \-help
This option indicates that a brief description of the command line arguments
should be printed on the standard error.  This will be done whenever an
unhandled argument is given to
.I xstdcmap.
.TP 8
.B \-red
This option indicates that the RGB_RED_MAP should be defined.
.TP 8
.B \-verbose
This option indicates that \fIxstdcmap\fP should
print logging information as it parses its input and defines the
standard colormap properties.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get default host and display number.
.SH SEE ALSO
X(__miscmansuffix__)
.SH AUTHOR
Donna Converse, MIT X Consortium


