static const struct file files[] = 
{
	{
		.name        = "AppleAirPort2",
		.version     = "3.30.15.p3 (3.1.1b2)",
		.md5         = "a8275cc50107a13b5be15d067b2245a0",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x42550,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x45630,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x493bc,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x4d860,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x52724,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x52ba0,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.30.15.p3 (3.1.2b3)",
		.md5         = "55134c1298abaa85f190331f016d4d36",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x42c24,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x45d04,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x49a90,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x4df34,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x52df8,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x53274,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.30.15.p3 (3.1.2b3)",
		.md5         = "ac232f87f4ccfd1342a878fa85cb95e0",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x426f0,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x457d0,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x4955c,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x4da00,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x528c4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x52d40,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.30.15.p7 (3.2)",
		.md5         = "e74e8d2df2e4eb97e28602f3b2dd4647",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x40efc,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x43fdc,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x47d68,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x4c20c,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x510d0,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x5154c,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.30.15.p8 (3.3b1)",			/* 01/19/2004 */
		.md5         = "87c74c55d2501d2e968f8c132e160b6e",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x41c8c,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x43fe4,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x47d70,  .uc4_length  = 0x44b2,
		.uc5_pos     = 0x4c214,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x510d8,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x51554,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p4 (3.4.2b1)",
		.md5         = "1739c357ade1d04c9be47e8604afb1c2",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f2b8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52da0,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x56ad4,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b0a0,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x605a4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x60a20,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p4 (3.4.3f1)",			/* 09/29/2004 */
		.md5         = "c672b8c218c5dc4a55060bdfa9f58a69",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f378,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52e60,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x56b94,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b160,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x60664,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x60ae0,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p4 (3.4.4f5)",
		.md5         = "2c388e3e8ea9310a58cf76a3757e8ccc",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f5f0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x530d8,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x56e0c,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b3d8,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x608dc,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x60d58,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p4 (3.4.4f5)",
		.md5         = "3860545266b554d2955664db55452f5a",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f5f0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x530d8,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x56e0c,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b3d8,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x608dc,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x60d58,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p6 (3.5f1)",
		.md5         = "a62e35ee9956b286c46b145d35bd6e0c",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f9b8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x534a0,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x571d4,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b7a0,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x60ca4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x61120,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.50.37.p6 (3.5f1)",
		.md5         = "b6f3d2437c40277c197f0afcf12208e9",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x4f9b8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x534a0,  .uc2_length  = 0x3d30,
		.uc4_pos     = 0x571d4,  .uc4_length  = 0x45c8,
		.uc5_pos     = 0x5b7a0,  .uc5_length  = 0x5500,
		.pcm4_pos    = 0x60ca4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x61120,  .pcm5_length = 0x478,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p11 (400.17)",	       /* 09/13/2005 (??) */
		.md5         = "ca0f34df2f0bfb8b5cfd83b5848d2bf5",
		.flags       = BYTE_ORDER_BIG_ENDIAN | 
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x4ff2c,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x5181c,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x55764,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5a554,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x5fd34,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x60254,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p11 (400.17)",
		.md5         = "dc3a69aac95c68fe8edc760e39bbb2c9",
		.flags       = BYTE_ORDER_BIG_ENDIAN | 
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x50efc,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x527ec,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x56734,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b524,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x60d04,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x61224,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p13 (401.2)",                /* 07/10/2005 */
		.md5         = "6ecf38e5ab6997c7ec483c0d637f5c68",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x50fcc,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x528bc,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x56804,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b5f4,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x60dd4,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x612f4,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p13 (402.6)",
		.md5         = "2ba0c4de95344b00f2c7efad917490f5",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x510f4,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x529e4,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x5692c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b71c,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x60f0c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6142c,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p16 (404.2)",
		.md5         = "1b44556cc33b4625f3115ce2942761c6",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x5dd60,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x59e18,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x55028,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x4f838,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x4f318,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x4edf8,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p16 (404.2)",
		.md5         = "6abbe6468954c510b36546f3cdb89efc",     /* x86 driver */
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x5dcd8,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x59d90,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x54fa0,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x4f7b0,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x4f290,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x4ed70,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p16 (404.2)",
		.md5         = "7200d1aef5f413ebc811046d068b40dc",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x511ec,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52adc,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x56a24,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b814,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x61004,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x61524,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p16 (404.2)",
		.md5         = "86cc708e8df3b035a1dbea41ac4eb7d2",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x5021c,                                /* A-PHY init vals empty */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x51b0c,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x55a54,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5a844,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x60034,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x60554,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p18 (405.1)",
		.md5         = "6ad97ec30caee8c5580abdc93c36a2da",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x53e24,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x55714,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x5965c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5e44c,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x63c3c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6415c,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort2",
		.version     = "3.90.34.0.p18 (405.1)",
		.md5         = "85c71d658b650fd2ef546d1d81b113a0",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x51204,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52AF4,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x56a3c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b82c,  .uc5_length  = 0x57f0,
		.pcm4_pos    = 0x6101c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6153c,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPort3",
		.version     = "3.90.34.0.p3 (3.6f2)",
		.md5         = "5aa65bf75ae1bee0f81092a076d1ad1d",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               MISSING_INITVAL_80211_A,
		.iv_pos      = 0x49910,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x4b200,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4f148,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x53f38,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x59718,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x59c38,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPortBrcm4311",
		.version     = "3.120.28.3 (101.3)",
		.md5         = "71f2dbea1dab2ec630b84f4076d9a14e",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x117b60,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x113be0,  .uc2_length  = 0x3f68,
		.uc4_pos     = 0x10edc0,  .uc4_length  = 0x4e10,
		.uc5_pos     = 0x1095c0,  .uc5_length  = 0x5800,
		.pcm4_pos    = 0x1090a0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x108b80,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPortBrcm4311",
		.version     = "3.120.28.3 (103.2)",
		.md5         = "e97c1a92bc961f3334992fe8eea2b185",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x1184c0,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x114540,  .uc2_length  = 0x3f68,
		.uc4_pos     = 0x10f720,  .uc4_length  = 0x4e10,
		.uc5_pos     = 0x109f20,  .uc5_length  = 0x5800,
		.pcm4_pos    = 0x109a00,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x1094e0,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPortBrcm4311",
		.version     = "3.120.28.3.p19 (104.1)",
		.md5         = "96be03e7d08d14db3a323078aa318a53",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x118c60,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x114ce0,  .uc2_length  = 0x3f68,
		.uc4_pos     = 0x10fec0,  .uc4_length  = 0x4e10,
		.uc5_pos     = 0x10a6c0,  .uc5_length  = 0x5800,
		.pcm4_pos    = 0x10a1a0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x109c80,  .pcm5_length = 0x520,
	},
	{
		.name        = "AppleAirPortBrcm4311",
		.version     = "4.80.46.0",
		.md5         = "e99ad02fdd7699fa52f0b9153c8411c8",
		.flags       = BYTE_ORDER_BIG_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x1592f4,
		.iv_map      = INITVALS_MAP_V4_80_46_REVERSE_ORDER,
		.uc4_pos     = 0x15448c,  .uc4_length  = 0x4e68,
		.uc5_pos     = 0x14ee4c,  .uc5_length  = 0x5640,
		.uc11_pos    = 0x148668,  .uc11_length = 0x67e0,
		.uc13_pos    = 0x142708,  .uc13_length = 0x5f60,
		.pcm4_pos    = 0x1421e8,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x141cc8,  .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",                           /* renamed to WMP11V27.sys */
		.version     = "3.8.28.0",
		.md5         = "f7c6cc420c21eb1a73f6a73bfec96f2c",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_8,
		.iv_pos      = 0x1c1a8,
		.iv_map      = INITVALS_MAP_V3_8_X,
		.uc2_pos     = 0x10ad4,  .uc2_length  = 0x3cf0,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.8.37.0",                             /* 09/23/2002 */ 
		.md5         = "e39e934eccd3b15bbb5f8d8f52f172b2",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_8,
		.iv_pos      = 0x10528,
		.iv_map      = INITVALS_MAP_V3_8_X,
		.uc2_pos     = 0x11454,  .uc2_length  = 0x3cf0,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.8.0",                             /* 10/04/2002 */ 
		.md5         = "288923b401e87ef76b7ae2652601ee47",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_8,
		.iv_pos      = 0x13448,
		.iv_map      = INITVALS_MAP_V3_10_8,
		.uc2_pos     = 0x193b4,  .uc2_length  = 0x3dd8,
		.pcm4_pos    = 0x24d6c,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.36.0",                            /* 12/29/2002 */ 
		.md5         = "94cf83440955c49387ab7d9d4a8ee138",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1a760,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1cf84,  .uc2_length  = 0x3ed0,
		.pcm4_pos    = 0x24d44,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.39.0",
		.md5         = "5204362ec9ae6d7a5e2c9ec97a869f3f", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1a860,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1d084,  .uc2_length  = 0x3f30,
		.pcm4_pos    = 0x24f04,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",                           /* was renamed to n54gnds.sys */
		.version     = "3.10.39.7",
		.md5         = "def910106deec0ad67712d124fc2047d", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1b060,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1d884,  .uc2_length  = 0x3f30,
		.pcm4_pos    = 0x25704,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.39.8",
		.md5         = "bdbd3b9bf07ead2e8e00cc6dc267fb4a", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1afe0,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1d804,  .uc2_length  = 0x3f30,
		.pcm4_pos    = 0x25684,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.52.0",
		.md5         = "4a8e982a023e48a6941d4581a88777a4", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1c968,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1f17c,  .uc2_length  = 0x3f30,
		.pcm4_pos    = 0x26ffc,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.53.0",
		.md5         = "50e009df2dbecf7a53fcefee6b137358", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1c9e8,
		.iv_map      = INITVALS_MAP_V3_10_3X,
		.uc2_pos     = 0x1f1fc,  .uc2_length  = 0x3f30,
		.pcm4_pos    = 0x2707c,  .pcm4_length = 0x428,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.10.53.6",                            /* 04/28/2003 */ 
		.md5         = "b43c593fd7c2a47cdc40580fe341f674",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               OLD_VERSION_STYLE_3_10,
		.iv_pos      = 0x1d2f0,
		.iv_map      = INITVALS_MAP_V3_10_53_6,
		.uc2_pos     = 0x1e054,  .uc2_length  = 0x3f38,
		.uc4_pos     = 0x288bc,  .uc4_length  = 0x4238,
		.pcm4_pos    = 0x30d4c,  .pcm4_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",                           /* was renamed to n54gnds.sys */
		.version     = "3.20.21.0",
		.md5         = "595a1b9c589b5d969b08c49c15649609", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x2a158,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x2d1a8,  .uc2_length  = 0x3da8,
		.uc4_pos     = 0x30f58,  .uc4_length  = 0x4470,
		.uc5_pos     = 0x353d0,  .uc5_length  = 0x4ba0,
		.pcm4_pos    = 0x39f78,  .pcm4_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.20.23.0",                            /* 06/13/2003 */ 
		.md5         = "1b1cf5e962c15abca83d1ef2b3906e2f",     /* pcm5 not available, driver is too old */
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x2a1d8,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x2d228,  .uc2_length  = 0x3da8,
		.uc4_pos     = 0x30fd8,  .uc4_length  = 0x4470,
		.uc5_pos     = 0x35450,  .uc5_length  = 0x4ba0,
		.pcm4_pos    = 0x39ff8,  .pcm4_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",                           /* was renamed to mn720-50.sys */
		.version     = "3.20.26.0",
		.md5         = "a8be5b44170d7d1fbdb4dac89d2dacda", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x2a1d8,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x2d228,  .uc2_length  = 0x3da8,
		.uc4_pos     = 0x30fd8,  .uc4_length  = 0x4470,
		.uc5_pos     = 0x35450,  .uc5_length  = 0x4ba0,
		.pcm4_pos    = 0x39ff8,  .pcm4_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.30.15.0",                            /* 07/17/2003 */ 
		.md5         = "ebf36d658d0da5b1ea667fa403919c26", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x2c658,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x2f738,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x334c8,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x37970,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x3c838,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x3ccb8,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.30.15.1",
		.md5         = "b3b3936d52a38b0257ffc7acf2d69a54", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x2c6d8,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x2f7b8,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x33548,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x379f0,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x3c8b8,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x3cd38,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.20.0",                            /* 09/24/2003 */ 
		.md5         = "0c3fc803184f6f85e665dd012611225b", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x302f0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x33d88,  .uc2_length  = 0x3db8,
		.uc4_pos     = 0x37b48,  .uc4_length  = 0x45d8,
		.uc5_pos     = 0x3c128,  .uc5_length  = 0x5050,
		.pcm4_pos    = 0x41180,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x41600,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.25.3",                            /* 10/28/2003 */ 
		.md5         = "5e58a3148b98c9f356cde6049435cb21", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x30970,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x34408,  .uc2_length  = 0x3db0,
		.uc4_pos     = 0x381c0,  .uc4_length  = 0x45d0,
		.uc5_pos     = 0x3c798,  .uc5_length  = 0x5050,
		.pcm4_pos    = 0x417f0,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x41c70,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.65.0",
		.md5         = "ba58cf7f9e8243f19c3eed2f2dcec770", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x36a18,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3a4b0,  .uc2_length  = 0x3ff0,
		.uc4_pos     = 0x3e4a8,  .uc4_length  = 0x47f0,
		.uc5_pos     = 0x42ca0,  .uc5_length  = 0x5260,
		.pcm4_pos    = 0x47f08,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x48388,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.69.0",                            /* 04/09/2004 */ 
		.md5         = "6b670978465408373ae70ab19d70ba7e", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x36a18,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3a4b0,  .uc2_length  = 0x3ff0,
		.uc4_pos     = 0x3e4a8,  .uc4_length  = 0x47f0,
		.uc5_pos     = 0x42ca0,  .uc5_length  = 0x5260,
		.pcm4_pos    = 0x47f08,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x48388,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.73.0",                            /* 06/25/2004 */ 
		.md5         = "52d67c5465c01913b03b7daca0cc4077", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x37398,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3ae30,  .uc2_length  = 0x3ff0,
		.uc4_pos     = 0x3ee28,  .uc4_length  = 0x47f0,
		.uc5_pos     = 0x43620,  .uc5_length  = 0x5260,
		.pcm4_pos    = 0x48888,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x48d08,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.40.100.0",                           /* 02/07/2004 */ 
		.md5         = "431195b941dff794f23c2077fcbf8377", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x34d18,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x387b0,  .uc2_length  = 0x3ff0,
		.uc4_pos     = 0x3c7a8,  .uc4_length  = 0x47f0,
		.uc5_pos     = 0x40fa0,  .uc5_length  = 0x5260,
		.pcm4_pos    = 0x46208,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x46688,  .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.50.21.10",
		.md5         = "7e5c80e858ce5f9f273017e8fecf12fe", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x33370,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x36e58,	 .uc2_length  = 0x3e00,
		.uc4_pos     = 0x3ac60,	 .uc4_length  = 0x4628,
		.uc5_pos     = 0x3f290,	 .uc5_length  = 0x5548,
		.pcm4_pos    = 0x447e0,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x44c60,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.50.21.11",                           /* 02/19/2004 */
		.md5         = "ae96075a3aed5c40f1ead477ea94acd7", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x33370,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x36e58,	 .uc2_length  = 0x3e00,
		.uc4_pos     = 0x3ac60,	 .uc4_length  = 0x4628,
		.uc5_pos     = 0x3f290,	 .uc5_length  = 0x5548,
		.pcm4_pos    = 0x447e0,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x44c60,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.60.7.0",                             /* 03/22/2004 */
		.md5         = "c5616736df4e83930780dca5795387ca", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b988,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f580,	 .uc2_length  = 0x3e08,
		.uc4_pos     = 0x43390,	 .uc4_length  = 0x4e58,
		.uc5_pos     = 0x481f0,	 .uc5_length  = 0x5608,
		.pcm4_pos    = 0x4d800,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x4dc80,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.60.7.5",                             /* 06/07/2004 */
		.md5         = "d2ae116c741c215ef3ef68603db9917f", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b988,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f580,	 .uc2_length  = 0x3e08,
		.uc4_pos     = 0x43390,	 .uc4_length  = 0x4e58,
		.uc5_pos     = 0x481f0,	 .uc5_length  = 0x5608,
		.pcm4_pos    = 0x4d800,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x4dc80,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.70.12.0",                            /* 06/02/2004 */
		.md5         = "d409b089370486521d5408baed9bffde", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x39480,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3d0c8,	 .uc2_length  = 0x3e80,
		.uc4_pos     = 0x40f50,	 .uc4_length  = 0x4ed0,
		.uc5_pos     = 0x45e28,	 .uc5_length  = 0x5680,
		.pcm4_pos    = 0x4b4b0,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x4b930,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.70.17.0",                            /* 06/25/2004 */
		.md5         = "d87b4e14e890091d8e64fb5c570cf192", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x39600,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3d248,	 .uc2_length  = 0x3e80,
		.uc4_pos     = 0x410d0,	 .uc4_length  = 0x4ed0,
		.uc5_pos     = 0x45fa8,	 .uc5_length  = 0x5680,
		.pcm4_pos    = 0x4b630,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x4bab0,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.70.22.0",                            /* 10/20/2004 */
		.md5         = "185a6dc6d655dc31c0b228cc94fb99ac", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x39a88,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3d6d0,	 .uc2_length  = 0x3e80,
		.uc4_pos     = 0x41558,	 .uc4_length  = 0x4ed0,
		.uc5_pos     = 0x46430,	 .uc5_length  = 0x5680,
		.pcm4_pos    = 0x4bab8,	 .pcm4_length = 0x478,
		.pcm5_pos    = 0x4bf38,	 .pcm5_length = 0x478,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.90.16.0",                            /* 12/06/2004 */
		.md5         = "980a7b1e46a368edbeff944ec22f30ad", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b4c8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f138,	 .uc2_length  = 0x3f48,
		.uc4_pos     = 0x43088,	 .uc4_length  = 0x4de8,
		.uc5_pos     = 0x47e78,	 .uc5_length  = 0x57d8,
		.pcm4_pos    = 0x4d658,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x4db80,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.90.41.1",                            /* 07/04/2005 */
		.md5         = "0a87541dd24c6f046a4bf8f671f74de2", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3bec8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3fb38,	 .uc2_length  = 0x3f48,
		.uc4_pos     = 0x43a88,	 .uc4_length  = 0x4df0,
		.uc5_pos     = 0x48880,	 .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x4e068,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x4e590,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.94.41.1",
		.md5         = "b553a59b798f398975083e240f9d0dcf", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3bec8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3fb38,	 .uc2_length  = 0x3f48,
		.uc4_pos     = 0x43a88,	 .uc4_length  = 0x4df0,
		.uc5_pos     = 0x48880,	 .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x4e068,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x4e590,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.94.41.2",
		.md5         = "904f2564fbdf2313bec37d5f7116ed05", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3bec8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3fb38,	 .uc2_length  = 0x3f48,
		.uc4_pos     = 0x43a88,	 .uc4_length  = 0x4df0,
		.uc5_pos     = 0x48880,	 .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x4e068,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x4e590,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.100.35.0",                           /* 11/27/2004 */
		.md5         = "c3ab2d6954c7b5103770832a3a6a591b", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3de80,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x41af0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x45a50,	 .uc4_length  = 0x4df8,
		.uc5_pos     = 0x4a850,	 .uc5_length  = 0x57f8,
		.pcm4_pos    = 0x50050,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x50578,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.100.35.1",                           /* 02/10/2005 */
		.md5         = "da7ca369a1a3593ceac85dec2d267a08", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3df00,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x41b70,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x45ad0,	 .uc4_length  = 0x4df8,
		.uc5_pos     = 0x4a8d0,	 .uc5_length  = 0x57f8,
		.pcm4_pos    = 0x500d0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x505f8,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.100.46.0",                           /* 12/22/2004 */
		.md5         = "38ca1443660d0f5f06887c6a2e692aeb", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3de80,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x41af0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x45a50,	 .uc4_length  = 0x4df8,
		.uc5_pos     = 0x4a850,	 .uc5_length  = 0x57f8,
		.pcm4_pos    = 0x50050,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x50578,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.100.64.0",                           /* 02/11/2005 */
		.md5         = "e7debb46b9ef1f28932e533be4a3d1a9", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3e980,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x425f0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x46550,	 .uc4_length  = 0x4e00,
		.uc5_pos     = 0x4b358,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x50b60,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51088,	 .pcm5_length = 0x520,
	},
	{ 
		.name        = "bcmwl5.sys",
		.version     = "3.100.64.50",                          /* 04/05/2005 */
		.md5         = "4b3e367b829b9b2c0c088909a617e04e", 
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3e900,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x42570,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x464d0,	 .uc4_length  = 0x4e00,
		.uc5_pos     = 0x4b2d8,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x50ae0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51008,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "3.100.65.1",                           /* 04/21/2005 */
		.md5         = "d5f1ab1aab8b81bca6f19da9554a267a",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3e980,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x425f0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x46550,	 .uc4_length  = 0x4e00,
		.uc5_pos     = 0x4b358,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x50b60,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51088,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "3.104.64.50",
		.md5         = "12554a8f91c5d565b96b6ebcfeb6a91a",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3e980,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x425f0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x46550,	 .uc4_length  = 0x4e00,
		.uc5_pos     = 0x4b358,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x50b60,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51088,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "3.104.64.52",
		.md5         = "3ccb53e4f0f5e9f4ae270cb2924cb941",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3e980,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x425f0,	 .uc2_length  = 0x3f58,
		.uc4_pos     = 0x46550,	 .uc4_length  = 0x4e00,
		.uc5_pos     = 0x4b358,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x50b60,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51088,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "3.120.27.0",                           /* 05/19/2005 */
		.md5         = "8d49f11238815a320880fee9f98b2c92",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3f700,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x43370,	 .uc2_length  = 0x3f68,
		.uc4_pos     = 0x472e0,	 .uc4_length  = 0x4e10,
		.uc5_pos     = 0x4c0f8,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x51900,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51e28,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "3.140.16.0",                           /* 07/21/2005 */
		.md5         = "fa4a4a50b4b2647afedc676cc68c69cc",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3f700,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x43370,	 .uc2_length  = 0x3f68,
		.uc4_pos     = 0x472e0,	 .uc4_length  = 0x4e10,
		.uc5_pos     = 0x4c0f8,	 .uc5_length  = 0x5800,
		.pcm4_pos    = 0x51900,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x51e28,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.10.23.2",
		.md5         = "cc04de6690d2f15c7fe2095a476141ba",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x46aa0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x4b498,	 .uc4_length  = 0x4e90,
		.uc5_pos     = 0x50330,	 .uc5_length  = 0x56f8,
		.uc11_pos    = 0x55a38,	 .uc11_length = 0x5bd0,
		.pcm4_pos    = 0x5b610,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x5bb38,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.10.40.0",                           /* 11/02/2005 */
		.md5         = "30d20fc98bcfd52e1da778cf19b223d4",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x47ba8,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x4c5b0,	 .uc4_length  = 0x4ee8,
		.uc5_pos     = 0x514a0,	 .uc5_length  = 0x5750,
		.uc11_pos    = 0x56c00,	 .uc11_length = 0x5a90,
		.pcm4_pos    = 0x5c698,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x5cbc0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.10.40.1",                           /* 12/17/2005 */
		.md5         = "69f940672be0ecee5bd1e905706ba8ce",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x47ba8,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x4c5b0,	 .uc4_length  = 0x4ee8,
		.uc5_pos     = 0x514a0,	 .uc5_length  = 0x5750,
		.uc11_pos    = 0x56c00,	 .uc11_length = 0x5a90,
		.pcm4_pos    = 0x5c698,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x5cbc0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.10.47.2",
		.md5         = "2b87cd8a92bc5003067534aba4349db0",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x47e28,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x4c830,	 .uc4_length  = 0x4ee8,
		.uc5_pos     = 0x51720,	 .uc5_length  = 0x5750,
		.uc11_pos    = 0x56e80,	 .uc11_length = 0x5a90,
		.pcm4_pos    = 0x5c918,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x5ce40,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.40.19.0",
		.md5         = "114234fafec7060392195170e1c4d45e",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x48ab8,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x4d4c0,	 .uc4_length  = 0x4f58,
		.uc5_pos     = 0x52420,	 .uc5_length  = 0x57c0,
		.uc11_pos    = 0x57bf0,	 .uc11_length = 0x5b00,
		.pcm4_pos    = 0x5d6f8,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x5dc20,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.5.0",
		.md5         = "4e89609eac698835250acd02851cc594",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x55780,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5aef8,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x5fd28,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x65330,  .uc11_length = 0x6020,
		.uc13_pos    = 0x6b358,  .uc13_length = 0x5d20,
		.pcm4_pos    = 0x71080,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x715a8,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.9.0",
		.md5         = "85fb2a9069a3cdef3a591606844d0036",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x56400,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5bb78,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x609a8,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x65fb0,  .uc11_length = 0x60f0,
		.uc13_pos    = 0x6c0a8,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x71dc8,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x722f0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.9.2",
		.md5         = "2ee34b694d1ce077678662d7884f6c79",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x56480,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5bbf8,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x60a28,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x66030,  .uc11_length = 0x6130,
		.uc13_pos    = 0x6c168,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x71e88,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x723b0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.17.0",
		.md5         = "90ef35fb5ae531420577c8f40d8a16f5",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x57f80,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5d6f8,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x62528,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x67b30,  .uc11_length = 0x6160,
		.uc13_pos    = 0x6dc98,  .uc13_length = 0x5d40,
		.pcm4_pos    = 0x739e0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x73f08,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.28.2",
		.md5         = "5538cd4cadc0ed0c0295192fd041860d",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x59200,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5e9a0,  .uc4_length  = 0x4e48,
		.uc5_pos     = 0x637f0,  .uc5_length  = 0x5618,
		.uc11_pos    = 0x68e18,  .uc11_length = 0x6660,
		.uc13_pos    = 0x6f480,  .uc13_length = 0x5e58,
		.pcm4_pos    = 0x752e0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x75808,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.28.7",
		.md5         = "3003c21e5e1f04ba84fc8e705a65db2b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x59380,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5eb20,  .uc4_length  = 0x4e48,
		.uc5_pos     = 0x63970,  .uc5_length  = 0x5618,
		.uc11_pos    = 0x68f98,  .uc11_length = 0x6660,
		.uc13_pos    = 0x6f600,  .uc13_length = 0x5e58,
		.pcm4_pos    = 0x75460,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x75988,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.46.0",
		.md5         = "c50861ee37c900bfbc666d49439dc778",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x5bd00,
		.iv_map      = INITVALS_MAP_V4_80_46,
		.uc4_pos     = 0x62e20,  .uc4_length  = 0x4e68,
		.uc5_pos     = 0x67c90,  .uc5_length  = 0x5640,
		.uc11_pos    = 0x6d2e0,  .uc11_length = 0x67e0,
		.uc13_pos    = 0x73ac8,  .uc13_length = 0x5f60,
		.pcm4_pos    = 0x79a30,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x79f58,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.80.53.0",
		.md5         = "e8814dbec973681ae2b2e502ed1a8f44",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x5c600,
		.iv_map      = INITVALS_MAP_V4_80_46,
		.uc4_pos     = 0x63720,  .uc4_length  = 0x4e68,
		.uc5_pos     = 0x68590,  .uc5_length  = 0x5640,
		.uc11_pos    = 0x6dbe0,  .uc11_length = 0x67e0,
		.uc13_pos    = 0x743c8,  .uc13_length = 0x5f60,
		.pcm4_pos    = 0x7a330,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x7a858,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5.sys",
		.version     = "4.100.15.5",
		.md5         = "b89bcf0a25aeb3b47030ac83287f894a",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x5e998,
		.iv_map      = INITVALS_MAP_V4_80_46,
		.uc4_pos     = 0x65908,  .uc4_length  = 0x4dc8,
		.uc5_pos     = 0x6a6d8,  .uc5_length  = 0x55b8,
		.uc11_pos    = 0x6fca0,  .uc11_length = 0x6ae0,
		.uc13_pos    = 0x76788,  .uc13_length = 0x6740,
		.pcm4_pos    = 0x7ced0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x7d3f8,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "3.70.17.5",
		.md5         = "f5590c8784b91dfd9ee092d3040b6e40",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x566f0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x5a360,  .uc2_length  = 0x3e80,
		.uc4_pos     = 0x5e1f0,  .uc4_length  = 0x4ed0,
		.uc5_pos     = 0x630d0,  .uc5_length  = 0x5680,
		.pcm4_pos    = 0x68760,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x68be0,  .pcm5_length = 0x478,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "3.100.64.10",                          /* 05/12/2005 */
		.md5         = "b8d76da338ecf2c650f5f7ca226ccf89",     /* for 64bit machines   */
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x50bf0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x54860,  .uc2_length  = 0x3f58,
		.uc4_pos     = 0x587c0,  .uc4_length  = 0x4e00,
		.uc5_pos     = 0x5d5d0,  .uc5_length  = 0x5800,
		.pcm4_pos    = 0x62de0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x63310,  .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.10.23.2",
		.md5         = "7f4786fb45f509d8c2808b6e423addf1",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x5bac0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x604c0,	 .uc4_length  = 0x4e90,
		.uc5_pos     = 0x65360,	 .uc5_length  = 0x56f8,
		.uc11_pos    = 0x6aa70,	 .uc11_length = 0x5bd0,
		.pcm4_pos    = 0x70650,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x70b80,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.40.19.0",
		.md5         = "68f48a63a827a87bc04f6c8763228054",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x5dcd0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV11,
		.uc4_pos     = 0x626e0,	 .uc4_length  = 0x4f58,
		.uc5_pos     = 0x67640,	 .uc5_length  = 0x57c0,
		.uc11_pos    = 0x6ce10,	 .uc11_length = 0x5b00,
		.pcm4_pos    = 0x72920,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x72e50,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.80.9.2",
		.md5         = "c24bb2a1207a6f2c0ed79e2463df9dea",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x6eb30,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x742e0,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x79110,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x7e720,  .uc11_length = 0x6130,
		.uc13_pos    = 0x84860,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x8a580,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x8aab0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.80.17.0",
		.md5         = "4cf95baf3c3011e4c59d37336e50be57",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x70b30,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x762e0,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x7b110,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x80720,  .uc11_length = 0x6160,
		.uc13_pos    = 0x86890,  .uc13_length = 0x5d40,
		.pcm4_pos    = 0x8c5e0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x8cb10,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.80.28.2",
		.md5         = "038dedd70e8ddfe2b241c75b0d8c1633",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x72130,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x77900,  .uc4_length  = 0x4e48,
		.uc5_pos     = 0x7c750,  .uc5_length  = 0x5618,
		.uc11_pos    = 0x81d80,  .uc11_length = 0x6660,
		.uc13_pos    = 0x883f0,  .uc13_length = 0x5e58,
		.pcm4_pos    = 0x8e250,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x8e780,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl564.sys",
		.version     = "4.100.15.5",
		.md5         = "feaf7ec9f38a37945b6fb169617ec859",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
			       V4_FIRMWARE,
		.iv_pos      = 0x79d40,
		.iv_map      = INITVALS_MAP_V4_80_46,
		.uc4_pos     = 0x80ce0,  .uc4_length  = 0x4dc8,
		.uc5_pos     = 0x85ab0,  .uc5_length  = 0x55b8,
		.uc11_pos    = 0x8b080,  .uc11_length = 0x6ae0,
		.uc13_pos    = 0x91b70,  .uc13_length = 0x6740,
		.pcm4_pos    = 0x982c0,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x987f0,	 .pcm5_length = 0x520,
	},
	{
		.name        = "bcmwl5a.sys",
		.version     = "3.90.16.0",                            /* 12/06/2004 */
		.md5         = "e6d927deea6c75bddf84080e6c3837b7",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b4c8,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f138,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x43088,  .uc4_length  = 0x4de8,
		.uc5_pos     = 0x47e78,  .uc5_length  = 0x57d8,
		.pcm4_pos    = 0x4d658,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x4db80,  .pcm5_length = 0x520,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.31.16.0 ?", /*FIXME: version correct? */
		.md5         = "31e6cac8a8129bf8f91291293e017329",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x40,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x3120,   .uc2_length  = 0x3d88,
		.uc4_pos     = 0x6eac,   .uc4_length  = 0x44a0,
		.uc5_pos     = 0xb350,   .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x10214,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x10690,  .pcm5_length = 0x478,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.50.21.10",
		.md5         = "2781ba96ee69bffd316315240be1f35b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x40,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3b28,   .uc2_length  = 0x3e00,
		.uc4_pos     = 0x792c,   .uc4_length  = 0x4628,
		.uc5_pos     = 0xbf58,   .uc5_length  = 0x5548,
		.pcm4_pos    = 0x114a4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x11920,  .pcm5_length = 0x478,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.60.7.0 ? (1.3.2)",                   /* no version number found */
		.md5         = "7774e5dda1daa2b3f83d279552ca1cc4",     /* but same fw files are also */
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,               /* in bcmwl5.sys 3.60.7.0 */
		.iv_pos      = 0x40,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3c38,   .uc2_length  = 0x3e08,
		.uc4_pos     = 0x7a44,   .uc4_length  = 0x4e58,
		.uc5_pos     = 0xc8a0,   .uc5_length  = 0x5608,
		.pcm4_pos    = 0x11eac,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x12328,  .pcm5_length = 0x478,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.60.13.0",
		.md5         = "020a36ac61eff3fc833489f7b4dc0a8a",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x40,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3c88,   .uc2_length  = 0x3e30,
		.uc4_pos     = 0x7abc,   .uc4_length  = 0x4e80,
		.uc5_pos     = 0xc940,   .uc5_length  = 0x5630,
		.pcm4_pos    = 0x11f74,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x123f0,  .pcm5_length = 0x478,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.90.7.0",                             /* 10/14/2004 */
		.md5         = "b2580361620881b06fa810422ec8b7ce",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x60,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3cd0,   .uc2_length  = 0x3ec0,
		.uc4_pos     = 0x7b94,   .uc4_length  = 0x4d60,
		.uc5_pos     = 0xc8f8,   .uc5_length  = 0x5750,
		.pcm4_pos    = 0x1204c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x12570,  .pcm5_length = 0x520,
	},
	{
		.name        = "d11ucode.o",
		.version     = "3.90.37.0",
		.md5         = "2543935259739a8a879ccb8386647ac7",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x60,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3cd0,   .uc2_length  = 0x3f48,
		.uc4_pos     = 0x7c1c,   .uc4_length  = 0x4df0,
		.uc5_pos     = 0xca10,   .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x121f4,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x12718,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "3.31.15.0",                            /* 07/28/2003 */
		.md5         = "a85af65b5ae1d64ee11eab714faab843",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x32270,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x35350,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x390dc,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x3d580,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x42444,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x428c0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.31.15.0",                            /* 07/28/2003 */
		.md5         = "98dd50a95b02c8bcb3725c770df81dfc",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x32270,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x35350,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x390dc,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x3d580,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x42444,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x428c0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.50.21.0",                            /* 05/11/2003 */
		.md5         = "f71be0e1d14f68c98d916465a300d835",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x38990,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3c428,  .uc2_length  = 0x3db8,
		.uc4_pos     = 0x401e4,  .uc4_length  = 0x45d8,
		.uc5_pos     = 0x447c0,  .uc5_length  = 0x5050,
		.pcm4_pos    = 0x49814,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x49c90,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.50.21.10",                           /* 01/21/2004 */
		.md5         = "191029d5e7097ed7db92cbd6e6131f85",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3a5d0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3e0b8,  .uc2_length  = 0x3e00,
		.uc4_pos     = 0x41ebc,  .uc4_length  = 0x4628,
		.uc5_pos     = 0x464e8,  .uc5_length  = 0x5548,
		.pcm4_pos    = 0x4ba34,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x4beb0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.60.7.0 ? (1.3.2.0)",                 /* 02/04/2004 */
		.md5         = "7009220d84c445797443aa0221b7d8a4",     /* no bcm version found */
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,               /* but same fw files are also */
		.iv_pos      = 0x545e0,                                /* in bcmwl5.sys 3.60.7.0, */
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x581d8,  .uc2_length  = 0x3e08,
		.uc4_pos     = 0x5bfe4,  .uc4_length  = 0x4e58,
		.uc5_pos     = 0x60e40,  .uc5_length  = 0x5608,
		.pcm4_pos    = 0x6644c,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x668c8,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.60.13.0",                            /* 05/05/2004 */
		.md5         = "275dd4958eb94058d4650f58d534c635",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b740,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f388,  .uc2_length  = 0x3e30,
		.uc4_pos     = 0x431bc,  .uc4_length  = 0x4e80,
		.uc5_pos     = 0x48040,  .uc5_length  = 0x5630,
		.pcm4_pos    = 0x4d674,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x4daf0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.60.13.0",                            /* 08/02/2004 */
		.md5         = "4f20653a0b7c0bb3bd1ee0dd79f77785",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3b730,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x3f378,  .uc2_length  = 0x3e30,
		.uc4_pos     = 0x431ac,  .uc4_length  = 0x4e80,
		.uc5_pos     = 0x48030,  .uc5_length  = 0x5630,
		.pcm4_pos    = 0x4d664,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x4dae0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl.o",
		.version     = "3.90.7.0",                             /* 14/10/2004 */
		.md5         = "f15b59ad4d6f6ad2c7f45193d033aff8",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4d890,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x51500,  .uc2_length  = 0x3ec0,
		.uc4_pos     = 0x553c4,  .uc4_length  = 0x4d60,
		.uc5_pos     = 0x5a128,  .uc5_length  = 0x5750,
		.pcm4_pos    = 0x5f87c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x5fda0,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "3.90.23.0",
		.md5         = "2bbeb870cf50b1231b9fd61e320aee19",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4e080,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x51cf0,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x55c3c,  .uc4_length  = 0x4de8,
		.uc5_pos     = 0x5aa28,  .uc5_length  = 0x57d8,
		.pcm4_pos    = 0x60204,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x60728,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "984c42947552652d5ab61b78e7d12227",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4cf50,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x50bc0,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x54b0c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x59900,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x5f0e4,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x5f608,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "3.90.38.0",
		.md5         = "cdcdefb185700461a207d9671c6c501f",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4f0d0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52d40,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x56c8c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5ba80,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x61264,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x61788,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "3.130.20.0",
		.md5         = "9b39b50b7b4c02115c348d645878ab2d",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x56020,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11,
		.uc2_pos     = 0x59ca0,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x5dc84,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x62b00,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x68204,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x6d6b0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6dbd4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "4.80.9.1",
		.md5         = "c3bf18125b65de73f2d6b68dd63d60cf",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x65bc0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x6a700,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x6f52c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x74b30,  .uc11_length = 0x60f0,
		.uc13_pos    = 0x7ac24,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x80940,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x80e64,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl.o",
		.version     = "4.80.9.1",
		.md5         = "de3a5d0d4a795cf85dc706f75ac4c56d",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x65bc0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x6a700,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x6f52c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x74b30,  .uc11_length = 0x60f0,
		.uc13_pos    = 0x7ac24,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x80940,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x80e64,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "3.31.16.0",                            /* 08/06/2003 */
		.md5         = "463633e7bf0efc6c0f8eac2514a71024",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x32270,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x35350,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x390dc,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x3d580,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x42444,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x428c0,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl_ap.o",
		.version     = "3.90.7.0",
		.md5         = "e0b96342c6a48a7eee8b4423fcb65b63",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3d7f0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x41460,  .uc2_length  = 0x3ec0,
		.uc4_pos     = 0x45324,  .uc4_length  = 0x4d60,
		.uc5_pos     = 0x4a088,  .uc5_length  = 0x5750,
		.pcm4_pos    = 0x4f7dc,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x4fd00,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "0538296d46a854d2facc9a0db2088180",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3eac0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x42730,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4667c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x4b470,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x50c54,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x51178,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "6c9073531a528dd455b716b5e821e696",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x3eac0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x42730,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4667c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x4b470,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x50c54,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x51178,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "3.130.20.0",
		.md5         = "1e3a8bb0b994a929ef38da3a5a29155b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x42840,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11,
		.uc2_pos     = 0x464c0,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x4a4a4,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x4f320,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x54a24,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x59ed0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x5a3f4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "4.80.9.2",
		.md5         = "dc87fafbb53fc70ca161be3de97b5be1",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x4f0a0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x53be0,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x58a0c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x5e010,  .uc11_length = 0x6130,
		.uc13_pos    = 0x64144,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x69e60,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6a384,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_ap.o",
		.version     = "4.80.17.0",
		.md5         = "5f698bc71300590208dcfe86e8dde860",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x4fa40,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x54580,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x593ac,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x5e9b0,  .uc11_length = 0x6160,
		.uc13_pos    = 0x64b14,  .uc13_length = 0x5d40,
		.pcm4_pos    = 0x6a858,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6ad7c,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.31.16.0",                            /* 06/08/2003 */
		.md5         = "22b90e4cbeee45ad7f78ff536c65712a",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x38020,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x3b100,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x3ee8c,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x43330,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x481f4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x48670,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.31.16.0",                            /* 06/08/2003 */
		.md5         = "dfce35a8b5cb6e53e1ab75342c7e7194",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x38020,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x3b100,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x3ee8c,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x43330,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x481f4,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x48670,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.90.7.0",
		.md5         = "8aec09b7cf92538182729eddc6d89d97",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4d890,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x51500,  .uc2_length  = 0x3ec0,
		.uc4_pos     = 0x553c4,  .uc4_length  = 0x4d60,
		.uc5_pos     = 0x5a128,  .uc5_length  = 0x5750,
		.pcm4_pos    = 0x5f87c,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x5fda0,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "2922e6c48917eacd6c8c094347d2ec4b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4ebc0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52830,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x5677c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b570,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x60d54,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x61278,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "f9fa565a766e8befeb495a8a8c0c134b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4ebc0,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x52830,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x5677c,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x5b570,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x60d54,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x61278,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.130.20.0",                           /* 19/05/2005 */
		.md5         = "e08665c5c5b66beb9c3b2dd54aa80cb3",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x56020,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11,
		.uc2_pos     = 0x59ca0,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x5dc84,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x62b00,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x68204,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x6d6b0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6dbd4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "3.130.35.0",
		.md5         = "e88dbfc4dfeff43ce9028c74bd0088c7",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x57c80,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11,
		.uc2_pos     = 0x5b900,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x5f8e4,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x64760,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x69e64,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x6f310,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6f834,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "4.80.9.1",
		.md5         = "5cc3774df07ef15506d08e45fab9b691",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x70220,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x75998,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x7a7c4,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x7fdc8,  .uc11_length = 0x60f0,
		.uc13_pos    = 0x85ebc,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x8bbd8,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x8c0fc,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "4.80.9.1",
		.md5         = "cfc06ff322a4e3024bc4040ebe3d1bb9",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x632a0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x67de0,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x6cc0c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x72210,  .uc11_length = 0x60f0,
		.uc13_pos    = 0x78304,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x7e020,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x7e544,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "4.80.9.2",
		.md5         = "2b353750e7063949fa08951370c8b06b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x632c0,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x67e00,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x6cc2c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x72230,  .uc11_length = 0x6130,
		.uc13_pos    = 0x78364,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x7e080,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x7e5a4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "4.80.17.0",
		.md5         = "1fb9e0cc7613ccb82c8e2da3da888ed1",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x63e30,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x68970,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x6d79c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x72da0,  .uc11_length = 0x6160,
		.uc13_pos    = 0x78f04,  .uc13_length = 0x5d40,
		.pcm4_pos    = 0x7ec48,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x7f16c,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_apsta.o",
		.version     = "4.80.53.0",
		.md5         = "9207bc565c2fc9fa1591f6c7911d3fc0",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x67930,
		.iv_map      = INITVALS_MAP_V4_80_46,
		.uc4_pos     = 0x6dcf8,  .uc4_length  = 0x4e68,
		.uc5_pos     = 0x72b64,  .uc5_length  = 0x5640,
		.uc11_pos    = 0x781b0,  .uc11_length = 0x67e0,
		.uc13_pos    = 0x7e994,  .uc13_length = 0x5f60,
		.pcm4_pos    = 0x848f8,	 .pcm4_length = 0x520,
		.pcm5_pos    = 0x84e1c,	 .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "3.31.16.0",                            /* 08/06/2003 */
		.md5         = "c3e663cb78b2fc299088de69fc11a9a9",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x317b0,
		.iv_map      = INITVALS_MAP_V3_WITHOUT_IV8,
		.uc2_pos     = 0x34890,  .uc2_length  = 0x3d88,
		.uc4_pos     = 0x3861c,  .uc4_length  = 0x44a0,
		.uc5_pos     = 0x3cac0,  .uc5_length  = 0x4ec0,
		.pcm4_pos    = 0x41984,  .pcm4_length = 0x478,
		.pcm5_pos    = 0x41e00,  .pcm5_length = 0x478,
	},
	{
		.name        = "wl_sta.o",
		.version     = "3.90.7.0",
		.md5         = "df4eeee4c50323c823527084cbac7935",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x45d10,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x49980,  .uc2_length  = 0x3ec0,
		.uc4_pos     = 0x4d844,  .uc4_length  = 0x4d60,
		.uc5_pos     = 0x525a8,  .uc5_length  = 0x5750,
		.pcm4_pos    = 0x57cfc,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x58220,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "4631d4d4c3ab943462e1ea24f4dba7bd",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x47040,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x4acb0,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4ebfc,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x539f0,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x591d4,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x596f8,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "3.90.37.0",                            /* 15/02/2005 */
		.md5         = "bf824b38b3993e0a8b5a9bf717c428ed",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x47040,
		.iv_map      = INITVALS_MAP_V3_DEFAULT,
		.uc2_pos     = 0x4acb0,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4ebfc,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x539f0,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x591d4,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x596f8,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "3.130.20.0",
		.md5         = "dbe071c3090297c1014c1c7f56d655ce",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN,
		.iv_pos      = 0x4b160,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11,
		.uc2_pos     = 0x4ede0,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x52dc4,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x57c40,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x5d344,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x627f0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x62d14,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "4.80.9.2",
		.md5         = "a4a396c45a4e88526fa8a8baca681cd3",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x54b00,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x59640,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x5e46c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x63a70,  .uc11_length = 0x6130,
		.uc13_pos    = 0x69ba4,  .uc13_length = 0x5d18,
		.pcm4_pos    = 0x6f8c0,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x6fde4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl_sta.o",
		.version     = "4.80.17.0",
		.md5         = "30e0f1a8fea33d4869e1a45ed3a91b1b",
		.flags       = BYTE_ORDER_LITTLE_ENDIAN |
		               V4_FIRMWARE,
		.iv_pos      = 0x55530,
		.iv_map      = INITVALS_MAP_V4_UP_TO_REV13,
		.uc4_pos     = 0x5a070,  .uc4_length  = 0x4e28,
		.uc5_pos     = 0x5ee9c,  .uc5_length  = 0x55f8,
		.uc11_pos    = 0x644a0,  .uc11_length = 0x6160,
		.uc13_pos    = 0x6a604,  .uc13_length = 0x5d40,
		.pcm4_pos    = 0x70348,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x7086c,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl96345GW.o_save",
		.version     = "3.91.41.0",
		.md5         = "1b1b9cdceccf0758a6bb21371edfe011",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x523cc,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x4e484,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x49690,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x43eac,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x43988,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x43464,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl96348GW.o_save",
		.version     = "3.91.41.0",
		.md5         = "4578369ebe849f268b464d7fb3d1ea6b",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x5152c,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x4d5e4,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x487f0,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x4300c,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x42ae8,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x425c4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl96348GW.o_save",
		.version     = "3.91.41.0",
		.md5         = "4b64e7bf6b308cd8433ba5f04a091a79",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x5147c,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x4d534,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x48740,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x42f5c,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x42a38,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x42514,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl96348GW.o_save",
		.version     = "3.131.35.0",
		.md5         = "4af53099070fc26a755c42e86c824003",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x74628,
		.iv_map      = INITVALS_MAP_V3_UP_TO_REV11_REVERSE_ORDER,
		.uc2_pos     = 0x70648,  .uc2_length  = 0x3fe0,
		.uc4_pos     = 0x6b7cc,  .uc4_length  = 0x4e78,
		.uc5_pos     = 0x660c8,  .uc5_length  = 0x5700,
		.uc11_pos    = 0x60c1c,  .uc11_length = 0x54a8,
		.pcm4_pos    = 0x606f8,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x601d4,  .pcm5_length = 0x520,
	},
	{
		.name        = "wl96348GWV_DT.o_save",
		.version     = "3.91.41.0",
		.md5         = "e48ecf90086e48061f49cd4af2c158b3",
		.flags       = BYTE_ORDER_BIG_ENDIAN,
		.iv_pos      = 0x54dec,
		.iv_map      = INITVALS_MAP_V3_REVERSE_ORDER,
		.uc2_pos     = 0x50ea4,  .uc2_length  = 0x3f48,
		.uc4_pos     = 0x4c0b0,  .uc4_length  = 0x4df0,
		.uc5_pos     = 0x468cc,  .uc5_length  = 0x57e0,
		.pcm4_pos    = 0x463a8,  .pcm4_length = 0x520,
		.pcm5_pos    = 0x45e84,  .pcm5_length = 0x520,
	},
};

#define FILES (sizeof(files) / sizeof(files[0]))
