//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//  Written by Aecio F. Neto (afn@harvest.com.br)
//              Harvest Consultoria (www.harvest.com.br)
//
//  and somewhat hacked by mad@madness.at
//

#include "ClamAV.hpp"


extern OptionContainer o;


ClamEngine::ClamEngine ():virname (NULL), err_str (NULL), root (NULL)
{
  memset (&dbstat, 0, sizeof (struct cl_stat));
}

ClamEngine::~ClamEngine ()
{
}

int
ClamEngine::loadEngine ()
{
  int ret = 0;
  unsigned int no = 0;
  const char *dbdir = cl_retdbdir ();

#ifdef DGDEBUG
  system ("date");
  std::cout << "Start ClamAV DB load." << std::endl;
#endif

  if (root != NULL)
    {
#ifndef CL_NUM_CHILDS           // assume clamav w/ new api
      cl_free (root);
#else
      cl_freetrie (root);
#endif
      root = NULL;
    }
  if ((ret = cl_loaddbdir (dbdir, &root, &no)))
    {
      syslog (LOG_ERR, "Error loading ClamAV DB: %s", cl_perror (ret));
      return ret;
    }
  else
    {
      syslog (LOG_INFO, "ClamAV DB loaded: %i signatures known", no);
#ifndef CL_NUM_CHILDS           // assume clamav w/ new api
      cl_build (root);
#else
      cl_buildtrie (root);
#endif
      cl_statfree (&dbstat);
      cl_statinidir (dbdir, &dbstat);
    }

#ifdef DGDEBUG
  std::cout << "End of ClamAV DB load." << std::endl;
  system ("date");
#endif

  limits.maxfiles = o.cl_max_files;
  limits.maxfilesize = o.cl_max_file_size;
  limits.maxreclevel = o.cl_max_rec_level;

  return 0;
}

int
ClamEngine::reloadEngine ()
{
  int ret = 0;

  if (cl_statchkdir (&dbstat) == 1)
    {
#ifdef DGDEBUG
      std::cout << "ClamAV virus database has changed. Reloading..." << std::endl;
#endif
      ret = loadEngine ();
    }

  return ret;
}

int
ClamEngine::unloadEngine ()
{
  int rc = 0;

  // XXX      here the cl_* stuff should be unloaded
  //          return -1 on error

  return rc;
}

int
ClamEngine::scanFile (const char *_fname)
{
  int rc;

  // clear-out previous err string
  err_str = NULL;

  unsigned int cl_options = CL_ARCHIVE | CL_MAIL | CL_OLE2
#ifdef CL_SCAN_PE
    | CL_SCAN_PE
#else
#warning "CL_SCAN_PE scan flag not supported"
#endif
#ifdef CL_SCAN_HTML
    | CL_SCAN_HTML
#else
#warning "CL_SCAN_HTML scan flag not supported"
#endif
#ifdef CL_SCAN_BLOCKBROKEN
    | (o.cl_detect_broken == 1 ? CL_SCAN_BLOCKBROKEN : 0)
#else
#warning "CL_SCAN_BLOCKBROKEN scan flag not supported"
#endif
#ifdef CL_SCAN_BLOCKENCRYPTED
    | (o.cl_block_encrypted == 1 ? CL_SCAN_BLOCKENCRYPTED : 0)
#else
#ifdef CL_ENCRYPTED
    | (o.cl_block_encrypted == 1 ? CL_ENCRYPTED : 0)
#else
#warning "CL_ENCRYPTED/CL_SCAN_BLOCKENCRYPTED scan flags not supported"
#endif
#endif
    ;

  rc = cl_scanfile (_fname, &virname, NULL, root, &limits, cl_options);

  if (rc == CL_CLEAN)
    {
      return AV_CLEAN;
    }

  if (rc == CL_VIRUS)
    {
      return AV_VIRUS;
    }

  // ok something went wrong
  err_str = cl_strerror (rc);

  return AV_FAIL;
}

const char *
ClamEngine::getVirusName ()
{
  return virname;
}

const char *
ClamEngine::getErrString ()
{
  return err_str;
}

void
ClamEngine::setVirusName (const char *_vname)
{
  vname = _vname;
  virname = vname.c_str ();
}

void
ClamEngine::setErrString (const char *_err_str)
{
  errstr = _err_str;
  err_str = errstr.c_str ();
}
