/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
 

/*******************************************************************/
/*                                                                 */
/*  GLOBAL variables for cfengine                                  */
/*                                                                 */
/*******************************************************************/

#include "cf.defs.h"

char *VERSION = "cfengine-1.1.2\n(C) Free Software Foundation 1995, donated by Mark Burgess, Dept of Computing and Engineering, Oslo College, 0254 Oslo, Norway";

char *VPRECONFIG = "cf.preconf";
char *VRCFILE = "cfrc";

short DEBUG = false;
short D1 = false;
short D2 = false;

short VERBOSE = false;
short TRAVLINKS = false;
short PTRAVLINKS = false;
short DONTDO = false;
short IFCONF = true;
short PARSEONLY = false;
short GOTMOUNTINFO = true;
short NOMOUNTS = false;
short NOFILECHECK = false;
short NOTIDY = false;
short NOSCRIPTS = false;
short PRSYSADM = false;
short MOUNTCHECK = false;
short NOEDITS = false;
short KILLOLDLINKS = false;
short IGNORELOCK = false;
short NOPRECONFIG = false;
short WARNINGS = true;
short MINUSF = false;
short NOLINKS = false;
short ENFORCELINKS = false;
short FORCELINK;

int ERRORCOUNT = 0;

char VINPUTFILE[bufsize];
char VCURRENTFILE[bufsize];
char VLOGFILE[bufsize];
char VSETUIDLOG[bufsize];
FILE *VLOGFP;

int LINENUMBER = 1;
int HAVEUID = 0;
int NUMBEROFEDITS = 0;

struct utsname VSYSNAME;                           /* For uname (2) */
time_t TICKSPERDAY;

mode_t PLUSMASK;
mode_t MINUSMASK;

mode_t DEFAULTMODE = (mode_t) 0755;      /* For files / directories created */
mode_t DEFAULTSYSTEMMODE = (mode_t) 0644;

char   CURRENTITEM[bufsize];
char     GROUPBUFF[bufsize];
char    ACTIONBUFF[bufsize];
char   CURRENTPATH[bufsize];
char     CLASSBUFF[bufsize];
char      LINKFROM[bufsize];
char         ERROR[bufsize];
char     MOUNTFROM[bufsize];
char     MOUNTONTO[bufsize];

char *HASH[hashtablesize];

/******************************************************************/

struct Item VDEFAULTBINSERVER =      /* see GetNameInfo(), main.c */
   {
   NULL,
   NULL
   };

char VBUFF[bufsize];           /* General workspace, contents not guaranteed */
char VUIDNAME[maxvarsize];
char VGIDNAME[maxvarsize];
uid_t VUID;
gid_t VGID;
int VRECURSE;
int VAGE;

enum classes VSYSTEMHARDCLASS;

struct Item *VHEAP = NULL;      /* Points to the base of the attribute heap */
struct Item *VNEGHEAP = NULL;
struct Item *VMOUNTABLES = NULL;         /* Points to the list of mountables */
struct Item *VMOUNTED = NULL;
struct Tidy *VTIDY = NULL;               /* Points to the list of tidy specs */
struct Tidy *VTIDYTOP = NULL;
struct Item *VPROCESSES = NULL;                       /* Points to proc list */
struct Item *VREQUIRED = NULL;              /* List of required file systems */
struct Item *VSCRIPT = NULL;                   /* List of scripts to execute */
struct Mounted *MOUNTED = NULL;             /* Files systems already mounted */
struct MiscMount *VMISCMOUNT = NULL;
struct MiscMount *VMISCMOUNTTOP = NULL;
struct Item *VBINSERVERS = &VDEFAULTBINSERVER;
struct Link *VLINK = NULL;
struct Link *VLINKTOP = NULL;
struct File *VFILE = NULL;
struct File *VFILETOP = NULL;
struct Item *VHOMESERVERS = NULL;
struct Item *VSETUIDLIST = NULL;
struct Item *VDISABLELIST = NULL;
struct File *VMAKEPATH = NULL;
struct File *VMAKEPATHTOP = NULL;
struct Link *VCHLINK = NULL;
struct Link *VCHLINKTOP = NULL;
struct Item *VIGNORE = NULL;
struct Item *VHOMEPATLIST = NULL;
struct Item *VRESOLVE = NULL;
struct Item *VIMPORT=NULL;
struct Item *VACTIONSEQ=NULL;
struct Item *VACCESSLIST=NULL;
struct Item *VADDCLASSES=NULL;
struct Item *VALLADDCLASSES=NULL;
struct Item *VUNMOUNT=NULL;
struct Edit *VEDITLIST=NULL;
struct Edit *VEDITLISTTOP=NULL;
struct Item *VCLASSDEFINE=NULL;


int SENSIBLEFILECOUNT = 2;
int SENSIBLEFSSIZE = 1000;
int EDITFILESIZE = 1000;

char      VFACULTY[maxvarsize];
char       VDOMAIN[maxvarsize];
char       VSYSADM[maxvarsize];
char      VNETMASK[maxvarsize];
char    VBROADCAST[maxvarsize];
char   VMAILSERVER[bufsize];
char     VTIMEZONE[maxvarsize];
char    VMOUNTPATH[maxvarsize];
char VDEFAULTROUTE[maxvarsize];
char      VNFSTYPE[maxvarsize];

/* Parsing flags etc */

enum actions ACTION = none;
enum classes CLASS = empty;
enum fileactions FILEACTION = warnall;

flag ACTION_IS_LINK = false;
flag ACTION_IS_LINKCHILDREN = false;
flag MOUNT_ONTO = false;
flag MOUNT_FROM = false;
flag HAVEPATH = false;
flag ACTIONPENDING = false;

/*********************************************************************/
/* TOOLKIT : actions                                                 */
/*********************************************************************/


char *ACTIONTEXT[] =
   {
   "",
   "Control Defintions:",
   "Groups:",
   "Processes:",
   "Resolve:",
   "Services:",
   "Files:",
   "Tidy:",
   "Home Servers:",
   "Binary Servers:",
   "Mail Server:",
   "Required Filesystems",
   "Reading Mountables",
   "Links:",
   "Import files:",
   "User Shell Commands:",
   "Disable Files:",
   "Make Directory Path:",
   "Ignore File Paths:",
   "Broadcast Mode:",
   "Default Packet Route:",
   "Miscellaneous Mountables:",
   "Edit Simple Text File:",
   "Unmount filesystems:",
   NULL
   };


char *ACTIONID[] =    /* The actions which may be specified as indexed */
   {                    /* macros in the "special" section of the file   */
   "",
   "control",
   "groups",
   "processes",
   "resolve",
   "services",
   "files",
   "tidy",
   "homeservers",
   "binservers",
   "mailserver",
   "required",
   "mountables",
   "links",
   "import",
   "shellcommands",
   "disable",
   "makepath",
   "ignore",
   "broadcast",
   "defaultroute",
   "miscmounts",
   "editfiles",
   NULL
   };


/*********************************************************************/
/* Toolkit: classes                                                  */
/*********************************************************************/

char *DAYTEXT[] =
   {
   "Monday",
   "Tuesday",
   "Wednesday",
   "Thursday",
   "Friday",
   "Saturday",
   "Sunday"
   };

/*********************************************************************/
/* Toolkit: file actions                                             */
/*********************************************************************/

char *FILEACTIONTEXT[] = 
   {
   "warnall",
   "warnplain",
   "warndirs",
   "fixall",
   "fixplain",
   "fixdirs",
   "touch",
   "linkchildren",
   NULL
   };

char *FILEATTRIBUTES[] =
   {
   "recurse",
   "mode",
   "owner",
   "group",
   "age",
   "action",
   "pattern",
   "links",
   "type",
   NULL
   };

/*********************************************************************/

char *ACTIONSEQTEXT[] =
   {
   "directories",
   "links",
   "simplelinks",
   "childlinks",
   "mailcheck",
   "required",
   "tidy",
   "shellcommands",
   "files",
   "disable",
   "addmounts",
   "editfiles",
   "mountall",
   "unmount",
   "resolve",
   "processes",
   "netconfig",
   "checktimezone",
   "mountinfo",
   "none",
   NULL
   };

/*********************************************************************/
/* Varstring: variable names                                         */
/*********************************************************************/

char *VVNAMES[varnames] =
   {
   "faculty",
   "site",
   "host",
   "binserver",
   "sysadm",
   "domain",
   "timezone",
   "netmask",
   "nfstype",
   "sensiblesize",
   "sensiblecount",
   "editfilesize",
   "actionsequence",
   "mountpattern",
   "homepattern",
   "addclasses",
   "access",
   NULL
   };

/*********************************************************************/
/* Edit action names                                                 */
/*********************************************************************/

char *VEDITNAMES[] =
   {
   "NoEdit",
   "DeleteLinesStarting",
   "DeleteLinesContaining",
   "AppendIfNoSuchLine",
   "PrependIfNoSuchLine",
   "WarnIfNoSuchLine",
   "WarnIfLineMatching",
   "WarnIfLineStarting",
   "WarnIfLineContaining",
   "WarnIfNoLineStarting",
   "WarnIfNoLineContaining",
   "HashCommentLinesContaining",
   "HashCommentLinesStarting",
   "HashCommentLinesMatching",
   "SlashCommentLinesContaining",
   "SlashCommentLinesStarting",
   "SlashCommentLinesMatching",
   "PercentCommentLinesContaining",
   "PercentCommentLinesStarting",
   "PercentCommentLinesMatching",
   "NULL"
   };

/*********************************************************************/
/* Signal names                                                      */
/*********************************************************************/

char *SIGNALS[] =
   {
   "",
   "SIGHUP",        /* hangup */
   "SIGINT",        /* interrupt */
   "SIGQUIT",       /* quit */
   "SIGILL",        /* illegal instruction (not reset when caught) */
   "SIGTRAP",       /* trace trap (not reset when caught) */
   "SIGIOT/SIGABRT",/* IOT instruction */
   "SIGEMT",        /* EMT instruction */
   "SIGFPE",        /* floating point exception */
   "SIGKILL",       /* kill (cannot be caught or ignored) */
   "SIGBUS",        /* bus error */
   "SIGSEGV",       /* segmentation violation */
   "SIGSYS",        /* bad argument to system call */
   "SIGPIPE",       /* write on a pipe with no one to read it */
   "SIGALRM",       /* alarm clock */
   "SIGTERM",       /* software termination signal from kill */
   "SIGURG",        /* urgent condition on IO channel */
   "SIGSTOP",       /* sendable stop signal not from tty */
   "SIGTSTP",       /* stop signal from tty */
   "SIGCONT",       /* continue a stopped process */
   "SIGCHLD/SIGCLD",/* to parent on child stop or exit */
   "SIGTTIN",       /* to readers pgrp upon background tty read */
   "SIGTTOU",       /* like TTIN for output if (tp->t_local&LTOSTOP) */
   "SIGIO/SIGPOLL", /* input/output possible signal */
   "SIGXCPU",       /* exceeded CPU time limit */
   "SIGXFSZ",       /* exceeded file size limit */
   "SIGVTALRM",     /* virtual time alarm */
   "SIGPROF",       /* profiling time alarm */
   "SIGWINCH",      /* window changed */
   "SIGLOST",       /* resource lost (eg, record-lock lost) */
   "SIGUSR1",       /* user defined signal 1 */
   "SIGUSR2"
   };



/*********************************************************************/
/* Resource names                                                    */
/*********************************************************************/

char *VRESOURCES[] = /* one for each major variable in class.c */
   {
   "mountcomm",
   "unmountcomm",
   "ethernet",
   "mountopts",
   "unused",
   "fstab",
   "maildir",
   "netstat",
   NULL
   };


/* GNU STUFF FOR LATER #include "getopt.h" */
 
#include "../gnulib/getopt.h"
 
struct option OPTIONS[] =
   {
   { "help",no_argument,0,'h' },
   { "debug",optional_argument,0,'d' }, 
   { "verbose",no_argument,0,'v' },
   { "traverse-links",no_argument,0,'l' },
   { "recon",no_argument,0,'n' },
   { "dry-run",no_argument,0,'n'},
   { "just-print",no_argument,0,'n'},
   { "no-ifconfig",no_argument,0,'i' },
   { "file",required_argument,0,'f' },
   { "parse-only",no_argument,0,'p' },
   { "no-mount",no_argument,0,'m' },
   { "no-check-files",no_argument,0,'c' },
   { "no-check-mounts",no_argument,0,'C' },
   { "no-tidy",no_argument,0,'t' },
   { "no-commands",no_argument,0,'s' },
   { "sysadm",no_argument,0,'a' },
   { "version",no_argument,0,'V' },
   { "define",required_argument,0,'D' },
   { "negate",required_argument,0,'N' },
   { "undefine",required_argument,0,'N' },
   { "delete-stale-links",no_argument,0,'L' },
   { "no-warn",no_argument,0,'w' },
   { "silent",no_argument,0,'w' },
   { "quiet",no_argument,0,'w' },
   { "no-preconf",no_argument,0,'x' },
   { "no-links",no_argument,0,'X'},
   { "no-edits",no_argument,0,'e'},
   { "enforce-links",no_argument,0,'E'},
   { NULL,0,0,0 }
   };



/* EOF */

