#!/bin/sh

if [ $# -ne 2 ]; then
	echo usage: $0 directory extension
	exit 1
fi

if ! cd $1; then
	echo $0: can not cd to $1
	exit 1
fi

ext=$2

function fixman {
	if [ $# -lt 2 ]; then
		echo fixman: called with too few args
		exit 1
	fi

	local base=$1
	shift 1

	for f in $*; do
		if ! ln -sf $base.$ext $f.$ext; then
			echo fixman: cant ln $base.$ext to $f.$ext
		fi
	done
}

fixman TclX dirs commandloop echo infox for_array_keys for_recursive_glob loop popd pushd recursive_glob showproc cmdtrace edprocs profile profrep saveprocs alarm chgrp chmod chown convertclock execl fmtclock chroot fork getclock id kill link mkdir nice readdir rmdir signal sleep system sync times umask unlink wait bsearch copyfile dup fcntl flock for_file funlock fstat lgets frename pipe read_file select write_file server_open server_info scancontext scanfile scanmatch fmathcmds max min random intersect intersect3 lassign lempty lmatch lrmdups lvarcat lvarpop lvarpush union keyedlists keyldel keylget keylkeys keylset cequal cindex clength crange csubstr ctoken cexpand ctype replicate translit catopen catgets catclose intro variables initialize help packagelib auto_commands buildpackageindex convert_lib auto_load loadlibindex auto_packages auto_load_file searchpath
