/* d_coment.c  94.12.09
 * Copyright 1983-1992   Albert Davis
 * processing for COMMENT netlist item (pseudo-device)
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
static 	void    parse_comment(branch_t*,const char*,int*);
static 	void	print_comment(const branch_t*,int,int);
/*--------------------------------------------------------------------------*/
functions_t dev_comment = {
   (generic_t*)NULL,	/* x */
   sizeof(functions_t),	/* ssize */
   sizeof(branch_t),	/* elementsize */
   (functions_t*)NULL,	/* super */
   0, 			/* numnodes */
   rnTEXT,		/* refnode */
   NO,			/* isdevice */
   create_std,		/* create */
   copy_std,		/* copy */
   parse_comment,	/* parse */
   print_comment,	/* print */
   NULL,		/* expand */
   NULL,		/* probe */
   NULL,		/* tr_probe */
   NULL,		/* ac_probe */
   NULL,		/* xprobe */
   NULL,		/* dotr */
   NULL,		/* untr */
   NULL,		/* doac */
   NULL,		/* trfun1 */
   NULL,		/* trfun0 */
   NULL,		/* acfun */
   NULL,		/* tr_guess */
   NULL,		/* tr_advance */
   NULL			/* tr_review */
};
/*--------------------------------------------------------------------------*/
static void parse_comment(branch_t *brh, const char *cmd, int *cnt)
{
 if (cmd[(*cnt)+1] == '+'){	/* throw away comments starting with "*+" */
    brh->f = (functions_t*)NULL;
 }else{
    size_t maxlen = sizeof(branch_t) - (&(brh->label[0]) - (char*)brh);
    (void)strncpy(brh->label, &cmd[*cnt], maxlen);
 }
}
/*--------------------------------------------------------------------------*/
static void print_comment(const branch_t *brh, int where, int detail)
{
 mprintf(where, "%s\n", brh->label);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
