/* d_diode.h  94.10.06
 * Copyright 1983-1992   Albert Davis
 * data structures and defaults for diode model.
 */
#define dDEFMOD_modelname	"-d-"
#define dDEFMOD_js	1e-14
#define dDEFMOD_rs	0.0
#define dDEFMOD_n	1.0
#define dDEFMOD_tt	0.0
#define dDEFMOD_cj	0.0
#define dDEFMOD_pb	1.0
#define dDEFMOD_mj	0.5
#define dDEFMOD_eg	1.11
#define dDEFMOD_xti	3.0
#define dDEFMOD_kf	0.0
#define dDEFMOD_af	1.0
#define dDEFMOD_fc	0.5
#define dDEFMOD_bv	0.0	/* infinity */
#define dDEFMOD_ibv	1e-3
#define dDEFMOD_cjsw	0.0
#define	dDEFMOD_mjsw	0.33
#define dDEFMOD_fcpb	(dDEFMOD_fc * dDEFMOD_pb)

#define dDEFDEV_modelname	dDEFMOD_modelname
#define dDEFDEV_is	NOT_INPUT
#define dDEFDEV_rs	NOT_INPUT
#define dDEFDEV_cj	NOT_INPUT
#define dDEFDEV_cjsw	NOT_INPUT
#define	dDEFDEV_area	1.0
#define dDEFDEV_perim	0.0
#define	dDEFDEV_ic	NOT_INPUT
#define dDEFDEV_off	NO

#define drFORWARD	1
#define	drREVERSE	-1
#define	drINITOFF	-2
#define drUNKNOWN	0

struct diode {
   generic_t	*x;		/* (not used)				*/
   size_t	ssize;
   const struct dmod *m;	/* process dependent model params	*/
   char 	modelname[LABELEN+1];
   double	is;		/* saturation current			*/
   double	rs;		/* series resistance			*/
   double	cj;		/* zero bias jct capacitance		*/
   double	cjsw;		/* zero bias sidewall capacitance	*/
   double	area;		/* area factor				*/
   double	perim;		/* perimeter factor			*/
   double	ic;		/* initial voltage			*/
   int		off;		/* flag: assume reverse biased		*/
   				/* initialized to here			*/
   int		region;		/* fwd, reverse, unknown		*/	
   double	isat;		/* is adjusted for temp, etc.		*/
   double	gd;		/* conductance to pass to capacitor	*/
   struct {
      unsigned	is:1,
      		rs:1,
		cj:1,
		cjsw:1;
   } calc;
   branch_t	*Yj;		/* subckt elements, for probe		*/
   branch_t	*Cj;
};

struct dmod {
   generic_t	*x;		/* owned expansion stuff (not used)	*/
   size_t	ssize;		/* spice2 parameters			*/
   double	js;   /* is  */	/* saturation current (per area)	*/
   double	rs;		/* ohmic resistance (per area)		*/
   double	n;		/* emission coefficient			*/
   double	tt;		/* transit time				*/
   double	cj;   /* cjo */	/* zero-bias jct capacitance (per area)	*/	
   double	pb;   /* vj  */	/* junction potential			*/
   double	mj;   /* m   */	/* grading coefficient			*/
   double	eg;		/* activation energy			*/
   double	xti;		/* saturation-current temp. exp.	*/
   double	kf;		/* flicker noise coefficient		*/
   double	af;		/* flicker noise exponent		*/
   double	fc;		/* coef for fwd bis depl cap formula	*/
   double	bv;		/* reverse breakdown voltage		*/
   double	ibv;		/* current at reverse breakdown		*/
   				/* non-spice extensions			*/
   double	cjsw;		/* zero bias sidewall cap (per perim.)	*/
   double	mjsw;		/* sidewall grading coefficient		*/
   double	fcpb;		/* fc * pb				*/
};
