/* ecah.h  94.07.13
 * Copyright 1983-1992   Albert Davis
 * define assorted stuff
 */
#include "machine.h"

/* misc. constants */
#define RANSCALE	(16384)
#define RANOFSET	(16384)
#define kPIx2		(6.2831853071795864769252867665590057683944)
#define kPI		(3.1415926535897932384626433832795028841972)
#define kPId2		(1.5707963267948966192313216916397514420986)
#define DTOR		(0.0174532925199432957692369076848861271344)
#define RTOD	       (57.2957795130823208768)
#define ONE_OVER_PI	(0.3183098861837906715377675267450287240689)
#define ABS_ZERO     (-273.15)
#define	E_0	(8.854214871e-12)  /* permittivity of air 		  */
#define	E_SI	(11.7*E_0)	   /* permittivity of silicon (1.0359e-10)*/
#define	E_OX	(3.9*E_0)	   /* permittivity of oxide (3.45e-11)	  */
#define K       (1.3806226e-23)    /* Boltzmann's constant		  */
#define Q       (1.6021918e-19)    /* electronic charge			  */
#define NOT_INPUT   (-(MAXDOUBLE)*(.8347658))	/* unlikely number	  */
#define NOT_VALID   (-(MAXDOUBLE)*(.8547958))	/* unlikely number	  */
#define LINEAR	    (-(MAXDOUBLE)*(.8747958))	/* unlikely number	  */
#define BIGBIG	    ( (MAXDOUBLE)*(.9747958))	/* unlikely number	  */
#define VOLTMIN	    (1.0e-50)
#define DBVOLTMIN   (20.*log10(VOLTMIN))
#define PWRMIN	    (1.0e-100)
#define DBPWRMIN    (10.*log10(PWRMIN))
#define TOKENTERM   ",=()[]"

#define	YES	(1)
#define	NO	(0)
#define	MAYBE	(-YES)
#define	BAD	(-1)
#define	GOOD	(0)

#define to_upper(c)	((islower(c)) ? (toupper(c)) : (c))
#define to_lower(c)	((isupper(c)) ? (tolower(c)) : (c))
#define CABS(z)		(hypot((z).x,(z).y))
#define uporder(a,b,c)	((a)<=(b) && (b)<=(c))
#define inorder(a,b,c)	(uporder(a,b,c) || uporder(c,b,a))
#define conchk(o,n,a)	((fabs((n)-(o))<=(a))\
	|| (fabs(o)>(a) && uporder(opt.lowlim, (n)/(o), opt.uplim)))
#define torange(a,b,c)	(MIN(MAX((a),(b)),(c)))
#ifdef MAX
#undef MAX
#endif
#define MAX(x,y)    ( ((x)>(y)) ? (x) : (y) )
#ifdef MIN
#undef MIN
#endif
#define MIN(x,y)    ( ((x)<(y)) ? (x) : (y) )

typedef struct {	/* first order polynomial	*/
   double  x;		/* the argument			*/
   double  f0;		/* the function (c0 + x*f1)	*/
   double  f1;		/* the first derivative		*/
} fpoly1_t;

typedef struct {	/* first order polynomial	*/
   double  x;		/* the argument			*/
   double  c0;		/* f(x) - x*f'(x), or f0 - x*f1 */
   double  f1;		/* the first derivative		*/
} cpoly1_t;

typedef struct {
   double  mag;
   double  phz;
} polar_t;

typedef struct mc {	/* monte-carlo  data collection	*/
   double  s1 ;		/* sum				*/
   double  s2 ;		/* sum of squares		*/
   double  min;		/* min sample			*/
   double  max;		/* max sample			*/
   double  sample;	/* most recent sample		*/
} mc_t;

typedef struct {
   double x;
   double y;
} complex_t;
