/* help.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * Accesses a help file to provide on-line documentation.
 * Will follow the executables path to find it.
 */
#include "ecah.h"
#include "error.h"
#include "io.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_help(const char*,int*);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern const char e_int[];
/*--------------------------------------------------------------------------*/
void cmd_help(const char *cmd, int *cnt)
{
 static FILE *hfn;
 char buffer[BUFLEN];
 char *name;

 if (hfn)
    (void)fclose(hfn);
 name = findfile(HELPFILE, HELPPATH, R_OK);
 if (!name)
    error(bERROR, "Help not available\n");
 hfn = fopen(name, "r");
 if (!hfn)
    error(bERROR, e_int, "help");
 if (cmd[*cnt])
    do {
       if (!fgets(buffer, BUFLEN, hfn)) {
	  error(bWARNING, "No help on %s\n", &cmd[*cnt]);
	  break;
       }
    } while (buffer[0]!=':'  ||  !pmatch(cmd,cnt,&buffer[1]));

 for (;;) {
    if (!fgets(buffer,BUFLEN,hfn))
       break;
    if (buffer[0]==':')
       break;
    mputs(buffer,io.mstderr);
 }
 (void)fclose(hfn);
 hfn = (FILE*)NULL;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
