/* polar.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Functions for use in converting to and from polar coordinates, etc.
 */
#include "ecah.h"
#include "options.h"
#include "declare.h"
/*LINTLIBRARY*/
/*--------------------------------------------------------------------------*/
	complex_t polartocomplex(polar_t);
	polar_t	  complextopolar(complex_t);
	double	  real(double,double);
	double	  imag(double,double);
	double	  phase(double,double);
	double	  db(double);
/*--------------------------------------------------------------------------*/
extern const struct options opt;
/*--------------------------------------------------------------------------*/
complex_t polartocomplex(polar_t p)
{
 complex_t c;
 c.x = p.mag * cos(p.phz*DTOR);
 c.y = p.mag * sin(p.phz*DTOR);
 return c;
}
/*--------------------------------------------------------------------------*/
polar_t complextopolar(complex_t c)
{
 polar_t p;
 p.mag = CABS(c);
 p.phz = RTOD * atan2(c.y,c.x);
 return p;
}
/*--------------------------------------------------------------------------*/
double real(double mag, double phase)
{
 return ( mag * cos(phase*DTOR) );
}
/*--------------------------------------------------------------------------*/
double imag(double mag, double phase)
{
 return ( mag * sin(phase*DTOR) );
}
/*--------------------------------------------------------------------------*/
double phase(double real, double imag)
{
 return ( RTOD * atan2(imag,real) );
}
/*--------------------------------------------------------------------------*/
double db(double value)
{
 return ( value<1.001e-50 || value<opt.floor ) ? -999.999 : (20*log10(value));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
