/* tr_conck.c  93.12.21
 * Copyright 1983-1992   Albert Davis
 * Check convergence, and other stuff done after evaluation
 * to evaluate performance
 */
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "io.h"
#include "options.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	int	conv_check(const branch_t*);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern const struct options opt;
extern const struct status stats;
/*--------------------------------------------------------------------------*/
/* conv_check: check branch for convergence
 * should be a macro, for speed
 */
int conv_check(const branch_t *brh)
{
 int converged;
   
    converged = conchk(brh->y1.f0,brh->y0.f0,opt.abstol);
    if ((stats.iter[iSTEP] >= opt.itl[8]) && !converged){
       error(bPICKY,"%s: non-convergence: (f0) (%s,%s,%s)\n",
          printlabel(brh,NO),
          ftos(brh->y0.f0, "", 7, 0),
          ftos(brh->y1.f0, "", 7, 0),
          ftos(brh->y2.f0, "", 7, 0));
       if (!conchk(brh->y1.f1,brh->y0.f1,opt.abstol)){
          error(bPICKY,"%s: non-convergence: (f1) (%s,%s,%s)\n",
	     printlabel(brh,NO),
	     ftos(brh->y0.f1, "", 7, 0),
    	     ftos(brh->y1.f1, "", 7, 0),
	     ftos(brh->y2.f1, "", 7, 0));
       }else{
          error(bPICKY,"%s: f1 is ok\n", printlabel(brh,NO));
       }
    }


 if (converged){
    converged = conchk(brh->y1.f1,brh->y0.f1,opt.abstol);
    if ((stats.iter[iSTEP] >= opt.itl[8]) && !converged){
       error(bPICKY,"%s: non-convergence: (f1 only) (%s,%s,%s)\n",
	  printlabel(brh,NO),
	  ftos(brh->y0.f1, "", 7, 0),
    	  ftos(brh->y1.f1, "", 7, 0),
	  ftos(brh->y2.f1, "", 7, 0));
    }
 }
 return converged;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
