/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: variable.h,v 35004.4 1995/08/23 02:53:46 hawkeye Exp $ */

#ifndef VARIABLE_H
#define VARIABLE_H

/*********************************************
 * Internal, user, and environment variables *
 *********************************************/

typedef void NDECL((Toggler));

typedef struct Var {
    CONST char *name;
    CONST char *value;
    int flags;
    CONST char **enumvec;	/* list of valid string values */
    long ival;			/* integer value */
    Toggler *func;		/* called when ival changes */
    struct ListEntry *node;	/* backpointer to node in list */
} Var;

struct List;  /* incomplete declaration of struct List */

extern void  NDECL(init_variables);
extern int   FDECL(enum2int,(CONST char *str, CONST char **vec, CONST char *msg));
extern CONST char *FDECL(getnearestvar,(CONST char *name, long *np));
extern CONST char *FDECL(getvar,(CONST char *name));
extern CONST char *FDECL(setnearestvar,(CONST char *name, CONST char *value));
extern CONST char *FDECL(setvar,(CONST char *name, CONST char *value, int exportflag));
extern void  FDECL(setivar,(CONST char *name, long value, int exportflag));
extern int   FDECL(do_set,(CONST char *args, int exportflag, int localflag));
extern void  FDECL(newvarscope,(struct List *level));
extern void  NDECL(nukevarscope);

/* Must be in the same order as enum_emul[].  This shouldn't really be here. */
enum {
    EMUL_RAW, EMUL_PRINT, EMUL_ANSI_STRIP, EMUL_ANSI_ATTR,
    EMUL_DEBUG
};

/* These must be in same order as special_var (sorted by user name) */
enum Vars {
    VAR_MAIL        ,      /* All caps. */
    VAR_TERM        ,      /* All caps. */
    VAR_TFHELP      ,      /* All caps. */
    VAR_TFLIBDIR    ,      /* All caps. */
    VAR_TFLIBRARY   ,      /* All caps. */
    VAR_ALWAYS_ECHO ,
    VAR_BACKGROUND  ,
    VAR_BACKSLASH   ,
    VAR_BAMF        ,
    VAR_BEEP        ,
    VAR_BG_OUTPUT   ,
    VAR_BORG        ,
    VAR_CLEARDONE   ,
    VAR_CLEARFULL   ,
    VAR_CLOCK       ,
    VAR_EMULATION   ,
    VAR_GAG         ,
    VAR_GETHOSTBYNAME,
    VAR_GPRI        ,
    VAR_HILITE      ,
    VAR_HILITEATTR  ,
    VAR_HISTSIZE    ,
    VAR_HOOKFLAG    ,      /* user name is "hook" */
    VAR_HPRI        ,
    VAR_IGNORE_SIGQUIT ,
    VAR_INSERT      ,
    VAR_ISIZE       ,
    VAR_ISTRIP      ,
    VAR_KECHO       ,
    VAR_KPREFIX     ,
    VAR_LOGIN       ,
    VAR_LPFLAG      ,      /* user name is "lp" */
    VAR_LPQUOTE     ,
    VAR_MAILDELAY   ,
    VAR_MATCHING    ,
    VAR_MAX_ITER    ,
    VAR_MAX_RECUR   ,
    VAR_MECHO       ,
    VAR_MORE        ,
    VAR_MPREFIX     ,
    VAR_OLDSLASH    ,
    VAR_PROMPT_SEC  ,
    VAR_PROMPT_USEC ,
    VAR_PROXY_HOST  ,
    VAR_PROXY_PORT  ,
    VAR_PROCESS_TIME,      /* user name is "ptime" */
    VAR_QECHO       ,
    VAR_QPREFIX     ,
    VAR_QUIET       ,
    VAR_QUITDONE    ,
    VAR_REDEF       ,
    VAR_REFRESHTIME ,
    VAR_SCROLL      ,
    VAR_SHPAUSE     ,
    VAR_SNARF       ,
    VAR_SOCKMLOAD   ,
    VAR_SUB         ,
    VAR_TABSIZE     ,
    VAR_TELOPT      ,
    VAR_TIME_FORMAT ,
    VAR_VISUAL      ,
    VAR_WATCHDOG    ,
    VAR_WATCHNAME   ,
    VAR_WORDPUNCT   ,
    VAR_WRAPFLAG    ,      /* user name is "wrap" */
    VAR_WRAPLOG     ,
    VAR_WRAPSIZE    ,
    VAR_WRAPSPACE   ,
    NUM_VARS               /* not a Var, but a count */
};

/* Convenient variable access.
 * These macros are READONLY.  Use setvar() to change a value.
 * The cast enforces the readonly-ness in ANSI C (gcc needs -pedantic).
 */
#define MAIL		((char*)special_var[ VAR_MAIL		].value)
#define TERM		((char*)special_var[ VAR_TERM		].value)
#define TFHELP		((char*)special_var[ VAR_TFHELP		].value)
#define TFLIBDIR	((char*)special_var[ VAR_TFLIBDIR	].value)
#define TFLIBRARY	((char*)special_var[ VAR_TFLIBRARY	].value)
#define always_echo	((long)	special_var[ VAR_ALWAYS_ECHO	].ival)
#define background	((long)	special_var[ VAR_BACKGROUND	].ival)
#define backslash	((long)	special_var[ VAR_BACKSLASH	].ival)
#define bamf		((long)	special_var[ VAR_BAMF		].ival)
#define beep		((long)	special_var[ VAR_BEEP		].ival)
#define bg_output	((long)	special_var[ VAR_BG_OUTPUT	].ival)
#define borg		((long)	special_var[ VAR_BORG		].ival)
#define cleardone	((long)	special_var[ VAR_CLEARDONE	].ival)
#define clearfull	((long)	special_var[ VAR_CLEARFULL	].ival)
#define clock_flag	((long)	special_var[ VAR_CLOCK		].ival)
#define emulation 	((long)	special_var[ VAR_EMULATION	].ival)
#define gag		((long)	special_var[ VAR_GAG		].ival)
#define is_gethost_nb	((long)	special_var[ VAR_GETHOSTBYNAME	].ival)
#define gpri		((long)	special_var[ VAR_GPRI		].ival)
#define hilite		((long)	special_var[ VAR_HILITE		].ival)
#define hiliteattr	((long)	special_var[ VAR_HILITEATTR	].ival)
#define histsize	((long)	special_var[ VAR_HISTSIZE	].ival)
#define hookflag	((long)	special_var[ VAR_HOOKFLAG	].ival)
#define hpri		((long)	special_var[ VAR_HPRI		].ival)
#define ignore_sigquit	((long)	special_var[ VAR_IGNORE_SIGQUIT	].ival)
#define insert		((long)	special_var[ VAR_INSERT		].ival)
#define isize		((long)	special_var[ VAR_ISIZE		].ival)
#define istrip		((long)	special_var[ VAR_ISTRIP		].ival)
#define kecho		((long)	special_var[ VAR_KECHO		].ival)
#define kprefix		((char*)special_var[ VAR_KPREFIX	].value)
#define login		((long)	special_var[ VAR_LOGIN		].ival)
#define lpflag		((long)	special_var[ VAR_LPFLAG		].ival)
#define lpquote		((long)	special_var[ VAR_LPQUOTE	].ival)
#define maildelay	((long)	special_var[ VAR_MAILDELAY	].ival)
#define matching	((long)	special_var[ VAR_MATCHING	].ival)
#define max_iter	((long)	special_var[ VAR_MAX_ITER	].ival)
#define max_recur	((long)	special_var[ VAR_MAX_RECUR	].ival)
#define mecho		((long)	special_var[ VAR_MECHO		].ival)
#define more		((long)	special_var[ VAR_MORE		].ival)
#define mprefix		((char*)special_var[ VAR_MPREFIX	].value)
#define oldslash	((long)	special_var[ VAR_OLDSLASH	].ival)
#define prompt_sec	((long)	special_var[ VAR_PROMPT_SEC	].ival)
#define prompt_usec	((long)	special_var[ VAR_PROMPT_USEC	].ival)
#define proxy_host	((char*)special_var[ VAR_PROXY_HOST	].value)
#define proxy_port	((char*)special_var[ VAR_PROXY_PORT	].value)
#define process_time	((long)	special_var[ VAR_PROCESS_TIME	].ival)
#define qecho		((long)	special_var[ VAR_QECHO		].ival)
#define qprefix		((char*)special_var[ VAR_QPREFIX	].value)
#define quiet		((long)	special_var[ VAR_QUIET		].ival)
#define quitdone	((long)	special_var[ VAR_QUITDONE	].ival)
#define redef		((long)	special_var[ VAR_REDEF		].ival)
#define refreshtime	((long)	special_var[ VAR_REFRESHTIME	].ival)
#define scroll		((long)	special_var[ VAR_SCROLL		].ival)
#define shpause		((long)	special_var[ VAR_SHPAUSE	].ival)
#define snarf		((long)	special_var[ VAR_SNARF		].ival)
#define sockmload	((long)	special_var[ VAR_SOCKMLOAD	].ival)
#define sub		((long)	special_var[ VAR_SUB		].ival)
#define tabsize		((long)	special_var[ VAR_TABSIZE	].ival)
#define telopt		((long)	special_var[ VAR_TELOPT		].ival)
#define time_format	((char*)special_var[ VAR_TIME_FORMAT	].value)
#define visual		((long)	special_var[ VAR_VISUAL		].ival)
#define watchdog	((long)	special_var[ VAR_WATCHDOG	].ival)
#define watchname	((long)	special_var[ VAR_WATCHNAME	].ival)
#define wordpunct	((char*)special_var[ VAR_WORDPUNCT	].value)
#define wrapflag	((long)	special_var[ VAR_WRAPFLAG	].ival)
#define wraplog		((long)	special_var[ VAR_WRAPLOG	].ival)
#define wrapsize	((long)	special_var[ VAR_WRAPSIZE	].ival)
#define wrapspace	((long)	special_var[ VAR_WRAPSPACE	].ival)

extern Var special_var[];

#endif /* VARIABLE_H */
