# Copyright (c) 1993 by Sanjay Ghemawat
#
# Startup script for X-based ical

proc ical_tk_script {} {
    # Parse arguments (some argument parsing has already been done
    # by startup.tcl)
    global argv ical

    set popup 0
    while {[llength $argv] != 0} {
	set arg [lindex $argv 0]
	set argv [lrange $argv 1 end]

	case $arg in {
	    "-popup" {set popup 1}
	    default  {ical_usage}
	}
    }

    # Load calendar
    calendar cal $ical(calendar)

    if {$popup} {
	# Create item listing
	set l [ItemListing]
	$l mainwindow
	$l dayrange [date today] [date today]
	if {$ical(geometry) != ""} {
	    catch {wm geometry [$l window] $ical(geometry)}
	}
    } else {
	# Various background threads
	io_thread
	start_alarmer
	start_midnight_thread

	# Create initial view
	set dv [ical_newview]
	if {$ical(iconic)} {wm iconify [$dv window]}
	if {$ical(geometry) != ""} {
	    catch {wm geometry [$dv window] $ical(geometry)}
	}
	if {$ical(iconposition) != ""} {
	    eval [list wm iconposition [$dv window]] $ical(iconposition)
	}
    }
}

# Handle background errors
proc tkerror {message} {
    global ical errorInfo

    # Ignore color allocation errors
    if [string match "no more colors left in colormap;*" $message] {
	error_notify "" [join {
	    {Ical could not allocate the colors it needed.  Monochrome}
	    {mode will be used from now on if necessary.}
	}]
	return
    }

    set message "Ical Version $ical(version)\n\n$message\n\nTrace:\n$errorInfo"
    bug_notify $ical(mailer) $ical(author) $message
}
