#!/bin/sh

PNAME=`basename $0`

USAGE='echo \
	"usage: $PNAME \
 (status|dumpdb|reload|stats|trace|notrace|querylog|start|stop|restart) \
	 ... \
	"; exit 1'

PATH=%DESTSBIN%:/bin:/usr/bin:/usr/ucb:$PATH
PIDFILE=%PIDDIR%/named.pid

[ -f $PIDFILE ] || {
	echo "$PNAME: $PIDFILE does not exist"
	exit 1
}
PID=`cat $PIDFILE`
PS=`%PS% $PID 2>/dev/null| tail -1 | grep $PID`
RUNNING=1
[ `echo $PS | wc -w` -ne 0 ] || {
	PS="named (pid $PID?) not running"
	RUNNING=0
}

for ARG
do
	case $ARG in
	start|stop|restart)
		;;
	*)
		[ $RUNNING -eq 0 ] && {
			echo $PS
			exit 1
		}
	esac

	case $ARG in
	status)	echo "$PS";;
	dumpdb)	kill -INT $PID && echo Dumping Database;;
	reload)	kill -HUP $PID && echo Reloading Database;;
	stats)	kill -%IOT% $PID && echo Dumping Statistics;;
	trace)	kill -USR1 $PID && echo Trace Level Incremented;;
	notrace) kill -USR2 $PID && echo Tracing Cleared;;
	querylog|qrylog) kill -WINCH $PID && echo Query Logging Toggled;;
	start)
		[ $RUNNING -eq 1 ] && {
			echo "$PNAME: start: named (pid $PID) already running"
			continue
		}
		%INDOT%named && echo Name Server Started
		;;
	stop)
		[ $RUNNING -eq 0 ] && {
			echo "$PNAME: stop: named not running"
			continue
		}
		kill $PID && {
			sleep 5
			echo Name Server Stopped
		}
		;;
	restart)
		[ $RUNNING -eq 1 ] && {
			kill $PID && sleep 5
		}
		%INDOT%named && echo Name Server Restarted
		;;
	*)	eval "$USAGE";;
	esac
done
test -z "$ARG" && eval "$USAGE"

exit 0
