/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#ifdef _PGPPATH

#define PGPENCRYPT 1
#define PGPSIGN    2
#define PGPKEY     4

typedef struct keyinfo
{
  char *keyid;
  ADDRESS *address;
  struct keyinfo *next;
  short revoked;
  short keylen;
} KEYINFO;

BODY *pgp_decrypt_part (BODY *, STATE *, FILE *);

int pgp_query (BODY *);
int pgp_valid_passphrase (void);
int pgp_protect (HEADER *);

void application_pgp_handler (BODY *, STATE *);
void pgp_signed_handler (BODY *, STATE *);
void pgp_encrypted_handler (BODY *, STATE *);
void pgp_void_passphrase (void);

char *pgp_ask_for_key (int, KEYINFO *, char *);

KEYINFO *ki_getdb (int);
char *ki_getkeybyaddr (ADDRESS *, KEYINFO *);
char *ki_getkeybystr (char *, KEYINFO *);
void ki_closedb (KEYINFO *);

#endif /* _PGPPATH */
