// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _LYXFONT_H
#define _LYXFONT_H

enum { // LYX_FONT_FAMILY
	LYX_ROMAN_FAMILY,
	LYX_SANS_FAMILY,
	LYX_TYPEWRITER_FAMILY,
	LYX_MODERN_FAMILY,	       /* obsolete */
	LYX_SYMBOL_FAMILY
};

enum { // LYX_FONT_SERIES
	LYX_MEDIUM_SERIES,
	LYX_BOLD_SERIES
};

enum { // LYX_FONT_SHAPE
	LYX_UP_SHAPE,
	LYX_ITALIC_SHAPE,
	LYX_SMALLCAPS_SHAPE
};

enum { // LYX_FONT_SHAPE
	LYX_SIZE_TINY,
	LYX_SIZE_SMALL,
	LYX_SIZE_NORMAL,
	LYX_SIZE_LARGE,
	LYX_SIZE_LARGER,
	LYX_SIZE_LARGEST,
	LYX_SIZE_HUGE,
	LYX_SIZE_GIANT
};

enum LYX_FONT_BAR {
	LYX_NO_BAR,
	LYX_UNDER_BAR
};

#define LYX_NO_FONT_CHANGE 98

struct LyXFont  {
	LyXFont() {
		family = LYX_NO_FONT_CHANGE; // or shold these be
		series = LYX_NO_FONT_CHANGE; // initialized to 0
		shape = LYX_NO_FONT_CHANGE;
		size = LYX_NO_FONT_CHANGE;
		latex = LYX_NO_FONT_CHANGE;
		bar = LYX_NO_FONT_CHANGE;
	}
	void setFont(char f, char se, char sh, char si = LYX_NO_FONT_CHANGE/*POSSIBLE BUG*/, char l = LYX_NO_FONT_CHANGE, char b= LYX_NO_FONT_CHANGE) {
		family = f;
		series = se;
		shape = sh;
		size = si;
		latex = l;
		bar = b;
	}
  char family;
  char series;
  char shape;
  char size;
   
  char latex; /* a boolean flag */ 
  char bar;
};

extern char* roman_font_name;
extern char* sans_font_name;
extern char* typewriter_font_name;
extern char* font_norm;
extern char font_sizes[];

extern LyXFont GetLyXFont(char family, char series, char shape, char size, 
		   char latex, char bar);
extern int LyXStringWidth(LyXFont font, char *s);

inline
int FontEqual(LyXFont font1, LyXFont font2) {
  return (font1.family == font2.family 
	  && font1.series == font2.series
	  && font1.shape == font2.shape
	  && font1.size == font2.size
	  && font1.latex == font2.latex
	  && font1.bar == font2.bar);
}
#endif


