#include "forms.h"
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>

/**** Forms and Objects ****/

typedef struct {
	FL_FORM *form0;
	FL_OBJECT *timer;
	FL_OBJECT *report;
	void *vdata;
	long ldata;
} FD_form0;

extern FD_form0 * create_form_form0(void);
FD_form0 *fd_form0;



#define TIMEOUT  20.0

/* callbacks for form form0 */
void exit_cb(FL_OBJECT *ob, long data)
{
  /* fill-in code for callback */
  exit(0);
}

struct timeval start, end;

void timer_cb(FL_OBJECT *ob, long data)
{
  char buf[128];
  float df;

  gettimeofday(&end, 0);

  df = end.tv_sec - start.tv_sec +
       (end.tv_usec - start.tv_usec)/1000000.0;

  sprintf(buf,"Timeout: %.1f Actual:%.1f",TIMEOUT, df);
  fl_set_object_label(fd_form0->report,buf);
}


int main(int argc, char *argv[])
{

   fl_initialize(&argc, argv, 0, 0, 0);
   fd_form0 = create_form_form0();
   fl_set_timer(fd_form0->timer, TIMEOUT);
   gettimeofday(&start, 0);

   /* fill-in form initialization code */

   /* show the first form */
   fl_show_form(fd_form0->form0,FL_PLACE_FREE_CENTER,FL_FULLBORDER,"form0");
   XSync(fl_display,0);
   fl_freeze_form(fd_form0->form0);
   fl_do_forms();
   return 0;
}
/* Form definition file generated with fdesign. */

#include "forms.h"
#include <stdlib.h>

FD_form0 *create_form_form0(void)
{
  FL_OBJECT *obj;
  FD_form0 *fdui = (FD_form0 *) fl_calloc(1, sizeof(*fdui));

  fdui->form0 = fl_bgn_form(FL_NO_BOX, 320, 250);
  obj = fl_add_box(FL_UP_BOX,0,0,320,250,"");
  obj = fl_add_button(FL_NORMAL_BUTTON,210,200,90,30,"Done");
    fl_set_object_callback(obj,exit_cb,0);
  fdui->timer = obj = fl_add_timer(FL_HIDDEN_TIMER,10,40,100,40,"Timer");
    fl_set_object_callback(obj,timer_cb,0);
  fdui->report = obj = fl_add_text(FL_NORMAL_TEXT,50,110,230,50,"");
  fl_end_form();

  fl_scale_form(fdui->form0,0.8,0.8);

  return fdui;
}
/*---------------------------------------*/


