/***************************************************************************
**    xIrcConnect3.cpp  $Revision: 1.7 $ - $Name: V1-17B $ 
**    Class for making the server connections Part 3
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qmenubar.h>
#include <xLineEditQuery.h>
#include "xIrcCommands.h"
#include "xIrcErrorBox.h"
#include "xDefaults.h"
#include "xIrcConnect.h"

static int dbg = 0;

extern xLineEditQuery *KickQuery;
extern xIrcCommands ircResponses;

void xIrcConnect::nickActionHandler(xMultiLineTextSelection txtSel)
{
   int err;
   char buf[256];
   const char *cp;
   xIrcMessage msg;
   xIrcMessageFrame *pMsg;
   xIrcDccChatFrame *pDccChatFrame;

   switch (txtSel.iData)
   {
      case xIrcNickActionQuery::DccChat:
         struct sockaddr_in addr = pSocket->socketName();
         sprintf(buf, "%d", addr.sin_addr.s_addr);
         if ((pDccChatFrame = new xIrcDccChatFrame(wdtPrv, NULL, txtSel.text)) != NULL)
         {
            connect(pDccChatFrame, SIGNAL(initiateDCCChat(xIrcDccChatFrame*)),
                    this, SLOT(initiateDCCChat(xIrcDccChatFrame*)));
            if ((err = pDccChatFrame->accept()) == 0)
            {
               connect(pDccChatFrame, SIGNAL(textSelected(xMultiLineTextSelection)),
                       pNickAction, SLOT(wakeUp(xMultiLineTextSelection)));
               pDccChatFrame->show();
            }
            else
            {
               sprintf(buf, "Error Accepting Connection from %s:%s",
                            (const char *)txtSel.text, strerror(err));
               QMessageBox::message("Error", buf);
               disconnect(pDccChatFrame, SIGNAL(initiateDCCChat(xIrcDccChatFrame*)),
                          this, SLOT(initiateDCCChat(xIrcDccChatFrame*)));
               delete pDccChatFrame;
            }
         }
         return;
                  
      case xIrcNickActionQuery::PrivChat:
         if (findMsgFrame(txtSel.text) == NULL)
         {
            if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Creating Message Frame\n");
            if (dbg) fflush(stdout);
            if ((pMsg = makeNewMsgFrame(NULL, txtSel.text)) != NULL)
            {
               if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Showing Message Frame\n");
               if (dbg) fflush(stdout);
               pMsg->show();
               if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Getting channel name\n");
               if (dbg) fflush(stdout);
               cp = txtSel.text;
               if (*cp == '#')
               {
                  if (dbg) fprintf(stdout, "xIrcConnect::gotChannelBoxResults():Joining channel\n");
                  if (dbg) fflush(stdout);
                  sprintf(buf, "JOIN %s\n", (const char *)txtSel.text);
                  emit textOut(buf);
               }
            }     
         }
         else
            QMessageBox::message("Error", "Channel already opened");
         pNickAction->hide();
         return;

      case xIrcNickActionQuery::Kick:
         cp = txtSel.winName;
         if (*cp != '#')
         {
            QMessageBox::message("Error", "Channel not specified!!");
            return;
         }
         else if (KickQuery->exec() != QDialog::Rejected)
         {
            msg.rspCode = ircResponses.code("KICK");
            msg.dstStr = txtSel.winName;
            msg.dstStr += ' ';
            msg.dstStr += txtSel.text;
            msg.msgStr = KickQuery->text();
         }
         else
            return;
         break;

      case xIrcNickActionQuery::WhoIs:
         msg.rspCode = ircResponses.code("WHOIS");
         msg.dstStr = txtSel.text;
         msg.msgStr = "";
         break;

      case xIrcNickActionQuery::Who:
         msg.rspCode = ircResponses.code("WHO");
         msg.dstStr = txtSel.text;
         msg.msgStr = "";
         break;

      case xIrcNickActionQuery::Ping:
         sprintf(buf, "%ld", time(NULL));
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = txtSel.text;
         msg.msgStr = "\x01";
         msg.msgStr += "PING ";
         msg.msgStr += buf;
         msg.msgStr += "\x01";
         break;

      case xIrcNickActionQuery::Ban:
         cp = txtSel.winName;
         if (*cp != '#')
         {
            QMessageBox::message("Error", "Channel not specified!!");
            return;
         }
         else
         {
            banFlag = TRUE;
            banChan = txtSel.winName;
            banNick = txtSel.text;
            msg.rspCode = ircResponses.code("WHO");
            msg.dstStr = txtSel.text;
            msg.msgStr = "";
         }
         break;

      case xIrcNickActionQuery::GiveOps:
         cp = txtSel.winName;
         if (*cp != '#')
         {
            QMessageBox::message("Error", "Channel not specified!!");
            return;
         }
         else
         {
            msg.rspCode = ircResponses.code("MODE");
            msg.dstStr = txtSel.winName;
            msg.dstStr += " +o ";
            msg.dstStr += txtSel.text;
            msg.msgStr = "";
         }
         break;

      case xIrcNickActionQuery::TakeOps:
         cp = txtSel.winName;
         if (*cp != '#')
         {
            QMessageBox::message("Error", "Channel not specified!!");
            return;
         }
         else
         {
            msg.rspCode = ircResponses.code("MODE");
            msg.dstStr = txtSel.winName;
            msg.dstStr += " -o ";
            msg.dstStr += txtSel.text;
            msg.msgStr = "";
         }
         break;

      case xIrcNickActionQuery::WhoWas:
         msg.rspCode = ircResponses.code("WHOWAS");
         msg.dstStr = txtSel.text;
         msg.msgStr = "";
         break;

      case xIrcNickActionQuery::UserInfo:
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = txtSel.text;
         msg.msgStr = "\x01";
         msg.msgStr += "USERINFO";
         msg.msgStr += "\x01";
         break;

      case xIrcNickActionQuery::Time:
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = txtSel.text;
         msg.msgStr = "\x01";
         msg.msgStr += "TIME";
         msg.msgStr += "\x01";
         break;

      case xIrcNickActionQuery::Finger:
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = txtSel.text;
         msg.msgStr = "\x01";
         msg.msgStr += "FINGER";
         msg.msgStr += "\x01";
         break;

      case xIrcNickActionQuery::Version:
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = txtSel.text;
         msg.msgStr = "\x01";
         msg.msgStr += "VERSION";
         msg.msgStr += "\x01";
         break;

      case xIrcNickActionQuery::Close:
         pNickAction->hide();
         return;
   }
   emit msgOut(&msg);
//   pNickAction->hide();
}

QString xIrcConnect::buildBanMask(xIrcMessage *pMsg)
{
   QString rv("*!");
   const char *cp;

   if (pMsg->rspCode == 352)
   {
      cp = pMsg->dstStr;
      if (*cp != '#')
      {
         rv += pMsg->dstStr;
         for (cp = pMsg->msgStr; *cp == ' '; cp++);
      }
      else
      {
         for (cp = pMsg->msgStr; *cp == ' '; cp++);
         for (; *cp != ' '; cp++)
            rv += *cp;
      }
      rv += "@";
      for (; *cp == ' '; cp++);
      if (isdigit(*cp))
      {
         for (; *cp != ' '; cp++)
            rv += *cp;
      }
      else
      {
         rv += "*";
         for (; *cp != '.'; cp++);
         for (; *cp != ' '; cp++)
            rv += *cp;
      }
   }
   else
      rv = "";
   return(rv);
}
         
