//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "netoutmeter.h"
#include "xosview.h"


NetOutMeter::NetOutMeter(XOSView *parent, int x, int y, 
			 int width, int height, float max )
: FieldMeter( parent, x, y, width, height, 2, "OUT", "PACKETS/SEC" ){
  maxpackets_ = max;
  parent_->addResource( "netOutColor", NULL, "lightblue" );
  parent_->addResource( "netOutBackground", NULL, "green2" );
  priority_ = 2;
}

NetOutMeter::~NetOutMeter( void ){
}

void NetOutMeter::checkResources( void ){
  FieldMeter::checkResources();

  setfieldcolor( 0, parent_->getResource( "netOutColor" ) );
  setfieldcolor( 1, parent_->getResource( "netOutBackground" ) );
}

void NetOutMeter::checkevent( void ){
  NetMeter::checkevent();
  total_ = maxpackets_;
  fields_[0] = outgoing();
  if ( fields_[0] < 0 ) fields_[0] = 0;
  if ( fields_[0] > total_ ) fields_[0] = total_;
  fields_[1] = total_ - fields_[0];

  used( (int)((100 * fields_[0]) / total_) );

  drawfields();
}
