#!	/bin/sh

. cd_functions.sh

EXCLUDE="$ALWAYS_EXCLUDE \
	$RELEASE/source \
	$ARCHIVE/contrib/source \
	$ARCHIVE/non-free/source"

for i in $EXCLUDE; do
	EXCLUDE_FLAGS="$EXCLUDE_FLAGS -x $i"
done

# Make the /boot directory at the top of the archive.
make_boot_directory

todos < text/binary-cd/SOURCE.txt > $ARCHIVE/SOURCE.txt
todos < text/binary-cd/READ_CD.txt > $ARCHIVE/READ_CD.txt
todos < text/both/colophon.txt > $ARCHIVE/colophon.txt

# Write .mkisofsrc
VOLI="Debian 1.3.1 Binary"
cd_info > .mkisofsrc

# -K is a kludge to add 16K to the end. This makes up for a Linux read-ahead
# problem that still exists as of 2.1.30 using the loop mount, and maybe off
# of CD as well.

mkisofs -K -a -r -T -v \
 $EXCLUDE_FLAGS \
 -b boot/resc1440.bin \
 -c boot/boot.catalog \
 -o $TARGET/binary.iso \
 $ARCHIVE

rm -f $ARCHIVE/SOURCE.txt
rm -f $ARCHIVE/READ_CD.txt
rm -f $ARCHIVE/colophon.txt
