#include "aconfig.h"
#ifdef OS2TXT_DRIVER
#define INCL_VIO
#define INCL_KBD
#define INCL_MOU
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include "ui.h"
#include "ui_os2viofont.h"

#define WM_BLACK             0x00
#define WM_BLUE              0x01
#define WM_GREEN             0x02
#define WM_CYAN              0x03
#define WM_RED               0x04
#define WM_MAGENTA           0x05
#define WM_BROWN             0x06
#define WM_PALEGRAY          0x07
#define WM_DKGREY            0x08
#define WM_LBLUE             0x09
#define WM_LGREEN            0x0A
#define WM_LCYAN             0x0B
#define WM_LRED              0x0C
#define WM_LMAGENTA          0x0D
#define WM_YELLOW            0x0E
#define WM_WHITE             0x0F
#define WM_MAX_COLOR         0X0F
#define TOP_ROW          0
#define LEFT_COL         0
#define BOT_ROW          25
#define RGT_COL          80

#define NORMAL  0
#define DIM	1
#define BOLD	2
#define REVERSE 3
#define BOLDFONT 4

#define NATTRS 5
#define NPALETTES 5;
#define TABLESIZE 65536
#define NPARAMS 5
#define NCHARS (128*NATTRS)
#define add(i) if(next[(i)]==(i)&&last!=(i)) {if(last!=-1) next[last]=(i),last=(i); else last=first=(i);}
#define dist(i1,i2,i3,i4,i5,y1,y2,y3,y4,y5) (3*(abs((int)(i1)-(int)(y1))+abs((int)(i2)-(int)(y2))+(abs((int)(i3)-(int)(y3))+abs((int)(i4)-(int)(y4))))+1*abs((int)(i5)-(int)(y5)))
#define pos(i1,i2,i3,i4) (((int)(i1)<<12)+((int)(i2)<<8)+((int)(i3)<<4)+(int)(i4))
#define postoparams(pos,i1,i2,i3,i4) \
  ((i1)=(pos)>>12),((i2)=((pos)>>8)&15),((i3)=((pos)>>4)&15),((i4)=((pos))&15)
#define isset(n,i) (((i)&1<<(n))!=0)
#define canset(n,i) (!isset(n,i)&&isset(n+1,i))

#define min(x,y) ((x)<(y)?(x):(y))

void mktable(void);
struct parameters {
  unsigned char p[NPARAMS];
};
static struct parameters *parameters;

unsigned short *table = NULL;
static int buttons = 0, keys = 0;
int supported[NATTRS] =
{1, 0, 1, 0, 0};
static unsigned short *next;
static int first = -1;
static int last = -1;
static int fontwidth = 8;

struct ui_driver os2txt_driver;
static int mode = -1;

static int currentbuff = 0;
static int ncolors = 0;
static int width=640, height=480;
static int supportedon[NATTRS]={1,1,1,1,1}, supportedoff[NATTRS]={0,0,0,0,0};
static int palette=0;

static HMOU hMou;
static USHORT mouwait = 0;
static MOUEVENTINFO mouEvent;
VIOCURSORINFO oldCurInfo;

char *buffers[4];

const char *tags[NATTRS - 1] =
{
  "<FONT COLOR=\"808080\">",
  "<B><FONT COLOR=\"ffffff\">",
  "<A HREF=A>",
  "<B>",
};

const char *endtags[NATTRS - 1] =
{
  "</FONT>",
  "</FONT></B>",
  "</A>",
  "</B>",
};

char *writetxt()
{
  static char name[256];
  static int nimage = 0;
  int x, y, c;
  struct stat sb;
  FILE *f;
  do {
    sprintf(name, "fract%i.txt", nimage++);
  } while (stat(name, &sb) != -1);
  f = fopen(name, "wt");
  os2txt_driver.print(0, 0, "Select attribute encoding:          ");
  os2txt_driver.print(0, 2, "1 - for more and less               ");
  os2txt_driver.print(0, 4, "2 - html                            ");
  os2txt_driver.print(0, 6, "3 - ansi escape sequences           ");
  while ((c = tolower(getch())) < '1' || c > '3');
  switch (c) {
  case '1':
    for (y = 0; y < height; y++) {
      for (x = 0; x < width; x++) {
	if (buffers[3][y * width + x] == BOLD || buffers[3][y * width + x] == BOLDFONT) {
	  putc(buffers[2][y * width + x], f);
	  if (buffers[2][y * width + x] != ' ') {
	    putc(8, f);
	    putc(buffers[2][y * width + x], f);
	  }
	} else
	  putc(buffers[2][y * width + x], f);
      }
      putc('\n', f);
    }
    break;
  case '3':
    {
      int lastmode = NORMAL, mode;
      for (y = 0; y < height; y++) {
	for (x = 0; x < width; x++) {
	  mode = buffers[3][y * width + x];
	  if (mode != lastmode) {
	    if (lastmode != NORMAL)
	      fprintf(f, "%c[0;10m", 27);
	    switch (mode) {
	    case BOLD:
	    case BOLDFONT:
	      fprintf(f, "%c[1m", 27);
	      break;
	    case REVERSE:
	      fprintf(f, "%c[7m", 27);
	      break;
	    case DIM:
	      fprintf(f, "%c[8m", 27);
	      break;
	      
	    }
	    lastmode = mode;
	  }
	  putc(buffers[2][y * width + x], f);
	}
	putc('\n', f);
      }
      if (lastmode != NORMAL)
	fprintf(f, "%c[0;10m", 27);
    }
    break;
  case '2':
    {
      int lasttag = -1;
      fprintf(f, "<HTML>\n <HEAD> <TITLE>Fractal generated by XaoS</TITLE>\n</HEAD>\n<BODY BGCOLOR=\"#000000\" TEXT=\"#dddddd\" LINK=\"#FFFFFF\">\n<FONT SIZE=2><PRE>\n");
      for (y = 0; y < height; y++) {
	for (x = 0; x < width; x++) {
	  char cc;
	  if ((char) buffers[3][y * width + x] - 1 != lasttag) {
	    if (lasttag >= 0)
	      fprintf(f, "%s", endtags[lasttag]);
	    lasttag = (char) buffers[3][y * width + x] - 1;
	    if (lasttag >= 0)
	      fprintf(f, "%s", tags[lasttag]);
	  }
	  cc = buffers[2][y * width + x];
	  switch (cc) {
	  case '<':
	    fprintf(f, "&lt;");
	    break;
	  case '>':
	    fprintf(f, "&gt;");
	    break;
	  case '&':
	    fprintf(f, "&amp;");
	    break;
	  default:
	    putc(buffers[2][y * width + x], f);
	  }
	}
	putc('\n', f);
      }
      fprintf(f, "</PRE></FONT></BODY>\n</HTML>\n");
      break;
    }
  }
  os2txt_driver.print(0, 0, "Saved.                     ");
  
  fclose(f);
  return name;
}



int txt_init()
{
  BYTE bCell[2];
  VIOCURSORINFO hidecur;

  if (MouOpen(NULL, &hMou) && MouOpen("POINTER$", &hMou))
    hMou = 0;
  MouDrawPtr(hMou);

  VioGetCurType(&oldCurInfo, (HVIO)0);
  hidecur.attr = -1;
  VioSetCurType(&hidecur, (HVIO)0);
  
  bCell[0] = 0x20;
  bCell[1] = ( WM_BLACK << 4 ) + WM_PALEGRAY;

  VioScrollDn(TOP_ROW,LEFT_COL,0xFFFF,0xFFFF,0xFFFF,bCell,(HVIO) 0);

  if (table == NULL) {
    int i;
    for (i = 0; i < NATTRS; i++) {
      if (supportedon[i])
	supported[i] = 1;
      if (supportedoff[i])
	supported[i] = 0;
    }
    printf("Please wait..rendering aproximation table..");
    mktable();
    printf("ok\n");
  }
  return 1;
}

static void txt_get_size(int *wi, int *he)
{
  width = 80;
  height = 25;
  *wi = 2 * width;
  *he = 2 * height;
}

/* check for cursor keys
 *
 * returns status
 */
static int check_ckeys(char c)
{
  if (c == 75) { /* left */
    keys |= 1;
  } else {
    keys &= ~1;
  }
  if (c == 77) { /* right */
    keys |= 2;
  } else {
    keys &= ~2;
  }
  if (c == 72) { /* up */
    keys |= 4;
  } else {
    keys &= ~4;
  }
  if (c == 80) { /* down */
    keys |= 8;
  } else {
    keys &= ~8;
  }
  return keys;
}

/* check for extra keyevents only for text version!
 *
 * returns 0, if key processed
 * otherwise 1
 */
static int check_keys(char c)
{
  if (tolower(c) == 'p') {
    palette = (palette + 1) % NPALETTES;
    os2txt_driver.display();
    return 0;
  }
  if (tolower(c) == 't') {
    writetxt();
    return 0;
  }
  if (tolower(c) == 'g') {
    os2txt_driver.print(0, 0, "1=8x16font 2=8x8font            ");
    while ((c = tolower(getch())) != '1' && c != '2');
    if (c == '1')
      fontwidth = 16;
    else
      fontwidth = 8;
    os2txt_driver.print(0, 2, "rendering aproximation tables   ");
    mktable();
    os2txt_driver.display();

    return 0;
  }

  return 1;  /* not handled */
}

static void check_buttons(USHORT b)
{
  if ((b == 1) || (b == 0)) {
    buttons = 0;
    return;
  }

  if (b & 0x06) {
    buttons |= BUTTON1;
  } else {
    buttons &= ~BUTTON1;
  };
  if (b & 0x18) {
    buttons |= BUTTON2;
  } else {
    buttons &= ~BUTTON2;
  };
  if (b & 0x60) {
    buttons |= BUTTON3;
  } else {
    buttons &= ~BUTTON3;
  };

}

static void txt_processevents(int wait, int *x, int *y, int *b, int *k)
{
  KBDKEYINFO    kbdkeyinfo;
  PTRLOC ptrLoc;

  *k = 0;
  if (wait) {
    while(1) {

      /* 'Reset' params */
      MouGetPtrPos(&ptrLoc, hMou);
      *x = 2 * ptrLoc.col; *y = 2 * ptrLoc.row;
      *b = 0;

      /* check for key events */
      KbdCharIn(&kbdkeyinfo, IO_NOWAIT, 0);
      if (kbdkeyinfo.fbStatus!=0) {
	if (check_keys(kbdkeyinfo.chChar))
	  ui_key(kbdkeyinfo.chChar);
        *k = check_ckeys(kbdkeyinfo.chScan);
        return;
      }

      /* check for mouse events */
      MouReadEventQue(&mouEvent, &mouwait, hMou);
      if (!(mouEvent.fs==0 && mouEvent.row==0 && mouEvent.col==0)) {
        MouGetPtrPos(&ptrLoc, hMou);
        *x = 2 * ptrLoc.col; *y = 2 * ptrLoc.row;
        check_buttons(mouEvent.fs);
        *b = buttons;
        return;
      }
      if (buttons!=0) {
        *b = buttons;
        return;
      }
      DosSleep(1);
    }
  } else {
    KbdCharIn(&kbdkeyinfo, IO_NOWAIT, 0);
    if (kbdkeyinfo.fbStatus!=0) {
      if (check_keys(kbdkeyinfo.chChar))
        ui_key(kbdkeyinfo.chChar);
      *k = check_ckeys(kbdkeyinfo.chScan);
    }
    MouReadEventQue(&mouEvent, &mouwait, hMou);
    if (!(mouEvent.fs==0 && mouEvent.row==0 && mouEvent.col==0)) {
      MouGetPtrPos(&ptrLoc, hMou);
      *x = 2 * ptrLoc.col; *y = 2 * ptrLoc.row;
      check_buttons(mouEvent.fs);
      *b = buttons;
    }
  }

  return;
}

static void txt_getmouse(int *x, int *y, int *b)
{
  PTRLOC ptrLoc;

  MouGetPtrPos(&ptrLoc, hMou);
  *x = 2 * ptrLoc.col; *y = 2 * ptrLoc.row;
  check_buttons(mouEvent.fs);
  *b = buttons;
}

static void txt_uninitialise()
{
  BYTE bCell[2];
  
  bCell[0] = 0x20;
  bCell[1] = ( WM_BLACK << 4 ) + WM_PALEGRAY;
  
  VioScrollDn(TOP_ROW,LEFT_COL,0xFFFF,0xFFFF,0xFFFF,bCell,(HVIO) 0);
  VioSetCurPos(0, 0, (HVIO)0);
  MouClose(hMou);
  VioSetCurType(&oldCurInfo, (HVIO)0);
}

static int txt_set_color(int r, int g, int b, int init) 
{
  if (init)
    ncolors = 0;
  if (ncolors >= 256)
    return (-1);
  return (ncolors++);
}

static void txt_print(int x, int y, char *text)
{
  BYTE bCell=(WM_BLACK << 4) + WM_PALEGRAY;;
  VioWrtCharStrAtt(text, strlen(text), y / 2, x, &bCell, (HVIO) 0);
}

static void txt_display()
{
  BYTE RowStr[160];
  int x, y;
  int nattrs = 0;
  for (y = 0; y < NATTRS; y++)
    nattrs += supported[y];
  for (y = 0; y < height; y++) {
    for (x = 0; x < width; x++) {
      int c1, c2, c3, c4, c = 0;
      
      c1 = ((unsigned char) buffers[currentbuff][((x) * 2 + 1 + width * 2 * (y) * 2)]);
      c2 = ((unsigned char) buffers[currentbuff][((x) * 2 + width * 2 * (y * 2))]);
      c3 = ((unsigned char) buffers[currentbuff][((x) * 2 + 1 + width * 2 * (y * 2 + 1))]);
      c4 = ((unsigned char) buffers[currentbuff][((x) * 2 + width * 2 * (y * 2 + 1))]);
      switch (palette) {
      case 0:
	c = ((int) c1 & 15) * 16 * 16 * 16 + ((int) c2 & 15) * 16 * 16 + ((int) c3 & 15) * 16 + ((int) c4 & 15);
	break;
      case 1:
	c = ((int) c1 & 1) * 16 * 16 * 16 * 15 + ((int) c2 & 1) * 16 * 16 * 15 + ((int) c3 & 1) * 16 * 15 + ((int) c4 & 1) * 15;
	break;
      case 2:
	c = min(((int) c1 % 5) * 16 * 16 * 16 * 4, 16 * 16 * 16 * 15) + min(((int) c2 % 5) * 16 * 16 * 4, 16 * 16 * 15) + min(((int) c3 % 5) * 16 * 4, 16 * 15) + min(((int) c4 % 5) * 4, 15);
	break;
      case 3:
	c = ((int) c1 & ~15) * 16 * 16 + ((int) c2 & ~15) * 16 + ((int) c3 & ~15) + ((int) c4 & ~15) / 16;
	break;
      case 4:
	c = ((int) c1 != 0) * 16 * 16 * 16 * 15 + ((int) c2 != 0) * 16 * 16 * 15 + ((int) c3 != 0) * 16 * 15 + ((int) c4 != 0) * 15;
	break;
      }
      if (c >= 65534)
	c = 65534;
      if (c < 0)
	c = 0;
      c = table[c];
      if (nattrs != 1) {
	switch (c / 128) {
	case NORMAL:
	  RowStr[x*2] = c % 128;
	  RowStr[x*2+1] = ( WM_BLACK << 4 ) + WM_PALEGRAY;
	  break;
	case REVERSE:
	  RowStr[x*2] = c % 128;
	  RowStr[x*2+1] = ( WM_PALEGRAY << 4 ) + WM_BLACK;
	  break;
	case DIM:
	  RowStr[x*2] = c % 128;
	  RowStr[x*2+1] = ( WM_BLACK << 4 ) + WM_LCYAN;
	  break;
	case BOLD:
	  RowStr[x*2] = c % 128;
	  RowStr[x*2+1] = ( WM_BLACK << 4 ) + WM_YELLOW;
	  break;
	case BOLDFONT:
	  RowStr[x*2] = c % 128;
	  RowStr[x*2+1] = ( WM_BLACK << 4 ) + WM_WHITE;
	  break;
	}
      }
      buffers[2][x + y * width] = c % 128;
      buffers[3][x + y * width] = c / 128;
    }
    VioWrtCellStr(RowStr, 160, y, 0, (HVIO)0);
  }
}

int txt_alloc(char **b1, char **b2)
{
  *b1 = buffers[0] = (char *)malloc(width*height*4);
  *b2 = buffers[1] = (char *)malloc(width*height*4);
  buffers[2] = (char *) malloc(width * height + 1);
  buffers[3] = (char *) malloc(width * height + 1);
  currentbuff = 0;

  return(2 * width);
}

void txt_free(char *b1, char *b2) 
{
  free(buffers[0]);
  free(buffers[1]);
}

static void txt_flip_buffers() 
{
  currentbuff ^= 1;
}

static char *helptext[] =
{
  "OS/2 TXT DRIVER VERSION 1.0            ", 
  "===========================            ", 
  " As you probably guessed the OS/2 text ",
  " driver is one of most powerfull       ",
  " drivers ever made for XaoS & OS/2     ",
  " It supports all XaoS features:        ",
  "  o 256 colors                         ",
  "  o smooth animations                  ",
  "  o much more                          ",
  "                                       ",
  "                                       ",
  " And has also many extended features   ",
  "  o Doubling of resolution with        ",
  "     anti-aliasing                     ",
  "  o Mouse support                      ",
  "     driver also supports mouse        ",
  "     interface included in VIO mode.   ",
  "  o Ascii-art images saving.           ",
  "     normally XaoS does not support    ",
  "     saving of ascii arted images and  ",
  "     uses poor gif file instead.       ",
  "     press 't' to save images.         ",
  "  o Uses 65535 bytes long lookup table ",
  "     to make ultra fast aproximation   ",
  "     by letters                        ",
  "  o Specialized palettes for text mode ",
  "  o Special top speed aproximation     ",
  "     table renderer that takes         ",
  "     advantage of attributes and       ",
  "     supports dithering, antialiasing  ",
  "     8x8 or 8x16 vga font.             ",
  "     Press 'g' to change font size.    ",
  "                                       ", 
  " As you can see OS/2 txt is simply     ",
  " the best avaiable driver for OS/2     ",
  "                                       ", 
  "      OS/2 TXT driver was done by      ", 
  "      Thomas A. K. Kjaer  (C) 1996     ", 
  "      takjaer@daimi.aau.dk             ",
  "                                       ",
  " The OS/2 TXT driver is based on       ",
  " NCURSES driver done by Jan Hubicka    ",
  "              (C) 1996                 ",
};

#define UGLYTEXTSIZE (sizeof(helptext)/sizeof(char *))
static struct params params[] =
{
  {"-fontheight", P_NUMBER, &fontwidth, "Set font height(8 or 16)"},
  {NULL, 0, NULL, NULL}
};

struct ui_driver os2txt_driver = 
{
  "OS2TXT", 
  txt_init, 
  txt_get_size, 
  txt_processevents, 
  txt_getmouse, 
  txt_uninitialise, 
  txt_set_color, 
  txt_print, 
  txt_display, 
  txt_alloc, 
  txt_free, 
  txt_flip_buffers, 
  NULL,
  256, 
  2, 
  helptext, 
  UGLYTEXTSIZE, 
  params,
  FULLSCREEN|UPDATE_AFTER_RESIZE
};

/* stolen from mktable.c */

void values(int c, int *v1, int *v2, int *v3, int *v4)
{
  int i;
  int attr = c / 128;
  unsigned char *font;
  if (fontwidth == 8)
    font = font8;
  else
    font = font16;
  c = c % 128;
  c = c * fontwidth;
  *v1 = 0;
  *v2 = 0;
  *v3 = 0;
  *v4 = 0;
  for (i = 0; i < fontwidth / 2; i++) {
    *v1 += (isset(0, font[c + i]) +
	    isset(1, font[c + i]) +
	    isset(2, font[c + i]) +
	    isset(3, font[c + i]));
    *v2 += (isset(4, font[c + i]) +
	    isset(5, font[c + i]) +
	    isset(6, font[c + i]) +
	    isset(7, font[c + i]));
  }
  for (; i < fontwidth; i++) {
    *v3 += (isset(0, font[c + i]) +
	    isset(1, font[c + i]) +
	    isset(2, font[c + i]) +
	    isset(3, font[c + i]));
    *v4 += (isset(4, font[c + i]) +
	    isset(5, font[c + i]) +
	    isset(6, font[c + i]) +
	    isset(7, font[c + i]));
  }
  switch (attr) {
  case REVERSE:
    *v1 = fontwidth * 2 - *v1;
    *v2 = fontwidth * 2 - *v2;
    *v3 = fontwidth * 2 - *v3;
    *v4 = fontwidth * 2 - *v4;
    break;
  case DIM:
    *v1 = (*v1 + 1) / 2;
    *v2 = (*v2 + 1) / 2;
    *v3 = (*v3 + 1) / 2;
    *v4 = (*v4 + 1) / 2;
    break;
  case BOLD:
    *v1 = *v1 * 2;
    *v2 = *v2 * 2;
    *v3 = *v3 * 2;
    *v4 = *v4 * 2;
    break;
  case BOLDFONT:
    for (i = 0; i < fontwidth / 2; i++) {
      *v1 += (isset(0, font[c + i]) +
	      canset(1, font[c + i]) +
	      canset(2, font[c + i]) +
	      canset(3, font[c + i]));
      *v2 += (isset(4, font[c + i]) +
	      canset(5, font[c + i]) +
	      canset(6, font[c + i]) +
	      canset(7, font[c + i]));
    }
    for (; i < fontwidth; i++) {
      *v3 += (isset(0, font[c + i]) +
	      canset(1, font[c + i]) +
	      canset(2, font[c + i]) +
	      canset(3, font[c + i]));
      *v4 += (isset(4, font[c + i]) +
	      canset(5, font[c + i]) +
	      canset(6, font[c + i]) +
	      canset(7, font[c + i]));
    }
  }
}
void static addparams(void)
{
  int i;
  int ma1 = 0, ma2 = 0, ma3 = 0, ma4 = 0, msum = 0;
  int mi1 = 50, mi2 = 50, mi3 = 50, mi4 = 50, misum = 50;
  int v1, v2, v3, v4, sum;
  for (i = 0; i < NCHARS; i++) {
    if ((!isgraph(i % 128) && (i % 128) != ' ') || !supported[i / 128])
      continue;
    values(i, &v1, &v2, &v3, &v4);
    if (v1 > ma1)
      ma1 = v1;
    if (v2 > ma2)
      ma2 = v2;
    if (v3 > ma3)
      ma3 = v3;
    if (v4 > ma4)
      ma4 = v4;
    if (v1 + v2 + v3 + v4 > msum)
      msum = v1 + v2 + v3 + v4;
    if (v1 < mi1)
      mi1 = v1;
    if (v2 < mi2)
      mi2 = v2;
    if (v3 < mi3)
      mi3 = v3;
    if (v4 < mi4)
      mi4 = v4;
    if (v1 + v2 + v3 + v4 < misum)
      misum = v1 + v2 + v3 + v4;
  }
  ma1 -= mi1;
  ma2 -= mi2;
  ma3 -= mi3;
  ma4 -= mi4;
  msum -= misum;
  for (i = 0; i < NCHARS; i++) {
    int pos;
    if ((!isgraph(i % 128) && (i % 128) != ' ') || !supported[i / 128])
      continue;
    values(i, &v1, &v2, &v3, &v4);
    sum = ((double) (v1 + v2 + v3 + v4 - misum) * (62.1 / (double) msum) + 0.900001);
    v1 = ((double) (v1 - mi1) * (14.1 / (double) ma1) + 0.9000001);
    v2 = ((double) (v2 - mi2) * (14.1 / (double) ma2) + 0.9000001);
    v3 = ((double) (v3 - mi3) * (14.1 / (double) ma3) + 0.9000001);
    v4 = ((double) (v4 - mi4) * (14.1 / (double) ma4) + 0.9000001);
    if (v1 > 15)
      v1 = 15;
    if (v2 > 15)
      v2 = 15;
    if (v3 > 15)
      v3 = 15;
    if (v4 > 15)
      v4 = 15;
    parameters[i].p[0] = v1;
    parameters[i].p[1] = v2;
    parameters[i].p[2] = v3;
    parameters[i].p[3] = v4;
    parameters[i].p[4] = sum;
    pos = pos(v1, v2, v3, v4);
    if (table[pos]) {
      if (abs((parameters[i].p[4]) - v1 - v2 - v3 - v4) > abs(parameters[table[pos]].p[4] - v1 - v2 - v3 - v4))
	continue;
    }
    table[pos] = i;

    add(pos);
  }
}
void mktable(void)
{
  int i;
  int i1, i2, i3, i4;
  next = (unsigned short *) malloc(sizeof(*next) * TABLESIZE);
  parameters = (struct parameters *) malloc(sizeof(struct parameters) * NCHARS);
  if (table == NULL)
    table = (unsigned short *) malloc(TABLESIZE * sizeof(*table));
  first = -1;
  last = -1;
  for (i = 0; i < TABLESIZE; i++)
    next[i] = i, table[i] = 0;
  addparams();
  do {
    int blocked;
    if (last != -1)
      next[last] = last;
    else
      break;
    blocked = last;
    i = first;
    if (i == -1)
      break;
    first = last = -1;
    do {
      int m1, m2, m3, m4, ii, dm;
      unsigned short c = table[i];
      /* printf ("%c\n", c); */
      postoparams(i, m1, m2, m3, m4);
      for (dm = 0; dm < 4; dm++)
	for (ii = -1; ii <= 1; ii += 2) {
	  int dist, dist1, index;
	  unsigned short ch;
	  i1 = m1;
	  i2 = m2;
	  i3 = m3;
	  i4 = m4;
	  switch (dm) {
	  case 0:
	    i1 += ii;
	    if (i1 < 0 || i1 >= 16)
	      continue;
	    break;
	  case 1:
	    i2 += ii;
	    if (i2 < 0 || i2 >= 16)
	      continue;
	    break;
	  case 2:
	    i3 += ii;
	    if (i3 < 0 || i3 >= 16)
	      continue;
	    break;
	  case 3:
	    i4 += ii;
	    if (i4 < 0 || i4 >= 16)
	      continue;
	    break;
	    
	  }
	  index = pos(i1, i2, i3, i4);
	  ch = table[index];
	  if (ch == c || index == blocked)
	    continue;
	  if (ch) {
	    dist = dist(
			i1, i2, i3, i4, (i1 + i2 + i3 + i4),
			parameters[c].p[0],
			parameters[c].p[1],
			parameters[c].p[2],
			parameters[c].p[3],
			parameters[c].p[4]);
	    dist1 = dist(i1, i2, i3, i4, (i1 + i2 + i3 + i4),
			 parameters[ch].p[0],
			 parameters[ch].p[1],
			 parameters[ch].p[2],
			 parameters[ch].p[3],
			 parameters[ch].p[4]);
	  }
	  if (!ch || dist < dist1) {
	    table[index] = c;
	    add(index);
	  }
	}
      i1 = i;
      i = next[i];
      next[i1] = i1;
    }
    while (i != i1);
  }
  while (last != -1);
  free(next);
  free(parameters);
}

#endif
