/*
 * dlsof.h - SunOS (Solaris 1.x and 2.x) header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.30 96/04/01 16:36:42 abe Exp $
 */


#if	!defined(SUN_LSOF_H)
#define	SUN_LSOF_H	1

# if	defined(solaris)
#include <fcntl.h>
#include <sys/mntent.h>
#include <sys/mnttab.h>
#define	_KMEMUSER	1
# else		/* not solaris */
#include <mntent.h>
#include <sys/domain.h>
# endif	/* solaris */

#include <stdlib.h>
#include <dirent.h>
#include <kvm.h>
#include <nlist.h>
#include <signal.h>
#include <setjmp.h>
#include <string.h>
#include <unistd.h>
#include <rpc/types.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/un.h>
#include <netinet/in.h>

# if	defined(solaris)
#define	_KERNEL
#define	MI_HRTIMING
#define	pfi_t	int
#define	pfv_t	int
#include <inet/led.h>
#include <inet/mi.h>
#include <inet/ip.h>
#undef	_KERNEL
#undef	MI_HRTIMING
#undef	pfi_t
#undef	pfv_t
#define	exit		kernel_exit
#define	rval_t		char
#define	strsignal	kernel_strsignal
#include <sys/strsubr.h>
#undef	exit
#undef	rval_t
#undef	strsignal
#include <inet/tcp.h>
# else	/* !solaris */
#include <sys/unpcb.h>
# endif	/*  solaris */

#include <net/route.h>
#include <netinet/in_pcb.h>
#include <sys/stream.h>
#include <sys/sysmacros.h>
#include <sys/vfs.h>
#include <sys/vnode.h>

# if	defined(solaris)
#include <sys/fs/hsfs_spec.h>
#include <sys/fs/hsfs_node.h>
#include <sys/fs/lofs_node.h>
#include <sys/fs/namenode.h>

#  if	solaris>=20500
#define	_KERNEL
#include <sys/door.h>
#undef	_KERNEL
#  endif	/* solaris>=20500 */
# else	/* !solaris */

/*
 * Dummy hsnode structure for SunOS 4.1.3 and below.  This should come from
 * hsfs_node.h, but it has unresolvable protoype declaration conflicts.
 */

struct  hsnode {
	struct hsnode	*dummy1[3];
	struct vnode	dummy2;
	struct	hs_direntry {
		u_int	ext_lbn;	/* SunOS 4.1.x inode number */
		u_int	ext_size;    	/* size */
	} hs_dirent;
};
# endif	/* solaris */

# if	defined(solaris)
#include <sys/t_lock.h>
#include <sys/flock.h>

# if	solaris>=20300
#  if	solaris<20400
/*
 * The lock_descriptor structure definition is missing from Solaris 2.3.
 */

struct lock_descriptor {
	u_long d1[5];
	int flags;
	short type;
};
#define	ACTIVE_LOCK	0x008		/* lock is active */
#  else	/* solaris>=20400 */
#include <sys/flock_impl.h>
#  endif	/* solaris<20400 */
# endif	/* solaris>=20300 */

#include <sys/fstyp.h>
#include <sys/dditypes.h>
#include <sys/ddidmareq.h>
#include <sys/ddi_impldefs.h>
#include <sys/mkdev.h>
#include <sys/fs/cachefs_fs.h>
#include <sys/fs/fifonode.h>
#include <sys/fs/pc_fs.h>
#include <sys/fs/pc_dir.h>
#include <sys/fs/pc_label.h>
#include <sys/fs/pc_node.h>
#include <sys/fs/snode.h>
#include <sys/fs/tmpnode.h>
#include <sys/fs/ufs_inode.h>
# else	/* !solaris */
#include <net/raw_cb.h>
#include <ufs/lockf.h>
#include <ufs/inode.h>
#include <specfs/snode.h>
#include <tmpfs/tmpnode.h>
#include <sys/mbuf.h>
#include <sys/domain.h>
#include <ufs/mount.h>
# endif	/* solaris */

#include <nfs/nfs.h>
#include <nfs/rnode.h>
#include <sys/proc.h>
#include <sys/user.h>

# if	defined(HASPROCFS)
#include <sys/proc/prdata.h>
# endif


# if	!defined(solaris)
#  if	!defined(KERNEL)
#define KERNEL	1
#  endif
#include <sys/file.h>
#include <pcfs/pc_dir.h>
#include <pcfs/pc_label.h>
#include <pcfs/pc_node.h>
#include <specfs/fifonode.h>
#undef	KERNEL
# endif	/* solaris */

#include <sys/file.h>
#include <vm/hat.h>
#include <vm/as.h>
#include <vm/seg.h>
#include <vm/seg_dev.h>
#include <vm/seg_map.h>
#include <vm/seg_vn.h>

# if	defined(solaris)
#include <sys/tiuser.h>
#include <sys/t_kuser.h>
#include <sys/sockmod.h>
# endif	/* defined(solaris) */

/*
 * Structure for Atria's MVFS nodes
 */

struct mvfsnode {
	unsigned long d1[6];
	unsigned long m_ino;			/* node number */
};

extern int nlist();

# if	!defined(solaris)
extern char *sys_errlist[];
#define	strerror(errno)	sys_errlist[errno]
# endif

# if	defined(HAS_AFS)
#define	AFSAPATHDEF	"/usr/vice/etc/modload/libafs"
#define	AFSDEV		1	/* AFS "fake" device number */
# endif	/* defined(HAS_AFS) */

# if	defined(NOCONST)
#define	COMP_P		void
# else
#define	COMP_P		const void
# endif

#define	CWDLEN		(MAXPATHLEN+1)
#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MAXSEGS		100	/* maximum text segments */
#define MALLOC_S	unsigned

# if	defined(solaris)
#define	DINAMEL		32
#define NETCLNML	8
#define	N_UNIX		"/dev/ksyms"
#define	PROCMIN		5	/* processes that make a "good" scan */

#  if	defined(HASPROCFS)
#define	PR_ROOTINO	2	/* root inode for proc file system */
#  endif	/* defined(HASPROCFS) */

# else	/* !defined(solaris) */
#define CLONEMAJ	37	/* major device number for clone device */
#define N_UNIX		"/vmunix"
#define	PROCMIN		3	/* processes that make a "good" scan */
# endif	/* defined(solaris) */

#define	PROCDFLT	256	/* default size for local proc table */
#define PROCSIZE	sizeof(struct proc)
#define	PROCTRYLM	5	/* times to try to read proc table */
#define QSORT_P		char
#define	READLEN_T	int
#define STRNCPY_L	int
#define	STRNML		32	/* stream name length (maximum) */
#define	UIDCACHEL	8192
#define U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

# if	defined(HAS_AFS)

#  if	defined(HASAOPT)
extern char *AFSApath;		/* alternate AFS name list path (from -a) */
#  endif	/* defined(HASAOPT) */

#  if	defined(solaris)
extern int AFSfstype;		/* AFS file system type index */
#  endif	/* defined(solaris) */

extern struct vfs *AFSVfsp;	/* AFS struct vfs kernel pointer */
# endif	/* defined(HAS_AFS) */

struct clone {
	char *nm;		/* path name */
	dev_t rdev;		/* device number */
	int n;			/* network flag */
	struct clone *next;	/* forward link */
};
extern struct clone *Clone;

extern int CloneMaj;

# if	!defined(solaris)
extern char *Cwd;
# endif

# if	defined(solaris)
extern char **Fsinfo;
extern int Fsinfomax;
# endif

extern int HaveCloneMaj;
extern kvm_t *Kd;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	dev_t dev;			/* device */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */

# if	defined(HASFSTYPE)
	char *fstype;			/* file system type */
# endif

	dev_t rdev;			/* st_rdev */
};


/*
 * Name list (Nl[]) indexes
 */

# if	defined(solaris)
#define	X_AFS_FID	0
#define	X_AFS_OPS	1
#define	X_AFS_VOL	2
#define X_CACHE_OPS	3
#define	X_CLONEMAJ	4
#define X_FIFO_OPS	5
#define X_HSFS_OPS	6
#define	X_LOFS_OPS	7
#define	X_MVFS_OPS	8
#define	X_NCACHE	9
#define	X_NCSIZE	10
#define X_NFS_OPS	11
#define X_NFS3_OPS	12
#define X_NM_OPS	13
#define	X_NPROC		14
#define	X_PC_DOPS	15
#define	X_PC_FOPS	16
#define X_PROC_OPS	17
#define X_SEGVN		18
#define	X_SPEC_OPS	19
#define X_TMP_OPS	20
#define X_UFS_OPS	21
# if	solaris<20500
#define	X_LAST		22
# else	/* solaris>=20500 */
#define X_DOOR_OPS	22
#define	X_KERNELBASE	23
#define X_LAST		24
# endif	/* solaris<20500 */
# else		/* !solaris */
#define	X_AFS_FID	0
#define	X_AFS_OPS	1
#define	X_AFS_VOL	2
#define X_FIFO_OPS	3
#define X_HSFS_OPS	4
#define	X_NCACHE	5
#define	X_NCSIZE	6
#define X_NFS_OPS	7
#define X_NFS3_OPS	8
#define	X_NPROC		9
#define	X_PC_DOPS	10
#define	X_PC_FOPS	11
#define X_SEGVN		12
#define	X_SPEC_OPS	13
#define X_TMP_OPS	14
#define X_UFS_OPS	15
#define	X_LAST		16
# endif	/* solaris */

# if	defined(solaris)
struct pseudo {
	char *nm;			/* path name */
	dev_t rdev;			/* device number */
	struct pseudo *next;		/* forward link */
};
extern struct pseudo *Pseudo;
# endif	/* solaris */

#if	!defined(solaris)
extern char *Rtd;
#endif

struct sfile {
	char *aname;			/* file name argument */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

#endif	/* SUN_LSOF_H */
