;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo0.2/Parser/cpp.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 29 09:46:19 1995                          */
;*    Last change :  Fri Apr 12 15:00:39 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The cpp parsing                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parser_cpp
   (include "Parser/coord.sch")
   (import  engine_param
	    engine_engine
	    parser_tools)
   (export  cpp-parser
	    cpp-lexer
	    (set-cpp-coord! coord)))

;*---------------------------------------------------------------------*/
;*    set-cpp-coord ...                                                */
;*---------------------------------------------------------------------*/
(define (set-cpp-coord! coord)
   (set! *cpp-coord* coord))

;*---------------------------------------------------------------------*/
;*    *cpp-coord* ...                                                  */
;*---------------------------------------------------------------------*/
(define *cpp-coord* #f)

;*---------------------------------------------------------------------*/
;*    cpp-lexer ...                                                    */
;*---------------------------------------------------------------------*/
(define cpp-lexer
   (regular-grammar ((letter          (inside #\a #\z #\A #\Z))
		     (digit           (inside #\0 #\9))
		     (nonzero-digit   (inside #\1 #\9))
		     (octal-digit     (inside #\0 #\7))
		     (hex-digit       (inside #\0 #\9 #\a #\f #\A #\F))
		     (long-suffix     (or #\l #\L))
		     (unsigned-suffix (or #\u #\U)))
 
      ;; blank
      ((+ (in #\space #\Newline #\tab #a012 #\\))
       (ignore))

      ;; comment
      (("/*" (* (or (out #\*) ((+ #\*) (out #\/ #\*)))) (+ #\*) "/")
       (ignore))

      ;; `define toto(...)'
      ((bol (#\# (* #\space) "define"
		 (* #\space)
		 ((or #\_ letter) (* (or #\_ letter #\_ digit)))
		 #\())
       (context 'define-fun)
       (cons 'define-fun (the-string)))

      ;; ending of `define toto( ...'
      (define-fun (#\))
	 (context)
	 'EOA)

      ;; define
      ((bol (#\# (* #\space) "define"))
       'define-var)

      ;; include
      ((bol (#\# (* #\space) "include"))
       'include)
	    
      ;; identifier
      (((or #\_ letter) (* (or letter #\_ digit)))
       (list 'ID (the-string)))

      ;; include strings
      ((#\< (+ (out #\>)) #\>)
       (list '<STRING> (the-small-string)))

      ;; strings
      ((#\" (+ (out #\")) #\")
       (list 'STRING (the-small-string)))

      ;; integer constant
      (((or (nonzero-digit (* digit))
	    (#\0 (* octal-digit))
	    ((or "0x" "0X") (+ hex-digit)))
	(? (or long-suffix
	       (long-suffix unsigned-suffix)
	       unsigned-suffix
	       (unsigned-suffix long-suffix))))
       (list 'INTEGER-CONSTANT (the-string)))

      ;; floating-point constant
      ((or ((+ digit)
	    ((in #\e #\E) (? (in #\- #\+)) (+ digit))
	    (? (in #\f #\F #\l #\L)))
	   ((or ((+ digit) #\. (* digit)) (#\. (+ digit)))
	    (? ((in #\e #\E) (? (in #\- #\+)) (+ digit)))
	    (? (in #\f #\F #\l #\L))))
       (list 'FLOAT-CONSTANT (the-string)))

      ;; character constant
      (((? #\L) (#\' (+ (all)) #\'))
       (list 'CHAR-CONSTANT (the-string)))

      ;; string constant
      ((#\L #\" (* (out #\")) #\")
       (list 'STRING-CONSTANT (the-string)))

      (else
       (let ((c (the-failing-char)))
	  (if (eof-object? c)
	      c
	      '???)))))

;*---------------------------------------------------------------------*/
;*    cpp-parser ...                                                   */
;*---------------------------------------------------------------------*/
(define cpp-parser
   (lalr-grammar
      
      (token <STRING> STRING INTEGER-CONSTANT FLOAT-CONSTANT
	     CHAR-CONSTANT STRING-CONSTANT ??? INCLUDE DEFINE-VAR DEFINE-FUN
	     ID EOA)
      
      (cmd
       (()
	'done)
       ((include-cmd cmd)
	'done)
       ((define-cmd cmd)
	'done)
       ((<STRING> cmd)
	'done)
       ((STRING cmd)
	'done)
       ((INTEGER-CONSTANT cmd)
	'done)
       ((FLOAT-CONSTANT cmd)
	'done)
       ((CHAR-CONSTANT cmd)
	'done)
       ((STRING-CONSTANT cmd)
	'done)
       ((ID cmd)
	'done cmd)
       ((??? cmd)
	'done)) 

      (include-cmd
       ((INCLUDE <STRING>)
	(let ((fname (car <STRING>)))
	   (cond
	      ((or (eq? *open-include* 'all) (member fname *open-include*))
	       (translate-file fname '<include> 'open))
	      ((or (eq? *scan-include* 'all) (member fname *scan-include*))
	       (translate-file fname '<include> 'scan)))))
       ((INCLUDE STRING)
	(let ((fname (car STRING)))
	   (cond
	      ((or (eq? *open-include* 'all) (member fname *open-include*))
	       (translate-file fname 'include 'open))
	      ((or (eq? *scan-include* 'all) (member fname *scan-include*))
	       (translate-file fname 'include 'scan))))))

      (define-cmd
       ((DEFINE-VAR ID)
	'done)
       ((DEFINE-VAR ID value)
	(if *define*
	    (let ((cell  (assq value *c-type-alist*))
		  (coord DEFINE-VAR)
		  (m-id  (car ID)))
	       (if (not (pair? cell))
		   (begin
		      (if (coord? *cpp-coord*)
			  
			  (warning "define:"
				   "Unknow type expression -- "
				   "Using `" *default-type* "' type"))
		      (fprint *oport*
			      "   (macro " *default-type*
			      " " m-id " \"" m-id "\")"))
		   (fprint *oport*
			   "   (macro " (cdr cell) " " m-id " \"" m-id
			   "\")"))))
	'done)
       ((DEFINE-FUN args)
	(if *define-fun*
	    (begin
	       (if (coord? *cpp-coord*)
		   (warning/location (coord-fname *cpp-coord*)
					    (coord-pos *cpp-coord*)
					    "define:"
					    "Unknow type expression -- "
					    "Using `"
					    *default-type*
					    "' type")
		   (warning "define:"
			    "Unknow type expression -- "
			    "Using `" *default-type* "' type"))
	       (let ((m-id (let ((str DEFINE-FUN))  
			      (let loop ((r     1)
					 (start #t))
				 (cond
				    ((char=? (string-ref str r) #\space)
				     (loop (+fx r 1) start))
				    (start
				     (loop (+fx r 6) #f))
				    (else
				     (substring
				      str
				      r
				      (-fx (string-length str) 1))))))))
		  (fprint *oport*
			  "   (macro " *default-type*
			  " " m-id " " (map (lambda (x) *default-type*) args)
			  " \"" m-id "\")"))))))
      (args
       ((EOA)
	'())
       ((ID EOA)
	`(,ID))
       ((ID ??? args)
	`(,ID ,@args)))

      (value
       ((STRING)
	'char*)
       ((STRING-CONSTANT)
	'char*)
       ((CHAR-CONSTANT)
	'char)
       ((INTEGER-CONSTANT)
	'long)
       ((FLOAT-CONSTANT)
	'double)
       ((???)
	'???))))
	
 
