;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/global-set.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 16:45:05 1994                          */
;*    Last change :  Wed Oct 25 14:40:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Global mutations.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_global-mutation
   (include "Ast/ast.sch")
   (import  ast_env
	    tools_error)
   (export  (find-and-check-mutations! <s-exp>* <symbol>*)))

;*---------------------------------------------------------------------*/
;*    find-and-check-mutations! ...                                    */
;*    -------------------------------------------------------------    */
;*    We scan code in order to find and check mutations.               */
;*---------------------------------------------------------------------*/
(define (find-and-check-mutations! codes stack)
   (for-each (lambda (c) (find-and-check-one-mutations! c stack)) codes))
 
;*---------------------------------------------------------------------*/
;*    find-and-check-one-mutations! ...                                */
;*---------------------------------------------------------------------*/
(define (find-and-check-one-mutations! exp stack)
   (match-case exp
      ((atom ?atom)
       'done)
      ((quote ?-)
       'done)
      ((pragma ?-)
       'done)
      ((assert ?- ?f- . ?body)
       (find-and-check-mutations! body stack))
      ((begin . ?exp)
       (find-and-check-mutations! exp stack))
      ((set! (and (? symbol?) ?var) ?val)
       (if (memq var stack)
	   'nothing
	   (check-mutation! var exp)))
      ((let ?bindings . ?exp)
       (let ((new-stack (let loop ((stack    stack)
				   (bindings bindings))
			   (cond
			      ((null? bindings)
			       stack)
			      ((not (pair? (car bindings)))
			       (loop (cons (car bindings) stack)
				     (cdr bindings)))
			      (else
			       (loop (cons (car (car bindings)) stack)
				     (cdr bindings)))))))
	  (find-and-check-mutations! exp new-stack)
	  (for-each (lambda (b)
		       (find-and-check-mutations! (cdr b) stack))
		    bindings)))
      ((letrec ?bindings . ?exp)
       (let ((new-stack (let loop ((stack    stack)
				   (bindings bindings))
			   (cond
			      ((null? bindings)
			       stack)
			      ((not (pair? (car bindings)))
			       (loop (cons (car bindings) stack)
				     (cdr bindings)))
			      (else
			       (loop (cons (car (car bindings)) stack)
				     (cdr bindings)))))))
	  (find-and-check-mutations! exp new-stack)
	  (for-each (lambda (b)
		       (find-and-check-mutations! (cdr b) new-stack))
		    bindings)))
      ((labels ?bindings . ?exp)
       (let ((new-stack (append (map car bindings) stack)))
	  (find-and-check-mutations! exp new-stack)
	  (for-each (lambda (b)
		       (find-and-check-mutations! (cddr b)
						  (add (cadr b) new-stack)))
		    bindings)))
      ((lambda ?args . ?exp)
       (find-and-check-mutations! exp (add args stack)))
      ((bind-exit ?exit . ?exp)
       (find-and-check-mutations! exp (cons exit stack)))
      ((apply ?proc ?arg)
       (find-and-check-one-mutations! proc stack)
       (find-and-check-one-mutations! arg stack))
      ((case ?val ?clauses)
       (find-and-check-one-mutations! val stack)
       (for-each (lambda (c)
		    (find-and-check-one-mutations! (cdr c) stack))
		 clauses))
      ((if . ?exp)
       (find-and-check-mutations! exp stack))
      ((define ?name . ?exp)
       (find-and-check-mutations! exp (cons name stack)))
      ((define-inline ?name . ?exp)
       (find-and-check-mutations! exp (cons name stack)))
      (else
       (find-and-check-mutations! exp stack))))

;*---------------------------------------------------------------------*/
;*    add ...                                                          */
;*---------------------------------------------------------------------*/
(define (add expr list)
   (let loop ((expr expr)
	      (list list))
      (cond
	 ((null? expr)
	  list)
	 ((not (pair? expr))
	  (cons expr list))
	 (else
	  (loop (cdr expr)
		(cons (car expr) list))))))

;*---------------------------------------------------------------------*/
;*    check-mutation ...                                               */
;*---------------------------------------------------------------------*/
(define (check-mutation! var exp)
   (let ((global (find-global var)))
      (cond
	 ((not (global? global))
	  'done)
	 ((not (or (eq? (global-class global) 'variable)
		   (eq? (global-class global) 'c-variable)
		   (eq? (global-class global) 'eval)))
	  (user-error "set!" "Illegal mutation of global function" exp))
	 (else
	  (global-access-set! global 'write)))))
      

   
 
