;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/local.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 17:39:21 1994                          */
;*    Last change :  Tue May 30 15:15:55 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The declaration of local variables                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_local
   (include "Ast/ast.sch"
	    "Type/type.sch")
   (import  type_env
	    engine_param)
   (export  (make-local-variable <name> <type>)
	    (local-shape         <local>)))

;*---------------------------------------------------------------------*/
;*    *local-key* ...                                                  */
;*---------------------------------------------------------------------*/
(define *local-key* 0)

;*---------------------------------------------------------------------*/
;*    make-local-variable ...                                          */
;*    -------------------------------------------------------------    */
;*    All local variables are allocated using this function.           */
;*---------------------------------------------------------------------*/
(define (make-local-variable name type)
   [assert check (type) (or (null? type) (type? type))]
   (set! *local-key* (+fx *local-key* 1))
   (let ((new (make-local)))
      (if (not (local? new))
	  (internal-error "make-local-variable"
			  "Can't allocate local variable"
			  name)
	  (begin
	     (local-name-set!       new name) 
	     (local-key-set!        new *local-key*)
	     (local-occurrence-set! new 0)
	     (local-access-set!     new 'read)
	     (local-fast-alpha-set! new #f)
	     (local-type-set!       new type)
	     new))))
  
;*---------------------------------------------------------------------*/
;*    local-shape ...                                                  */
;*---------------------------------------------------------------------*/
(define (local-shape local)
   (let* ((sym  (if *key-shape?*
		    (symbol-append (local-name local)
				   '_
				   (string->symbol
				    (integer->string (local-key local))))
		    (local-name local)))
	  (sym  (string->symbol (string-downcase! (symbol->string sym))))
	  (type (if (function? (local-value local))
		    (function-type-res (local-value local))
		    (local-type local))))
      (cond
	 ((not *type-shape?*)
	  sym)
	 ((type? type)
	  (symbol-append sym ':: (type-id type)))
	 ((null? type)
	  (symbol-append sym '::_))
	 (else
	  sym))))
