;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/warning.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  6 08:12:57 1995                          */
;*    Last change :  Fri Apr 21 11:27:25 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type and arity warning.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_warning
   (include "Ast/node.sch"
	    "Cfa/approx.sch")
   (import  cfa_closure
	    tools_args
	    tools_shape
	    tools_error
	    tools_set
	    type_cache
	    cfa_special
	    cfa_procedure
	    cfa_approx)
   (export  (cfa-warning)))

;*---------------------------------------------------------------------*/
;*    cfa-warning ...                                                  */
;*---------------------------------------------------------------------*/
(define (cfa-warning)
   (for-each
    (lambda (ast)
       (let* ((fun       (funcall-fun ast))
	      (approx    (get-approx fun))
	      (type      (approx-type approx))
	      (alloc     (approx-alloc approx))
	      (n-args    (length (funcall-actuals ast)))
	      (error     #t))
	  ;; the arity checks
	  (for-each-set
	   (lambda (alloc)
	      (if (is-closure-alloc? alloc)
		  (let* ((proc  (closure->function alloc))
			 (arity (function-arity (global-value proc))))
		     (if (or (and (>=fx arity 0)
				  (not (=fx arity n-args)))
			     (and (<fx arity 0)
				  (>fx (-fx (negfx arity) 1) n-args)))
			 (user-warning/location
			  (ast-location ast)
			  "cfa"
			  "Possible funcall arity error"
			  (shape proc))))))
	   alloc)
	  ;; the type checks
	  (let ((error-type '()))
	     (for-each-set
	      (lambda (type)
		 (cond
		    ((eq? type *procedure*)
		     #unspecified)
		    ((eq? type *obj*)
		     #unspecified)
		    (else
		     (set! error-type (cons type error-type)))))
	      type)
	  (if (pair? error-type)
	      (user-warning/location
	       (ast-location ast)
	       "cfa"
	       "Possible funcall type error"
	       (shape (set->list type)))))))
    (get-funcall-list)))


