;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Coerce/app.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 19 11:31:25 1995                          */
;*    Last change :  Mon Apr  3 12:17:10 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The coercion of applications                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_app
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    type_cache
	    ast_sexp
	    ast_dump
	    ast_app
	    ast_env
	    coerce_coerce
	    coerce_convert)
   (export  (coerce-app!         <ast> <type>)
	    (fix-function-types! <function>)))

;*---------------------------------------------------------------------*/
;*    coerce-app! ...                                                  */
;*---------------------------------------------------------------------*/
(define (coerce-app! ast to)
   (let ((fun (var-variable (app-fun ast))))
      (if (and (global? fun) (eq? (global-import fun) 'foreign))
	  (coerce-foreign-app! fun ast to)
	  (coerce-bigloo-app! fun ast to))))

;*---------------------------------------------------------------------*/
;*    coerce-foreign-app! ...                                          */
;*---------------------------------------------------------------------*/
(define (coerce-foreign-app! callee ast to)
   (trace type "coerce-foreign-app!: " (ast->sexp ast) #\Newline)
   (let* ((ffun  (variable-value callee))
	  (arity (ffunction-arity ffun)))
      (if (not (correct-app? arity ast))
	  (convert! (app-error (current-function) ast) *obj* to)
	  (if (>=fx arity 0)
	      (coerce-foreign-fx-app! ffun callee ast to)
	      (coerce-foreign-va-app! ffun callee ast to)))))

;*---------------------------------------------------------------------*/
;*    coerce-foreign-fx-app! ...                                       */
;*---------------------------------------------------------------------*/
(define (coerce-foreign-fx-app! fun callee ast to)
   (trace type "coerce-foreign-fx-app!: " (ast->sexp ast) #\Newline)
   (let loop ((actuals (app-actuals ast))
	      (types   (ffunction-type-args fun)))
      (if (null? actuals)
	  (convert! ast (ffunction-type-res fun) to)
	  (begin
	     (set-car! actuals (coerce! (car actuals) (car types)))
	     (loop (cdr actuals) (cdr types))))))

;*---------------------------------------------------------------------*/
;*    coerce-foreign-va-app! ...                                       */
;*---------------------------------------------------------------------*/
(define (coerce-foreign-va-app! fun callee ast to)
   (let loop ((actuals (app-actuals ast))
	      (types   (ffunction-type-args fun))
	      (counter (ffunction-arity fun)))
      (if (=fx counter -1)
	  ;; this is the formals of a foreign va-args
	  (let loop ((actuals actuals))
	     (if (null? actuals)
		 (convert! ast (ffunction-type-res fun) to)
		 (begin
		    (set-car! actuals (coerce! (car actuals) (car types)))
		    (loop (cdr actuals)))))
	  (begin
	     (set-car! actuals (coerce! (car actuals) (car types)))
	     (loop (cdr actuals) (cdr types) (+fx counter 1))))))

;*---------------------------------------------------------------------*/
;*    coerce-bigloo-app! ...                                           */
;*---------------------------------------------------------------------*/
(define (coerce-bigloo-app! callee ast to)
   (let* ((fun (variable-value callee))
	  (arity (function-arity fun)))
      (fix-function-types! fun)
      (if (not (correct-app? arity ast))
	  (convert! (app-error (current-function) ast) *obj* to)
	  ;; we coerce the arguments.
	  (let loop ((actuals (app-actuals ast))
		     (formals (function-args fun)))
	     (if (null? actuals)
		 (convert! ast (function-type-res fun) to)
		 (begin
		    (set-car! actuals
			      (coerce! (car actuals)
				       (local-type (car formals))))
		    (loop (cdr actuals)
			  (cdr formals))))))))

;*---------------------------------------------------------------------*/
;*    fix-function-types! ...                                          */
;*---------------------------------------------------------------------*/
(define (fix-function-types! fun)
   (define (fix-type! type)
      (if (not (type? type))
	  *obj*
	  type))
   (function-type-res-set! fun (fix-type! (function-type-res fun)))
   (for-each (lambda (arg)
		(local-type-set! arg (fix-type! (local-type arg))))
	     (function-args fun)))
 
